/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.NamedEnumUtil;
import com.intellij.util.xml.NonExhaustiveEnum;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.util.xml.XmlDomBundle;
import com.intellij.xml.util.XmlUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EnumConverter<T extends Enum>
extends ResolvingConverter<T> {
    private final Class<T> myType;

    private EnumConverter(Class<T> aClass) {
        this.myType = aClass;
    }

    public static <T extends Enum> EnumConverter<T> createEnumConverter(Class<T> aClass) {
        return new EnumConverter<T>(aClass);
    }

    private String getStringValue(T anEnum) {
        return NamedEnumUtil.getEnumValueByElement(anEnum);
    }

    public T fromString(String s, @NotNull ConvertContext context) {
        if (context == null) {
            EnumConverter.$$$reportNull$$$0(0);
        }
        return (T)(s == null ? null : NamedEnumUtil.getEnumElementByValue(this.myType, (String)s));
    }

    public String toString(T t, @NotNull ConvertContext context) {
        if (context == null) {
            EnumConverter.$$$reportNull$$$0(1);
        }
        return t == null ? null : this.getStringValue(t);
    }

    public String getErrorMessage(@Nullable String s, @NotNull ConvertContext context) {
        if (context == null) {
            EnumConverter.$$$reportNull$$$0(2);
        }
        return XmlDomBundle.message((String)"dom.converter.unknown.enum.value", (Object[])new Object[]{s});
    }

    @NotNull
    public Collection<? extends T> getVariants(@NotNull ConvertContext context) {
        XmlTag simpleContent;
        XmlElement element;
        if (context == null) {
            EnumConverter.$$$reportNull$$$0(3);
        }
        if ((element = context.getXmlElement()) instanceof XmlTag && (simpleContent = XmlUtil.getSchemaSimpleContent((XmlTag)element)) != null && XmlUtil.collectEnumerationValues(simpleContent, new HashSet())) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                EnumConverter.$$$reportNull$$$0(4);
            }
            return list2;
        }
        List<Enum> list3 = Arrays.asList((Enum[])this.myType.getEnumConstants());
        if (list3 == null) {
            EnumConverter.$$$reportNull$$$0(5);
        }
        return list3;
    }

    public boolean isExhaustive() {
        return !ReflectionUtil.isAssignable(NonExhaustiveEnum.class, this.myType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/EnumConverter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/EnumConverter";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fromString";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "toString";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessage";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getVariants";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }
}

