/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jewel.markdown.processing;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.commonmark.node.Block;
import org.commonmark.node.BlockQuote;
import org.commonmark.node.BulletList;
import org.commonmark.node.CustomBlock;
import org.commonmark.node.Document;
import org.commonmark.node.FencedCodeBlock;
import org.commonmark.node.Heading;
import org.commonmark.node.HtmlBlock;
import org.commonmark.node.IndentedCodeBlock;
import org.commonmark.node.ListBlock;
import org.commonmark.node.ListItem;
import org.commonmark.node.Node;
import org.commonmark.node.OrderedList;
import org.commonmark.node.Paragraph;
import org.commonmark.node.SourceSpan;
import org.commonmark.node.ThematicBreak;
import org.commonmark.parser.Parser;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.jewel.foundation.ExperimentalJewelApi;
import org.jetbrains.jewel.foundation.InternalJewelApi;
import org.jetbrains.jewel.markdown.InlineMarkdown;
import org.jetbrains.jewel.markdown.MarkdownBlock;
import org.jetbrains.jewel.markdown.MimeType;
import org.jetbrains.jewel.markdown.extensions.MarkdownBlockProcessorExtension;
import org.jetbrains.jewel.markdown.extensions.MarkdownProcessorExtension;
import org.jetbrains.jewel.markdown.processing.MarkdownParserFactory;
import org.jetbrains.jewel.markdown.processing.ProcessingUtilKt;

@ExperimentalJewelApi
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001:\u0001;B)\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001f\u0010\f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\r0\u0003H\u0001\u00a2\u0006\u0002\b\u000fJ\u0018\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u00032\b\b\u0001\u0010\u0012\u001a\u00020\u0013H\u0002J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00032\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u00032\b\b\u0001\u0010\u0012\u001a\u00020\u0013J\u001d\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00110\u00032\b\b\u0001\u0010\u0012\u001a\u00020\u0013H\u0001\u00a2\u0006\u0002\b\u001aJ \u0010\u001b\u001a\u00020\u001c*\u00020\u00172\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u001c0\u001eH\u0002J\u0012\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u0003*\u00020!H\u0002J\u0012\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u0003*\u00020\u0011H\u0002J\f\u0010$\u001a\u00020%*\u00020&H\u0002J\f\u0010'\u001a\u00020(*\u00020)H\u0002J\f\u0010'\u001a\u00020**\u00020+H\u0002J\u000e\u0010,\u001a\u0004\u0018\u00010-*\u00020.H\u0002J\u000e\u0010/\u001a\u0004\u0018\u000100*\u000201H\u0002J\u000e\u00102\u001a\u0004\u0018\u000103*\u000204H\u0002J\u000e\u00102\u001a\u0004\u0018\u000105*\u000206H\u0002J\f\u00107\u001a\u000208*\u000209H\u0002J\u000e\u0010:\u001a\u0004\u0018\u00010\u0015*\u00020\u0017H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lorg/jetbrains/jewel/markdown/processing/MarkdownProcessor;", "", "extensions", "", "Lorg/jetbrains/jewel/markdown/extensions/MarkdownProcessorExtension;", "optimizeEdits", "", "commonMarkParser", "Lorg/commonmark/parser/Parser;", "(Ljava/util/List;ZLorg/commonmark/parser/Parser;)V", "currentState", "Lorg/jetbrains/jewel/markdown/processing/MarkdownProcessor$State;", "getCurrentIndexesInTest", "Lkotlin/Pair;", "", "getCurrentIndexesInTest$core", "parseRawMarkdown", "Lorg/commonmark/node/Block;", "rawMarkdown", "", "processChildren", "Lorg/jetbrains/jewel/markdown/MarkdownBlock;", "node", "Lorg/commonmark/node/Node;", "processMarkdownDocument", "processWithQuickEdits", "processWithQuickEdits$core", "forEachChild", "", "action", "Lkotlin/Function1;", "processListItems", "Lorg/jetbrains/jewel/markdown/MarkdownBlock$ListItem;", "Lorg/commonmark/node/ListBlock;", "readInlineContent", "Lorg/jetbrains/jewel/markdown/InlineMarkdown;", "toMarkdownBlockQuote", "Lorg/jetbrains/jewel/markdown/MarkdownBlock$BlockQuote;", "Lorg/commonmark/node/BlockQuote;", "toMarkdownCodeBlockOrNull", "Lorg/jetbrains/jewel/markdown/MarkdownBlock$CodeBlock$FencedCodeBlock;", "Lorg/commonmark/node/FencedCodeBlock;", "Lorg/jetbrains/jewel/markdown/MarkdownBlock$CodeBlock$IndentedCodeBlock;", "Lorg/commonmark/node/IndentedCodeBlock;", "toMarkdownHeadingOrNull", "Lorg/jetbrains/jewel/markdown/MarkdownBlock$Heading;", "Lorg/commonmark/node/Heading;", "toMarkdownHtmlBlockOrNull", "Lorg/jetbrains/jewel/markdown/MarkdownBlock$HtmlBlock;", "Lorg/commonmark/node/HtmlBlock;", "toMarkdownListOrNull", "Lorg/jetbrains/jewel/markdown/MarkdownBlock$ListBlock$UnorderedList;", "Lorg/commonmark/node/BulletList;", "Lorg/jetbrains/jewel/markdown/MarkdownBlock$ListBlock$OrderedList;", "Lorg/commonmark/node/OrderedList;", "toMarkdownParagraph", "Lorg/jetbrains/jewel/markdown/MarkdownBlock$Paragraph;", "Lorg/commonmark/node/Paragraph;", "tryProcessMarkdownBlock", "State", "core"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nMarkdownProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownProcessor.kt\norg/jetbrains/jewel/markdown/processing/MarkdownProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,287:1\n1603#2,9:288\n1855#2:297\n1856#2:299\n1612#2:300\n1549#2:301\n1620#2,3:302\n1549#2:305\n1620#2,3:306\n1#3:298\n1#3:309\n*S KotlinDebug\n*F\n+ 1 MarkdownProcessor.kt\norg/jetbrains/jewel/markdown/processing/MarkdownProcessor\n*L\n85#1:288,9\n85#1:297\n85#1:299\n85#1:300\n141#1:301\n141#1:302,3\n155#1:305\n155#1:306,3\n85#1:298\n*E\n"})
public final class MarkdownProcessor {
    @NotNull
    private final List<MarkdownProcessorExtension> extensions;
    private final boolean optimizeEdits;
    @NotNull
    private final Parser commonMarkParser;
    @NotNull
    private State currentState;
    public static final int $stable = 8;

    public MarkdownProcessor(@NotNull List<? extends MarkdownProcessorExtension> extensions, boolean optimizeEdits, @NotNull Parser commonMarkParser) {
        Intrinsics.checkNotNullParameter(extensions, (String)"extensions");
        Intrinsics.checkNotNullParameter((Object)commonMarkParser, (String)"commonMarkParser");
        this.extensions = extensions;
        this.optimizeEdits = optimizeEdits;
        this.commonMarkParser = commonMarkParser;
        this.currentState = new State(CollectionsKt.emptyList(), CollectionsKt.emptyList(), CollectionsKt.emptyList());
    }

    public /* synthetic */ MarkdownProcessor(List list, boolean bl, Parser parser, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            parser = MarkdownParserFactory.create$default(MarkdownParserFactory.INSTANCE, bl, list, null, 4, null);
        }
        this(list, bl, parser);
    }

    @TestOnly
    @NotNull
    public final List<Pair<Integer, Integer>> getCurrentIndexesInTest$core() {
        return this.currentState.getIndexes();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<MarkdownBlock> processMarkdownDocument(@Language(value="Markdown") @NotNull String rawMarkdown) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)rawMarkdown, (String)"rawMarkdown");
        List<Block> blocks = this.optimizeEdits ? this.processWithQuickEdits$core(rawMarkdown) : this.parseRawMarkdown(rawMarkdown);
        Iterable $this$mapNotNull$iv = blocks;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            MarkdownBlock it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Block child = (Block)element$iv$iv;
            boolean bl2 = false;
            if (this.tryProcessMarkdownBlock(child) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @VisibleForTesting
    @NotNull
    public final List<Block> processWithQuickEdits$core(@Language(value="Markdown") @NotNull String rawMarkdown) {
        Intrinsics.checkNotNullParameter((Object)rawMarkdown, (String)"rawMarkdown");
        var2_2 = this.currentState;
        previousLines = var2_2.component1();
        previousBlocks = var2_2.component2();
        previousIndexes = var2_2.component3();
        newLines = StringsKt.lines((CharSequence)rawMarkdown);
        nLinesDelta = newLines.size() - previousLines.size();
        firstBlock = 0;
        firstLine = 0;
        currFirstBlock = 0;
        currFirstLine = 0;
        var12_12 = previousIndexes.iterator();
        var13_14 = 0;
        block0: while (var12_12.hasNext()) {
            i = var13_14++;
            j = currFirstLine;
            spans = var12_12.next();
            end = ((Number)spans.component2()).intValue();
            if (j > end) ** GOTO lbl24
            while (j >= 0 && j < newLines.size() && Intrinsics.areEqual(newLines.get(j), (Object)previousLines.get(j))) {
                if (j != end) {
                    ++j;
                    continue;
                }
lbl24:
                // 3 sources

                firstBlock = currFirstBlock;
                firstLine = currFirstLine;
                currFirstBlock = i + 1;
                currFirstLine = end + 1;
                continue block0;
            }
            break block0;
        }
        lastBlock = previousBlocks.size();
        lastLine = previousLines.size();
        currLastBlock = lastBlock;
        currLastLine = lastLine;
        block2: for (IndexedValue j : CollectionsKt.reversed((Iterable)CollectionsKt.withIndex((Iterable)previousIndexes))) {
            i = j.component1();
            spans = (Pair)j.component2();
            var22_33 = currLastLine;
            for (j = begin = ((Number)spans.component1()).intValue(); j < var22_33; ++j) {
                newIndex = j + nLinesDelta;
                if (newIndex < 0 || newIndex >= newLines.size() || !Intrinsics.areEqual((Object)previousLines.get(j), newLines.get(newIndex))) break block2;
            }
            lastBlock = currLastBlock;
            lastLine = currLastLine;
            currLastBlock = i;
            currLastLine = begin;
        }
        if (firstLine > lastLine + nLinesDelta) {
            return previousBlocks;
        }
        updatedText = CollectionsKt.joinToString$default((Iterable)newLines.subList(firstLine, lastLine + nLinesDelta), (CharSequence)"\n", null, (CharSequence)"\n", (int)0, null, null, (int)58, null);
        updatedBlocks = this.parseRawMarkdown(updatedText);
        $this$map$iv = updatedBlocks;
        $i$f$map = false;
        j = $this$map$iv;
        destination$iv$iv /* !! */  = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            var26_40 = (Block)item$iv$iv;
            var30_45 = destination$iv$iv /* !! */ ;
            $i$a$-map-MarkdownProcessor$processWithQuickEdits$updatedIndexes$1 = false;
            if (node.getSourceSpans().isEmpty()) {
                node.setSourceSpans(node.getPrevious().getSourceSpans());
            }
            v0 = node.getSourceSpans();
            Intrinsics.checkNotNullExpressionValue(v0, (String)"getSourceSpans(...)");
            firstLineIndex = ((SourceSpan)CollectionsKt.first(v0)).getLineIndex() + firstLine;
            v1 = node.getSourceSpans();
            Intrinsics.checkNotNullExpressionValue(v1, (String)"getSourceSpans(...)");
            lastLineIndex = ((SourceSpan)CollectionsKt.last(v1)).getLineIndex() + firstLine;
            var30_45.add(TuplesKt.to((Object)firstLineIndex, (Object)lastLineIndex));
        }
        updatedIndexes = (List)destination$iv$iv /* !! */ ;
        $this$map$iv = previousIndexes.subList(lastBlock, previousBlocks.size());
        $i$f$map = false;
        destination$iv$iv /* !! */  = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            $i$a$-map-MarkdownProcessor$processWithQuickEdits$updatedIndexes$1 = (Pair)item$iv$iv;
            var30_45 = destination$iv$iv;
            $i$a$-map-MarkdownProcessor$processWithQuickEdits$suffixIndexes$1 = false;
            var30_45.add(TuplesKt.to((Object)(((Number)it.getFirst()).intValue() + nLinesDelta), (Object)(((Number)it.getSecond()).intValue() + nLinesDelta)));
        }
        suffixIndexes = (List)destination$iv$iv;
        newBlocks = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)previousBlocks.subList(0, firstBlock), (Iterable)updatedBlocks), (Iterable)previousBlocks.subList(lastBlock, previousBlocks.size()));
        newIndexes = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)previousIndexes.subList(0, firstBlock), (Iterable)updatedIndexes), (Iterable)suffixIndexes);
        this.currentState = new State(newLines, newBlocks, newIndexes);
        return newBlocks;
    }

    private final List<Block> parseRawMarkdown(@Language(value="Markdown") String rawMarkdown) {
        List list;
        Node node = this.commonMarkParser.parse(rawMarkdown);
        Document document = node instanceof Document ? (Document)node : null;
        if (document == null) {
            throw new IllegalStateException("This doesn't look like a Markdown document".toString());
        }
        Document document2 = document;
        List $this$parseRawMarkdown_u24lambda_u243 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        this.forEachChild(document2, (Function1<? super Node, Unit>)((Function1)new Function1<Node, Unit>((List<Block>)$this$parseRawMarkdown_u24lambda_u243){
            final /* synthetic */ List<Block> $this_buildList;
            {
                this.$this_buildList = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Node child) {
                Intrinsics.checkNotNullParameter((Object)child, (String)"child");
                if (child instanceof Block) {
                    this.$this_buildList.add((Block)child);
                }
            }
        }));
        return CollectionsKt.build((List)list);
    }

    private final MarkdownBlock tryProcessMarkdownBlock(Node $this$tryProcessMarkdownBlock) {
        MarkdownBlock markdownBlock;
        Node node = $this$tryProcessMarkdownBlock;
        if (node instanceof Paragraph) {
            markdownBlock = this.toMarkdownParagraph((Paragraph)$this$tryProcessMarkdownBlock);
        } else if (node instanceof Heading) {
            markdownBlock = this.toMarkdownHeadingOrNull((Heading)$this$tryProcessMarkdownBlock);
        } else if (node instanceof BulletList) {
            markdownBlock = this.toMarkdownListOrNull((BulletList)$this$tryProcessMarkdownBlock);
        } else if (node instanceof OrderedList) {
            markdownBlock = this.toMarkdownListOrNull((OrderedList)$this$tryProcessMarkdownBlock);
        } else if (node instanceof BlockQuote) {
            markdownBlock = this.toMarkdownBlockQuote((BlockQuote)$this$tryProcessMarkdownBlock);
        } else if (node instanceof FencedCodeBlock) {
            markdownBlock = this.toMarkdownCodeBlockOrNull((FencedCodeBlock)$this$tryProcessMarkdownBlock);
        } else if (node instanceof IndentedCodeBlock) {
            markdownBlock = this.toMarkdownCodeBlockOrNull((IndentedCodeBlock)$this$tryProcessMarkdownBlock);
        } else if (node instanceof ThematicBreak) {
            markdownBlock = MarkdownBlock.ThematicBreak.INSTANCE;
        } else if (node instanceof HtmlBlock) {
            markdownBlock = this.toMarkdownHtmlBlockOrNull((HtmlBlock)$this$tryProcessMarkdownBlock);
        } else if (node instanceof CustomBlock) {
            MarkdownBlockProcessorExtension markdownBlockProcessorExtension;
            Object v3;
            block21: {
                Iterable iterable = this.extensions;
                for (Object t : iterable) {
                    MarkdownProcessorExtension it = (MarkdownProcessorExtension)t;
                    boolean bl = false;
                    MarkdownBlockProcessorExtension markdownBlockProcessorExtension2 = it.getBlockProcessorExtension();
                    boolean bl2 = markdownBlockProcessorExtension2 != null ? markdownBlockProcessorExtension2.canProcess((CustomBlock)$this$tryProcessMarkdownBlock) : false;
                    if (!bl2) continue;
                    v3 = t;
                    break block21;
                }
                v3 = null;
            }
            MarkdownProcessorExtension markdownProcessorExtension = v3;
            markdownBlock = markdownProcessorExtension != null && (markdownBlockProcessorExtension = markdownProcessorExtension.getBlockProcessorExtension()) != null ? markdownBlockProcessorExtension.processMarkdownBlock((CustomBlock)$this$tryProcessMarkdownBlock, this) : null;
        } else {
            markdownBlock = null;
        }
        return markdownBlock;
    }

    private final MarkdownBlock.Paragraph toMarkdownParagraph(Paragraph $this$toMarkdownParagraph) {
        return new MarkdownBlock.Paragraph(CollectionsKt.toList((Iterable)this.readInlineContent($this$toMarkdownParagraph)));
    }

    private final MarkdownBlock.BlockQuote toMarkdownBlockQuote(BlockQuote $this$toMarkdownBlockQuote) {
        return new MarkdownBlock.BlockQuote(this.processChildren($this$toMarkdownBlockQuote));
    }

    private final MarkdownBlock.Heading toMarkdownHeadingOrNull(Heading $this$toMarkdownHeadingOrNull) {
        if ($this$toMarkdownHeadingOrNull.getLevel() < 1 || $this$toMarkdownHeadingOrNull.getLevel() > 6) {
            return null;
        }
        return new MarkdownBlock.Heading(CollectionsKt.toList((Iterable)this.readInlineContent($this$toMarkdownHeadingOrNull)), $this$toMarkdownHeadingOrNull.getLevel());
    }

    private final MarkdownBlock.CodeBlock.FencedCodeBlock toMarkdownCodeBlockOrNull(FencedCodeBlock $this$toMarkdownCodeBlockOrNull) {
        String string = $this$toMarkdownCodeBlockOrNull.getLiteral();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLiteral(...)");
        char[] cArray = new char[]{'\n'};
        String string2 = StringsKt.trimEnd((String)string, (char[])cArray);
        String string3 = $this$toMarkdownCodeBlockOrNull.getInfo();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getInfo(...)");
        return new MarkdownBlock.CodeBlock.FencedCodeBlock(string2, MimeType.Known.INSTANCE.fromMarkdownLanguageName-HxXrbs8(string3), null);
    }

    private final MarkdownBlock.CodeBlock.IndentedCodeBlock toMarkdownCodeBlockOrNull(IndentedCodeBlock $this$toMarkdownCodeBlockOrNull) {
        String string = $this$toMarkdownCodeBlockOrNull.getLiteral();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLiteral(...)");
        char[] cArray = new char[]{'\n'};
        return new MarkdownBlock.CodeBlock.IndentedCodeBlock(StringsKt.trimEnd((String)string, (char[])cArray));
    }

    private final MarkdownBlock.ListBlock.UnorderedList toMarkdownListOrNull(BulletList $this$toMarkdownListOrNull) {
        List<MarkdownBlock.ListItem> children = this.processListItems($this$toMarkdownListOrNull);
        if (children.isEmpty()) {
            return null;
        }
        boolean bl = $this$toMarkdownListOrNull.isTight();
        String string = $this$toMarkdownListOrNull.getMarker();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMarker(...)");
        return new MarkdownBlock.ListBlock.UnorderedList(children, bl, string);
    }

    private final MarkdownBlock.ListBlock.OrderedList toMarkdownListOrNull(OrderedList $this$toMarkdownListOrNull) {
        List<MarkdownBlock.ListItem> children = this.processListItems($this$toMarkdownListOrNull);
        if (children.isEmpty()) {
            return null;
        }
        boolean bl = $this$toMarkdownListOrNull.isTight();
        Integer n = $this$toMarkdownListOrNull.getMarkerStartNumber();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getMarkerStartNumber(...)");
        int n2 = ((Number)n).intValue();
        String string = $this$toMarkdownListOrNull.getMarkerDelimiter();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMarkerDelimiter(...)");
        return new MarkdownBlock.ListBlock.OrderedList(children, bl, n2, string);
    }

    private final List<MarkdownBlock.ListItem> processListItems(ListBlock $this$processListItems) {
        List list;
        List $this$processListItems_u24lambda_u245 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        this.forEachChild($this$processListItems, (Function1<? super Node, Unit>)((Function1)new Function1<Node, Unit>((List<MarkdownBlock.ListItem>)$this$processListItems_u24lambda_u245, this){
            final /* synthetic */ List<MarkdownBlock.ListItem> $this_buildList;
            final /* synthetic */ MarkdownProcessor this$0;
            {
                this.$this_buildList = $receiver;
                this.this$0 = $receiver2;
                super(1);
            }

            public final void invoke(@NotNull Node child) {
                Intrinsics.checkNotNullParameter((Object)child, (String)"child");
                if (!(child instanceof ListItem)) {
                    return;
                }
                this.$this_buildList.add(new MarkdownBlock.ListItem(this.this$0.processChildren(child)));
            }
        }));
        return CollectionsKt.build((List)list);
    }

    @InternalJewelApi
    @NotNull
    public final List<MarkdownBlock> processChildren(@NotNull Node node) {
        List list;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        List $this$processChildren_u24lambda_u246 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        this.forEachChild(node, (Function1<? super Node, Unit>)((Function1)new Function1<Node, Unit>(this, (List<MarkdownBlock>)$this$processChildren_u24lambda_u246){
            final /* synthetic */ MarkdownProcessor this$0;
            final /* synthetic */ List<MarkdownBlock> $this_buildList;
            {
                this.this$0 = $receiver;
                this.$this_buildList = $receiver2;
                super(1);
            }

            public final void invoke(@NotNull Node child) {
                Intrinsics.checkNotNullParameter((Object)child, (String)"child");
                MarkdownBlock parsedBlock = MarkdownProcessor.access$tryProcessMarkdownBlock(this.this$0, child);
                if (parsedBlock != null) {
                    this.$this_buildList.add(parsedBlock);
                }
            }
        }));
        return CollectionsKt.build((List)list);
    }

    private final void forEachChild(Node $this$forEachChild, Function1<? super Node, Unit> action) {
        for (Node child = $this$forEachChild.getFirstChild(); child != null; child = child.getNext()) {
            action.invoke((Object)child);
        }
    }

    private final MarkdownBlock.HtmlBlock toMarkdownHtmlBlockOrNull(HtmlBlock $this$toMarkdownHtmlBlockOrNull) {
        String string = $this$toMarkdownHtmlBlockOrNull.getLiteral();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLiteral(...)");
        if (StringsKt.isBlank((CharSequence)string)) {
            return null;
        }
        String string2 = $this$toMarkdownHtmlBlockOrNull.getLiteral();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getLiteral(...)");
        char[] cArray = new char[]{'\n'};
        return new MarkdownBlock.HtmlBlock(StringsKt.trimEnd((String)string2, (char[])cArray));
    }

    private final List<InlineMarkdown> readInlineContent(Block $this$readInlineContent) {
        return ProcessingUtilKt.readInlineContent($this$readInlineContent, this, this.extensions);
    }

    public MarkdownProcessor() {
        this(null, false, null, 7, null);
    }

    public static final /* synthetic */ MarkdownBlock access$tryProcessMarkdownBlock(MarkdownProcessor $this, Node $receiver) {
        return $this.tryProcessMarkdownBlock($receiver);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B;\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u0018\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b0\u0003\u00a2\u0006\u0002\u0010\nJ\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0003J\u001b\u0010\u0011\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b0\u0003H\u00c6\u0003JE\u0010\u0012\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u00032\u001a\b\u0002\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b0\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\tH\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0004H\u00d6\u0001R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR#\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/jewel/markdown/processing/MarkdownProcessor$State;", "", "lines", "", "", "blocks", "Lorg/commonmark/node/Block;", "indexes", "Lkotlin/Pair;", "", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getBlocks", "()Ljava/util/List;", "getIndexes", "getLines", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "core"})
    private static final class State {
        @NotNull
        private final List<String> lines;
        @NotNull
        private final List<Block> blocks;
        @NotNull
        private final List<Pair<Integer, Integer>> indexes;

        public State(@NotNull List<String> lines, @NotNull List<? extends Block> blocks, @NotNull List<Pair<Integer, Integer>> indexes) {
            Intrinsics.checkNotNullParameter(lines, (String)"lines");
            Intrinsics.checkNotNullParameter(blocks, (String)"blocks");
            Intrinsics.checkNotNullParameter(indexes, (String)"indexes");
            this.lines = lines;
            this.blocks = blocks;
            this.indexes = indexes;
        }

        @NotNull
        public final List<String> getLines() {
            return this.lines;
        }

        @NotNull
        public final List<Block> getBlocks() {
            return this.blocks;
        }

        @NotNull
        public final List<Pair<Integer, Integer>> getIndexes() {
            return this.indexes;
        }

        @NotNull
        public final List<String> component1() {
            return this.lines;
        }

        @NotNull
        public final List<Block> component2() {
            return this.blocks;
        }

        @NotNull
        public final List<Pair<Integer, Integer>> component3() {
            return this.indexes;
        }

        @NotNull
        public final State copy(@NotNull List<String> lines, @NotNull List<? extends Block> blocks, @NotNull List<Pair<Integer, Integer>> indexes) {
            Intrinsics.checkNotNullParameter(lines, (String)"lines");
            Intrinsics.checkNotNullParameter(blocks, (String)"blocks");
            Intrinsics.checkNotNullParameter(indexes, (String)"indexes");
            return new State(lines, blocks, indexes);
        }

        public static /* synthetic */ State copy$default(State state, List list, List list2, List list3, int n, Object object) {
            if ((n & 1) != 0) {
                list = state.lines;
            }
            if ((n & 2) != 0) {
                list2 = state.blocks;
            }
            if ((n & 4) != 0) {
                list3 = state.indexes;
            }
            return state.copy(list, list2, list3);
        }

        @NotNull
        public String toString() {
            return "State(lines=" + this.lines + ", blocks=" + this.blocks + ", indexes=" + this.indexes + ")";
        }

        public int hashCode() {
            int result = ((Object)this.lines).hashCode();
            result = result * 31 + ((Object)this.blocks).hashCode();
            result = result * 31 + ((Object)this.indexes).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof State)) {
                return false;
            }
            State state = (State)other;
            if (!Intrinsics.areEqual(this.lines, state.lines)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.blocks, state.blocks)) {
                return false;
            }
            return Intrinsics.areEqual(this.indexes, state.indexes);
        }
    }
}

