/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.platform.diagnostic.telemetry.Scope;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.jetbrains.performancePlugin.commands.WaitForFinishedCodeAnalysisKt;
import java.util.concurrent.TimeUnit;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b2\u0018\u0000 \u00112\u00060\u0001j\u0002`\u0002:\u0001\u0011B\u0013\b\u0004\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0012\u0010\r\u001a\u00020\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u0082\u0001\u0001\u0012\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/performancePlugin/commands/ExceptionWithTime;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "message", "", "<init>", "(Ljava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "timestamp", "", "getTimestamp", "()J", "wasStartedInLimitedSetup", "", "getWasStartedInLimitedSetup", "()Z", "Companion", "Lcom/jetbrains/performancePlugin/commands/ExceptionWithTime$Companion$DaemonAnalysisStarted;", "intellij.performanceTesting"})
abstract class ExceptionWithTime
extends Exception {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String message;
    private final long timestamp;

    private ExceptionWithTime(String message) {
        super(message);
        this.message = message;
        this.timestamp = System.currentTimeMillis();
    }

    @Override
    @Nullable
    public String getMessage() {
        return this.message;
    }

    public final long getTimestamp() {
        return this.timestamp;
    }

    public abstract boolean getWasStartedInLimitedSetup();

    public /* synthetic */ ExceptionWithTime(String message, DefaultConstructorMarker $constructor_marker) {
        this(message);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0016B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0005J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\u0005J \u0010\u0011\u001a\n\u0018\u00010\u0012j\u0004\u0018\u0001`\u00132\u0006\u0010\u0006\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0005\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/performancePlugin/commands/ExceptionWithTime$Companion;", "", "<init>", "()V", "createForAnalysisStart", "Lcom/jetbrains/performancePlugin/commands/ExceptionWithTime;", "editor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "isStartedInDumbMode", "", "markAnalysisFinished", "", "exceptionWithTime", "getLogHighlightingMessage", "", "currentTime", "", "createIntersectionErrorIfNeeded", "Ljava/lang/AssertionError;", "Lkotlin/AssertionError;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "previousSessionStartTrace", "DaemonAnalysisStarted", "intellij.performanceTesting"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ExceptionWithTime createForAnalysisStart(@NotNull TextEditor editor, boolean isStartedInDumbMode) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            return new DaemonAnalysisStarted(editor, isStartedInDumbMode);
        }

        public final void markAnalysisFinished(@Nullable ExceptionWithTime exceptionWithTime) {
            block0: {
                DaemonAnalysisStarted daemonAnalysisStarted = exceptionWithTime instanceof DaemonAnalysisStarted ? (DaemonAnalysisStarted)exceptionWithTime : null;
                if (daemonAnalysisStarted == null) break block0;
                daemonAnalysisStarted.markAnalysisFinished();
            }
        }

        @NotNull
        public final String getLogHighlightingMessage(long currentTime, @NotNull TextEditor editor, @Nullable ExceptionWithTime exceptionWithTime) {
            String string;
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            ExceptionWithTime exceptionWithTime2 = exceptionWithTime;
            if (exceptionWithTime2 == null) {
                string = "Editor " + editor + " wasn't opened, and highlighting didn't start, but it finished, and the editor was highlighted";
            } else if (exceptionWithTime2 instanceof DaemonAnalysisStarted) {
                TelemetryManager.Companion.getTracer(new Scope("highlighting", null, false, 6, null)).spanBuilder("highlighting_" + editor.getFile().getName()).setStartTimestamp(((DaemonAnalysisStarted)exceptionWithTime).getTimestamp(), TimeUnit.MILLISECONDS).startSpan().end(currentTime, TimeUnit.MILLISECONDS);
                string = "Total highlighting time is : " + (currentTime - ((DaemonAnalysisStarted)exceptionWithTime).getTimestamp()) + " ms for " + WaitForFinishedCodeAnalysisKt.access$getDescription((FileEditor)editor);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return string;
        }

        @Nullable
        public final AssertionError createIntersectionErrorIfNeeded(@NotNull FileEditor editor, @Nullable ExceptionWithTime previousSessionStartTrace) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            if (previousSessionStartTrace instanceof DaemonAnalysisStarted && ((DaemonAnalysisStarted)previousSessionStartTrace).isNotFinished()) {
                AssertionError err = new AssertionError((Object)"Overlapping highlighting sessions");
                ExceptionsKt.addSuppressed((Throwable)((Throwable)((Object)err)), (Throwable)new Exception("Current daemon start trace (editor = " + WaitForFinishedCodeAnalysisKt.access$getDescription(editor) + " )"));
                ExceptionsKt.addSuppressed((Throwable)((Throwable)((Object)err)), (Throwable)previousSessionStartTrace);
                return err;
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\u0005R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/performancePlugin/commands/ExceptionWithTime$Companion$DaemonAnalysisStarted;", "Lcom/jetbrains/performancePlugin/commands/ExceptionWithTime;", "editor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "wasStartedInLimitedSetup", "", "<init>", "(Lcom/intellij/openapi/fileEditor/TextEditor;Z)V", "getWasStartedInLimitedSetup", "()Z", "analysisFinished", "markAnalysisFinished", "", "isNotFinished", "intellij.performanceTesting"})
        private static final class DaemonAnalysisStarted
        extends ExceptionWithTime {
            private final boolean wasStartedInLimitedSetup;
            private boolean analysisFinished;

            public DaemonAnalysisStarted(@NotNull TextEditor editor, boolean wasStartedInLimitedSetup) {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                super("Previous daemon start trace (editor = " + WaitForFinishedCodeAnalysisKt.access$getDescription((FileEditor)editor) + ")", (DefaultConstructorMarker)null);
                this.wasStartedInLimitedSetup = wasStartedInLimitedSetup;
            }

            @Override
            public boolean getWasStartedInLimitedSetup() {
                return this.wasStartedInLimitedSetup;
            }

            public final void markAnalysisFinished() {
                this.analysisFinished = true;
            }

            public final boolean isNotFinished() {
                return !this.analysisFinished;
            }
        }
    }
}

