/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.PosixFilePermissionsUtil;
import com.intellij.util.io.UnsyncByteArrayInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.PosixFileAttributeView;
import java.util.function.BiPredicate;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Compressor
implements Closeable {
    @Nullable
    private @Nullable BiPredicate<? super String, ? super @Nullable Path> myFilter;
    private static final Logger LOG = Logger.getInstance(Compressor.class);

    public Compressor filter(@Nullable @Nullable BiPredicate<? super String, ? super @Nullable Path> filter2) {
        this.myFilter = filter2;
        return this;
    }

    @ApiStatus.Obsolete
    public final void addFile(@NotNull String entryName, @NotNull File file) throws IOException {
        if (entryName == null) {
            Compressor.$$$reportNull$$$0(0);
        }
        if (file == null) {
            Compressor.$$$reportNull$$$0(1);
        }
        this.addFile(entryName, file.toPath());
    }

    public final void addFile(@NotNull String entryName, @NotNull Path file) throws IOException {
        if (entryName == null) {
            Compressor.$$$reportNull$$$0(2);
        }
        if (file == null) {
            Compressor.$$$reportNull$$$0(3);
        }
        this.addFile(entryName, file, -1L);
    }

    public final void addFile(@NotNull String entryName, @NotNull Path file, long timestamp) throws IOException {
        if (entryName == null) {
            Compressor.$$$reportNull$$$0(4);
        }
        if (file == null) {
            Compressor.$$$reportNull$$$0(5);
        }
        if (this.accept(entryName = Compressor.entryName(entryName), file)) {
            this.addFile(file, Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]), entryName, timestamp);
        }
    }

    public final void addFile(@NotNull String entryName, byte @NotNull [] content) throws IOException {
        if (entryName == null) {
            Compressor.$$$reportNull$$$0(6);
        }
        if (content == null) {
            Compressor.$$$reportNull$$$0(7);
        }
        this.addFile(entryName, content, -1L);
    }

    public final void addFile(@NotNull String entryName, byte @NotNull [] content, long timestamp) throws IOException {
        if (entryName == null) {
            Compressor.$$$reportNull$$$0(8);
        }
        if (content == null) {
            Compressor.$$$reportNull$$$0(9);
        }
        if (this.accept(entryName = Compressor.entryName(entryName), null)) {
            this.writeFileEntry(entryName, new ByteArrayInputStream(content), content.length, Compressor.timestamp(timestamp), 0, null);
        }
    }

    public final void addFile(@NotNull String entryName, @NotNull InputStream content) throws IOException {
        if (entryName == null) {
            Compressor.$$$reportNull$$$0(10);
        }
        if (content == null) {
            Compressor.$$$reportNull$$$0(11);
        }
        this.addFile(entryName, content, -1L);
    }

    public final void addFile(@NotNull String entryName, @NotNull InputStream content, long timestamp) throws IOException {
        if (entryName == null) {
            Compressor.$$$reportNull$$$0(12);
        }
        if (content == null) {
            Compressor.$$$reportNull$$$0(13);
        }
        if (this.accept(entryName = Compressor.entryName(entryName), null)) {
            this.writeFileEntry(entryName, content, -1L, Compressor.timestamp(timestamp), 0, null);
        }
    }

    public final void addDirectory(@NotNull String entryName) throws IOException {
        if (entryName == null) {
            Compressor.$$$reportNull$$$0(14);
        }
        this.addDirectory(entryName, -1L);
    }

    public final void addDirectory(@NotNull String entryName, long timestamp) throws IOException {
        if (entryName == null) {
            Compressor.$$$reportNull$$$0(15);
        }
        if (this.accept(entryName = Compressor.entryName(entryName), null)) {
            this.writeDirectoryEntry(entryName, Compressor.timestamp(timestamp));
        }
    }

    @ApiStatus.Obsolete
    public final void addDirectory(@NotNull File directory) throws IOException {
        if (directory == null) {
            Compressor.$$$reportNull$$$0(16);
        }
        this.addDirectory(directory.toPath());
    }

    public final void addDirectory(@NotNull Path directory) throws IOException {
        if (directory == null) {
            Compressor.$$$reportNull$$$0(17);
        }
        this.addDirectory("", directory);
    }

    @ApiStatus.Obsolete
    public final void addDirectory(@NotNull String prefix, @NotNull File directory) throws IOException {
        if (prefix == null) {
            Compressor.$$$reportNull$$$0(18);
        }
        if (directory == null) {
            Compressor.$$$reportNull$$$0(19);
        }
        this.addDirectory(prefix, directory.toPath());
    }

    public final void addDirectory(@NotNull String prefix, @NotNull Path directory) throws IOException {
        if (prefix == null) {
            Compressor.$$$reportNull$$$0(20);
        }
        if (directory == null) {
            Compressor.$$$reportNull$$$0(21);
        }
        this.addDirectory(prefix, directory, -1L);
    }

    public final void addDirectory(@NotNull String prefix, @NotNull Path directory, long timestampInMillis) throws IOException {
        if (prefix == null) {
            Compressor.$$$reportNull$$$0(22);
        }
        if (directory == null) {
            Compressor.$$$reportNull$$$0(23);
        }
        prefix = prefix.isEmpty() ? "" : Compressor.entryName(prefix);
        this.addRecursively(prefix, directory, timestampInMillis);
    }

    protected Compressor() {
    }

    private static String entryName(String name) {
        String entryName = StringUtil.trimLeading(StringUtil.trimTrailing(name.replace('\\', '/'), '/'), '/');
        if (entryName.isEmpty()) {
            throw new IllegalArgumentException("Invalid entry name: " + name);
        }
        return entryName;
    }

    private static long timestamp(long timestamp) {
        return timestamp == -1L ? System.currentTimeMillis() : timestamp;
    }

    private boolean accept(String entryName, @Nullable Path file) {
        return this.myFilter == null || this.myFilter.test(entryName, file);
    }

    private void addFile(Path file, BasicFileAttributes attrs, String name, long explicitTimestamp) throws IOException {
        try (InputStream source = Files.newInputStream(file, new OpenOption[0]);){
            long timestamp = explicitTimestamp == -1L ? attrs.lastModifiedTime().toMillis() : explicitTimestamp;
            String symlinkTarget = attrs.isSymbolicLink() ? Files.readSymbolicLink(file).toString() : null;
            this.writeFileEntry(name, source, attrs.size(), timestamp, Compressor.mode(file), symlinkTarget);
        }
    }

    private static int mode(Path file) throws IOException {
        if (SystemInfo.isWindows) {
            DosFileAttributeView attrs = Files.getFileAttributeView(file, DosFileAttributeView.class, new LinkOption[0]);
            if (attrs != null) {
                DosFileAttributes dosAttrs = attrs.readAttributes();
                int mode = 0;
                if (dosAttrs.isReadOnly()) {
                    mode |= 1;
                }
                if (dosAttrs.isHidden()) {
                    mode |= 2;
                }
                return mode;
            }
        } else {
            PosixFileAttributeView attrs = Files.getFileAttributeView(file, PosixFileAttributeView.class, new LinkOption[0]);
            if (attrs != null) {
                return PosixFilePermissionsUtil.toUnixMode(attrs.readAttributes().permissions());
            }
        }
        return 0;
    }

    private void addRecursively(final String prefix, final Path root, final long timestampMs) throws IOException {
        final boolean traceEnabled = LOG.isTraceEnabled();
        if (traceEnabled) {
            LOG.trace("dir=" + root + " prefix=" + prefix);
        }
        Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                String name;
                String string = name = dir == root ? prefix : this.entryName(dir);
                if (name.isEmpty()) {
                    return FileVisitResult.CONTINUE;
                }
                if (Compressor.this.accept(name, dir)) {
                    if (traceEnabled) {
                        LOG.trace("  " + dir + " -> " + name + '/');
                    }
                    Compressor.this.writeDirectoryEntry(name, timestampMs == -1L ? attrs.lastModifiedTime().toMillis() : timestampMs);
                    return FileVisitResult.CONTINUE;
                }
                return FileVisitResult.SKIP_SUBTREE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                String name = this.entryName(file);
                if (Compressor.this.accept(name, file)) {
                    if (traceEnabled) {
                        LOG.trace("  " + file + " -> " + name + (attrs.isSymbolicLink() ? " symlink" : " size=" + attrs.size()));
                    }
                    Compressor.this.addFile(file, attrs, name, timestampMs);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                if (exc instanceof NoSuchFileException) {
                    return FileVisitResult.CONTINUE;
                }
                throw exc;
            }

            private String entryName(Path fileOrDir) {
                String relativeName = Compressor.entryName(root.relativize(fileOrDir).toString());
                return prefix.isEmpty() ? relativeName : prefix + '/' + relativeName;
            }
        });
        LOG.trace(".");
    }

    protected abstract void writeDirectoryEntry(String var1, long var2) throws IOException;

    protected abstract void writeFileEntry(String var1, InputStream var2, long var3, long var5, int var7, @Nullable String var8) throws IOException;

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryName";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 18: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/io/Compressor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addFile";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "addDirectory";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class Jar
    extends Zip {
        @ApiStatus.Obsolete
        public Jar(@NotNull File file) throws IOException {
            if (file == null) {
                Jar.$$$reportNull$$$0(0);
            }
            this(file.toPath());
        }

        public Jar(@NotNull Path file) throws IOException {
            if (file == null) {
                Jar.$$$reportNull$$$0(1);
            }
            super(new JarOutputStream(new BufferedOutputStream(Files.newOutputStream(file, new OpenOption[0]))));
        }

        public void addManifest(@NotNull Manifest manifest) throws IOException {
            if (manifest == null) {
                Jar.$$$reportNull$$$0(2);
            }
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            manifest.write(buffer);
            this.addFile("META-INF/MANIFEST.MF", buffer.toByteArray());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manifest";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/io/Compressor$Jar";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addManifest";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Zip
    extends Compressor {
        private final ZipOutputStream myStream;

        @ApiStatus.Obsolete
        public Zip(@NotNull File file) throws IOException {
            if (file == null) {
                Zip.$$$reportNull$$$0(0);
            }
            this(file.toPath());
        }

        public Zip(@NotNull Path file) throws IOException {
            if (file == null) {
                Zip.$$$reportNull$$$0(1);
            }
            this(new ZipOutputStream(new BufferedOutputStream(Files.newOutputStream(file, new OpenOption[0]))));
        }

        public Zip(@NotNull OutputStream stream) {
            if (stream == null) {
                Zip.$$$reportNull$$$0(2);
            }
            this(new ZipOutputStream(stream));
        }

        public Zip withLevel(int compressionLevel) {
            this.myStream.setLevel(compressionLevel);
            return this;
        }

        protected Zip(ZipOutputStream stream) {
            this.myStream = stream;
        }

        @Override
        protected void writeDirectoryEntry(String name, long timestamp) throws IOException {
            ZipEntry e = new ZipEntry(name + '/');
            e.setMethod(0);
            e.setSize(0L);
            e.setCrc(0L);
            e.setTime(timestamp);
            this.myStream.putNextEntry(e);
            this.myStream.closeEntry();
        }

        @Override
        protected void writeFileEntry(String name, InputStream source, long length, long timestamp, int mode, @Nullable String symlinkTarget) throws IOException {
            ZipEntry e = new ZipEntry(name);
            if (length == 0L) {
                e.setMethod(0);
                e.setSize(0L);
                e.setCrc(0L);
            }
            e.setTime(timestamp);
            this.myStream.putNextEntry(e);
            if (length != 0L) {
                StreamUtil.copy(source, this.myStream);
            }
            this.myStream.closeEntry();
        }

        @Override
        public void close() throws IOException {
            this.myStream.close();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "stream";
                    break;
                }
            }
            objectArray[1] = "com/intellij/util/io/Compressor$Zip";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Tar
    extends Compressor {
        private final TarArchiveOutputStream myStream;

        public Tar(@NotNull Path file, @NotNull Compression compression) throws IOException {
            if (file == null) {
                Tar.$$$reportNull$$$0(0);
            }
            if (compression == null) {
                Tar.$$$reportNull$$$0(1);
            }
            this(Files.newOutputStream(file, new OpenOption[0]), compression);
        }

        @ApiStatus.Obsolete
        public Tar(@NotNull File file, @NotNull Compression compression) throws IOException {
            if (file == null) {
                Tar.$$$reportNull$$$0(2);
            }
            if (compression == null) {
                Tar.$$$reportNull$$$0(3);
            }
            this(file.toPath(), compression);
        }

        private Tar(OutputStream stream, Compression compression) throws IOException {
            this.myStream = new TarArchiveOutputStream(Tar.compressedStream(stream, compression));
            this.myStream.setLongFileMode(3);
        }

        private static OutputStream compressedStream(OutputStream stream, Compression compression) throws IOException {
            if (compression == Compression.GZIP) {
                return new GzipCompressorOutputStream(stream);
            }
            if (compression == Compression.BZIP2) {
                return new BZip2CompressorOutputStream(stream);
            }
            return stream;
        }

        @Override
        protected void writeDirectoryEntry(String name, long timestamp) throws IOException {
            TarArchiveEntry e = new TarArchiveEntry(name + '/');
            e.setModTime(timestamp);
            this.myStream.putArchiveEntry(e);
            this.myStream.closeArchiveEntry();
        }

        @Override
        protected void writeFileEntry(String name, InputStream source, long length, long timestamp, int mode, @Nullable String symlinkTarget) throws IOException {
            TarArchiveEntry e;
            if (symlinkTarget == null) {
                e = new TarArchiveEntry(name);
            } else {
                e = new TarArchiveEntry(name, 50);
                e.setLinkName(symlinkTarget);
                length = 0L;
            }
            if (length < 0L) {
                if (source instanceof ByteArrayInputStream || source instanceof UnsyncByteArrayInputStream) {
                    length = source.available();
                } else {
                    BufferExposingByteArrayOutputStream temp = new BufferExposingByteArrayOutputStream();
                    StreamUtil.copy(source, temp);
                    length = temp.size();
                    source = new ByteArrayInputStream(temp.getInternalBuffer(), 0, temp.size());
                }
            }
            e.setSize(length);
            e.setModTime(timestamp);
            if (mode != 0) {
                e.setMode(mode);
            }
            this.myStream.putArchiveEntry(e);
            if (length > 0L) {
                StreamUtil.copy(source, (OutputStream)this.myStream);
            }
            this.myStream.closeArchiveEntry();
        }

        @Override
        public void close() throws IOException {
            this.myStream.close();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "compression";
                    break;
                }
            }
            objectArray[1] = "com/intellij/util/io/Compressor$Tar";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        public static enum Compression {
            GZIP,
            BZIP2,
            NONE;

        }
    }
}

