/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.VcsShowSettingOption;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.wm.impl.status.StatusBarUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.SvnWCRootCrawler;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.ErrorCategory;
import org.jetbrains.idea.svn.api.ErrorCode;
import org.jetbrains.idea.svn.api.EventAction;
import org.jetbrains.idea.svn.api.ProgressEvent;
import org.jetbrains.idea.svn.api.ProgressTracker;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationManager;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationNew;
import org.jetbrains.idea.svn.browse.DirectoryEntryConsumer;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.dialogs.LockDialog;
import org.jetbrains.idea.svn.info.Info;
import org.jetbrains.idea.svn.status.Status;

public final class SvnUtil {
    @NonNls
    public static final String SVN_ADMIN_DIR_NAME = SystemInfo.isWindows && EnvironmentUtil.getValue((String)"SVN_ASP_DOT_NET_HACK") != null ? "_svn" : ".svn";
    @NonNls
    public static final String ENTRIES_FILE_NAME = "entries";
    @NonNls
    public static final String WC_DB_FILE_NAME = "wc.db";
    @NonNls
    public static final String PATH_TO_LOCK_FILE = SVN_ADMIN_DIR_NAME + "/lock";
    public static final NotNullLazyValue<Path> USER_CONFIGURATION_PATH = NotNullLazyValue.atomicLazy(() -> SystemInfo.isWindows ? Paths.get(Objects.requireNonNull(EnvironmentUtil.getValue((String)"APPDATA")), "Subversion") : Paths.get(SystemProperties.getUserHome(), ".subversion"));
    public static final NotNullLazyValue<Path> SYSTEM_CONFIGURATION_PATH = NotNullLazyValue.atomicLazy(() -> SystemInfo.isWindows ? Paths.get(Objects.requireNonNull(EnvironmentUtil.getValue((String)"ALLUSERSPROFILE")), "Application Data", "Subversion") : Paths.get("/etc/subversion", new String[0]));
    private static final Logger LOG = Logger.getInstance(SvnUtil.class);
    public static final Pattern ERROR_PATTERN = Pattern.compile("^svn: (E(\\d+)): (.*)$", 8);
    public static final Pattern WARNING_PATTERN = Pattern.compile("^svn: warning: (W(\\d+)): (.*)$", 8);
    private static final Pair<Url, WorkingCopyFormat> UNKNOWN_REPOSITORY_AND_FORMAT = Pair.create(null, (Object)((Object)WorkingCopyFormat.UNKNOWN));
    @NonNls
    private static final String NOT_VERSIONED_RESOURCE = "(not a versioned resource)";

    private SvnUtil() {
    }

    @Nullable
    public static String parseWarning(@NotNull String text) {
        Matcher matcher;
        if (text == null) {
            SvnUtil.$$$reportNull$$$0(0);
        }
        return (matcher = WARNING_PATTERN.matcher(text)).find() ? matcher.group() : null;
    }

    @Nullable
    public static Date parseDate(@Nullable String value) {
        return SvnUtil.parseDate(value, true);
    }

    @Nullable
    public static Date parseDate(@Nullable String value, boolean logError) {
        if (value == null) {
            return null;
        }
        try {
            return Date.from(Instant.parse(value));
        }
        catch (ArithmeticException | DateTimeParseException e) {
            if (logError) {
                LOG.error("Could not parse date " + value, (Throwable)e);
            }
            return null;
        }
    }

    public static boolean isSvnVersioned(@NotNull SvnVcs vcs, @NotNull File file) {
        if (vcs == null) {
            SvnUtil.$$$reportNull$$$0(1);
        }
        if (file == null) {
            SvnUtil.$$$reportNull$$$0(2);
        }
        return vcs.getInfo(file) != null;
    }

    @NotNull
    public static Collection<VirtualFile> crawlWCRoots(@NotNull SvnVcs vcs, @NotNull File path, @NotNull SvnWCRootCrawler callback, @Nullable ProgressIndicator progress) {
        VirtualFile file;
        if (vcs == null) {
            SvnUtil.$$$reportNull$$$0(3);
        }
        if (path == null) {
            SvnUtil.$$$reportNull$$$0(4);
        }
        if (callback == null) {
            SvnUtil.$$$reportNull$$$0(5);
        }
        Collection<VirtualFile> collection = (file = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(path)) != null ? SvnUtil.crawlWCRoots(vcs, file, callback, progress) : Collections.emptyList();
        if (collection == null) {
            SvnUtil.$$$reportNull$$$0(6);
        }
        return collection;
    }

    @NotNull
    private static Collection<VirtualFile> crawlWCRoots(@NotNull SvnVcs vcs, @NotNull VirtualFile file, @NotNull SvnWCRootCrawler callback, @Nullable ProgressIndicator progress) {
        VirtualFile parent;
        if (vcs == null) {
            SvnUtil.$$$reportNull$$$0(7);
        }
        if (file == null) {
            SvnUtil.$$$reportNull$$$0(8);
        }
        if (callback == null) {
            SvnUtil.$$$reportNull$$$0(9);
        }
        HashSet<VirtualFile> result = new HashSet<VirtualFile>();
        VirtualFile virtualFile = parent = !file.isDirectory() || !file.isValid() ? file.getParent() : file;
        if (SvnUtil.isSvnVersioned(vcs, VfsUtilCore.virtualToIoFile((VirtualFile)parent))) {
            SvnUtil.checkCanceled(progress);
            callback.handleWorkingCopyRoot(VfsUtilCore.virtualToIoFile((VirtualFile)file), progress);
            SvnUtil.checkCanceled(progress);
            result.add(parent);
        } else if (file.isDirectory()) {
            SvnUtil.checkCanceled(progress);
            for (VirtualFile child : parent.getChildren()) {
                SvnUtil.checkCanceled(progress);
                if (!child.isDirectory()) continue;
                result.addAll(SvnUtil.crawlWCRoots(vcs, child, callback, progress));
            }
        }
        HashSet<VirtualFile> hashSet = result;
        if (hashSet == null) {
            SvnUtil.$$$reportNull$$$0(10);
        }
        return hashSet;
    }

    private static void checkCanceled(@Nullable ProgressIndicator progress) {
        ProgressIndicatorUtils.checkCancelledEvenWithPCEDisabled((ProgressIndicator)progress);
    }

    public static File @NotNull [] toIoFiles(VirtualFile @NotNull [] files) {
        if (files == null) {
            SvnUtil.$$$reportNull$$$0(11);
        }
        File[] fileArray = (File[])ContainerUtil.map2Array((Object[])files, File.class, VfsUtilCore::virtualToIoFile);
        if (fileArray == null) {
            SvnUtil.$$$reportNull$$$0(12);
        }
        return fileArray;
    }

    public static void doLockFiles(Project project, SvnVcs activeVcs, File @NotNull [] ioFiles) throws VcsException {
        boolean force;
        String lockMessage;
        VcsShowSettingOption option;
        if (ioFiles == null) {
            SvnUtil.$$$reportNull$$$0(13);
        }
        if ((option = ProjectLevelVcsManager.getInstance((Project)project).getStandardOption(VcsConfiguration.StandardOption.CHECKOUT, (AbstractVcs)activeVcs)).getValue()) {
            LockDialog dialog = new LockDialog(project, true, ioFiles.length > 1, option);
            if (!dialog.showAndGet()) {
                return;
            }
            lockMessage = dialog.getComment();
            force = dialog.isForce();
        } else {
            lockMessage = "";
            force = false;
        }
        VcsException[] exception = new VcsException[1];
        final ArrayList failedLocks = new ArrayList();
        final int[] count = new int[]{ioFiles.length};
        ProgressTracker eventHandler = new ProgressTracker(){

            public void consume(ProgressEvent event) {
                if (event.getAction() == EventAction.LOCK_FAILED) {
                    failedLocks.add((String)ObjectUtils.notNull((Object)event.getErrorMessage(), (Object)event.getFile().getAbsolutePath()));
                    count[0] = count[0] - 1;
                }
            }

            @Override
            public void checkCancelled() {
            }
        };
        Runnable command = () -> {
            ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
            try {
                if (progress != null) {
                    progress.setText(SvnBundle.message("progress.text.locking.files", new Object[0]));
                }
                for (File ioFile : ioFiles) {
                    if (progress != null) {
                        progress.checkCanceled();
                    }
                    if (progress != null) {
                        progress.setText2(SvnBundle.message("progress.text2.processing.file", ioFile.getName()));
                    }
                    activeVcs.getFactory(ioFile).createLockClient().lock(ioFile, force, lockMessage, eventHandler);
                }
            }
            catch (VcsException e) {
                exception[0] = e;
            }
        };
        ProgressManager.getInstance().runProcessWithProgressSynchronously(command, SvnBundle.message("progress.title.lock.files", new Object[0]), false, project);
        if (!failedLocks.isEmpty()) {
            String[] failedFiles = ArrayUtilRt.toStringArray(failedLocks);
            ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
            for (String file : failedFiles) {
                exceptions.add(new VcsException(SvnBundle.message("exception.text.locking.file.failed", file)));
            }
            @Nls StringBuilder sb = new StringBuilder(SvnBundle.message("message.text.files.lock.failed", failedFiles.length == 1 ? 0 : 1));
            for (VcsException vcsException : exceptions) {
                if (sb.length() > 0) {
                    sb.append('\n');
                }
                sb.append(vcsException.getMessage());
            }
            throw new VcsException(sb.toString());
        }
        StatusBarUtil.setStatusBarInfo((Project)project, (String)SvnBundle.message("message.text.files.locked", count[0]));
        if (exception[0] != null) {
            throw exception[0];
        }
    }

    public static void doUnlockFiles(Project project, SvnVcs activeVcs, File[] ioFiles) throws VcsException {
        boolean force = true;
        VcsException[] exception = new VcsException[1];
        final ArrayList failedUnlocks = new ArrayList();
        final int[] count = new int[]{ioFiles.length};
        ProgressTracker eventHandler = new ProgressTracker(){

            public void consume(ProgressEvent event) {
                if (event.getAction() == EventAction.UNLOCK_FAILED) {
                    failedUnlocks.add((String)ObjectUtils.notNull((Object)event.getErrorMessage(), (Object)event.getFile().getAbsolutePath()));
                    count[0] = count[0] - 1;
                }
            }

            @Override
            public void checkCancelled() {
            }
        };
        Runnable command = () -> {
            ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
            try {
                if (progress != null) {
                    progress.setText(SvnBundle.message("progress.text.unlocking.files", new Object[0]));
                }
                for (File ioFile : ioFiles) {
                    if (progress != null) {
                        progress.checkCanceled();
                    }
                    if (progress != null) {
                        progress.setText2(SvnBundle.message("progress.text2.processing.file", ioFile.getName()));
                    }
                    activeVcs.getFactory(ioFile).createLockClient().unlock(ioFile, true, eventHandler);
                }
            }
            catch (VcsException e) {
                exception[0] = e;
            }
        };
        ProgressManager.getInstance().runProcessWithProgressSynchronously(command, SvnBundle.message("progress.title.unlock.files", new Object[0]), false, project);
        if (!failedUnlocks.isEmpty()) {
            String[] failedFiles = ArrayUtilRt.toStringArray(failedUnlocks);
            ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
            for (String file : failedFiles) {
                exceptions.add(new VcsException(SvnBundle.message("exception.text.failed.to.unlock.file", file)));
            }
            AbstractVcsHelper.getInstance((Project)project).showErrors(exceptions, SvnBundle.message("message.title.unlock.failures", new Object[0]));
        }
        StatusBarUtil.setStatusBarInfo((Project)project, (String)SvnBundle.message("message.text.files.unlocked", count[0]));
        if (exception[0] != null) {
            throw new VcsException((Throwable)exception[0]);
        }
    }

    @NotNull
    public static MultiMap<Pair<Url, WorkingCopyFormat>, Change> splitChangesIntoWc(@NotNull SvnVcs vcs, @NotNull List<? extends Change> changes) {
        if (vcs == null) {
            SvnUtil.$$$reportNull$$$0(14);
        }
        if (changes == null) {
            SvnUtil.$$$reportNull$$$0(15);
        }
        return SvnUtil.splitIntoRepositoriesMap(vcs, changes, change -> ChangesUtil.getFilePath((Change)change));
    }

    @NotNull
    public static <T> MultiMap<Pair<Url, WorkingCopyFormat>, T> splitIntoRepositoriesMap(@NotNull SvnVcs vcs, @NotNull Collection<? extends T> items, @NotNull Convertor<? super T, ? extends FilePath> converter) {
        if (vcs == null) {
            SvnUtil.$$$reportNull$$$0(16);
        }
        if (items == null) {
            SvnUtil.$$$reportNull$$$0(17);
        }
        if (converter == null) {
            SvnUtil.$$$reportNull$$$0(18);
        }
        MultiMap multiMap = ContainerUtil.groupBy(items, item -> {
            RootUrlInfo path = vcs.getSvnFileUrlMapping().getWcRootForFilePath((FilePath)converter.convert(item));
            return path == null ? UNKNOWN_REPOSITORY_AND_FORMAT : Pair.create((Object)path.getRepositoryUrl(), (Object)((Object)path.getFormat()));
        });
        if (multiMap == null) {
            SvnUtil.$$$reportNull$$$0(19);
        }
        return multiMap;
    }

    @NotNull
    public static WorkingCopyFormat getFormat(File path) {
        WorkingCopyFormat result = null;
        File dbFile = SvnUtil.resolveDatabase(path);
        if (dbFile != null && (result = (WorkingCopyFormat)((Object)FileUtilRt.doIOOperation((FileUtilRt.RepeatableIOOperation)new SqLiteJdbcWorkingCopyFormatOperation(dbFile)))) == null) {
            SvnUtil.notifyDatabaseError();
        }
        WorkingCopyFormat workingCopyFormat = result != null ? result : WorkingCopyFormat.UNKNOWN;
        if (workingCopyFormat == null) {
            SvnUtil.$$$reportNull$$$0(20);
        }
        return workingCopyFormat;
    }

    private static void notifyDatabaseError() {
        VcsNotifier.toolWindowNotification().createNotification(SvnBundle.message("notification.content.can.not.access.working.copy.database", new Object[0]), NotificationType.ERROR).notify(null);
    }

    private static File resolveDatabase(File path) {
        File dbFile = SvnUtil.getWcDb(path);
        File result = null;
        try {
            if (dbFile.exists() && dbFile.isFile()) {
                result = dbFile;
            }
        }
        catch (SecurityException e) {
            LOG.error("Failed to access working copy database", (Throwable)e);
        }
        return result;
    }

    @Nullable
    public static String getRepositoryUUID(SvnVcs vcs, File file) {
        Info info = vcs.getInfo(file);
        return info != null ? info.getRepositoryId() : null;
    }

    @Nullable
    public static String getRepositoryUUID(SvnVcs vcs, Url url) {
        try {
            Info info = vcs.getInfo(url, Revision.UNDEFINED);
            return info == null ? null : info.getRepositoryId();
        }
        catch (SvnBindException e) {
            return null;
        }
    }

    @Nullable
    public static Url getRepositoryRoot(SvnVcs vcs, File file) {
        Info info = vcs.getInfo(file);
        return info != null ? info.getRepositoryRootUrl() : null;
    }

    @Nullable
    public static Url getRepositoryRoot(SvnVcs vcs, String url) {
        try {
            return SvnUtil.getRepositoryRoot(vcs, SvnUtil.createUrl(url));
        }
        catch (SvnBindException e) {
            return null;
        }
    }

    @Nullable
    public static Url getRepositoryRoot(SvnVcs vcs, Url url) throws SvnBindException {
        Info info = vcs.getInfo(url, Revision.HEAD);
        return info == null ? null : info.getRepositoryRootUrl();
    }

    public static boolean isWorkingCopyRoot(@NotNull File file) {
        if (file == null) {
            SvnUtil.$$$reportNull$$$0(21);
        }
        return FileUtil.filesEqual((File)file, (File)SvnUtil.getWorkingCopyRoot(file));
    }

    public static boolean isWorkingCopyRoot(@NotNull VirtualFile file) {
        VirtualFile adminDir;
        if (file == null) {
            SvnUtil.$$$reportNull$$$0(22);
        }
        return (adminDir = file.findChild(SVN_ADMIN_DIR_NAME)) != null && adminDir.findChild(WC_DB_FILE_NAME) != null;
    }

    @NotNull
    public static File fileFromUrl(File baseDir, String baseUrl, String fullUrl) {
        assert (fullUrl.startsWith(baseUrl));
        String part = fullUrl.substring(baseUrl.length()).replace('/', File.separatorChar).replace('\\', File.separatorChar);
        return new File(baseDir, part);
    }

    public static VirtualFile getVirtualFile(String filePath) {
        @NonNls String path = VfsUtilCore.pathToUrl((String)filePath.replace(File.separatorChar, '/'));
        return (VirtualFile)ReadAction.compute(() -> VirtualFileManager.getInstance().findFileByUrl(path));
    }

    @Nullable
    public static Url getBranchForUrl(@NotNull SvnVcs vcs, @NotNull VirtualFile vcsRoot, @NotNull Url url) {
        if (vcs == null) {
            SvnUtil.$$$reportNull$$$0(23);
        }
        if (vcsRoot == null) {
            SvnUtil.$$$reportNull$$$0(24);
        }
        if (url == null) {
            SvnUtil.$$$reportNull$$$0(25);
        }
        Url result = null;
        SvnBranchConfigurationNew configuration = SvnBranchConfigurationManager.getInstance(vcs.getProject()).get(vcsRoot);
        try {
            result = configuration.getWorkingBranch(url);
        }
        catch (SvnBindException e) {
            LOG.debug((Throwable)((Object)e));
        }
        return result;
    }

    public static boolean checkRepositoryVersion15(@NotNull SvnVcs vcs, @NotNull Url url) {
        if (vcs == null) {
            SvnUtil.$$$reportNull$$$0(26);
        }
        if (url == null) {
            SvnUtil.$$$reportNull$$$0(27);
        }
        boolean result = false;
        try {
            result = vcs.getFactory().createRepositoryFeaturesClient().supportsMergeTracking(url);
        }
        catch (VcsException e) {
            LOG.info((Throwable)e);
        }
        return result;
    }

    @Nullable
    public static Status getStatus(@NotNull SvnVcs vcs, @NotNull File file) {
        if (vcs == null) {
            SvnUtil.$$$reportNull$$$0(28);
        }
        if (file == null) {
            SvnUtil.$$$reportNull$$$0(29);
        }
        try {
            return vcs.getFactory(file).createStatusClient().doStatus(file, false);
        }
        catch (SvnBindException e) {
            return null;
        }
    }

    @NotNull
    public static Depth getDepth(SvnVcs vcs, File file) {
        Info info = vcs.getInfo(file);
        Depth depth = info != null && info.getDepth() != null ? info.getDepth() : Depth.UNKNOWN;
        if (depth == null) {
            SvnUtil.$$$reportNull$$$0(30);
        }
        return depth;
    }

    public static boolean seemsLikeVersionedDir(@NotNull VirtualFile file) {
        VirtualFile child;
        if (file == null) {
            SvnUtil.$$$reportNull$$$0(31);
        }
        return (child = file.findChild(SVN_ADMIN_DIR_NAME)) != null && child.isDirectory();
    }

    public static boolean seemsLikeVersionedDir(@NotNull File file) {
        if (file == null) {
            SvnUtil.$$$reportNull$$$0(32);
        }
        return new File(file, SVN_ADMIN_DIR_NAME).isDirectory();
    }

    public static boolean isAdminDirectory(VirtualFile file) {
        return SvnUtil.isAdminDirectory(file.getParent(), file.getName());
    }

    public static boolean isAdminDirectory(VirtualFile parent, String name) {
        if (name.equals(SVN_ADMIN_DIR_NAME)) {
            return true;
        }
        if (parent != null) {
            if (parent.getName().equals(SVN_ADMIN_DIR_NAME)) {
                return true;
            }
            if ((parent = parent.getParent()) != null && parent.getName().equals(SVN_ADMIN_DIR_NAME)) {
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static Url getUrl(SvnVcs vcs, File file) {
        Info info = vcs.getInfo(file);
        return info == null ? null : info.getUrl();
    }

    public static boolean remoteFolderIsEmpty(@NotNull SvnVcs vcs, @NotNull String url) throws VcsException {
        if (vcs == null) {
            SvnUtil.$$$reportNull$$$0(33);
        }
        if (url == null) {
            SvnUtil.$$$reportNull$$$0(34);
        }
        Target target = Target.on(SvnUtil.createUrl(url));
        Ref result = new Ref((Object)true);
        DirectoryEntryConsumer handler = entry -> {
            if (entry != null) {
                result.set((Object)false);
            }
        };
        vcs.getFactory(target).createBrowseClient().list(target, null, Depth.IMMEDIATES, handler);
        return (Boolean)result.get();
    }

    public static File getWcDb(File file) {
        return new File(file, SVN_ADMIN_DIR_NAME + "/wc.db");
    }

    @Nullable
    public static File getWorkingCopyRoot(@NotNull File file) {
        File current;
        if (file == null) {
            SvnUtil.$$$reportNull$$$0(35);
        }
        if ((current = SvnUtil.getParentWithDb(file)) == null) {
            return null;
        }
        WorkingCopyFormat format = SvnUtil.getFormat(current);
        return format.isOrGreater(WorkingCopyFormat.ONE_DOT_SEVEN) ? current : null;
    }

    @Nullable
    public static VirtualFile getWorkingCopyRoot(@NotNull VirtualFile file) {
        if (file == null) {
            SvnUtil.$$$reportNull$$$0(36);
        }
        do {
            if (!SvnUtil.isWorkingCopyRoot(file)) continue;
            return file;
        } while ((file = file.getParent()) != null);
        return null;
    }

    @Nullable
    public static File getParentWithDb(@NotNull File file) {
        File current;
        if (file == null) {
            SvnUtil.$$$reportNull$$$0(37);
        }
        boolean wcDbFound = false;
        for (current = file; current != null; current = current.getParentFile()) {
            File wcDb = SvnUtil.getWcDb(current);
            if (!wcDb.exists() || wcDb.isDirectory()) continue;
            wcDbFound = true;
            break;
        }
        if (!wcDbFound) {
            return null;
        }
        return current;
    }

    public static boolean isAncestor(@NotNull Url parentUrl, @NotNull Url childUrl) {
        if (parentUrl == null) {
            SvnUtil.$$$reportNull$$$0(38);
        }
        if (childUrl == null) {
            SvnUtil.$$$reportNull$$$0(39);
        }
        return Url.isAncestor(parentUrl.toDecodedString(), childUrl.toDecodedString());
    }

    public static String getRelativeUrl(@NotNull Url parentUrl, @NotNull Url childUrl) {
        if (parentUrl == null) {
            SvnUtil.$$$reportNull$$$0(40);
        }
        if (childUrl == null) {
            SvnUtil.$$$reportNull$$$0(41);
        }
        return SvnUtil.getRelativeUrl(parentUrl.toDecodedString(), childUrl.toDecodedString());
    }

    public static String getRelativeUrl(@NotNull Target parent, @NotNull Target child) {
        if (parent == null) {
            SvnUtil.$$$reportNull$$$0(42);
        }
        if (child == null) {
            SvnUtil.$$$reportNull$$$0(43);
        }
        return SvnUtil.getRelativeUrl(SvnUtil.toDecodedString(parent), SvnUtil.toDecodedString(child));
    }

    private static String getRelativeUrl(@NotNull String parentUrl, @NotNull String childUrl) {
        if (parentUrl == null) {
            SvnUtil.$$$reportNull$$$0(44);
        }
        if (childUrl == null) {
            SvnUtil.$$$reportNull$$$0(45);
        }
        return FileUtilRt.getRelativePath((String)parentUrl, (String)childUrl, (char)'/', (boolean)true);
    }

    public static String getRelativePath(@NotNull String parentPath, @NotNull String childPath) {
        if (parentPath == null) {
            SvnUtil.$$$reportNull$$$0(46);
        }
        if (childPath == null) {
            SvnUtil.$$$reportNull$$$0(47);
        }
        return FileUtilRt.getRelativePath((String)FileUtil.toSystemIndependentName((String)parentPath), (String)FileUtil.toSystemIndependentName((String)childPath), (char)'/');
    }

    @NotNull
    @Contract(pure=true)
    public static String ensureStartSlash(@NotNull String path) {
        if (path == null) {
            SvnUtil.$$$reportNull$$$0(48);
        }
        Object object = StringUtil.startsWithChar((CharSequence)path, (char)'/') ? path : "/" + path;
        if (object == null) {
            SvnUtil.$$$reportNull$$$0(49);
        }
        return object;
    }

    @NotNull
    public static String join(String ... parts) {
        if (parts == null) {
            SvnUtil.$$$reportNull$$$0(50);
        }
        String string = StringUtil.join((String[])parts, (String)"/");
        if (string == null) {
            SvnUtil.$$$reportNull$$$0(51);
        }
        return string;
    }

    @NotNull
    public static Url removePathTail(@NotNull Url url) throws SvnBindException {
        if (url == null) {
            SvnUtil.$$$reportNull$$$0(52);
        }
        return SvnUtil.createUrl(Url.removeTail(url.toDecodedString()), false);
    }

    @NotNull
    public static Revision getHeadRevision(@NotNull SvnVcs vcs, @NotNull Url url) throws SvnBindException {
        Info info;
        if (vcs == null) {
            SvnUtil.$$$reportNull$$$0(53);
        }
        if (url == null) {
            SvnUtil.$$$reportNull$$$0(54);
        }
        if ((info = vcs.getInfo(url, Revision.HEAD)) == null) {
            throw new SvnBindException(SvnBundle.message("error.could.not.get.info.for.path", url));
        }
        if (!info.getRevision().isValid()) {
            throw new SvnBindException(SvnBundle.message("error.could.not.get.revision.for.url", url));
        }
        Revision revision = info.getRevision();
        if (revision == null) {
            SvnUtil.$$$reportNull$$$0(55);
        }
        return revision;
    }

    public static byte[] getFileContents(@NotNull SvnVcs vcs, @NotNull Target target, @Nullable Revision revision, @Nullable Revision pegRevision) throws VcsException {
        if (vcs == null) {
            SvnUtil.$$$reportNull$$$0(56);
        }
        if (target == null) {
            SvnUtil.$$$reportNull$$$0(57);
        }
        return vcs.getFactory(target).createContentClient().getContent(target, revision, pegRevision);
    }

    @NotNull
    public static Url createUrl(@NotNull String url) throws SvnBindException {
        if (url == null) {
            SvnUtil.$$$reportNull$$$0(58);
        }
        return SvnUtil.createUrl(url, true);
    }

    @NotNull
    public static Url createUrl(@NotNull String url, boolean encoded) throws SvnBindException {
        if (url == null) {
            SvnUtil.$$$reportNull$$$0(59);
        }
        Url url2 = Url.parse(url, encoded);
        if (url2 == null) {
            SvnUtil.$$$reportNull$$$0(60);
        }
        return url2;
    }

    @NotNull
    public static Url parseUrl(@NotNull String url) {
        if (url == null) {
            SvnUtil.$$$reportNull$$$0(61);
        }
        try {
            return SvnUtil.createUrl(url);
        }
        catch (SvnBindException e) {
            throw SvnUtil.createIllegalArgument((Exception)((Object)e));
        }
    }

    @NotNull
    public static Url parseUrl(@NotNull String url, boolean encoded) {
        if (url == null) {
            SvnUtil.$$$reportNull$$$0(62);
        }
        try {
            return SvnUtil.createUrl(url, encoded);
        }
        catch (SvnBindException e) {
            throw SvnUtil.createIllegalArgument((Exception)((Object)e));
        }
    }

    @NotNull
    public static Url append(@NotNull Url parent, @NotNull String child) throws SvnBindException {
        if (parent == null) {
            SvnUtil.$$$reportNull$$$0(63);
        }
        if (child == null) {
            SvnUtil.$$$reportNull$$$0(64);
        }
        return SvnUtil.append(parent, child, false);
    }

    @NotNull
    public static Url append(@NotNull Url parent, @NotNull String child, boolean encoded) throws SvnBindException {
        if (parent == null) {
            SvnUtil.$$$reportNull$$$0(65);
        }
        if (child == null) {
            SvnUtil.$$$reportNull$$$0(66);
        }
        Url url = parent.appendPath(child, encoded);
        if (url == null) {
            SvnUtil.$$$reportNull$$$0(67);
        }
        return url;
    }

    @NotNull
    public static IllegalArgumentException createIllegalArgument(@NotNull Exception e) {
        if (e == null) {
            SvnUtil.$$$reportNull$$$0(68);
        }
        return new IllegalArgumentException(e);
    }

    @Nullable
    public static String getChangelistName(@NotNull Status status) {
        if (status == null) {
            SvnUtil.$$$reportNull$$$0(69);
        }
        return status.getNodeKind().isFile() ? status.getChangeListName() : null;
    }

    public static boolean isUnversionedOrNotFound(@NotNull SvnBindException e) {
        if (e == null) {
            SvnUtil.$$$reportNull$$$0(70);
        }
        return e.contains(ErrorCode.WC_PATH_NOT_FOUND) || e.contains(ErrorCode.UNVERSIONED_RESOURCE) || e.contains(ErrorCode.WC_NOT_WORKING_COPY) || e.contains(ErrorCode.ILLEGAL_TARGET) || StringUtil.containsIgnoreCase((String)e.getMessage(), (String)NOT_VERSIONED_RESOURCE);
    }

    public static boolean isAuthError(@NotNull SvnBindException e) {
        if (e == null) {
            SvnUtil.$$$reportNull$$$0(71);
        }
        return e.contains(ErrorCode.RA_NOT_AUTHORIZED) || e.contains(ErrorCode.RA_UNKNOWN_AUTH) || e.containsCategory(ErrorCategory.AUTHZ) || e.containsCategory(ErrorCategory.AUTHN);
    }

    @NotNull
    public static Target append(@NotNull Target target, @NotNull String path) throws SvnBindException {
        if (target == null) {
            SvnUtil.$$$reportNull$$$0(72);
        }
        if (path == null) {
            SvnUtil.$$$reportNull$$$0(73);
        }
        return SvnUtil.append(target, path, false);
    }

    @NotNull
    public static Target append(@NotNull Target target, @NotNull String path, boolean checkAbsolute) throws SvnBindException {
        if (target == null) {
            SvnUtil.$$$reportNull$$$0(74);
        }
        if (path == null) {
            SvnUtil.$$$reportNull$$$0(75);
        }
        Target result = target.isFile() ? Target.on(SvnUtil.resolvePath(target.getFile(), path)) : Target.on(checkAbsolute && URI.create(path).isAbsolute() ? SvnUtil.createUrl(path) : SvnUtil.append(target.getUrl(), path));
        Target target2 = result;
        if (target2 == null) {
            SvnUtil.$$$reportNull$$$0(76);
        }
        return target2;
    }

    @NotNull
    public static File resolvePath(@NotNull File base, @NotNull String path) {
        File result;
        if (base == null) {
            SvnUtil.$$$reportNull$$$0(77);
        }
        if (path == null) {
            SvnUtil.$$$reportNull$$$0(78);
        }
        if (!(result = new File(path)).isAbsolute()) {
            result = ".".equals(path) ? base : new File(base, path);
        }
        File file = result;
        if (file == null) {
            SvnUtil.$$$reportNull$$$0(79);
        }
        return file;
    }

    @NotNull
    public static String toDecodedString(@NotNull Target target) {
        if (target == null) {
            SvnUtil.$$$reportNull$$$0(80);
        }
        String string = target.isFile() ? target.getFile().getPath() : target.getUrl().toDecodedString();
        if (string == null) {
            SvnUtil.$$$reportNull$$$0(81);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 10, 12, 19, 20, 30, 49, 51, 55, 60, 67, 76, 79, 81 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 14: 
            case 16: 
            case 23: 
            case 26: 
            case 28: 
            case 33: 
            case 53: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 2: 
            case 8: 
            case 21: 
            case 22: 
            case 29: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 48: 
            case 73: 
            case 75: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 6: 
            case 10: 
            case 12: 
            case 19: 
            case 20: 
            case 30: 
            case 49: 
            case 51: 
            case 55: 
            case 60: 
            case 67: 
            case 76: 
            case 79: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/SvnUtil";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ioFiles";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsRoot";
                break;
            }
            case 25: 
            case 27: 
            case 34: 
            case 52: 
            case 54: 
            case 58: 
            case 59: 
            case 61: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 38: 
            case 40: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentUrl";
                break;
            }
            case 39: 
            case 41: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childUrl";
                break;
            }
            case 42: 
            case 63: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 43: 
            case 64: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentPath";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childPath";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parts";
                break;
            }
            case 57: 
            case 72: 
            case 74: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 68: 
            case 70: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/SvnUtil";
                break;
            }
            case 6: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "crawlWCRoots";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "toIoFiles";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "splitIntoRepositoriesMap";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getFormat";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getDepth";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureStartSlash";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "join";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeadRevision";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "createUrl";
                break;
            }
            case 67: 
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "append";
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "resolvePath";
                break;
            }
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "toDecodedString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseWarning";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isSvnVersioned";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "crawlWCRoots";
                break;
            }
            case 6: 
            case 10: 
            case 12: 
            case 19: 
            case 20: 
            case 30: 
            case 49: 
            case 51: 
            case 55: 
            case 60: 
            case 67: 
            case 76: 
            case 79: 
            case 81: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "toIoFiles";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "doLockFiles";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "splitChangesIntoWc";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "splitIntoRepositoriesMap";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isWorkingCopyRoot";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getBranchForUrl";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "checkRepositoryVersion15";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getStatus";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "seemsLikeVersionedDir";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "remoteFolderIsEmpty";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getWorkingCopyRoot";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getParentWithDb";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "isAncestor";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getRelativeUrl";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePath";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "ensureStartSlash";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "join";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "removePathTail";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getHeadRevision";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getFileContents";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "createUrl";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "parseUrl";
                break;
            }
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "append";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "createIllegalArgument";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "getChangelistName";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "isUnversionedOrNotFound";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "isAuthError";
                break;
            }
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "resolvePath";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "toDecodedString";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 10, 12, 19, 20, 30, 49, 51, 55, 60, 67, 76, 79, 81 -> new IllegalStateException(string);
        };
    }

    private static class SqLiteJdbcWorkingCopyFormatOperation
    implements FileUtilRt.RepeatableIOOperation<WorkingCopyFormat, RuntimeException> {
        private static final String SQLITE_JDBC_TEMP_DIR_PROPERTY = "org.sqlite.tmpdir";
        @NonNls
        private static final String USER_VERSION_QUERY = "pragma user_version";
        @NotNull
        private final File myDbFile;

        SqLiteJdbcWorkingCopyFormatOperation(@NotNull File dbFile) {
            if (dbFile == null) {
                SqLiteJdbcWorkingCopyFormatOperation.$$$reportNull$$$0(0);
            }
            this.myDbFile = dbFile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public WorkingCopyFormat execute(boolean lastAttempt) {
            Connection connection = null;
            int userVersion = 0;
            try {
                Class.forName("org.sqlite.JDBC");
                connection = DriverManager.getConnection("jdbc:sqlite:" + FileUtil.toSystemIndependentName((String)this.myDbFile.getPath()));
                ResultSet resultSet = connection.createStatement().executeQuery(USER_VERSION_QUERY);
                if (resultSet.next()) {
                    userVersion = resultSet.getInt(1);
                } else {
                    LOG.info("No result while getting user version for " + this.myDbFile.getPath());
                }
                SqLiteJdbcWorkingCopyFormatOperation.close(connection);
            }
            catch (ClassNotFoundException | SQLException e) {
                LOG.info((Throwable)e);
            }
            finally {
                SqLiteJdbcWorkingCopyFormatOperation.close(connection);
            }
            WorkingCopyFormat format = WorkingCopyFormat.getInstance(userVersion);
            return !WorkingCopyFormat.UNKNOWN.equals((Object)format) ? format : null;
        }

        private static void ensureTempFolder() {
            if (System.getProperty(SQLITE_JDBC_TEMP_DIR_PROPERTY) == null) {
                System.setProperty(SQLITE_JDBC_TEMP_DIR_PROPERTY, PathManager.getTempPath());
            }
        }

        private static void close(@Nullable Connection connection) {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    SvnUtil.notifyDatabaseError();
                }
            }
        }

        static {
            SqLiteJdbcWorkingCopyFormatOperation.ensureTempFolder();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dbFile", "org/jetbrains/idea/svn/SvnUtil$SqLiteJdbcWorkingCopyFormatOperation", "<init>"));
        }
    }
}

