/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.injection;

import com.intellij.lang.ASTNode;
import com.intellij.lang.DependentLanguage;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import org.intellij.plugins.markdown.injection.CodeFenceLanguageProvider;
import org.intellij.plugins.markdown.injection.aliases.CodeFenceLanguageAliases;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypeSets;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypes;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownCodeFence;
import org.intellij.plugins.markdown.lang.psi.util.AstUtilsKt;
import org.intellij.plugins.markdown.lang.psi.util.PsiUtilsKt;
import org.intellij.plugins.markdown.util.MarkdownPsiUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J \u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005H\u0007J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0007J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u0012\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0013\u001a\u00020\u000bJ\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0013\u001a\u00020\rH\u0007J\u001a\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u000bH\u0007\u00a8\u0006\u001a"}, d2={"Lorg/intellij/plugins/markdown/injection/MarkdownCodeFenceUtils;", "", "<init>", "()V", "isCodeFence", "", "node", "Lcom/intellij/lang/ASTNode;", "inCodeFence", "getContent", "", "Lcom/intellij/psi/PsiElement;", "host", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownCodeFence;", "withWhitespaces", "isAbleToAcceptInjections", "getEmptyRange", "Lcom/intellij/openapi/util/TextRange;", "getCodeFence", "element", "getIndent", "", "getLanguageInfoString", "language", "Lcom/intellij/lang/Language;", "context", "intellij.markdown"})
@SourceDebugExtension(value={"SMAP\nMarkdownCodeFenceUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownCodeFenceUtils.kt\norg/intellij/plugins/markdown/injection/MarkdownCodeFenceUtils\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,132:1\n1251#2,2:133\n1#3:135\n12371#4,2:136\n12371#4,2:138\n12734#4,3:140\n*S KotlinDebug\n*F\n+ 1 MarkdownCodeFenceUtils.kt\norg/intellij/plugins/markdown/injection/MarkdownCodeFenceUtils\n*L\n34#1:133,2\n75#1:136,2\n76#1:138,2\n80#1:140,3\n*E\n"})
public final class MarkdownCodeFenceUtils {
    @NotNull
    public static final MarkdownCodeFenceUtils INSTANCE = new MarkdownCodeFenceUtils();

    private MarkdownCodeFenceUtils() {
    }

    public final boolean isCodeFence(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        IElementType iElementType = MarkdownTokenTypeSets.CODE_FENCE;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"CODE_FENCE");
        return AstUtilsKt.hasType(node, iElementType);
    }

    public final boolean inCodeFence(@NotNull ASTNode node) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Sequence<ASTNode> $this$any$iv = AstUtilsKt.parents(node, false);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                ASTNode it = (ASTNode)element$iv;
                boolean bl2 = false;
                IElementType iElementType = MarkdownTokenTypeSets.CODE_FENCE;
                Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"CODE_FENCE");
                if (!AstUtilsKt.hasType(it, iElementType)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    @JvmStatic
    @Nullable
    public static final List<PsiElement> getContent(@NotNull MarkdownCodeFence host, boolean withWhitespaces) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        PsiElement psiElement = host.getFirstChild();
        if (psiElement == null || (psiElement = PsiTreeUtilKt.siblings((PsiElement)psiElement, (boolean)true, (boolean)true)) == null) {
            return null;
        }
        PsiElement children2 = psiElement;
        List elements2 = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)children2, arg_0 -> MarkdownCodeFenceUtils.getContent$lambda$1(withWhitespaces, arg_0)));
        if (!((Collection)elements2).isEmpty() && MarkdownPsiUtil.WhiteSpaces.isNewLine((PsiElement)CollectionsKt.first((List)elements2))) {
            elements2 = CollectionsKt.drop((Iterable)elements2, (int)1);
        }
        if (!((Collection)elements2).isEmpty() && MarkdownPsiUtil.WhiteSpaces.isNewLine((PsiElement)CollectionsKt.last((List)elements2))) {
            elements2 = CollectionsKt.dropLast((List)elements2, (int)1);
        }
        List it = list2 = elements2;
        boolean bl = false;
        return !((Collection)it).isEmpty() ? list2 : null;
    }

    @JvmStatic
    public static final boolean isAbleToAcceptInjections(@NotNull MarkdownCodeFence host) {
        block8: {
            block7: {
                boolean bl;
                block6: {
                    boolean bl2;
                    PsiElement it;
                    boolean $i$f$all;
                    Object[] $this$all$iv;
                    block5: {
                        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
                        PsiElement[] psiElementArray = host.getChildren();
                        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
                        $this$all$iv = psiElementArray;
                        $i$f$all = false;
                        for (Object element$iv : $this$all$iv) {
                            it = (PsiElement)element$iv;
                            boolean bl3 = false;
                            Intrinsics.checkNotNull((Object)it);
                            IElementType iElementType = MarkdownTokenTypes.CODE_FENCE_END;
                            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"CODE_FENCE_END");
                            if (!PsiUtilsKt.hasType(it, iElementType)) continue;
                            bl2 = false;
                            break block5;
                        }
                        bl2 = true;
                    }
                    if (bl2) break block7;
                    PsiElement[] psiElementArray = host.getChildren();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
                    $this$all$iv = psiElementArray;
                    $i$f$all = false;
                    for (Object element$iv : $this$all$iv) {
                        it = (PsiElement)element$iv;
                        boolean bl4 = false;
                        Intrinsics.checkNotNull((Object)it);
                        IElementType iElementType = MarkdownTokenTypes.CODE_FENCE_START;
                        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"CODE_FENCE_START");
                        if (!PsiUtilsKt.hasType(it, iElementType)) continue;
                        bl = false;
                        break block6;
                    }
                    bl = true;
                }
                if (!bl) break block8;
            }
            return false;
        }
        PsiElement[] psiElementArray = host.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
        Object[] $this$count$iv = psiElementArray;
        boolean $i$f$count = false;
        int count$iv = 0;
        for (Object element$iv : $this$count$iv) {
            PsiElement it = (PsiElement)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            if (!MarkdownPsiUtil.WhiteSpaces.isNewLine(it)) continue;
            ++count$iv;
        }
        int newlines = count$iv;
        return newlines >= 2;
    }

    @NotNull
    public final TextRange getEmptyRange(@NotNull MarkdownCodeFence host) {
        PsiElement start;
        PsiElement psiElement;
        Object object;
        PsiElement it;
        block3: {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            PsiElement[] psiElementArray = host.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
            for (Object object2 : (Object[])psiElementArray) {
                it = (PsiElement)object2;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                IElementType iElementType = MarkdownTokenTypes.FENCE_LANG;
                Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"FENCE_LANG");
                if (!PsiUtilsKt.hasType(it, iElementType)) continue;
                object = object2;
                break block3;
            }
            object = null;
        }
        if ((psiElement = (PsiElement)object) == null) {
            Object object3;
            block4: {
                PsiElement[] psiElementArray = host.getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
                for (Object object2 : (Object[])psiElementArray) {
                    it = (PsiElement)object2;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    IElementType iElementType = MarkdownTokenTypes.CODE_FENCE_START;
                    Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"CODE_FENCE_START");
                    if (!PsiUtilsKt.hasType(it, iElementType)) continue;
                    object3 = object2;
                    break block4;
                }
                object3 = null;
            }
            psiElement = (PsiElement)object3;
        }
        PsiElement psiElement2 = start = psiElement;
        Intrinsics.checkNotNull((Object)psiElement2);
        TextRange textRange = TextRange.from((int)(psiElement2.getStartOffsetInParent() + start.getTextLength() + 1), (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"from(...)");
        return textRange;
    }

    @Nullable
    public final MarkdownCodeFence getCodeFence(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        PsiLanguageInjectionHost psiLanguageInjectionHost = InjectedLanguageManager.getInstance((Project)element2.getProject()).getInjectionHost(element2);
        MarkdownCodeFence markdownCodeFence = psiLanguageInjectionHost instanceof MarkdownCodeFence ? (MarkdownCodeFence)psiLanguageInjectionHost : null;
        if (markdownCodeFence == null) {
            markdownCodeFence = (MarkdownCodeFence)PsiTreeUtil.getParentOfType((PsiElement)element2, MarkdownCodeFence.class);
        }
        return markdownCodeFence;
    }

    @JvmStatic
    @Nullable
    public static final String getIndent(@NotNull MarkdownCodeFence element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Document document = PsiDocumentManager.getInstance((Project)element2.getProject()).getDocument(element2.getContainingFile());
        if (document == null) {
            return null;
        }
        Document document2 = document;
        int offset = element2.getTextOffset();
        int lineStartOffset = document2.getLineStartOffset(document2.getLineNumber(offset));
        String string = document2.getText(TextRange.create((int)lineStartOffset, (int)offset));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        CharSequence charSequence = string;
        Regex regex = new Regex("[^> ]");
        String string2 = " ";
        return regex.replace(charSequence, string2);
    }

    @JvmStatic
    @ApiStatus.Internal
    @NotNull
    public static final String getLanguageInfoString(@NotNull Language language, @Nullable PsiElement context) {
        String string;
        String string2;
        block5: {
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            for (CodeFenceLanguageProvider it : (Iterable)CodeFenceLanguageProvider.EP_NAME.getExtensionList()) {
                boolean bl = false;
                String string3 = it.getInfoStringForLanguage(language, context);
                if (string3 == null) continue;
                string2 = string3;
                break block5;
            }
            string2 = string = null;
        }
        if (string2 == null) {
            Object object;
            block6: {
                JBIterable jBIterable = LanguageUtil.getBaseLanguages((Language)language);
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"getBaseLanguages(...)");
                for (Language it : (Iterable)jBIterable) {
                    String string4;
                    boolean bl = false;
                    String string5 = it.getID();
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getID(...)");
                    String string6 = CodeFenceLanguageAliases.INSTANCE.findMainAliasIfRegistered(string5);
                    if (string6 == null) {
                        string6 = it instanceof DependentLanguage ? null : StringUtil.toLowerCase((String)it.getID());
                    }
                    if ((string4 = string6) == null) continue;
                    object = string4;
                    break block6;
                }
                object = string = null;
            }
            if (object == null) {
                String string7 = StringUtil.toLowerCase((String)language.getID());
                string = string7;
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toLowerCase(...)");
            }
        }
        return string;
    }

    private static final boolean getContent$lambda$1(boolean $withWhitespaces, PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !(it instanceof OuterLanguageElement) && (Intrinsics.areEqual((Object)it.getNode().getElementType(), (Object)MarkdownTokenTypes.CODE_FENCE_CONTENT) || MarkdownPsiUtil.WhiteSpaces.isNewLine(it) || $withWhitespaces && MarkdownTokenTypeSets.WHITE_SPACES.contains(PsiTreeUtilKt.getElementType((PsiElement)it)));
    }
}

