package polardb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// TransformDBClusterPayType invokes the polardb.TransformDBClusterPayType API synchronously
func (client *Client) TransformDBClusterPayType(request *TransformDBClusterPayTypeRequest) (response *TransformDBClusterPayTypeResponse, err error) {
	response = CreateTransformDBClusterPayTypeResponse()
	err = client.DoAction(request, response)
	return
}

// TransformDBClusterPayTypeWithChan invokes the polardb.TransformDBClusterPayType API asynchronously
func (client *Client) TransformDBClusterPayTypeWithChan(request *TransformDBClusterPayTypeRequest) (<-chan *TransformDBClusterPayTypeResponse, <-chan error) {
	responseChan := make(chan *TransformDBClusterPayTypeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.TransformDBClusterPayType(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// TransformDBClusterPayTypeWithCallback invokes the polardb.TransformDBClusterPayType API asynchronously
func (client *Client) TransformDBClusterPayTypeWithCallback(request *TransformDBClusterPayTypeRequest, callback func(response *TransformDBClusterPayTypeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *TransformDBClusterPayTypeResponse
		var err error
		defer close(result)
		response, err = client.TransformDBClusterPayType(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// TransformDBClusterPayTypeRequest is the request struct for api TransformDBClusterPayType
type TransformDBClusterPayTypeRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	ResourceGroupId      string           `position:"Query" name:"ResourceGroupId"`
	Period               string           `position:"Query" name:"Period"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId          string           `position:"Query" name:"DBClusterId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	UsedTime             string           `position:"Query" name:"UsedTime"`
	PayType              string           `position:"Query" name:"PayType"`
}

// TransformDBClusterPayTypeResponse is the response struct for api TransformDBClusterPayType
type TransformDBClusterPayTypeResponse struct {
	*responses.BaseResponse
	RequestId   string `json:"RequestId" xml:"RequestId"`
	ChargeType  string `json:"ChargeType" xml:"ChargeType"`
	DBClusterId string `json:"DBClusterId" xml:"DBClusterId"`
	ExpiredTime string `json:"ExpiredTime" xml:"ExpiredTime"`
	OrderId     string `json:"OrderId" xml:"OrderId"`
}

// CreateTransformDBClusterPayTypeRequest creates a request to invoke TransformDBClusterPayType API
func CreateTransformDBClusterPayTypeRequest() (request *TransformDBClusterPayTypeRequest) {
	request = &TransformDBClusterPayTypeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("polardb", "2017-08-01", "TransformDBClusterPayType", "", "")
	request.Method = requests.POST
	return
}

// CreateTransformDBClusterPayTypeResponse creates a response to parse from TransformDBClusterPayType response
func CreateTransformDBClusterPayTypeResponse() (response *TransformDBClusterPayTypeResponse) {
	response = &TransformDBClusterPayTypeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
