/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2021 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * TransfSphericalFoldPnorm using p-norm

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_transf_spherical_fold_pnorm.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 TransfSphericalFoldPnormIteration(
	REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	REAL4 lpN = fabs(z);
	lpN.x = pow(lpN.x, fractal->transformCommon.scale2);
	lpN.y = pow(lpN.y, fractal->transformCommon.scale2);
	lpN.z = pow(lpN.z, fractal->transformCommon.scale2);
	REAL pNorm = lpN.x + lpN.y + lpN.z;
	// if (fractal->transformCommon.functionEnabledFalse)
	//	pNorm +=  pow(lpN.w, fractal->transformCommon.scale2);
	if (fractal->transformCommon.scaleA1 != 1.0f)
		pNorm = pow(pNorm, fractal->transformCommon.scaleA1);
	REAL rr = pNorm;
	REAL useScale = 1.0f;

	useScale = fractal->transformCommon.scale1 - aux->actualScaleA;
	if (fractal->transformCommon.functionEnabledKFalse) // update actualScaleA
		aux->actualScaleA = fractal->transformCommon.scaleVary0 * (fabs(aux->actualScaleA) + 1.0f);
	pNorm = useScale / pNorm;

	z += fractal->transformCommon.offset000;
	REAL minR = fractal->transformCommon.minR0;
	REAL temp = 0.0f;
	if (rr < minR)
	{
		temp = useScale / minR;
		z *= temp;
		aux->DE *= temp;
		minR = minR - rr;
	}
	else if (rr < useScale)
	{
		z *= pNorm;
		aux->DE *= pNorm;
		useScale = useScale - rr;
	}
	z -= fractal->transformCommon.offset000;

	if (fractal->analyticDE.enabledFalse)
		aux->DE = aux->DE * fractal->analyticDE.scale1 + fractal->analyticDE.offset0;

	if (fractal->foldColor.auxColorEnabledFalse)
	{
		aux->color += fractal->foldColor.difs0000.x * temp;
		aux->color += fractal->foldColor.difs0000.y * pNorm;
		aux->color += fractal->foldColor.difs0000.z * minR;
		aux->color += fractal->foldColor.difs0000.w * useScale;
	}
	return z;
}