/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2020 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * Reciprocal3  based on DarkBeam's code from M3D,
 * @reference
 * http://www.fractalforums.com/mandelbulb-3d/custom-formulas-and-transforms-release-t17106/

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_transf_reciprocal3.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 TransfReciprocal3Iteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	REAL4 tempZ = z;

	if (fractal->transformCommon.functionEnabledx)
	{
		if (fractal->transformCommon.functionEnabledAx)
			tempZ.x = (1.0f / fractal->transformCommon.offset111.x)
								- 1.0f / (fabs(z.x) + fractal->transformCommon.offset111.x);

		if (fractal->transformCommon.functionEnabledAxFalse)
			tempZ.x = (fractal->transformCommon.offsetA111.x)
								- 1.0f / (fabs(z.x) + fractal->transformCommon.offset111.x);

		if (fractal->transformCommon.functionEnabledBxFalse)
		{
			REAL M1 = fractal->transformCommon.scale1;
			REAL M2 = fractal->transformCommon.scaleA1;
			tempZ.x = (1.0f / fractal->transformCommon.offset111.x)
								+ (1.0f / fractal->transformCommon.offsetA111.x)
								- 1.0f / (fabs(z.x * M1) + fractal->transformCommon.offset111.x)
								- 1.0f / ((z.x * z.x * M2) + fractal->transformCommon.offsetA111.x);
		}
		if (fractal->transformCommon.functionEnabledCxFalse)
		{
			REAL M1 = fractal->transformCommon.scale1;
			REAL M2 = fractal->transformCommon.scaleA1;
			tempZ.x = fractal->transformCommon.offsetB111.x
								- 1.0f / (fabs(z.x * M1) + fractal->transformCommon.offset111.x)
								- 1.0f / ((z.x * z.x * M2) + fractal->transformCommon.offsetA111.x);
		}

		tempZ.x += fabs(z.x) * fractal->transformCommon.offset000.x; // function slope
		z.x = sign(z.x) * tempZ.x;
	}

	if (fractal->transformCommon.functionEnabledy)
	{
		if (fractal->transformCommon.functionEnabledAx)
			tempZ.y = (1.0f / fractal->transformCommon.offset111.y)
								- 1.0f / (fabs(z.y) + fractal->transformCommon.offset111.y);

		if (fractal->transformCommon.functionEnabledAxFalse)
			tempZ.y = (fractal->transformCommon.offsetA111.y)
								- 1.0f / (fabs(z.y) + fractal->transformCommon.offset111.y);

		if (fractal->transformCommon.functionEnabledBxFalse)
		{
			REAL M1 = fractal->transformCommon.scale1;
			REAL M2 = fractal->transformCommon.scaleA1;
			tempZ.y = (1.0f / fractal->transformCommon.offset111.y)
								+ (1.0f / fractal->transformCommon.offsetA111.y)
								- 1.0f / (fabs(z.y * M1) + fractal->transformCommon.offset111.y)
								- 1.0f / ((z.y * z.y * M2) + fractal->transformCommon.offsetA111.y);
		}

		if (fractal->transformCommon.functionEnabledCxFalse)
		{
			REAL M1 = fractal->transformCommon.scale1;
			REAL M2 = fractal->transformCommon.scaleA1;
			tempZ.y = fractal->transformCommon.offsetB111.y
								- 1.0f / (fabs(z.y * M1) + fractal->transformCommon.offset111.y)
								- 1.0f / ((z.y * z.y * M2) + fractal->transformCommon.offsetA111.y);
		}
		tempZ.y += fabs(z.y) * fractal->transformCommon.offset000.y;
		z.y = sign(z.y) * tempZ.y;
	}

	if (fractal->transformCommon.functionEnabledz)
	{
		if (fractal->transformCommon.functionEnabledAx)
			tempZ.z = (1.0f / fractal->transformCommon.offset111.z)
								- 1.0f / (fabs(z.z) + fractal->transformCommon.offset111.z);

		if (fractal->transformCommon.functionEnabledAxFalse)
			tempZ.z = (fractal->transformCommon.offsetA111.z)
								- 1.0f / (fabs(z.z) + fractal->transformCommon.offset111.z);

		if (fractal->transformCommon.functionEnabledBxFalse)
		{
			REAL M1 = fractal->transformCommon.scale1;
			REAL M2 = fractal->transformCommon.scaleA1;
			tempZ.z = (1.0f / fractal->transformCommon.offset111.z)
								+ (1.0f / fractal->transformCommon.offsetA111.z)
								- 1.0f / (fabs(z.z * M1) + fractal->transformCommon.offset111.z)
								- 1.0f / ((z.z * z.z * M2) + fractal->transformCommon.offsetA111.z);
		}
		if (fractal->transformCommon.functionEnabledCxFalse)
		{
			REAL M1 = fractal->transformCommon.scale1;
			REAL M2 = fractal->transformCommon.scaleA1;
			tempZ.z = fractal->transformCommon.offsetB111.z
								- 1.0f / (fabs(z.z * M1) + fractal->transformCommon.offset111.z)
								- 1.0f / ((z.z * z.z * M2) + fractal->transformCommon.offsetA111.z);
		}

		tempZ.z += fabs(z.z) * fractal->transformCommon.offset000.z;
		z.z = sign(z.z) * tempZ.z;
	}
	aux->DE *= fractal->analyticDE.scale1; // DE tweak
	return z;
}