/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2021 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * TransfDIFSSpring

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_transf_difs_spring.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 TransfDIFSSpringIteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	REAL4 zc = z;

	zc *= fractal->transformCommon.scale1;
	aux->DE *= fractal->transformCommon.scale1;
	zc += fractal->transformCommon.offset000;

	// swap axis
	if (fractal->transformCommon.functionEnabledSwFalse)
	{
		REAL temp = zc.x;
		zc.x = zc.z;
		zc.z = temp;
	}

	REAL T = native_sqrt(zc.x * zc.x + zc.y * zc.y) - fractal->transformCommon.minR05;

	REAL ht1 = fractal->transformCommon.int8X * fractal->transformCommon.offset01;
	REAL ht2 = fractal->transformCommon.int8Y * fractal->transformCommon.offsetp01;

	REAL L = fabs(zc.z) - ht1 - ht2;
	REAL P;
	if (fabs(zc.z) < ht1)
		P = fractal->transformCommon.offset01;
	else
		P = fractal->transformCommon.offsetp01;
	zc.z += atan2(zc.y, zc.x) / M_PI_F * P;
	zc.z = (zc.z - P * 2.0f * floor(zc.z / (P * 2.0f))) - P;

	// L = max(max(T, L), 0.0f);
	// L = native_sqrt(T * T + L * L);

	REAL dd;
	if (!fractal->transformCommon.functionEnabledJFalse)
		dd = native_sqrt(T * T + zc.z * zc.z);
	else
		dd = max(fabs(T), fabs(zc.z));

	dd = max(L, dd);
	if (!fractal->analyticDE.enabledFalse)
		aux->dist = (dd - fractal->transformCommon.offset0005) / (aux->DE + 1.0f);
	else
		aux->dist = min(aux->dist, (dd - fractal->transformCommon.offset0005) / (aux->DE + 1.0f));

	aux->DE0 = (dd - fractal->transformCommon.offset0005); // temp testing

	if (fractal->transformCommon.functionEnabledYFalse) z = zc;

	if (fractal->foldColor.auxColorEnabledFalse)
	{
		if (P == fractal->transformCommon.offset01)
			aux->color = fractal->foldColor.difs0000.x;
		else
			aux->color = fractal->foldColor.difs0000.y;
	}
	return z;
}