/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2023 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * TransfDIFSClipCustom

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_transf_difs_clip_custom.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 TransfDIFSClipCustomIteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	if (fractal->transformCommon.functionEnabledwFalse) aux->dist = length(z) / aux->DE;

	// pre-box option
	if (fractal->transformCommon.functionEnabledAFalse)
	{
		REAL4 zc = z;
		zc += fractal->transformCommon.offsetA000;
		zc = fabs(zc) - fractal->transformCommon.additionConstant111;
		zc.x = max(zc.x, 0.0f);
		zc.y = max(zc.y, 0.0f);
		zc.z = max(zc.z, 0.0f);
		REAL zcd = length(zc) * fractal->transformCommon.scale1 - fractal->transformCommon.offsetB0;
		if (!fractal->transformCommon.functionEnabledNFalse)
		{
			aux->dist = zcd;
		}
		else
		{
			aux->dist = min(aux->dist, zcd);
		}
	}

	// transform c
	REAL4 c = aux->const_c;
	if (fractal->transformCommon.functionEnabledFalse) c = z;

	// polyfold
	if (fractal->transformCommon.functionEnabledPFalse)
	{
		c.y = fabs(c.y);
		REAL psi = M_PI_F / fractal->transformCommon.int6;
		psi = fabs(fmod(atan2(c.y, c.x) + psi, 2.0f * psi) - psi);
		REAL len = native_sqrt(c.x * c.x + c.y * c.y);
		c.x = native_cos(psi) * len;
		c.y = native_sin(psi) * len;
	}

	if (fractal->transformCommon.functionEnabledAxFalse) c.x = fabs(c.x);
	if (fractal->transformCommon.functionEnabledAyFalse) c.y = fabs(c.y);
	if (fractal->transformCommon.functionEnabledAzFalse) c.z = fabs(c.z);

	c *= fractal->transformCommon.scale3D111;
	c += fractal->transformCommon.offset000;
	c = Matrix33MulFloat4(fractal->transformCommon.rotationMatrix, c);

	REAL dst = 0.0f;
	if (fractal->transformCommon.functionEnabledBx)
	{
		REAL4 g = fabs(c) - fractal->transformCommon.offsetC111;
		if (!fractal->transformCommon.functionEnabledCFalse)
		{
			dst = max(max(g.x, g.y), g.z);
		}
		else
		{
			dst = length(c) - length(g);
		}
		if (fractal->transformCommon.functionEnabledOFalse)
		{
			dst = fabs(dst) - fractal->transformCommon.offsetC0;
		}
	}

	REAL dst1 = 0.0f;
	if (fractal->transformCommon.functionEnabledBFalse) // sphere
	{

		if (!fractal->transformCommon.functionEnabledIFalse)
		{
			dst1 = length(c) - fractal->transformCommon.offsetR1; // sphere
		}
		else // cyl or cone
		{
			if (!fractal->transformCommon.functionEnabledEFalse) // cyl
			{
				dst1 = native_sqrt(c.x * c.x + c.y * c.y) - fractal->transformCommon.offsetR1;
			}
			else // cones
			{
				REAL CZ = -c.z;
				if (fractal->transformCommon.functionEnabledFFalse) CZ = fabs(c.z);
				if (fractal->transformCommon.functionEnabledGFalse) CZ = c.z * c.z;
				dst1 = native_sqrt(c.x * c.x + c.y * c.y) - fractal->transformCommon.offsetR1 * CZ;
			}
		}

		if (!fractal->transformCommon.functionEnabledJFalse) // z clip
		{
			dst1 = max(fabs(c.z) - fractal->transformCommon.offset1, dst1);
		}
		if (fractal->transformCommon.functionEnabledMFalse)
		{
			dst1 = fabs(dst1) - fractal->transformCommon.offsetA0;
		}

		if (!fractal->transformCommon.functionEnabledDFalse)
			dst = dst1;
		else
			dst = max(dst, dst1);
	}

	// aux->color
	if (fractal->foldColor.auxColorEnabledFalse)
	{
		REAL addColor = 0.0f;
		if (dst > aux->dist) addColor += fractal->foldColor.difs0000.x;
		if (dst1 > aux->dist) addColor += fractal->foldColor.difs0000.y;
		if (!fractal->transformCommon.functionEnabledyFalse)
			aux->color = addColor;
		else
			aux->color += addColor;
	}

	if (!fractal->transformCommon.functionEnabledxFalse)
	{
		dst *= fractal->analyticDE.scale1;
	}
	else
	{
		dst *= fractal->analyticDE.scale1 / aux->DE;
	}

	dst = max(aux->dist, dst);

	if (!fractal->analyticDE.enabledFalse)
		aux->dist = dst;
	else
		aux->dist = min(dst, aux->dist);
	return z;
}