/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2023 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * abs add  constant,  z = fabs( z + pre-offset) + post-offset

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_transf_abs_add_constant_v2.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 TransfAbsAddConstantV2Iteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	z += fractal->transformCommon.additionConstant000;

	if (fractal->transformCommon.functionEnabledAx)
		z.x = fabs(z.x) + fractal->transformCommon.offset000.x;
	if (fractal->transformCommon.functionEnabledAy)
		z.y = fabs(z.y) + fractal->transformCommon.offset000.y;
	if (fractal->transformCommon.functionEnabledAz)
		z.z = fabs(z.z) + fractal->transformCommon.offset000.z;

	if (fractal->transformCommon.functionEnabledx)
		z.x = fractal->transformCommon.offsetA000.x - fabs(fractal->transformCommon.offsetA000.x - z.x);
	if (fractal->transformCommon.functionEnabledy)
		z.y = fractal->transformCommon.offsetA000.y - fabs(fractal->transformCommon.offsetA000.y - z.y);
	if (fractal->transformCommon.functionEnabledz)
		z.z = fractal->transformCommon.offsetA000.z - fabs(fractal->transformCommon.offsetA000.z - z.z);

	if (fractal->transformCommon.addCpixelEnabledFalse
			&& aux->i >= fractal->transformCommon.startIterationsD
			&& aux->i < fractal->transformCommon.stopIterationsD1)
		aux->const_c = z;
	return z;
}