/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2025 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * Menger Middle Mod

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_menger_middle_mod.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 MengerMiddleModIteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	REAL4 Col = (REAL4){0.0f, 0.0f, 0.0f, 0.0f};
	REAL t = 0.0f;
	// sphere inversion
	if (fractal->transformCommon.sphereInversionEnabledFalse
			&& aux->i >= fractal->transformCommon.startIterationsD
			&& aux->i < fractal->transformCommon.stopIterationsD1)
	{
		REAL rr = 1.0f;
		z += fractal->transformCommon.offset000;
		rr = dot(z, z);
		z *= fractal->transformCommon.maxR2d1 / rr;
		z += fractal->transformCommon.additionConstant000 - fractal->transformCommon.offset000;
		z *= fractal->transformCommon.scaleB1;
		// REAL r = native_sqrt(rr);
		aux->DE *= (fractal->transformCommon.maxR2d1 / rr) * fractal->analyticDE.scale1
							 * fractal->transformCommon.scaleB1;
	}

	// fabs() and menger fold
	z = fabs(z + fractal->transformCommon.additionConstantA000);
	if (z.x < z.y)
	{
		t = z.y;
		z.y = z.x;
		z.x = t;
		Col.x = 1.0f;
	}
	if (z.x < z.z)
	{
		t = z.z;
		z.z = z.x;
		z.x = t;
		Col.y = 1.0f;
	}
	if (z.y < z.z)
	{
		t = z.z;
		z.z = z.y;
		z.y = t;
		Col.z = 1.0f;
	}

	if (fractal->mandelbox.mainRotationEnabled && aux->i >= fractal->transformCommon.startIterationsC
			&& aux->i < fractal->transformCommon.stopIterationsC) // rotation
	{
		z = Matrix33MulFloat4(fractal->mandelbox.mainRot, z);
	}

	if (fractal->transformCommon.functionEnabledBxFalse
			&& aux->i >= fractal->transformCommon.startIterationsA
			&& aux->i < fractal->transformCommon.stopIterationsA) // box fold
	{
		if (fabs(z.x) > fractal->mandelbox.foldingLimit)
		{
			z.x = sign(z.x) * fractal->mandelbox.foldingValue - z.x;
			aux->color += fractal->mandelbox.color.factor.x;
		}
		if (fabs(z.y) > fractal->mandelbox.foldingLimit)
		{
			z.y = sign(z.y) * fractal->mandelbox.foldingValue - z.y;
			aux->color += fractal->mandelbox.color.factor.y;
		}
		REAL zLimit = fractal->mandelbox.foldingLimit * fractal->transformCommon.scale1;
		REAL zValue = fractal->mandelbox.foldingValue * fractal->transformCommon.scale1;
		if (fabs(z.z) > zLimit)
		{
			z.z = sign(z.z) * zValue - z.z;
			aux->color += fractal->mandelbox.color.factor.z;
		}
	}
	if (fractal->transformCommon.functionEnabledByFalse
			&& aux->i >= fractal->transformCommon.startIterations
			&& aux->i < fractal->transformCommon.stopIterations)
	{ // fabsBoxFold
		REAL4 tempA = (REAL4){0.0f, 0.0f, 0.0f, 0.0f};
		REAL4 tempB = (REAL4){0.0f, 0.0f, 0.0f, 0.0f};

		if (fractal->transformCommon.functionEnabledx)
			tempA.x = fabs(z.x + fractal->transformCommon.additionConstant111.x);
		if (fractal->transformCommon.functionEnabledAx)
			tempB.x = fabs(z.x - fractal->transformCommon.additionConstantA111.x);
		z.x = tempA.x - tempB.x - (z.x * fractal->transformCommon.scale3D111.x);

		if (fractal->transformCommon.functionEnabledy)
			tempA.y = fabs(z.y + fractal->transformCommon.additionConstant111.y);
		if (fractal->transformCommon.functionEnabledAy)
			tempB.y = fabs(z.y - fractal->transformCommon.additionConstantA111.y);
		z.y = tempA.y - tempB.y - (z.y * fractal->transformCommon.scale3D111.y);

		if (fractal->transformCommon.functionEnabledz)
			tempA.z = fabs(z.z + fractal->transformCommon.additionConstant111.z);
		if (fractal->transformCommon.functionEnabledAz)
			tempB.z = fabs(z.z - fractal->transformCommon.additionConstantA111.z);
		z.z = tempA.z - tempB.z - (z.z * fractal->transformCommon.scale3D111.z);

		if (aux->i >= fractal->transformCommon.startIterationsB
				&& aux->i < fractal->transformCommon.stopIterationsB)
		{
			z *= fractal->transformCommon.scaleA1;
			aux->DE *= fabs(fractal->transformCommon.scaleA1);
		}
	}
	// menger scale
	REAL useScale = 1.0f;
	if (aux->i >= fractal->transformCommon.startIterationsS
			&& aux->i < fractal->transformCommon.stopIterationsS)
	{
		useScale = aux->actualScaleA + fractal->transformCommon.scale3;

		z *= useScale;

		if (!fractal->analyticDE.enabledFalse)
			aux->DE = aux->DE * fabs(useScale) + 1.0f;
		else // testing for log
			aux->DE = aux->DE * fabs(useScale) * fractal->analyticDE.scale1 + fractal->analyticDE.offset1;

		if (fractal->transformCommon.functionEnabledFFalse
				&& aux->i >= fractal->transformCommon.startIterationsY
				&& aux->i < fractal->transformCommon.stopIterationsY)
		{
			// update actualScaleA for next iteration
			REAL vary = fractal->transformCommon.scaleVary0
									* (fabs(aux->actualScaleA) - fractal->transformCommon.scaleC1);
			if (fractal->transformCommon.functionEnabledMFalse)
				aux->actualScaleA = -vary;
			else
				aux->actualScaleA = aux->actualScaleA - vary;
		}
	}

	// menger offsets
	z.x -= 2.0f * fractal->transformCommon.constantMultiplier111.x;
	z.y -= 2.0f * fractal->transformCommon.constantMultiplier111.y;
	if (fractal->transformCommon.functionEnabled)
	{
		if (z.z > 1.0f)
		{
			z.z -= 2.0f * fractal->transformCommon.constantMultiplier111.z;
			Col.w = 1.0f;
		}
	}
	else
	{
		z.z -= 2.0f * fractal->transformCommon.constantMultiplier111.z;
	}

	if (fractal->transformCommon.addCpixelEnabledFalse) // addCpixel options
	{
		switch (fractal->mandelbulbMulti.orderOfXYZC)
		{
			case multi_OrderOfXYZCl_xyz:
			default: aux->c = (REAL4){aux->c.x, aux->c.y, aux->c.z, aux->c.w}; break;
			case multi_OrderOfXYZCl_xzy: aux->c = (REAL4){aux->c.x, aux->c.z, aux->c.y, aux->c.w}; break;
			case multi_OrderOfXYZCl_yxz: aux->c = (REAL4){aux->c.y, aux->c.x, aux->c.z, aux->c.w}; break;
			case multi_OrderOfXYZCl_yzx: aux->c = (REAL4){aux->c.y, aux->c.z, aux->c.x, aux->c.w}; break;
			case multi_OrderOfXYZCl_zxy: aux->c = (REAL4){aux->c.z, aux->c.x, aux->c.y, aux->c.w}; break;
			case multi_OrderOfXYZCl_zyx: aux->c = (REAL4){aux->c.z, aux->c.y, aux->c.x, aux->c.w}; break;
		}
		z += aux->c * fractal->transformCommon.constantMultiplierC111;
	}
	if (fractal->foldColor.auxColorEnabledFalse && aux->i >= fractal->foldColor.startIterationsA
			&& aux->i < fractal->foldColor.stopIterationsA)
	{
		Col.x *= fractal->foldColor.difs0000.x;
		Col.y *= fractal->foldColor.difs0000.y;
		Col.z *= fractal->foldColor.difs0000.z;
		Col.w *= fractal->foldColor.difs0000.w;
		aux->color += Col.x + Col.y + Col.z + Col.w;
	}
	return z;
}