package servicebus

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AccessRights enumerates the values for access rights.
type AccessRights string

const (
	// Listen ...
	Listen AccessRights = "Listen"
	// Manage ...
	Manage AccessRights = "Manage"
	// SendEnumValue ...
	SendEnumValue AccessRights = "Send"
)

// PossibleAccessRightsValues returns an array of possible values for the AccessRights const type.
func PossibleAccessRightsValues() []AccessRights {
	return []AccessRights{Listen, Manage, SendEnumValue}
}

// EntityAvailabilityStatus enumerates the values for entity availability status.
type EntityAvailabilityStatus string

const (
	// Available ...
	Available EntityAvailabilityStatus = "Available"
	// Limited ...
	Limited EntityAvailabilityStatus = "Limited"
	// Renaming ...
	Renaming EntityAvailabilityStatus = "Renaming"
	// Restoring ...
	Restoring EntityAvailabilityStatus = "Restoring"
	// Unknown ...
	Unknown EntityAvailabilityStatus = "Unknown"
)

// PossibleEntityAvailabilityStatusValues returns an array of possible values for the EntityAvailabilityStatus const type.
func PossibleEntityAvailabilityStatusValues() []EntityAvailabilityStatus {
	return []EntityAvailabilityStatus{Available, Limited, Renaming, Restoring, Unknown}
}

// EntityStatus enumerates the values for entity status.
type EntityStatus string

const (
	// EntityStatusActive ...
	EntityStatusActive EntityStatus = "Active"
	// EntityStatusCreating ...
	EntityStatusCreating EntityStatus = "Creating"
	// EntityStatusDeleting ...
	EntityStatusDeleting EntityStatus = "Deleting"
	// EntityStatusDisabled ...
	EntityStatusDisabled EntityStatus = "Disabled"
	// EntityStatusReceiveDisabled ...
	EntityStatusReceiveDisabled EntityStatus = "ReceiveDisabled"
	// EntityStatusRenaming ...
	EntityStatusRenaming EntityStatus = "Renaming"
	// EntityStatusRestoring ...
	EntityStatusRestoring EntityStatus = "Restoring"
	// EntityStatusSendDisabled ...
	EntityStatusSendDisabled EntityStatus = "SendDisabled"
	// EntityStatusUnknown ...
	EntityStatusUnknown EntityStatus = "Unknown"
)

// PossibleEntityStatusValues returns an array of possible values for the EntityStatus const type.
func PossibleEntityStatusValues() []EntityStatus {
	return []EntityStatus{EntityStatusActive, EntityStatusCreating, EntityStatusDeleting, EntityStatusDisabled, EntityStatusReceiveDisabled, EntityStatusRenaming, EntityStatusRestoring, EntityStatusSendDisabled, EntityStatusUnknown}
}

// NamespaceState enumerates the values for namespace state.
type NamespaceState string

const (
	// NamespaceStateActivating ...
	NamespaceStateActivating NamespaceState = "Activating"
	// NamespaceStateActive ...
	NamespaceStateActive NamespaceState = "Active"
	// NamespaceStateCreated ...
	NamespaceStateCreated NamespaceState = "Created"
	// NamespaceStateCreating ...
	NamespaceStateCreating NamespaceState = "Creating"
	// NamespaceStateDisabled ...
	NamespaceStateDisabled NamespaceState = "Disabled"
	// NamespaceStateDisabling ...
	NamespaceStateDisabling NamespaceState = "Disabling"
	// NamespaceStateEnabling ...
	NamespaceStateEnabling NamespaceState = "Enabling"
	// NamespaceStateFailed ...
	NamespaceStateFailed NamespaceState = "Failed"
	// NamespaceStateRemoved ...
	NamespaceStateRemoved NamespaceState = "Removed"
	// NamespaceStateRemoving ...
	NamespaceStateRemoving NamespaceState = "Removing"
	// NamespaceStateSoftDeleted ...
	NamespaceStateSoftDeleted NamespaceState = "SoftDeleted"
	// NamespaceStateSoftDeleting ...
	NamespaceStateSoftDeleting NamespaceState = "SoftDeleting"
	// NamespaceStateUnknown ...
	NamespaceStateUnknown NamespaceState = "Unknown"
)

// PossibleNamespaceStateValues returns an array of possible values for the NamespaceState const type.
func PossibleNamespaceStateValues() []NamespaceState {
	return []NamespaceState{NamespaceStateActivating, NamespaceStateActive, NamespaceStateCreated, NamespaceStateCreating, NamespaceStateDisabled, NamespaceStateDisabling, NamespaceStateEnabling, NamespaceStateFailed, NamespaceStateRemoved, NamespaceStateRemoving, NamespaceStateSoftDeleted, NamespaceStateSoftDeleting, NamespaceStateUnknown}
}

// Policykey enumerates the values for policykey.
type Policykey string

const (
	// PrimaryKey ...
	PrimaryKey Policykey = "PrimaryKey"
	// SecondaryKey ...
	SecondaryKey Policykey = "SecondaryKey"
)

// PossiblePolicykeyValues returns an array of possible values for the Policykey const type.
func PossiblePolicykeyValues() []Policykey {
	return []Policykey{PrimaryKey, SecondaryKey}
}

// SkuName enumerates the values for sku name.
type SkuName string

const (
	// Basic ...
	Basic SkuName = "Basic"
	// Premium ...
	Premium SkuName = "Premium"
	// Standard ...
	Standard SkuName = "Standard"
)

// PossibleSkuNameValues returns an array of possible values for the SkuName const type.
func PossibleSkuNameValues() []SkuName {
	return []SkuName{Basic, Premium, Standard}
}

// SkuTier enumerates the values for sku tier.
type SkuTier string

const (
	// SkuTierBasic ...
	SkuTierBasic SkuTier = "Basic"
	// SkuTierPremium ...
	SkuTierPremium SkuTier = "Premium"
	// SkuTierStandard ...
	SkuTierStandard SkuTier = "Standard"
)

// PossibleSkuTierValues returns an array of possible values for the SkuTier const type.
func PossibleSkuTierValues() []SkuTier {
	return []SkuTier{SkuTierBasic, SkuTierPremium, SkuTierStandard}
}

// UnavailableReason enumerates the values for unavailable reason.
type UnavailableReason string

const (
	// InvalidName ...
	InvalidName UnavailableReason = "InvalidName"
	// NameInLockdown ...
	NameInLockdown UnavailableReason = "NameInLockdown"
	// NameInUse ...
	NameInUse UnavailableReason = "NameInUse"
	// None ...
	None UnavailableReason = "None"
	// SubscriptionIsDisabled ...
	SubscriptionIsDisabled UnavailableReason = "SubscriptionIsDisabled"
	// TooManyNamespaceInCurrentSubscription ...
	TooManyNamespaceInCurrentSubscription UnavailableReason = "TooManyNamespaceInCurrentSubscription"
)

// PossibleUnavailableReasonValues returns an array of possible values for the UnavailableReason const type.
func PossibleUnavailableReasonValues() []UnavailableReason {
	return []UnavailableReason{InvalidName, NameInLockdown, NameInUse, None, SubscriptionIsDisabled, TooManyNamespaceInCurrentSubscription}
}
