#!/bin/sh

# em_telnet.sh v.0.4, 2005, 2006, 2023 Mikhail Zakharov
# telnet example for empty

telnet="telnet"						# (/full/path/to/)telnet
target="localhost"					# target telnet-host
login="luser" 						# username (Change it!)
password="TopSecret"				# password (Change it!)

fifo_in="/tmp/empty.in"				# input fifo
fifo_out="/tmp/empty.out"			# output

# telnet command examples. Chose one:
telnet_cmd="$telnet -K $target"		# connect FreeBSD from FreeBSD (SRA)
#telnet_cmd="$telnet $target"		# All other OSes

# -----------------------------------------------------------------------------
tmp="/tmp/empty.tmp"				# tempfile to store result

echo "Starting empty"
empty -f -i $fifo_in -o $fifo_out -L $tmp $telnet_cmd
if [ $? = 0 ]; then
	if [ -w $fifo_in -a -r $fifo_out ]; then
		empty -w -v -i $fifo_out -o $fifo_in -t 5 ogin: "$login\n" 
		echo Keyphrase matches : $?
		empty -w -v -i $fifo_out -o $fifo_in -t 5 "qwerrtry" "qwqwqw" assword: "$password\n"
		echo Keyphrase matches : $?
		empty -s -o $fifo_in "echo -- EMPTY TEST BEGIN --\n"
		empty -s -o $fifo_in "uname -a\n"
		empty -s -o $fifo_in "uptime\n"
		empty -s -o $fifo_in "who am i\n"
		empty -s -o $fifo_in "echo -- EMPTY TEST END --\n"
		empty -s -o $fifo_in 'exit\n'
		echo "Check results:"
		sleep 1
		cat $tmp
		rm -f $tmp
	else
		echo "Error: Can't find I/O fifos!"
		return 1
	fi
else
	echo "Error: Can't start empty in daemon mode"
	return 1
fi

echo "Done"
