/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.gamemode.wieldcategory;

import java.util.StringTokenizer;
import pcgen.core.character.WieldCategory;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class DamagemultToken
extends AbstractTokenWithSeparator<WieldCategory>
implements CDOMPrimaryToken<WieldCategory> {
    public String getTokenName() {
        return "DAMAGEMULT";
    }

    protected ParseResult parseTokenWithSeparator(LoadContext context, WieldCategory wc, String value) {
        StringTokenizer st = new StringTokenizer(value, ",");
        while (st.hasMoreTokens()) {
            float mult;
            int numHands;
            String set = st.nextToken();
            ParseResult pr = this.checkForIllegalSeparator('=', set);
            if (!pr.passed()) {
                return pr;
            }
            int equalLoc = set.indexOf(61);
            if (equalLoc == -1) {
                return new ParseResult.Fail("No = in part of token, found: " + set + " in " + value, context);
            }
            if (equalLoc != set.lastIndexOf(61)) {
                return new ParseResult.Fail("Too many = in part of token, found: " + set + " in " + value, context);
            }
            String hands = set.substring(0, equalLoc);
            try {
                numHands = Integer.parseInt(hands);
            }
            catch (NumberFormatException ex) {
                return new ParseResult.Fail(this.getTokenName() + " expected an integer before '='.  Found: " + hands + " in " + value, context);
            }
            String multiplier = set.substring(equalLoc + 1);
            try {
                mult = Float.parseFloat(multiplier);
            }
            catch (NumberFormatException ex) {
                return new ParseResult.Fail(this.getTokenName() + " expected an float after '='.  Found: " + hands + " in " + value, context);
            }
            wc.addDamageMult(numHands, mult);
        }
        return ParseResult.SUCCESS;
    }

    protected char separator() {
        return ',';
    }

    public String[] unparse(LoadContext context, WieldCategory wc) {
        return null;
    }

    public Class<WieldCategory> getTokenClass() {
        return WieldCategory.class;
    }
}

