/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.race;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.StringTokenizer;
import pcgen.base.util.MapToList;
import pcgen.cdom.base.AssociatedPrereqObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.ChooseDriver;
import pcgen.cdom.base.ChooseSelectionActor;
import pcgen.cdom.enumeration.AssociationKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.SkillCost;
import pcgen.cdom.list.ClassSkillList;
import pcgen.cdom.reference.CDOMGroupRef;
import pcgen.cdom.reference.PatternMatchingReference;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;
import pcgen.core.Skill;
import pcgen.persistence.PersistenceLayerException;
import pcgen.rules.context.AssociatedChanges;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.TokenUtilities;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class MoncskillToken
extends AbstractTokenWithSeparator<Race>
implements CDOMPrimaryToken<Race>,
ChooseSelectionActor<Skill> {
    private static final Class<Skill> SKILL_CLASS = Skill.class;

    @Override
    public String getTokenName() {
        return "MONCSKILL";
    }

    @Override
    protected char separator() {
        return '|';
    }

    @Override
    protected ParseResult parseTokenWithSeparator(LoadContext context, Race race, String value) {
        boolean firstToken = true;
        boolean foundAny = false;
        boolean foundOther = false;
        StringTokenizer tok = new StringTokenizer(value, "|");
        CDOMGroupRef<ClassSkillList> monsterList = context.getReferenceContext().getCDOMTypeReference(ClassSkillList.class, "Monster");
        while (tok.hasMoreTokens()) {
            CDOMReference skill;
            String tokText = tok.nextToken();
            if (".CLEAR".equals(tokText)) {
                if (!firstToken) {
                    return new ParseResult.Fail("Non-sensical situation was encountered while parsing " + this.getTokenName() + ": When used, .CLEAR must be the first argument", context);
                }
                context.getListContext().removeAllFromList(this.getTokenName(), race, monsterList);
            } else if (tokText.startsWith(".CLEAR.")) {
                skill = null;
                String clearText = tokText.substring(7);
                if ("ALL".equals(clearText)) {
                    skill = context.getReferenceContext().getCDOMAllReference(SKILL_CLASS);
                } else if ("LIST".equals(clearText)) {
                    context.getObjectContext().removeFromList(race, ListKey.NEW_CHOOSE_ACTOR, this);
                } else {
                    skill = this.getSkillReference(context, clearText);
                    if (skill == null) {
                        return new ParseResult.Fail("  Error was encountered while parsing " + this.getTokenName(), context);
                    }
                }
                if (skill != null) {
                    context.getListContext().removeFromList(this.getTokenName(), race, monsterList, skill);
                }
            } else {
                skill = null;
                if ("ALL".equals(tokText)) {
                    foundAny = true;
                    skill = context.getReferenceContext().getCDOMAllReference(SKILL_CLASS);
                } else {
                    foundOther = true;
                    if ("LIST".equals(tokText)) {
                        context.getObjectContext().addToList(race, ListKey.NEW_CHOOSE_ACTOR, this);
                    } else {
                        skill = this.getSkillReference(context, tokText);
                        if (skill == null) {
                            return new ParseResult.Fail("  Error was encountered while parsing " + this.getTokenName(), context);
                        }
                    }
                }
                if (skill != null) {
                    AssociatedPrereqObject apo = context.getListContext().addToList(this.getTokenName(), race, monsterList, skill);
                    apo.setAssociation(AssociationKey.SKILL_COST, SkillCost.CLASS);
                }
            }
            firstToken = false;
        }
        if (foundAny && foundOther) {
            return new ParseResult.Fail("Non-sensical " + this.getTokenName() + ": Contains ANY and a specific reference: " + value, context);
        }
        return ParseResult.SUCCESS;
    }

    private CDOMReference<Skill> getSkillReference(LoadContext context, String tokText) {
        if (tokText.endsWith("%")) {
            return new PatternMatchingReference<Skill>(Skill.class, context.getReferenceContext().getCDOMAllReference(SKILL_CLASS), tokText);
        }
        return TokenUtilities.getTypeOrPrimitive(context, SKILL_CLASS, tokText);
    }

    @Override
    public String[] unparse(LoadContext context, Race race) {
        Collection<ChooseSelectionActor<?>> listAdded;
        MapToList map;
        Collection<ChooseSelectionActor<?>> listRemoved;
        CDOMGroupRef<ClassSkillList> monsterList = context.getReferenceContext().getCDOMTypeReference(ClassSkillList.class, "Monster");
        AssociatedChanges changes = context.getListContext().getChangesInList(this.getTokenName(), race, monsterList);
        Changes<ChooseSelectionActor<?>> listChanges = context.getObjectContext().getListChanges(race, ListKey.NEW_CHOOSE_ACTOR);
        ArrayList<String> list = new ArrayList<String>();
        Collection removedItems = changes.getRemoved();
        if (removedItems != null && !removedItems.isEmpty()) {
            if (changes.includesGlobalClear()) {
                context.addWriteMessage("Non-sensical relationship in " + this.getTokenName() + ": global .CLEAR and local .CLEAR. performed");
                return null;
            }
            list.add(".CLEAR." + ReferenceUtilities.joinLstFormat(removedItems, "|.CLEAR."));
        }
        if ((listRemoved = listChanges.getRemoved()) != null && !listRemoved.isEmpty() && listRemoved.contains(this)) {
            list.add(".CLEAR.LIST");
        }
        if (changes.includesGlobalClear()) {
            list.add(".CLEAR");
        }
        if ((map = changes.getAddedAssociations()) != null && !map.isEmpty()) {
            Set added = map.getKeySet();
            for (CDOMReference cDOMReference : added) {
                for (AssociatedPrereqObject assoc : map.getListFor((Object)cDOMReference)) {
                    if (SkillCost.CLASS.equals((Object)assoc.getAssociation(AssociationKey.SKILL_COST))) continue;
                    context.addWriteMessage("Skill Cost must be CLASS for Token " + this.getTokenName());
                    return null;
                }
            }
            list.add(ReferenceUtilities.joinLstFormat(added, "|"));
        }
        if ((listAdded = listChanges.getAdded()) != null && !listAdded.isEmpty()) {
            for (ChooseSelectionActor chooseSelectionActor : listAdded) {
                if (!chooseSelectionActor.getSource().equals(this.getTokenName())) continue;
                try {
                    list.add(chooseSelectionActor.getLstFormat());
                }
                catch (PersistenceLayerException e) {
                    context.addWriteMessage("Error writing Prerequisite: " + e);
                    return null;
                }
            }
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.toArray(new String[list.size()]);
    }

    @Override
    public Class<Race> getTokenClass() {
        return Race.class;
    }

    @Override
    public void applyChoice(ChooseDriver obj, Skill skill, PlayerCharacter pc) {
        pc.addMonCSkill(skill, obj);
    }

    @Override
    public void removeChoice(ChooseDriver obj, Skill skill, PlayerCharacter pc) {
        pc.removeMonCSkill(skill, obj);
    }

    @Override
    public String getSource() {
        return this.getTokenName();
    }

    @Override
    public String getLstFormat() {
        return "LIST";
    }

    @Override
    public Class<Skill> getChoiceClass() {
        return SKILL_CLASS;
    }
}

