/*
 * Decompiled with CFR 0.152.
 */
package plugin.exporttokens.deprecated;

import java.util.ArrayList;
import pcgen.cdom.content.LevelCommandFactory;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;
import pcgen.core.SettingsHandler;
import pcgen.core.SpecialAbility;
import pcgen.core.analysis.OutputNameFormatting;
import pcgen.core.display.CharacterDisplay;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.Token;
import pcgen.system.LanguageBundle;

public class RaceToken
extends Token {
    private static final String TOKENNAME = "RACE";
    private static final String[] SUBTOKENLIST = new String[]{"ABILITYLIST"};

    @Override
    public String getTokenName() {
        return TOKENNAME;
    }

    @Override
    public String getToken(String tokenSource, PlayerCharacter pc, ExportHandler eh) {
        String retString = "";
        if (TOKENNAME.equals(tokenSource)) {
            retString = RaceToken.getRaceToken(pc);
        } else {
            String preString = "RACE.";
            for (int i = 0; i < SUBTOKENLIST.length; ++i) {
                String subToken = "RACE." + SUBTOKENLIST[i];
                if (!subToken.equals(tokenSource)) continue;
                retString = RaceToken.getSubToken(SUBTOKENLIST[i], pc.getDisplay());
            }
        }
        return retString;
    }

    private static String getSubToken(String subToken, CharacterDisplay display) {
        if (!subToken.equals(SUBTOKENLIST[0])) {
            return "";
        }
        ArrayList<SpecialAbility> saList = new ArrayList<SpecialAbility>();
        Race race = display.getRace();
        saList.addAll(display.getResolvedUserSpecialAbilities(race));
        saList.addAll(display.getResolvedSpecialAbilities(race));
        if (saList.isEmpty()) {
            return "";
        }
        StringBuilder returnString = new StringBuilder();
        boolean firstLine = true;
        for (SpecialAbility sa : saList) {
            if (!firstLine) {
                returnString.append(", ");
            }
            firstLine = false;
            returnString.append(sa.getDisplayName());
        }
        return returnString.toString();
    }

    private static String getRaceToken(PlayerCharacter pc) {
        PCClass monsterClass;
        PCClass aClass;
        LevelCommandFactory lcf;
        String retString = "";
        Race race = pc.getDisplay().getRace();
        String tempRaceName = OutputNameFormatting.getOutputName(race);
        if (tempRaceName == null || tempRaceName.length() == 0) {
            tempRaceName = race.getDisplayName();
        }
        StringBuilder extraRaceInfo = new StringBuilder(40);
        String subRace = pc.getDisplay().getSubRace();
        if (subRace != null) {
            extraRaceInfo.append(subRace);
        }
        if (SettingsHandler.hideMonsterClasses() && (lcf = race.get(ObjectKey.MONSTER_CLASS)) != null && (aClass = pc.getClassKeyed((monsterClass = lcf.getPCClass()).getKeyName())) != null) {
            int minHD = lcf.getLevelCount().resolve(pc, "").intValue();
            int monsterHD = pc.getDisplay().getLevel(aClass);
            if (monsterHD != minHD) {
                if (extraRaceInfo.length() != 0) {
                    extraRaceInfo.append(' ');
                }
                extraRaceInfo.append(monsterHD).append(LanguageBundle.getString("in_hdLabel"));
            }
        }
        retString = tempRaceName;
        if (extraRaceInfo.length() != 0) {
            retString = retString + " (" + extraRaceInfo + ')';
        }
        return retString;
    }
}

