/*
 * Decompiled with CFR 0.152.
 */
package plugin.experience;

import gmgen.io.ReadXML;
import gmgen.plugin.Combatant;
import gmgen.plugin.InitHolder;
import gmgen.plugin.InitHolderList;
import gmgen.plugin.State;
import gmgen.util.LogUtilities;
import java.io.File;
import java.util.Observable;
import pcgen.core.SettingsHandler;
import pcgen.util.Logging;
import plugin.experience.ExperienceList;
import plugin.experience.ExperienceListItem;

public class ExperienceAdjusterModel
extends Observable {
    private ReadXML experienceTable = null;
    protected ExperienceList enemies = new ExperienceList();
    protected ExperienceList party = new ExperienceList();
    protected InitHolderList combat;
    protected File dir;
    protected double multiplier = 1.0;
    protected int partyExperience;

    public ExperienceAdjusterModel(File parentDir) {
        this.dir = parentDir;
    }

    public void setCombat(InitHolderList combat) {
        this.combat = combat;
    }

    public void setEnemies(ExperienceList enemies) {
        this.enemies = enemies;
    }

    public ExperienceList getEnemies() {
        return this.enemies;
    }

    public void setMultiplier(double mult) {
        this.multiplier = mult;
    }

    public void setParty(ExperienceList party) {
        this.party = party;
    }

    public ExperienceList getParty() {
        return this.party;
    }

    public void addEnemy(ExperienceListItem enemy) {
        this.combat.add(enemy.getCombatant());
        this.enemies.addElement(enemy);
    }

    public void addExperienceToCharacter(ExperienceListItem item, int experience) {
        Combatant cbt = item.getCombatant();
        cbt.setXP(cbt.getXP() + experience);
        LogUtilities.inst().logMessage("Experience_Adjuster", cbt.getName() + " Awarded " + experience + " Experience");
    }

    public void addExperienceToParty() {
        int expType = SettingsHandler.getGMGenOption("Experience_Adjuster.ExperienceType", 2);
        LogUtilities.inst().logMessage("Experience_Adjuster", "Party Awarded " + this.getPartyExperience() + " Total Experience Split as:");
        for (int i = 0; i < this.party.size(); ++i) {
            Combatant cbt = ((ExperienceListItem)this.party.get(i)).getCombatant();
            if (expType == 1) {
                cbt.setXP(cbt.getXP() + this.getPartyTotalExperience() / this.party.size());
                LogUtilities.inst().logMessage("Experience_Adjuster", cbt.getName() + ": " + this.getPartyTotalExperience() / this.party.size());
                continue;
            }
            cbt.setXP(cbt.getXP() + this.getCombatantExperience(cbt));
            LogUtilities.inst().logMessage("Experience_Adjuster", cbt.getName() + ": " + this.getCombatantExperience(cbt));
        }
    }

    public void clearEnemies() {
        for (int i = 0; i < this.enemies.size(); ++i) {
            ExperienceListItem item = (ExperienceListItem)this.enemies.get(i);
            this.combat.remove(item.getCombatant());
        }
        this.enemies.removeAllElements();
    }

    public void populateLists() {
        if (this.combat != null) {
            this.party.removeAllElements();
            this.enemies.removeAllElements();
            for (int i = 0; i < this.combat.size(); ++i) {
                InitHolder iH = (InitHolder)this.combat.get(i);
                if (!(iH instanceof Combatant)) continue;
                Combatant cbt = (Combatant)iH;
                if (cbt.getCombatantType().equals("PC")) {
                    this.party.addElement(new ExperienceListItem(cbt));
                    continue;
                }
                if (!cbt.getCombatantType().equals("Enemy") || cbt.getStatus() != State.Dead && cbt.getStatus() != State.Defeated) continue;
                this.enemies.addElement(new ExperienceListItem(cbt));
            }
        }
    }

    public void removeEnemy(ExperienceListItem enemy) {
        this.combat.remove(enemy.getCombatant());
        this.enemies.removeElement(enemy);
    }

    public int getCombatantExperience(Combatant cbt) {
        int experience = 0;
        File experienceFolder = new File(this.dir, "experience_tables");
        File experienceFile = new File(experienceFolder, "7_1.xml");
        if (this.experienceTable == null) {
            this.experienceTable = new ReadXML(experienceFile);
        }
        for (int i = 0; i < this.enemies.size(); ++i) {
            ExperienceListItem item = (ExperienceListItem)this.enemies.get(i);
            float enemyCR = item.getCombatant().getCR();
            int tableCR = enemyCR < 1.0f ? 1 : (int)enemyCR;
            String xp = (String)this.experienceTable.getTable().crossReference(Integer.toString((int)cbt.getCR()), Integer.toString(tableCR));
            try {
                if (enemyCR < 1.0f) {
                    experience += (int)(Float.parseFloat(xp) * enemyCR);
                    continue;
                }
                experience += Integer.parseInt(xp);
                continue;
            }
            catch (Exception e) {
                Logging.errorPrint("Experience Value: '" + xp + "' Not a number");
                Logging.errorPrint(e.getMessage(), e);
            }
        }
        return new Double((double)experience * this.multiplier / (double)this.party.size()).intValue();
    }

    public int getPartyTotalExperience() {
        int experience = 0;
        File experienceFolder = new File(this.dir, "experience_tables");
        File experienceFile = new File(experienceFolder, "7_1.xml");
        if (this.experienceTable == null) {
            this.experienceTable = new ReadXML(experienceFile);
        }
        for (int i = 0; i < this.enemies.size(); ++i) {
            ExperienceListItem item = (ExperienceListItem)this.enemies.get(i);
            float enemyCR = item.getCombatant().getCR();
            int tableCR = enemyCR < 1.0f ? 1 : (int)enemyCR;
            String xp = (String)this.experienceTable.getTable().crossReference(Integer.toString(this.party.averageCR()), Integer.toString(tableCR));
            try {
                if (enemyCR < 1.0f) {
                    experience += (int)(Float.parseFloat(xp) * enemyCR);
                    continue;
                }
                experience += Integer.parseInt(xp);
                continue;
            }
            catch (Exception e) {
                Logging.errorPrint("Experience Value: '" + xp + "' Not a number");
                Logging.errorPrint(e.getMessage(), e);
            }
        }
        return new Double((double)experience * this.multiplier).intValue();
    }

    public int getPartyExperience() {
        return this.partyExperience;
    }

    public void updatePartyExperience() {
        int expType = SettingsHandler.getGMGenOption("Experience_Adjuster.ExperienceType", 2);
        if (expType == 1) {
            this.partyExperience = this.getPartyTotalExperience();
        } else {
            this.partyExperience = 0;
            for (int i = 0; i < this.party.size(); ++i) {
                Combatant cbt = ((ExperienceListItem)this.party.get(i)).getCombatant();
                this.partyExperience += this.getCombatantExperience(cbt);
            }
        }
    }
}

