/*
 * Decompiled with CFR 0.152.
 */
package pcgen.system;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import pcgen.system.ConfigurationSettings;
import pcgen.system.PropertyContext;
import pcgen.util.Logging;

public class PropertyContextFactory {
    private static PropertyContextFactory DEFAULT_FACTORY;
    private final Map<String, PropertyContext> contextMap = new HashMap<String, PropertyContext>();
    private final String dir;

    public PropertyContextFactory(String dir) {
        this.dir = dir;
    }

    public static PropertyContextFactory getDefaultFactory() {
        return DEFAULT_FACTORY;
    }

    static void setDefaultFactory(String dir) {
        DEFAULT_FACTORY = new PropertyContextFactory(dir);
    }

    public void registerAndLoadPropertyContext(PropertyContext context) {
        this.registerPropertyContext(context);
        String filePath = this.dir == null ? ConfigurationSettings.getSettingsDir() : this.dir;
        this.loadPropertyContext(new File(filePath, context.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPropertyContext(File file) {
        PropertyContext context;
        String name = file.getName();
        if (!file.exists()) {
            if (Logging.isDebugMode()) {
                Logging.debugPrint("No " + name + " file found, will create one when exiting.");
            }
            return;
        }
        if (!file.canWrite()) {
            Logging.errorPrint("WARNING: The file you specified is not updatable. Settings changes will not be saved. File is " + file.getAbsolutePath());
        }
        if ((context = this.contextMap.get(name)) == null) {
            context = new PropertyContext(name);
            this.contextMap.put(name, context);
        }
        FileInputStream in = null;
        boolean loaded = false;
        try {
            in = new FileInputStream(file);
            context.properties.load(in);
            loaded = true;
            context.afterPropertiesLoaded();
        }
        catch (Exception ex) {
            Logging.errorPrint("Error occurred while reading properties", ex);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                Logging.errorPrint("Failed to close input stream for file: " + context.getName(), ex);
            }
        }
        if (!loaded) {
            Logging.errorPrint("Failed to load " + name + ", either the file is unreadable or it " + "is corrupt. Possible solution is to delete the " + name + " file and restart PCGen");
        }
    }

    void loadPropertyContexts() {
        File settingsDir = this.dir == null ? new File(ConfigurationSettings.getSettingsDir()) : new File(this.dir);
        File[] files = settingsDir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory() || !file.getName().endsWith(".ini")) continue;
            this.loadPropertyContext(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void savePropertyContext(File settingsDir, PropertyContext context) {
        File file = new File(settingsDir, context.getName());
        if (file.exists() && !file.canWrite()) {
            Logging.errorPrint("WARNING: Could not update settings file: " + file.getAbsolutePath());
            return;
        }
        FileOutputStream out = null;
        try {
            context.beforePropertiesSaved();
            out = new FileOutputStream(file);
            context.properties.store(out, null);
        }
        catch (Exception ex) {
            Logging.errorPrint("Error occurred while storing properties", ex);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ex) {
                Logging.errorPrint("Failed to close output stream for file: " + context.getName(), ex);
            }
        }
    }

    public void savePropertyContexts() {
        File settingsDir = this.dir == null ? new File(ConfigurationSettings.getSettingsDir()) : new File(this.dir);
        if (settingsDir.exists() || settingsDir.mkdirs()) {
            for (PropertyContext context : this.contextMap.values()) {
                this.savePropertyContext(settingsDir, context);
            }
        } else {
            Logging.errorPrint("Could not create directory to save settings files");
        }
    }

    public PropertyContext getPropertyContext(String fileName) {
        PropertyContext context = this.contextMap.get(fileName);
        if (context == null) {
            context = new PropertyContext(fileName);
            this.contextMap.put(fileName, context);
        }
        return context;
    }

    void registerPropertyContext(PropertyContext context) {
        this.contextMap.put(context.getName(), context);
    }
}

