/*
 * Decompiled with CFR 0.152.
 */
package pcgen.rules.persistence.token;

import java.io.StringWriter;
import java.util.TreeSet;
import pcgen.cdom.base.ConcretePrereqObject;
import pcgen.core.prereq.Prerequisite;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.output.prereq.PrerequisiteWriterFactory;
import pcgen.persistence.lst.output.prereq.PrerequisiteWriterInterface;
import pcgen.persistence.lst.prereq.PrerequisiteParserInterface;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.CDOMSecondaryToken;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.util.Logging;

public class PreCompatibilityToken
implements CDOMPrimaryToken<ConcretePrereqObject>,
CDOMSecondaryToken<ConcretePrereqObject> {
    private static PrerequisiteWriterFactory factory = PrerequisiteWriterFactory.getInstance();
    private final String tokenRoot;
    private final String tokenName;
    private final PrerequisiteParserInterface token;
    private final boolean invert;

    public PreCompatibilityToken(String s, PrerequisiteParserInterface prereqToken, boolean inv) {
        this.tokenRoot = s.toUpperCase();
        this.token = prereqToken;
        this.invert = inv;
        this.tokenName = (this.invert ? "!" : "") + "PRE" + this.tokenRoot;
    }

    @Override
    public Class<ConcretePrereqObject> getTokenClass() {
        return ConcretePrereqObject.class;
    }

    @Override
    public ParseResult parseToken(LoadContext context, ConcretePrereqObject obj, String value) {
        boolean overrideQualify = false;
        String preValue = value;
        if (value.startsWith("Q:")) {
            preValue = value.substring(2);
            overrideQualify = true;
        }
        try {
            Prerequisite p = this.token.parse(this.tokenRoot, preValue, this.invert, overrideQualify);
            if (p == null) {
                return ParseResult.INTERNAL_ERROR;
            }
            context.getObjectContext().put(obj, p);
            return ParseResult.SUCCESS;
        }
        catch (PersistenceLayerException e) {
            return new ParseResult.Fail(e.getMessage(), context);
        }
    }

    @Override
    public String getTokenName() {
        return this.tokenName;
    }

    public int compatibilityLevel() {
        return 5;
    }

    public int compatibilityPriority() {
        return 0;
    }

    public int compatibilitySubLevel() {
        return 14;
    }

    @Override
    public String getParentToken() {
        return "*KITTOKEN";
    }

    @Override
    public String[] unparse(LoadContext context, ConcretePrereqObject obj) {
        Changes<Prerequisite> changes = context.getObjectContext().getPrerequisiteChanges(obj);
        if (changes == null || changes.isEmpty()) {
            return null;
        }
        TreeSet<String> set = new TreeSet<String>();
        for (Prerequisite p : changes.getAdded()) {
            String key;
            String kind = p.getKind();
            StringWriter capture = new StringWriter();
            try {
                PrerequisiteWriterInterface writer = factory.getWriter(kind);
                writer.write(capture, p);
            }
            catch (PersistenceLayerException e) {
                Logging.errorPrint("Error in Compatibility Token", e);
            }
            String output = capture.toString();
            int colonLoc = output.indexOf(58);
            boolean outInvert = output.startsWith("!");
            if (this.invert ^ outInvert || !this.tokenName.equalsIgnoreCase(key = output.substring(0, colonLoc))) continue;
            set.add(output.substring(colonLoc + 1));
        }
        if (set.isEmpty()) {
            return null;
        }
        return set.toArray(new String[set.size()]);
    }
}

