/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.tabs.skill;

import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import pcgen.cdom.enumeration.SkillCost;
import pcgen.facade.core.CharacterFacade;
import pcgen.facade.core.CharacterLevelFacade;
import pcgen.facade.core.CharacterLevelsFacade;
import pcgen.gui2.tabs.Utilities;
import pcgen.system.LanguageBundle;

public class SkillCostTableModel
extends AbstractTableModel
implements ListSelectionListener {
    private final CharacterFacade character;
    private final CharacterLevelsFacade levels;
    private ListSelectionModel selectionModel;

    public SkillCostTableModel(CharacterFacade character, ListSelectionModel selectionModel) {
        this.character = character;
        this.levels = character.getCharacterLevelsFacade();
        this.selectionModel = selectionModel;
        selectionModel.addListSelectionListener(this);
    }

    public static void initializeTable(JTable table) {
        table.setAutoCreateColumnsFromModel(false);
        JTableHeader header = table.getTableHeader();
        DefaultTableColumnModel columns = new DefaultTableColumnModel();
        TableCellRenderer headerRenderer = header.getDefaultRenderer();
        columns.addColumn(Utilities.createTableColumn(0, LanguageBundle.getString("in_skillSkillCost"), headerRenderer, true));
        columns.addColumn(Utilities.createTableColumn(1, LanguageBundle.getString("in_skillRankCost"), headerRenderer, false));
        columns.addColumn(Utilities.createTableColumn(2, LanguageBundle.getString("in_skillMaxRanks"), headerRenderer, false));
        table.setColumnModel(columns);
        table.setFocusable(false);
        table.setCellSelectionEnabled(false);
        header.setReorderingAllowed(false);
        header.setResizingAllowed(false);
    }

    public void install(JTable table) {
        table.setModel(this);
        table.setPreferredScrollableViewportSize(table.getPreferredSize());
    }

    @Override
    public int getRowCount() {
        return 3;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return Integer.class;
            }
            case 2: {
                return Float.class;
            }
        }
        return Object.class;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return LanguageBundle.getString("in_skillSkillCost");
            }
            case 1: {
                return LanguageBundle.getString("in_skillRankCost");
            }
            case 2: {
                return LanguageBundle.getString("in_skillMaxRanks");
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        int index = this.selectionModel.getMinSelectionIndex();
        CharacterLevelFacade level = null;
        if (index != -1) {
            level = (CharacterLevelFacade)this.levels.getElementAt(index);
        }
        SkillCost cost = SkillCost.values()[rowIndex];
        switch (columnIndex) {
            case 0: {
                return cost;
            }
            case 1: {
                if (this.levels == null) {
                    return 0;
                }
                return this.levels.getRankCost(level, cost);
            }
            case 2: {
                if (this.levels == null) {
                    return 0.0;
                }
                return Float.valueOf(this.levels.getMaxRanks(level, cost, false));
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            this.fireTableRowsUpdated(0, 2);
        }
    }
}

