/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import pcgen.core.SettingsHandler;
import pcgen.gui2.doomsdaybook.NameGenPanel;
import pcgen.gui2.tools.Utility;
import pcgen.system.LanguageBundle;

public class RandomNameDialog
extends JDialog {
    private NameGenPanel nameGenPanel = new NameGenPanel(new File(this.getDataDir()));
    private boolean cancelled;

    public RandomNameDialog(JFrame frame, String gender) {
        super(frame, LanguageBundle.getString("in_rndNameTitle"), true);
        this.nameGenPanel.setGender(gender);
        this.initUserInterface();
        this.pack();
        this.setDefaultCloseOperation(1);
        if (frame != null) {
            Utility.setDialogRelativeLocation(frame, this);
        }
        this.cancelled = false;
        Utility.installEscapeCloseOperation(this);
    }

    private void initUserInterface() {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.nameGenPanel, "Center");
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new FlowLayout(2));
        JButton okButton = new JButton(LanguageBundle.getString("in_ok"));
        okButton.setMnemonic(LanguageBundle.getMnemonic("in_mn_ok"));
        controlPanel.add(okButton);
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomNameDialog.this.okButtonActionPerformed();
            }
        });
        JButton cancelButton = new JButton(LanguageBundle.getString("in_cancel"));
        cancelButton.setMnemonic(LanguageBundle.getMnemonic("in_mn_cancel"));
        controlPanel.add(cancelButton);
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomNameDialog.this.cancelButtonActionPerformed();
            }
        });
        this.getContentPane().add((Component)controlPanel, "South");
    }

    private void okButtonActionPerformed() {
        this.setVisible(false);
    }

    private void cancelButtonActionPerformed() {
        this.cancelled = true;
        this.setVisible(false);
    }

    private String getDataDir() {
        String pluginDirectory = SettingsHandler.getGmgenPluginDir().toString();
        return pluginDirectory + File.separator + "Random Names";
    }

    public String getChosenName() {
        if (this.cancelled) {
            return "";
        }
        return this.nameGenPanel.getChosenName();
    }

    public String getGender() {
        if (this.cancelled) {
            return "";
        }
        return this.nameGenPanel.getGender();
    }
}

