/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.dialog;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.apache.commons.lang.StringUtils;
import pcgen.cdom.content.Sponsor;
import pcgen.core.Globals;
import pcgen.gui2.tools.Icons;
import pcgen.gui2.tools.Utility;
import pcgen.gui2.util.GridBoxLayout;
import pcgen.gui2.util.JLabelPane;
import pcgen.system.LanguageBundle;
import pcgen.system.PCGenPropBundle;
import pcgen.util.Logging;

final class MainAbout
extends JPanel {
    static final long serialVersionUID = -423796320641536943L;
    private JButton mailingList;
    private JButton wwwSite;

    MainAbout() {
        this.initComponents();
    }

    private void initComponents() {
        JTabbedPane mainPane = new JTabbedPane();
        mainPane.add(LanguageBundle.getString("in_abt_credits"), this.buildCreditsPanel());
        mainPane.add(LanguageBundle.getString("in_abt_libraries"), this.buildIncludesPanel());
        mainPane.add(LanguageBundle.getString("in_abt_license"), this.buildLicensePanel());
        mainPane.add(LanguageBundle.getString("in_abt_awards"), this.buildAwardsPanel());
        mainPane.add(LanguageBundle.getString("in_abt_sponsors"), this.buildSponsorsPanel());
        this.setLayout(new BorderLayout());
        this.add((Component)mainPane, "Center");
        mainPane.setPreferredSize(new Dimension(640, 480));
    }

    private JPanel buildCreditsPanel() {
        JLabel versionLabel = new JLabel();
        JLabel dateLabel = new JLabel();
        JLabel javaVersionLabel = new JLabel();
        JLabel leaderLabel = new JLabel();
        JLabel helperLabel = new JLabel();
        JLabel wwwLink = new JLabel();
        JLabel emailLabel = new JLabel();
        JTextField version = new JTextField();
        JTextField releaseDate = new JTextField();
        JTextField javaVersion = new JTextField();
        JTextField projectLead = new JTextField();
        this.wwwSite = new JButton();
        this.mailingList = new JButton();
        JTabbedPane monkeyTabPane = new JTabbedPane();
        JPanel aCreditsPanel = new JPanel();
        aCreditsPanel.setLayout(new GridBagLayout());
        versionLabel.setText(LanguageBundle.getString("in_abt_version"));
        GridBagConstraints gridBagConstraints1 = this.buildConstraints(0, 0, 17);
        gridBagConstraints1.weightx = 0.2;
        aCreditsPanel.add((Component)versionLabel, gridBagConstraints1);
        dateLabel.setText(LanguageBundle.getString("in_abt_release_date"));
        gridBagConstraints1 = this.buildConstraints(0, 1, 17);
        aCreditsPanel.add((Component)dateLabel, gridBagConstraints1);
        javaVersionLabel.setText(LanguageBundle.getString("in_abt_java_version"));
        gridBagConstraints1 = this.buildConstraints(0, 2, 17);
        aCreditsPanel.add((Component)javaVersionLabel, gridBagConstraints1);
        leaderLabel.setText(LanguageBundle.getString("in_abt_BD"));
        gridBagConstraints1 = this.buildConstraints(0, 3, 17);
        aCreditsPanel.add((Component)leaderLabel, gridBagConstraints1);
        wwwLink.setText(LanguageBundle.getString("in_abt_web"));
        gridBagConstraints1 = this.buildConstraints(0, 4, 17);
        aCreditsPanel.add((Component)wwwLink, gridBagConstraints1);
        emailLabel.setText(LanguageBundle.getString("in_abt_email"));
        gridBagConstraints1 = this.buildConstraints(0, 5, 17);
        aCreditsPanel.add((Component)emailLabel, gridBagConstraints1);
        helperLabel.setText(LanguageBundle.getString("in_abt_monkeys"));
        gridBagConstraints1 = this.buildConstraints(0, 6, 18);
        aCreditsPanel.add((Component)helperLabel, gridBagConstraints1);
        version.setEditable(false);
        String versionNum = PCGenPropBundle.getVersionNumber();
        if (StringUtils.isNotBlank(PCGenPropBundle.getAutobuildNumber())) {
            versionNum = versionNum + " autobuild #" + PCGenPropBundle.getAutobuildNumber();
        }
        version.setText(versionNum);
        version.setBorder(null);
        version.setOpaque(false);
        gridBagConstraints1 = this.buildConstraints(1, 0, 17);
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.weightx = 1.0;
        aCreditsPanel.add((Component)version, gridBagConstraints1);
        releaseDate.setEditable(false);
        String releaseDateStr = PCGenPropBundle.getReleaseDate();
        if (StringUtils.isNotBlank(PCGenPropBundle.getAutobuildDate())) {
            releaseDateStr = PCGenPropBundle.getAutobuildDate();
        }
        releaseDate.setText(releaseDateStr);
        releaseDate.setBorder(new EmptyBorder(new Insets(1, 1, 1, 1)));
        releaseDate.setOpaque(false);
        gridBagConstraints1 = this.buildConstraints(1, 1, 17);
        gridBagConstraints1.fill = 2;
        aCreditsPanel.add((Component)releaseDate, gridBagConstraints1);
        javaVersion.setEditable(false);
        javaVersion.setText(System.getProperty("java.runtime.version") + " (" + System.getProperty("java.vm.vendor") + ")");
        javaVersion.setBorder(new EmptyBorder(new Insets(1, 1, 1, 1)));
        javaVersion.setOpaque(false);
        gridBagConstraints1 = this.buildConstraints(1, 2, 17);
        gridBagConstraints1.fill = 2;
        aCreditsPanel.add((Component)javaVersion, gridBagConstraints1);
        projectLead.setEditable(false);
        projectLead.setText(PCGenPropBundle.getHeadCodeMonkey());
        projectLead.setBorder(new EmptyBorder(new Insets(1, 1, 1, 1)));
        projectLead.setOpaque(false);
        gridBagConstraints1 = this.buildConstraints(1, 3, 17);
        gridBagConstraints1.fill = 2;
        aCreditsPanel.add((Component)projectLead, gridBagConstraints1);
        this.wwwSite.setText(PCGenPropBundle.getWWWHome());
        this.wwwSite.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Utility.viewInBrowser(MainAbout.this.wwwSite.getText());
                }
                catch (IOException ioe) {
                    Logging.errorPrint(LanguageBundle.getString("in_abt_browser_err"), ioe);
                }
            }
        });
        gridBagConstraints1 = this.buildConstraints(1, 4, 17);
        aCreditsPanel.add((Component)this.wwwSite, gridBagConstraints1);
        this.mailingList.setText(PCGenPropBundle.getMailingList());
        this.mailingList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Utility.viewInBrowser(MainAbout.this.mailingList.getText());
                }
                catch (IOException ioe) {
                    Logging.errorPrint(LanguageBundle.getString("in_abt_browser_err"), ioe);
                }
            }
        });
        gridBagConstraints1 = this.buildConstraints(1, 5, 17);
        aCreditsPanel.add((Component)this.mailingList, gridBagConstraints1);
        gridBagConstraints1 = this.buildConstraints(1, 6, 17);
        gridBagConstraints1.gridwidth = 2;
        gridBagConstraints1.weighty = 1.0;
        gridBagConstraints1.fill = 1;
        aCreditsPanel.add((Component)monkeyTabPane, gridBagConstraints1);
        monkeyTabPane.add(LanguageBundle.getString("in_abt_code_mky"), this.buildMonkeyList(PCGenPropBundle.getCodeMonkeys()));
        monkeyTabPane.add(LanguageBundle.getString("in_abt_list_mky"), this.buildMonkeyList(PCGenPropBundle.getListMonkeys()));
        monkeyTabPane.add(LanguageBundle.getString("in_abt_test_mky"), this.buildMonkeyList(PCGenPropBundle.getTestMonkeys()));
        monkeyTabPane.add(LanguageBundle.getString("in_abt_eng_mky"), this.buildMonkeyList(PCGenPropBundle.getEngineeringMonkeys()));
        monkeyTabPane.setToolTipTextAt(2, LanguageBundle.getString("in_abt_easter_egg"));
        return aCreditsPanel;
    }

    private JScrollPane buildMonkeyList(String monkeys) {
        JTextArea textArea = new JTextArea();
        JScrollPane scroller = new JScrollPane();
        textArea.setWrapStyleWord(true);
        textArea.setLineWrap(true);
        textArea.setEditable(false);
        textArea.setText(monkeys);
        scroller.setViewportView(textArea);
        textArea.setCaretPosition(0);
        return scroller;
    }

    private GridBagConstraints buildConstraints(int xPos, int yPos, int anchor) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = xPos;
        constraints.gridy = yPos;
        constraints.fill = 0;
        constraints.anchor = anchor;
        constraints.insets = new Insets(5, 0, 5, 10);
        return constraints;
    }

    private JPanel buildIncludesPanel() {
        JPanel iPanel = new JPanel();
        JTextArea otherLibrariesField = new JTextArea();
        iPanel.setLayout(new BorderLayout());
        String s = LanguageBundle.getString("in_abt_lib_apache");
        s = s + LanguageBundle.getString("in_abt_lib_jdom");
        s = s + LanguageBundle.getString("in_abt_lib_l2f");
        otherLibrariesField.setText(s);
        otherLibrariesField.setWrapStyleWord(true);
        otherLibrariesField.setLineWrap(true);
        otherLibrariesField.setEditable(false);
        otherLibrariesField.setBorder(BorderFactory.createBevelBorder(1));
        iPanel.add((Component)otherLibrariesField, "Center");
        return iPanel;
    }

    private JPanel buildAwardsPanel() {
        ImageIcon bronzeIcon;
        JScrollPane sp = new JScrollPane();
        JPanel panel = new JPanel();
        JPanel aPanel = new JPanel();
        aPanel.setLayout(new GridBoxLayout(2, 2));
        aPanel.setBackground(Color.WHITE);
        ImageIcon goldIcon = Icons.createImageIcon("gold200x200-2005.gif");
        if (goldIcon != null) {
            JLabel e2005 = new JLabel(goldIcon);
            aPanel.add(e2005);
            JTextArea title = new JTextArea();
            title.setLineWrap(true);
            title.setWrapStyleWord(true);
            title.setEditable(false);
            title.setText(LanguageBundle.getString("in_abt_awards_2005_ennie"));
            aPanel.add(title);
        }
        if ((bronzeIcon = Icons.createImageIcon("bronze200x200-2003.gif")) != null) {
            JLabel e2003 = new JLabel(bronzeIcon);
            aPanel.add(e2003);
            JTextArea title = new JTextArea();
            title.setLineWrap(true);
            title.setWrapStyleWord(true);
            title.setEditable(false);
            title.setText(LanguageBundle.getString("in_abt_awards_2003_ennie"));
            aPanel.add(title);
        }
        sp.setViewportView(aPanel);
        panel.add((Component)sp, "Center");
        return panel;
    }

    private JPanel buildSponsorsPanel() {
        TitledBorder title = BorderFactory.createTitledBorder(null, LanguageBundle.getString("in_abt_sponsorsTitle"));
        title.setTitleJustification(2);
        JLabelPane sponsorLabel = new JLabelPane();
        JScrollPane sp = new JScrollPane(sponsorLabel);
        sp.setBorder(title);
        JPanel panel = new JPanel(new BorderLayout());
        sponsorLabel.setBackground(panel.getBackground());
        panel.add((Component)sp, "Center");
        Collection<Sponsor> sponsors = Globals.getGlobalContext().getReferenceContext().getConstructedCDOMObjects(Sponsor.class);
        StringBuilder sb = new StringBuilder();
        sb.append("<html><b>");
        sb.append(LanguageBundle.getString("in_abt_ourSponsors")).append("</b><br>");
        for (Sponsor sponsor : sponsors) {
            if ("PCGEN".equals(sponsor.getKeyName())) continue;
            sb.append("<img src='").append(sponsor.getBannerImage()).append("'><br>");
        }
        sb.append("</html>");
        sponsorLabel.setText(sb.toString());
        return panel;
    }

    private JPanel buildLicensePanel() {
        JPanel lPanel = new JPanel();
        JScrollPane license = new JScrollPane();
        JTextArea LGPLArea = new JTextArea();
        lPanel.setLayout(new BorderLayout());
        LGPLArea.setEditable(false);
        InputStream lgpl = ClassLoader.getSystemResourceAsStream("LICENSE");
        if (lgpl != null) {
            try {
                LGPLArea.read(new InputStreamReader(lgpl), "LICENSE");
            }
            catch (IOException ioe) {
                LGPLArea.setText(LanguageBundle.getString("in_abt_license_read_err1"));
            }
        } else {
            LGPLArea.setText(LanguageBundle.getString("in_abt_license_read_err2"));
        }
        license.setViewportView(LGPLArea);
        lPanel.add((Component)license, "Center");
        return lPanel;
    }
}

