/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.connection.client;

import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.connection.backend.BungeeCordMessageResponder;
import com.velocitypowered.proxy.connection.backend.VelocityServerConnection;
import com.velocitypowered.proxy.connection.client.ConnectedPlayer;
import com.velocitypowered.proxy.protocol.packet.PluginMessage;
import com.velocitypowered.proxy.protocol.util.PluginMessageUtil;

public class InitialConnectSessionHandler
implements MinecraftSessionHandler {
    private final ConnectedPlayer player;

    InitialConnectSessionHandler(ConnectedPlayer player) {
        this.player = player;
    }

    @Override
    public boolean handle(PluginMessage packet) {
        VelocityServerConnection serverConn = this.player.getConnectionInFlight();
        if (serverConn != null) {
            if (this.player.getPhase().handle(this.player, packet, serverConn)) {
                return true;
            }
            if (PluginMessageUtil.isRegister(packet)) {
                this.player.getKnownChannels().addAll(PluginMessageUtil.getChannels(packet));
            } else if (PluginMessageUtil.isUnregister(packet)) {
                this.player.getKnownChannels().removeAll(PluginMessageUtil.getChannels(packet));
            } else if (BungeeCordMessageResponder.isBungeeCordMessage(packet)) {
                return true;
            }
            serverConn.ensureConnected().write(packet.retain());
        }
        return true;
    }

    @Override
    public void disconnected() {
        this.player.teardown();
    }
}

