/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.api.network;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public enum ProtocolVersion {
    UNKNOWN(-1, "Unknown"),
    LEGACY(-2, "Legacy"),
    MINECRAFT_1_7_2(4, "1.7.2", "1.7.3", "1.7.4", "1.7.5"),
    MINECRAFT_1_7_6(5, "1.7.6", "1.7.7", "1.7.8", "1.7.9", "1.7.10"),
    MINECRAFT_1_8(47, "1.8", "1.8.1", "1.8.2", "1.8.3", "1.8.4", "1.8.5", "1.8.6", "1.8.7", "1.8.8", "1.8.9"),
    MINECRAFT_1_9(107, "1.9"),
    MINECRAFT_1_9_1(108, "1.9.1"),
    MINECRAFT_1_9_2(109, "1.9.2"),
    MINECRAFT_1_9_4(110, "1.9.3", "1.9.4"),
    MINECRAFT_1_10(210, "1.10", "1.10.1", "1.10.2"),
    MINECRAFT_1_11(315, "1.11"),
    MINECRAFT_1_11_1(316, "1.11.1", "1.11.2"),
    MINECRAFT_1_12(335, "1.12"),
    MINECRAFT_1_12_1(338, "1.12.1"),
    MINECRAFT_1_12_2(340, "1.12.2"),
    MINECRAFT_1_13(393, "1.13"),
    MINECRAFT_1_13_1(401, "1.13.1"),
    MINECRAFT_1_13_2(404, "1.13.2"),
    MINECRAFT_1_14(477, "1.14"),
    MINECRAFT_1_14_1(480, "1.14.1"),
    MINECRAFT_1_14_2(485, "1.14.2"),
    MINECRAFT_1_14_3(490, "1.14.3"),
    MINECRAFT_1_14_4(498, "1.14.4"),
    MINECRAFT_1_15(573, "1.15"),
    MINECRAFT_1_15_1(575, "1.15.1"),
    MINECRAFT_1_15_2(578, "1.15.2"),
    MINECRAFT_1_16(735, "1.16"),
    MINECRAFT_1_16_1(736, "1.16.1"),
    MINECRAFT_1_16_2(751, "1.16.2"),
    MINECRAFT_1_16_3(753, "1.16.3"),
    MINECRAFT_1_16_4(754, "1.16.4", "1.16.5"),
    MINECRAFT_1_17(755, "1.17"),
    MINECRAFT_1_17_1(756, "1.17.1");

    private static final int SNAPSHOT_BIT = 30;
    private final int protocol;
    private final int snapshotProtocol;
    private final String[] names;
    public static final ProtocolVersion MINIMUM_VERSION;
    public static final ProtocolVersion MAXIMUM_VERSION;
    public static final String SUPPORTED_VERSION_STRING;
    public static final ImmutableMap<Integer, ProtocolVersion> ID_TO_PROTOCOL_CONSTANT;
    public static final Set<ProtocolVersion> SUPPORTED_VERSIONS;

    private ProtocolVersion(int protocol, String ... names) {
        this(protocol, -1, names);
    }

    private ProtocolVersion(int protocol, int snapshotProtocol, String ... names) {
        this.snapshotProtocol = snapshotProtocol != -1 ? 0x40000000 | snapshotProtocol : -1;
        this.protocol = protocol;
        this.names = names;
    }

    public int getProtocol() {
        return this.protocol == -1 ? this.snapshotProtocol : this.protocol;
    }

    @Deprecated
    public String getName() {
        return this.getVersionIntroducedIn();
    }

    public String getVersionIntroducedIn() {
        return this.names[0];
    }

    public String getMostRecentSupportedVersion() {
        return this.names[this.names.length - 1];
    }

    public List<String> getVersionsSupportedBy() {
        return ImmutableList.copyOf(this.names);
    }

    public static ProtocolVersion getProtocolVersion(int protocol) {
        return ID_TO_PROTOCOL_CONSTANT.getOrDefault(protocol, UNKNOWN);
    }

    public static boolean isSupported(int protocol) {
        ProtocolVersion version = ID_TO_PROTOCOL_CONSTANT.get(protocol);
        return version != null && !version.isUnknown();
    }

    public static boolean isSupported(ProtocolVersion version) {
        return version != null && !version.isUnknown();
    }

    public boolean isUnknown() {
        return this == UNKNOWN;
    }

    public boolean isLegacy() {
        return this == LEGACY;
    }

    public String toString() {
        return this.getVersionIntroducedIn();
    }

    static {
        MINIMUM_VERSION = MINECRAFT_1_7_2;
        MAXIMUM_VERSION = ProtocolVersion.values()[ProtocolVersion.values().length - 1];
        SUPPORTED_VERSION_STRING = String.format("%s-%s", MINIMUM_VERSION.getVersionIntroducedIn(), MAXIMUM_VERSION.getMostRecentSupportedVersion());
        Cloneable versions = new HashMap<Integer, ProtocolVersion>();
        for (ProtocolVersion version : ProtocolVersion.values()) {
            versions.putIfAbsent(version.protocol, version);
            if (version.snapshotProtocol == -1) continue;
            versions.put(version.snapshotProtocol, version);
        }
        ID_TO_PROTOCOL_CONSTANT = ImmutableMap.copyOf(versions);
        versions = EnumSet.noneOf(ProtocolVersion.class);
        for (ProtocolVersion value : ProtocolVersion.values()) {
            if (value.isUnknown() || value.isLegacy()) continue;
            versions.add(value);
        }
        SUPPORTED_VERSIONS = Sets.immutableEnumSet(versions);
    }
}

