// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// A list of key groups, and the public keys in each key group, that CloudFront
// can use to verify the signatures of signed URLs and signed cookies.
type ActiveTrustedKeyGroups struct {

	// This field is true if any of the key groups have public keys that CloudFront
	// can use to verify the signatures of signed URLs and signed cookies. If not, this
	// field is false .
	//
	// This member is required.
	Enabled *bool

	// The number of key groups in the list.
	//
	// This member is required.
	Quantity *int32

	// A list of key groups, including the identifiers of the public keys in each key
	// group that CloudFront can use to verify the signatures of signed URLs and signed
	// cookies.
	Items []KGKeyPairIds

	noSmithyDocumentSerde
}

// A list of Amazon Web Services accounts and the active CloudFront key pairs in
// each account that CloudFront can use to verify the signatures of signed URLs and
// signed cookies.
type ActiveTrustedSigners struct {

	// This field is true if any of the Amazon Web Services accounts in the list are
	// configured as trusted signers. If not, this field is false .
	//
	// This member is required.
	Enabled *bool

	// The number of Amazon Web Services accounts in the list.
	//
	// This member is required.
	Quantity *int32

	// A list of Amazon Web Services accounts and the identifiers of active CloudFront
	// key pairs in each account that CloudFront can use to verify the signatures of
	// signed URLs and signed cookies.
	Items []Signer

	noSmithyDocumentSerde
}

// A complex type that contains information about CNAMEs (alternate domain names),
// if any, for this distribution.
type Aliases struct {

	// The number of CNAME aliases, if any, that you want to associate with this
	// distribution.
	//
	// This member is required.
	Quantity *int32

	// A complex type that contains the CNAME aliases, if any, that you want to
	// associate with this distribution.
	Items []string

	noSmithyDocumentSerde
}

// Amazon Web Services services in China customers must file for an Internet
// Content Provider (ICP) recordal if they want to serve content publicly on an
// alternate domain name, also known as a CNAME, that they've added to CloudFront.
// AliasICPRecordal provides the ICP recordal status for CNAMEs associated with
// distributions. The status is returned in the CloudFront response; you can't
// configure it yourself.
//
// For more information about ICP recordals, see [Signup, Accounts, and Credentials] in Getting Started with Amazon
// Web Services services in China.
//
// [Signup, Accounts, and Credentials]: https://docs.amazonaws.cn/en_us/aws/latest/userguide/accounts-and-credentials.html
type AliasICPRecordal struct {

	// A domain name associated with a distribution.
	CNAME *string

	// The Internet Content Provider (ICP) recordal status for a CNAME. The
	// ICPRecordalStatus is set to APPROVED for all CNAMEs (aliases) in regions outside
	// of China.
	//
	// The status values returned are the following:
	//
	//   - APPROVED indicates that the associated CNAME has a valid ICP recordal
	//   number. Multiple CNAMEs can be associated with a distribution, and CNAMEs can
	//   correspond to different ICP recordals. To be marked as APPROVED, that is, valid
	//   to use with China region, a CNAME must have one ICP recordal number associated
	//   with it.
	//
	//   - SUSPENDED indicates that the associated CNAME does not have a valid ICP
	//   recordal number.
	//
	//   - PENDING indicates that CloudFront can't determine the ICP recordal status
	//   of the CNAME associated with the distribution because there was an error in
	//   trying to determine the status. You can try again to see if the error is
	//   resolved in which case CloudFront returns an APPROVED or SUSPENDED status.
	ICPRecordalStatus ICPRecordalStatus

	noSmithyDocumentSerde
}

// A complex type that controls which HTTP methods CloudFront processes and
// forwards to your Amazon S3 bucket or your custom origin. There are three
// choices:
//
//   - CloudFront forwards only GET and HEAD requests.
//
//   - CloudFront forwards only GET , HEAD , and OPTIONS requests.
//
//   - CloudFront forwards GET, HEAD, OPTIONS, PUT, PATCH, POST , and DELETE
//     requests.
//
// If you pick the third choice, you may need to restrict access to your Amazon S3
// bucket or to your custom origin so users can't perform operations that you don't
// want them to. For example, you might not want users to have permissions to
// delete objects from your origin.
type AllowedMethods struct {

	// A complex type that contains the HTTP methods that you want CloudFront to
	// process and forward to your origin.
	//
	// This member is required.
	Items []Method

	// The number of HTTP methods that you want CloudFront to forward to your origin.
	// Valid values are 2 (for GET and HEAD requests), 3 (for GET , HEAD , and OPTIONS
	// requests) and 7 (for GET, HEAD, OPTIONS, PUT, PATCH, POST , and DELETE
	// requests).
	//
	// This member is required.
	Quantity *int32

	// A complex type that controls whether CloudFront caches the response to requests
	// using the specified HTTP methods. There are two choices:
	//
	//   - CloudFront caches responses to GET and HEAD requests.
	//
	//   - CloudFront caches responses to GET , HEAD , and OPTIONS requests.
	//
	// If you pick the second choice for your Amazon S3 Origin, you may need to
	// forward Access-Control-Request-Method, Access-Control-Request-Headers, and
	// Origin headers for the responses to be cached correctly.
	CachedMethods *CachedMethods

	noSmithyDocumentSerde
}

// An Anycast static IP list. For more information, see [Request Anycast static IPs to use for allowlisting] in the Amazon CloudFront
// Developer Guide.
//
// [Request Anycast static IPs to use for allowlisting]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/request-static-ips.html
type AnycastIpList struct {

	// The static IP addresses that are allocated to the Anycast static IP list.
	//
	// This member is required.
	AnycastIps []string

	// The Amazon Resource Name (ARN) of the Anycast static IP list.
	//
	// This member is required.
	Arn *string

	// The ID of the Anycast static IP list.
	//
	// This member is required.
	Id *string

	// The number of IP addresses in the Anycast static IP list.
	//
	// This member is required.
	IpCount *int32

	// The last time the Anycast static IP list was modified.
	//
	// This member is required.
	LastModifiedTime *time.Time

	// The name of the Anycast static IP list.
	//
	// This member is required.
	Name *string

	// The status of the Anycast static IP list. Valid values: Deployed , Deploying ,
	// or Failed .
	//
	// This member is required.
	Status *string

	noSmithyDocumentSerde
}

// The Anycast static IP list collection.
type AnycastIpListCollection struct {

	// If there are more items in the list collection than are in this response, this
	// value is true .
	//
	// This member is required.
	IsTruncated *bool

	// Use this field when paginating results to indicate where to begin in your list.
	// The response includes items in the list that occur after the marker. To get the
	// next page of the list, set this field's value to the value of NextMarker from
	// the current page's response.
	//
	// This member is required.
	Marker *string

	// The maximum number of Anycast static IP list collections that you want returned
	// in the response.
	//
	// This member is required.
	MaxItems *int32

	// The quantity of Anycast static IP lists in the collection.
	//
	// This member is required.
	Quantity *int32

	// Items in the Anycast static IP list collection. Each item is of the AnycastIpListSummary structure
	// type.
	Items []AnycastIpListSummary

	// Indicates the next page of the Anycast static IP list collection. To get the
	// next page of the list, use this value in the Marker field of your request.
	NextMarker *string

	noSmithyDocumentSerde
}

// An abbreviated version of the AnycastIpList structure. Omits the allocated static IP
// addresses (AnycastIpList$AnycastIps ).
type AnycastIpListSummary struct {

	// The Amazon Resource Name (ARN) of the Anycast static IP list.
	//
	// This member is required.
	Arn *string

	// The ID of the Anycast static IP list.
	//
	// This member is required.
	Id *string

	// The number of IP addresses in the Anycast static IP list.
	//
	// This member is required.
	IpCount *int32

	// The last time the Anycast static IP list was modified.
	//
	// This member is required.
	LastModifiedTime *time.Time

	// The name of the Anycast static IP list.
	//
	// This member is required.
	Name *string

	// The deployment status of the Anycast static IP list. Valid values: Deployed,
	// Deploying, or Failed.
	//
	// This member is required.
	Status *string

	noSmithyDocumentSerde
}

// A complex type that describes how CloudFront processes requests.
//
// You must create at least as many cache behaviors (including the default cache
// behavior) as you have origins if you want CloudFront to serve objects from all
// of the origins. Each cache behavior specifies the one origin from which you want
// CloudFront to get objects. If you have two origins and only the default cache
// behavior, the default cache behavior will cause CloudFront to get objects from
// one of the origins, but the other origin is never used.
//
// For the current quota (formerly known as limit) on the number of cache
// behaviors that you can add to a distribution, see [Quotas]in the Amazon CloudFront
// Developer Guide.
//
// If you don't want to specify any cache behaviors, include only an empty
// CacheBehaviors element. Don't specify an empty individual CacheBehavior
// element, because this is invalid. For more information, see [CacheBehaviors].
//
// To delete all cache behaviors in an existing distribution, update the
// distribution configuration and include only an empty CacheBehaviors element.
//
// To add, change, or remove one or more cache behaviors, update the distribution
// configuration and specify all of the cache behaviors that you want to include in
// the updated distribution.
//
// For more information about cache behaviors, see [Cache Behavior Settings] in the Amazon CloudFront
// Developer Guide.
//
// [Cache Behavior Settings]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesCacheBehavior
// [Quotas]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html
// [CacheBehaviors]: https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_CacheBehaviors.html
type CacheBehavior struct {

	// The pattern (for example, images/*.jpg ) that specifies which requests to apply
	// the behavior to. When CloudFront receives a viewer request, the requested path
	// is compared with path patterns in the order in which cache behaviors are listed
	// in the distribution.
	//
	// You can optionally include a slash ( / ) at the beginning of the path pattern.
	// For example, /images/*.jpg . CloudFront behavior is the same with or without the
	// leading / .
	//
	// The path pattern for the default cache behavior is * and cannot be changed. If
	// the request for an object does not match the path pattern for any cache
	// behaviors, CloudFront applies the behavior in the default cache behavior.
	//
	// For more information, see [Path Pattern] in the Amazon CloudFront Developer Guide.
	//
	// [Path Pattern]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesPathPattern
	//
	// This member is required.
	PathPattern *string

	// The value of ID for the origin that you want CloudFront to route requests to
	// when they match this cache behavior.
	//
	// This member is required.
	TargetOriginId *string

	// The protocol that viewers can use to access the files in the origin specified
	// by TargetOriginId when a request matches the path pattern in PathPattern . You
	// can specify the following options:
	//
	//   - allow-all : Viewers can use HTTP or HTTPS.
	//
	//   - redirect-to-https : If a viewer submits an HTTP request, CloudFront returns
	//   an HTTP status code of 301 (Moved Permanently) to the viewer along with the
	//   HTTPS URL. The viewer then resubmits the request using the new URL.
	//
	//   - https-only : If a viewer sends an HTTP request, CloudFront returns an HTTP
	//   status code of 403 (Forbidden).
	//
	// For more information about requiring the HTTPS protocol, see [Requiring HTTPS Between Viewers and CloudFront] in the Amazon
	// CloudFront Developer Guide.
	//
	// The only way to guarantee that viewers retrieve an object that was fetched from
	// the origin using HTTPS is never to use any other protocol to fetch the object.
	// If you have recently changed from HTTP to HTTPS, we recommend that you clear
	// your objects' cache because cached objects are protocol agnostic. That means
	// that an edge location will return an object from the cache regardless of whether
	// the current request protocol matches the protocol used previously. For more
	// information, see [Managing Cache Expiration]in the Amazon CloudFront Developer Guide.
	//
	// [Requiring HTTPS Between Viewers and CloudFront]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https-viewers-to-cloudfront.html
	// [Managing Cache Expiration]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html
	//
	// This member is required.
	ViewerProtocolPolicy ViewerProtocolPolicy

	// A complex type that controls which HTTP methods CloudFront processes and
	// forwards to your Amazon S3 bucket or your custom origin. There are three
	// choices:
	//
	//   - CloudFront forwards only GET and HEAD requests.
	//
	//   - CloudFront forwards only GET , HEAD , and OPTIONS requests.
	//
	//   - CloudFront forwards GET, HEAD, OPTIONS, PUT, PATCH, POST , and DELETE
	//   requests.
	//
	// If you pick the third choice, you may need to restrict access to your Amazon S3
	// bucket or to your custom origin so users can't perform operations that you don't
	// want them to. For example, you might not want users to have permissions to
	// delete objects from your origin.
	AllowedMethods *AllowedMethods

	// The unique identifier of the cache policy that is attached to this cache
	// behavior. For more information, see [Creating cache policies]or [Using the managed cache policies] in the Amazon CloudFront Developer
	// Guide.
	//
	// A CacheBehavior must include either a CachePolicyId or ForwardedValues . We
	// recommend that you use a CachePolicyId .
	//
	// [Creating cache policies]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy
	// [Using the managed cache policies]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html
	CachePolicyId *string

	// Whether you want CloudFront to automatically compress certain files for this
	// cache behavior. If so, specify true; if not, specify false. For more
	// information, see [Serving Compressed Files]in the Amazon CloudFront Developer Guide.
	//
	// [Serving Compressed Files]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/ServingCompressedFiles.html
	Compress *bool

	// This field is deprecated. We recommend that you use the DefaultTTL field in a
	// cache policy instead of this field. For more information, see [Creating cache policies]or [Using the managed cache policies] in the Amazon
	// CloudFront Developer Guide.
	//
	// The default amount of time that you want objects to stay in CloudFront caches
	// before CloudFront forwards another request to your origin to determine whether
	// the object has been updated. The value that you specify applies only when your
	// origin does not add HTTP headers such as Cache-Control max-age , Cache-Control
	// s-maxage , and Expires to objects. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)] in the Amazon
	// CloudFront Developer Guide.
	//
	// [Creating cache policies]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy
	// [Using the managed cache policies]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html
	// [Managing How Long Content Stays in an Edge Cache (Expiration)]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html
	//
	// Deprecated: This member has been deprecated.
	DefaultTTL *int64

	// The value of ID for the field-level encryption configuration that you want
	// CloudFront to use for encrypting specific fields of data for this cache
	// behavior.
	FieldLevelEncryptionId *string

	// This field is deprecated. We recommend that you use a cache policy or an origin
	// request policy instead of this field. For more information, see [Working with policies]in the Amazon
	// CloudFront Developer Guide.
	//
	// If you want to include values in the cache key, use a cache policy. For more
	// information, see [Creating cache policies]or [Using the managed cache policies] in the Amazon CloudFront Developer Guide.
	//
	// If you want to send values to the origin but not include them in the cache key,
	// use an origin request policy. For more information, see [Creating origin request policies]or [Using the managed origin request policies] in the Amazon
	// CloudFront Developer Guide.
	//
	// A CacheBehavior must include either a CachePolicyId or ForwardedValues . We
	// recommend that you use a CachePolicyId .
	//
	// A complex type that specifies how CloudFront handles query strings, cookies,
	// and HTTP headers.
	//
	// [Working with policies]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/working-with-policies.html
	// [Using the managed origin request policies]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html
	// [Creating origin request policies]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy
	// [Creating cache policies]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy
	// [Using the managed cache policies]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html
	//
	// Deprecated: This member has been deprecated.
	ForwardedValues *ForwardedValues

	// A list of CloudFront functions that are associated with this cache behavior.
	// CloudFront functions must be published to the LIVE stage to associate them with
	// a cache behavior.
	FunctionAssociations *FunctionAssociations

	// The gRPC configuration for your cache behavior.
	GrpcConfig *GrpcConfig

	// A complex type that contains zero or more Lambda@Edge function associations for
	// a cache behavior.
	LambdaFunctionAssociations *LambdaFunctionAssociations

	// This field is deprecated. We recommend that you use the MaxTTL field in a cache
	// policy instead of this field. For more information, see [Creating cache policies]or [Using the managed cache policies] in the Amazon
	// CloudFront Developer Guide.
	//
	// The maximum amount of time that you want objects to stay in CloudFront caches
	// before CloudFront forwards another request to your origin to determine whether
	// the object has been updated. The value that you specify applies only when your
	// origin adds HTTP headers such as Cache-Control max-age , Cache-Control s-maxage
	// , and Expires to objects. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)] in the Amazon CloudFront
	// Developer Guide.
	//
	// [Creating cache policies]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy
	// [Using the managed cache policies]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html
	// [Managing How Long Content Stays in an Edge Cache (Expiration)]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html
	//
	// Deprecated: This member has been deprecated.
	MaxTTL *int64

	// This field is deprecated. We recommend that you use the MinTTL field in a cache
	// policy instead of this field. For more information, see [Creating cache policies]or [Using the managed cache policies] in the Amazon
	// CloudFront Developer Guide.
	//
	// The minimum amount of time that you want objects to stay in CloudFront caches
	// before CloudFront forwards another request to your origin to determine whether
	// the object has been updated. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)]in the Amazon CloudFront
	// Developer Guide.
	//
	// You must specify 0 for MinTTL if you configure CloudFront to forward all
	// headers to your origin (under Headers , if you specify 1 for Quantity and * for
	// Name ).
	//
	// [Creating cache policies]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy
	// [Using the managed cache policies]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html
	// [Managing How Long Content Stays in an Edge Cache (Expiration)]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html
	//
	// Deprecated: This member has been deprecated.
	MinTTL *int64

	// The unique identifier of the origin request policy that is attached to this
	// cache behavior. For more information, see [Creating origin request policies]or [Using the managed origin request policies] in the Amazon CloudFront
	// Developer Guide.
	//
	// [Using the managed origin request policies]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html
	// [Creating origin request policies]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy
	OriginRequestPolicyId *string

	// The Amazon Resource Name (ARN) of the real-time log configuration that is
	// attached to this cache behavior. For more information, see [Real-time logs]in the Amazon
	// CloudFront Developer Guide.
	//
	// [Real-time logs]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html
	RealtimeLogConfigArn *string

	// The identifier for a response headers policy.
	ResponseHeadersPolicyId *string

	// Indicates whether you want to distribute media files in the Microsoft Smooth
	// Streaming format using the origin that is associated with this cache behavior.
	// If so, specify true ; if not, specify false . If you specify true for
	// SmoothStreaming , you can still distribute other content using this cache
	// behavior if the content matches the value of PathPattern .
	SmoothStreaming *bool

	// A list of key groups that CloudFront can use to validate signed URLs or signed
	// cookies.
	//
	// When a cache behavior contains trusted key groups, CloudFront requires signed
	// URLs or signed cookies for all requests that match the cache behavior. The URLs
	// or cookies must be signed with a private key whose corresponding public key is
	// in the key group. The signed URL or cookie contains information about which
	// public key CloudFront should use to verify the signature. For more information,
	// see [Serving private content]in the Amazon CloudFront Developer Guide.
	//
	// [Serving private content]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html
	TrustedKeyGroups *TrustedKeyGroups

	// We recommend using TrustedKeyGroups instead of TrustedSigners .
	//
	// A list of Amazon Web Services account IDs whose public keys CloudFront can use
	// to validate signed URLs or signed cookies.
	//
	// When a cache behavior contains trusted signers, CloudFront requires signed URLs
	// or signed cookies for all requests that match the cache behavior. The URLs or
	// cookies must be signed with the private key of a CloudFront key pair in the
	// trusted signer's Amazon Web Services account. The signed URL or cookie contains
	// information about which public key CloudFront should use to verify the
	// signature. For more information, see [Serving private content]in the Amazon CloudFront Developer Guide.
	//
	// [Serving private content]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html
	TrustedSigners *TrustedSigners

	noSmithyDocumentSerde
}

// A complex type that contains zero or more CacheBehavior elements.
type CacheBehaviors struct {

	// The number of cache behaviors for this distribution.
	//
	// This member is required.
	Quantity *int32

	// Optional: A complex type that contains cache behaviors for this distribution.
	// If Quantity is 0 , you can omit Items .
	Items []CacheBehavior

	noSmithyDocumentSerde
}

// A complex type that controls whether CloudFront caches the response to requests
// using the specified HTTP methods. There are two choices:
//
//   - CloudFront caches responses to GET and HEAD requests.
//
//   - CloudFront caches responses to GET , HEAD , and OPTIONS requests.
//
// If you pick the second choice for your Amazon S3 Origin, you may need to
// forward Access-Control-Request-Method, Access-Control-Request-Headers, and
// Origin headers for the responses to be cached correctly.
type CachedMethods struct {

	// A complex type that contains the HTTP methods that you want CloudFront to cache
	// responses to. Valid values for CachedMethods include GET , HEAD , and OPTIONS ,
	// depending on which caching option you choose. For more information, see the
	// preceding section.
	//
	// This member is required.
	Items []Method

	// The number of HTTP methods for which you want CloudFront to cache responses.
	// Valid values are 2 (for caching responses to GET and HEAD requests) and 3 (for
	// caching responses to GET , HEAD , and OPTIONS requests).
	//
	// This member is required.
	Quantity *int32

	noSmithyDocumentSerde
}

// A cache policy.
//
// When it's attached to a cache behavior, the cache policy determines the
// following:
//
//   - The values that CloudFront includes in the cache key. These values can
//     include HTTP headers, cookies, and URL query strings. CloudFront uses the cache
//     key to find an object in its cache that it can return to the viewer.
//
//   - The default, minimum, and maximum time to live (TTL) values that you want
//     objects to stay in the CloudFront cache.
//
// The headers, cookies, and query strings that are included in the cache key are
// also included in requests that CloudFront sends to the origin. CloudFront sends
// a request when it can't find a valid object in its cache that matches the
// request's cache key. If you want to send values to the origin but not include
// them in the cache key, use OriginRequestPolicy .
type CachePolicy struct {

	// The cache policy configuration.
	//
	// This member is required.
	CachePolicyConfig *CachePolicyConfig

	// The unique identifier for the cache policy.
	//
	// This member is required.
	Id *string

	// The date and time when the cache policy was last modified.
	//
	// This member is required.
	LastModifiedTime *time.Time

	noSmithyDocumentSerde
}

// A cache policy configuration.
//
// This configuration determines the following:
//
//   - The values that CloudFront includes in the cache key. These values can
//     include HTTP headers, cookies, and URL query strings. CloudFront uses the cache
//     key to find an object in its cache that it can return to the viewer.
//
//   - The default, minimum, and maximum time to live (TTL) values that you want
//     objects to stay in the CloudFront cache.
//
// The headers, cookies, and query strings that are included in the cache key are
// also included in requests that CloudFront sends to the origin. CloudFront sends
// a request when it can't find a valid object in its cache that matches the
// request's cache key. If you want to send values to the origin but not include
// them in the cache key, use OriginRequestPolicy .
type CachePolicyConfig struct {

	// The minimum amount of time, in seconds, that you want objects to stay in the
	// CloudFront cache before CloudFront sends another request to the origin to see if
	// the object has been updated. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)]in the Amazon CloudFront
	// Developer Guide.
	//
	// [Managing How Long Content Stays in an Edge Cache (Expiration)]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html
	//
	// This member is required.
	MinTTL *int64

	// A unique name to identify the cache policy.
	//
	// This member is required.
	Name *string

	// A comment to describe the cache policy. The comment cannot be longer than 128
	// characters.
	Comment *string

	// The default amount of time, in seconds, that you want objects to stay in the
	// CloudFront cache before CloudFront sends another request to the origin to see if
	// the object has been updated. CloudFront uses this value as the object's time to
	// live (TTL) only when the origin does not send Cache-Control or Expires headers
	// with the object. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)]in the Amazon CloudFront Developer
	// Guide.
	//
	// The default value for this field is 86400 seconds (one day). If the value of
	// MinTTL is more than 86400 seconds, then the default value for this field is the
	// same as the value of MinTTL .
	//
	// [Managing How Long Content Stays in an Edge Cache (Expiration)]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html
	DefaultTTL *int64

	// The maximum amount of time, in seconds, that objects stay in the CloudFront
	// cache before CloudFront sends another request to the origin to see if the object
	// has been updated. CloudFront uses this value only when the origin sends
	// Cache-Control or Expires headers with the object. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)] in
	// the Amazon CloudFront Developer Guide.
	//
	// The default value for this field is 31536000 seconds (one year). If the value
	// of MinTTL or DefaultTTL is more than 31536000 seconds, then the default value
	// for this field is the same as the value of DefaultTTL .
	//
	// [Managing How Long Content Stays in an Edge Cache (Expiration)]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html
	MaxTTL *int64

	// The HTTP headers, cookies, and URL query strings to include in the cache key.
	// The values included in the cache key are also included in requests that
	// CloudFront sends to the origin.
	ParametersInCacheKeyAndForwardedToOrigin *ParametersInCacheKeyAndForwardedToOrigin

	noSmithyDocumentSerde
}

// An object that determines whether any cookies in viewer requests (and if so,
// which cookies) are included in the cache key and in requests that CloudFront
// sends to the origin.
type CachePolicyCookiesConfig struct {

	// Determines whether any cookies in viewer requests are included in the cache key
	// and in requests that CloudFront sends to the origin. Valid values are:
	//
	//   - none – No cookies in viewer requests are included in the cache key or in
	//   requests that CloudFront sends to the origin. Even when this field is set to
	//   none , any cookies that are listed in an OriginRequestPolicy are included in
	//   origin requests.
	//
	//   - whitelist – Only the cookies in viewer requests that are listed in the
	//   CookieNames type are included in the cache key and in requests that CloudFront
	//   sends to the origin.
	//
	//   - allExcept – All cookies in viewer requests are included in the cache key and
	//   in requests that CloudFront sends to the origin, except for those that are
	//   listed in the CookieNames type, which are not included.
	//
	//   - all – All cookies in viewer requests are included in the cache key and in
	//   requests that CloudFront sends to the origin.
	//
	// This member is required.
	CookieBehavior CachePolicyCookieBehavior

	// Contains a list of cookie names.
	Cookies *CookieNames

	noSmithyDocumentSerde
}

// An object that determines whether any HTTP headers (and if so, which headers)
// are included in the cache key and in requests that CloudFront sends to the
// origin.
type CachePolicyHeadersConfig struct {

	// Determines whether any HTTP headers are included in the cache key and in
	// requests that CloudFront sends to the origin. Valid values are:
	//
	//   - none – No HTTP headers are included in the cache key or in requests that
	//   CloudFront sends to the origin. Even when this field is set to none , any
	//   headers that are listed in an OriginRequestPolicy are included in origin
	//   requests.
	//
	//   - whitelist – Only the HTTP headers that are listed in the Headers type are
	//   included in the cache key and in requests that CloudFront sends to the origin.
	//
	// This member is required.
	HeaderBehavior CachePolicyHeaderBehavior

	// Contains a list of HTTP header names.
	Headers *Headers

	noSmithyDocumentSerde
}

// A list of cache policies.
type CachePolicyList struct {

	// The maximum number of cache policies requested.
	//
	// This member is required.
	MaxItems *int32

	// The total number of cache policies returned in the response.
	//
	// This member is required.
	Quantity *int32

	// Contains the cache policies in the list.
	Items []CachePolicySummary

	// If there are more items in the list than are in this response, this element is
	// present. It contains the value that you should use in the Marker field of a
	// subsequent request to continue listing cache policies where you left off.
	NextMarker *string

	noSmithyDocumentSerde
}

// An object that determines whether any URL query strings in viewer requests (and
// if so, which query strings) are included in the cache key and in requests that
// CloudFront sends to the origin.
type CachePolicyQueryStringsConfig struct {

	// Determines whether any URL query strings in viewer requests are included in the
	// cache key and in requests that CloudFront sends to the origin. Valid values are:
	//
	//   - none – No query strings in viewer requests are included in the cache key or
	//   in requests that CloudFront sends to the origin. Even when this field is set to
	//   none , any query strings that are listed in an OriginRequestPolicy are
	//   included in origin requests.
	//
	//   - whitelist – Only the query strings in viewer requests that are listed in the
	//   QueryStringNames type are included in the cache key and in requests that
	//   CloudFront sends to the origin.
	//
	//   - allExcept – All query strings in viewer requests are included in the cache
	//   key and in requests that CloudFront sends to the origin, except those that are
	//   listed in the QueryStringNames type, which are not included.
	//
	//   - all – All query strings in viewer requests are included in the cache key and
	//   in requests that CloudFront sends to the origin.
	//
	// This member is required.
	QueryStringBehavior CachePolicyQueryStringBehavior

	// Contains the specific query strings in viewer requests that either are or are
	// not included in the cache key and in requests that CloudFront sends to the
	// origin. The behavior depends on whether the QueryStringBehavior field in the
	// CachePolicyQueryStringsConfig type is set to whitelist (the listed query
	// strings are included) or allExcept (the listed query strings are not included,
	// but all other query strings are).
	QueryStrings *QueryStringNames

	noSmithyDocumentSerde
}

// Contains a cache policy.
type CachePolicySummary struct {

	// The cache policy.
	//
	// This member is required.
	CachePolicy *CachePolicy

	// The type of cache policy, either managed (created by Amazon Web Services) or
	// custom (created in this Amazon Web Services account).
	//
	// This member is required.
	Type CachePolicyType

	noSmithyDocumentSerde
}

// CloudFront origin access identity.
type CloudFrontOriginAccessIdentity struct {

	// The ID for the origin access identity, for example, E74FTE3AJFJ256A .
	//
	// This member is required.
	Id *string

	// The Amazon S3 canonical user ID for the origin access identity, used when
	// giving the origin access identity read permission to an object in Amazon S3.
	//
	// This member is required.
	S3CanonicalUserId *string

	// The current configuration information for the identity.
	CloudFrontOriginAccessIdentityConfig *CloudFrontOriginAccessIdentityConfig

	noSmithyDocumentSerde
}

// Origin access identity configuration. Send a GET request to the /CloudFront API
// version/CloudFront/identity ID/config resource.
type CloudFrontOriginAccessIdentityConfig struct {

	// A unique value (for example, a date-time stamp) that ensures that the request
	// can't be replayed.
	//
	// If the value of CallerReference is new (regardless of the content of the
	// CloudFrontOriginAccessIdentityConfig object), a new origin access identity is
	// created.
	//
	// If the CallerReference is a value already sent in a previous identity request,
	// and the content of the CloudFrontOriginAccessIdentityConfig is identical to the
	// original request (ignoring white space), the response includes the same
	// information returned to the original request.
	//
	// If the CallerReference is a value you already sent in a previous request to
	// create an identity, but the content of the CloudFrontOriginAccessIdentityConfig
	// is different from the original request, CloudFront returns a
	// CloudFrontOriginAccessIdentityAlreadyExists error.
	//
	// This member is required.
	CallerReference *string

	// A comment to describe the origin access identity. The comment cannot be longer
	// than 128 characters.
	//
	// This member is required.
	Comment *string

	noSmithyDocumentSerde
}

// Lists the origin access identities for CloudFront.Send a GET request to the
// /CloudFront API version/origin-access-identity/cloudfront resource. The response
// includes a CloudFrontOriginAccessIdentityList element with zero or more
// CloudFrontOriginAccessIdentitySummary child elements. By default, your entire
// list of origin access identities is returned in one single page. If the list is
// long, you can paginate it using the MaxItems and Marker parameters.
type CloudFrontOriginAccessIdentityList struct {

	// A flag that indicates whether more origin access identities remain to be
	// listed. If your results were truncated, you can make a follow-up pagination
	// request using the Marker request parameter to retrieve more items in the list.
	//
	// This member is required.
	IsTruncated *bool

	// Use this when paginating results to indicate where to begin in your list of
	// origin access identities. The results include identities in the list that occur
	// after the marker. To get the next page of results, set the Marker to the value
	// of the NextMarker from the current page's response (which is also the ID of the
	// last identity on that page).
	//
	// This member is required.
	Marker *string

	// The maximum number of origin access identities you want in the response body.
	//
	// This member is required.
	MaxItems *int32

	// The number of CloudFront origin access identities that were created by the
	// current Amazon Web Services account.
	//
	// This member is required.
	Quantity *int32

	// A complex type that contains one CloudFrontOriginAccessIdentitySummary element
	// for each origin access identity that was created by the current Amazon Web
	// Services account.
	Items []CloudFrontOriginAccessIdentitySummary

	// If IsTruncated is true , this element is present and contains the value you can
	// use for the Marker request parameter to continue listing your origin access
	// identities where they left off.
	NextMarker *string

	noSmithyDocumentSerde
}

// Summary of the information about a CloudFront origin access identity.
type CloudFrontOriginAccessIdentitySummary struct {

	// The comment for this origin access identity, as originally specified when
	// created.
	//
	// This member is required.
	Comment *string

	// The ID for the origin access identity. For example: E74FTE3AJFJ256A .
	//
	// This member is required.
	Id *string

	// The Amazon S3 canonical user ID for the origin access identity, which you use
	// when giving the origin access identity read permission to an object in Amazon
	// S3.
	//
	// This member is required.
	S3CanonicalUserId *string

	noSmithyDocumentSerde
}

// An alias (also called a CNAME) and the CloudFront distribution and Amazon Web
// Services account ID that it's associated with. The distribution and account IDs
// are partially hidden, which allows you to identify the distributions and
// accounts that you own, but helps to protect the information of ones that you
// don't own.
type ConflictingAlias struct {

	// The (partially hidden) ID of the Amazon Web Services account that owns the
	// distribution that's associated with the alias.
	AccountId *string

	// An alias (also called a CNAME).
	Alias *string

	// The (partially hidden) ID of the CloudFront distribution associated with the
	// alias.
	DistributionId *string

	noSmithyDocumentSerde
}

// A list of aliases (also called CNAMEs) and the CloudFront distributions and
// Amazon Web Services accounts that they are associated with. In the list, the
// distribution and account IDs are partially hidden, which allows you to identify
// the distributions and accounts that you own, but helps to protect the
// information of ones that you don't own.
type ConflictingAliasesList struct {

	// Contains the conflicting aliases in the list.
	Items []ConflictingAlias

	// The maximum number of conflicting aliases requested.
	MaxItems *int32

	// If there are more items in the list than are in this response, this element is
	// present. It contains the value that you should use in the Marker field of a
	// subsequent request to continue listing conflicting aliases where you left off.
	NextMarker *string

	// The number of conflicting aliases returned in the response.
	Quantity *int32

	noSmithyDocumentSerde
}

// A field-level encryption content type profile.
type ContentTypeProfile struct {

	// The content type for a field-level encryption content type-profile mapping.
	//
	// This member is required.
	ContentType *string

	// The format for a field-level encryption content type-profile mapping.
	//
	// This member is required.
	Format Format

	// The profile ID for a field-level encryption content type-profile mapping.
	ProfileId *string

	noSmithyDocumentSerde
}

// The configuration for a field-level encryption content type-profile mapping.
type ContentTypeProfileConfig struct {

	// The setting in a field-level encryption content type-profile mapping that
	// specifies what to do when an unknown content type is provided for the profile.
	// If true, content is forwarded without being encrypted when the content type is
	// unknown. If false (the default), an error is returned when the content type is
	// unknown.
	//
	// This member is required.
	ForwardWhenContentTypeIsUnknown *bool

	// The configuration for a field-level encryption content type-profile.
	ContentTypeProfiles *ContentTypeProfiles

	noSmithyDocumentSerde
}

// Field-level encryption content type-profile.
type ContentTypeProfiles struct {

	// The number of field-level encryption content type-profile mappings.
	//
	// This member is required.
	Quantity *int32

	// Items in a field-level encryption content type-profile mapping.
	Items []ContentTypeProfile

	noSmithyDocumentSerde
}

// A continuous deployment policy.
type ContinuousDeploymentPolicy struct {

	// Contains the configuration for a continuous deployment policy.
	//
	// This member is required.
	ContinuousDeploymentPolicyConfig *ContinuousDeploymentPolicyConfig

	// The identifier of the continuous deployment policy.
	//
	// This member is required.
	Id *string

	// The date and time the continuous deployment policy was last modified.
	//
	// This member is required.
	LastModifiedTime *time.Time

	noSmithyDocumentSerde
}

// Contains the configuration for a continuous deployment policy.
type ContinuousDeploymentPolicyConfig struct {

	// A Boolean that indicates whether this continuous deployment policy is enabled
	// (in effect). When this value is true , this policy is enabled and in effect.
	// When this value is false , this policy is not enabled and has no effect.
	//
	// This member is required.
	Enabled *bool

	// The CloudFront domain name of the staging distribution. For example:
	// d111111abcdef8.cloudfront.net .
	//
	// This member is required.
	StagingDistributionDnsNames *StagingDistributionDnsNames

	// Contains the parameters for routing production traffic from your primary to
	// staging distributions.
	TrafficConfig *TrafficConfig

	noSmithyDocumentSerde
}

// Contains a list of continuous deployment policies.
type ContinuousDeploymentPolicyList struct {

	// The maximum number of continuous deployment policies that were specified in
	// your request.
	//
	// This member is required.
	MaxItems *int32

	// The total number of continuous deployment policies in your Amazon Web Services
	// account, regardless of the MaxItems value.
	//
	// This member is required.
	Quantity *int32

	// A list of continuous deployment policy items.
	Items []ContinuousDeploymentPolicySummary

	// Indicates the next page of continuous deployment policies. To get the next page
	// of the list, use this value in the Marker field of your request.
	NextMarker *string

	noSmithyDocumentSerde
}

// A summary of the information about your continuous deployment policies.
type ContinuousDeploymentPolicySummary struct {

	// The continuous deployment policy.
	//
	// This member is required.
	ContinuousDeploymentPolicy *ContinuousDeploymentPolicy

	noSmithyDocumentSerde
}

// This configuration determines which HTTP requests are sent to the staging
// distribution. If the HTTP request contains a header and value that matches what
// you specify here, the request is sent to the staging distribution. Otherwise the
// request is sent to the primary distribution.
type ContinuousDeploymentSingleHeaderConfig struct {

	// The request header name that you want CloudFront to send to your staging
	// distribution. The header must contain the prefix aws-cf-cd- .
	//
	// This member is required.
	Header *string

	// The request header value.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Contains the percentage of traffic to send to a staging distribution.
type ContinuousDeploymentSingleWeightConfig struct {

	// The percentage of traffic to send to a staging distribution, expressed as a
	// decimal number between 0 and 0.15. For example, a value of 0.10 means 10% of
	// traffic is sent to the staging distribution.
	//
	// This member is required.
	Weight *float32

	// Session stickiness provides the ability to define multiple requests from a
	// single viewer as a single session. This prevents the potentially inconsistent
	// experience of sending some of a given user's requests to your staging
	// distribution, while others are sent to your primary distribution. Define the
	// session duration using TTL values.
	SessionStickinessConfig *SessionStickinessConfig

	noSmithyDocumentSerde
}

// Contains a list of cookie names.
type CookieNames struct {

	// The number of cookie names in the Items list.
	//
	// This member is required.
	Quantity *int32

	// A list of cookie names.
	Items []string

	noSmithyDocumentSerde
}

// This field is deprecated. We recommend that you use a cache policy or an origin
// request policy instead of this field.
//
// If you want to include cookies in the cache key, use CookiesConfig in a cache
// policy. See CachePolicy .
//
// If you want to send cookies to the origin but not include them in the cache
// key, use CookiesConfig in an origin request policy. See OriginRequestPolicy .
//
// A complex type that specifies whether you want CloudFront to forward cookies to
// the origin and, if so, which ones. For more information about forwarding cookies
// to the origin, see [Caching Content Based on Cookies]in the Amazon CloudFront Developer Guide.
//
// [Caching Content Based on Cookies]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Cookies.html
type CookiePreference struct {

	// This field is deprecated. We recommend that you use a cache policy or an origin
	// request policy instead of this field.
	//
	// If you want to include cookies in the cache key, use a cache policy. For more
	// information, see [Creating cache policies]in the Amazon CloudFront Developer Guide.
	//
	// If you want to send cookies to the origin but not include them in the cache
	// key, use origin request policy. For more information, see [Creating origin request policies]in the Amazon
	// CloudFront Developer Guide.
	//
	// Specifies which cookies to forward to the origin for this cache behavior: all,
	// none, or the list of cookies specified in the WhitelistedNames complex type.
	//
	// Amazon S3 doesn't process cookies. When the cache behavior is forwarding
	// requests to an Amazon S3 origin, specify none for the Forward element.
	//
	// [Creating origin request policies]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy
	// [Creating cache policies]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy
	//
	// This member is required.
	Forward ItemSelection

	// This field is deprecated. We recommend that you use a cache policy or an origin
	// request policy instead of this field.
	//
	// If you want to include cookies in the cache key, use a cache policy. For more
	// information, see [Creating cache policies]in the Amazon CloudFront Developer Guide.
	//
	// If you want to send cookies to the origin but not include them in the cache
	// key, use an origin request policy. For more information, see [Creating origin request policies]in the Amazon
	// CloudFront Developer Guide.
	//
	// Required if you specify whitelist for the value of Forward . A complex type that
	// specifies how many different cookies you want CloudFront to forward to the
	// origin for this cache behavior and, if you want to forward selected cookies, the
	// names of those cookies.
	//
	// If you specify all or none for the value of Forward , omit WhitelistedNames . If
	// you change the value of Forward from whitelist to all or none and you don't
	// delete the WhitelistedNames element and its child elements, CloudFront deletes
	// them automatically.
	//
	// For the current limit on the number of cookie names that you can whitelist for
	// each cache behavior, see [CloudFront Limits]in the Amazon Web Services General Reference.
	//
	// [CloudFront Limits]: https://docs.aws.amazon.com/general/latest/gr/xrefaws_service_limits.html#limits_cloudfront
	// [Creating origin request policies]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy
	// [Creating cache policies]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy
	WhitelistedNames *CookieNames

	noSmithyDocumentSerde
}

// A complex type that controls:
//
//   - Whether CloudFront replaces HTTP status codes in the 4xx and 5xx range with
//     custom error messages before returning the response to the viewer.
//
//   - How long CloudFront caches HTTP status codes in the 4xx and 5xx range.
//
// For more information about custom error pages, see [Customizing Error Responses] in the Amazon CloudFront
// Developer Guide.
//
// [Customizing Error Responses]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html
type CustomErrorResponse struct {

	// The HTTP status code for which you want to specify a custom error page and/or a
	// caching duration.
	//
	// This member is required.
	ErrorCode *int32

	// The minimum amount of time, in seconds, that you want CloudFront to cache the
	// HTTP status code specified in ErrorCode . When this time period has elapsed,
	// CloudFront queries your origin to see whether the problem that caused the error
	// has been resolved and the requested object is now available.
	//
	// For more information, see [Customizing Error Responses] in the Amazon CloudFront Developer Guide.
	//
	// [Customizing Error Responses]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html
	ErrorCachingMinTTL *int64

	// The HTTP status code that you want CloudFront to return to the viewer along
	// with the custom error page. There are a variety of reasons that you might want
	// CloudFront to return a status code different from the status code that your
	// origin returned to CloudFront, for example:
	//
	//   - Some Internet devices (some firewalls and corporate proxies, for example)
	//   intercept HTTP 4xx and 5xx and prevent the response from being returned to the
	//   viewer. If you substitute 200 , the response typically won't be intercepted.
	//
	//   - If you don't care about distinguishing among different client errors or
	//   server errors, you can specify 400 or 500 as the ResponseCode for all 4xx or
	//   5xx errors.
	//
	//   - You might want to return a 200 status code (OK) and static website so your
	//   customers don't know that your website is down.
	//
	// If you specify a value for ResponseCode , you must also specify a value for
	// ResponsePagePath .
	ResponseCode *string

	// The path to the custom error page that you want CloudFront to return to a
	// viewer when your origin returns the HTTP status code specified by ErrorCode ,
	// for example, /4xx-errors/403-forbidden.html . If you want to store your objects
	// and your custom error pages in different locations, your distribution must
	// include a cache behavior for which the following is true:
	//
	//   - The value of PathPattern matches the path to your custom error messages. For
	//   example, suppose you saved custom error pages for 4xx errors in an Amazon S3
	//   bucket in a directory named /4xx-errors . Your distribution must include a
	//   cache behavior for which the path pattern routes requests for your custom error
	//   pages to that location, for example, /4xx-errors/* .
	//
	//   - The value of TargetOriginId specifies the value of the ID element for the
	//   origin that contains your custom error pages.
	//
	// If you specify a value for ResponsePagePath , you must also specify a value for
	// ResponseCode .
	//
	// We recommend that you store custom error pages in an Amazon S3 bucket. If you
	// store custom error pages on an HTTP server and the server starts to return 5xx
	// errors, CloudFront can't get the files that you want to return to viewers
	// because the origin server is unavailable.
	ResponsePagePath *string

	noSmithyDocumentSerde
}

// A complex type that controls:
//
//   - Whether CloudFront replaces HTTP status codes in the 4xx and 5xx range with
//     custom error messages before returning the response to the viewer.
//
//   - How long CloudFront caches HTTP status codes in the 4xx and 5xx range.
//
// For more information about custom error pages, see [Customizing Error Responses] in the Amazon CloudFront
// Developer Guide.
//
// [Customizing Error Responses]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html
type CustomErrorResponses struct {

	// The number of HTTP status codes for which you want to specify a custom error
	// page and/or a caching duration. If Quantity is 0 , you can omit Items .
	//
	// This member is required.
	Quantity *int32

	// A complex type that contains a CustomErrorResponse element for each HTTP status
	// code for which you want to specify a custom error page and/or a caching
	// duration.
	Items []CustomErrorResponse

	noSmithyDocumentSerde
}

// A complex type that contains the list of Custom Headers for each origin.
type CustomHeaders struct {

	// The number of custom headers, if any, for this distribution.
	//
	// This member is required.
	Quantity *int32

	//  Optional: A list that contains one OriginCustomHeader element for each custom
	// header that you want CloudFront to forward to the origin. If Quantity is 0 ,
	// omit Items .
	Items []OriginCustomHeader

	noSmithyDocumentSerde
}

// A custom origin. A custom origin is any origin that is not an Amazon S3 bucket,
// with one exception. An Amazon S3 bucket that is [configured with static website hosting]is a custom origin.
//
// [configured with static website hosting]: https://docs.aws.amazon.com/AmazonS3/latest/dev/WebsiteHosting.html
type CustomOriginConfig struct {

	// The HTTP port that CloudFront uses to connect to the origin. Specify the HTTP
	// port that the origin listens on.
	//
	// This member is required.
	HTTPPort *int32

	// The HTTPS port that CloudFront uses to connect to the origin. Specify the HTTPS
	// port that the origin listens on.
	//
	// This member is required.
	HTTPSPort *int32

	// Specifies the protocol (HTTP or HTTPS) that CloudFront uses to connect to the
	// origin. Valid values are:
	//
	//   - http-only – CloudFront always uses HTTP to connect to the origin.
	//
	//   - match-viewer – CloudFront connects to the origin using the same protocol
	//   that the viewer used to connect to CloudFront.
	//
	//   - https-only – CloudFront always uses HTTPS to connect to the origin.
	//
	// This member is required.
	OriginProtocolPolicy OriginProtocolPolicy

	// Specifies how long, in seconds, CloudFront persists its connection to the
	// origin. The minimum timeout is 1 second, the maximum is 60 seconds, and the
	// default (if you don't specify otherwise) is 5 seconds.
	//
	// For more information, see [Keep-alive timeout (custom origins only)] in the Amazon CloudFront Developer Guide.
	//
	// [Keep-alive timeout (custom origins only)]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginKeepaliveTimeout
	OriginKeepaliveTimeout *int32

	// Specifies how long, in seconds, CloudFront waits for a response from the
	// origin. This is also known as the origin response timeout. The minimum timeout
	// is 1 second, the maximum is 60 seconds, and the default (if you don't specify
	// otherwise) is 30 seconds.
	//
	// For more information, see [Response timeout (custom origins only)] in the Amazon CloudFront Developer Guide.
	//
	// [Response timeout (custom origins only)]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginResponseTimeout
	OriginReadTimeout *int32

	// Specifies the minimum SSL/TLS protocol that CloudFront uses when connecting to
	// your origin over HTTPS. Valid values include SSLv3 , TLSv1 , TLSv1.1 , and
	// TLSv1.2 .
	//
	// For more information, see [Minimum Origin SSL Protocol] in the Amazon CloudFront Developer Guide.
	//
	// [Minimum Origin SSL Protocol]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginSSLProtocols
	OriginSslProtocols *OriginSslProtocols

	noSmithyDocumentSerde
}

// A complex type that describes the default cache behavior if you don't specify a
// CacheBehavior element or if request URLs don't match any of the values of
// PathPattern in CacheBehavior elements. You must create exactly one default
// cache behavior.
type DefaultCacheBehavior struct {

	// The value of ID for the origin that you want CloudFront to route requests to
	// when they use the default cache behavior.
	//
	// This member is required.
	TargetOriginId *string

	// The protocol that viewers can use to access the files in the origin specified
	// by TargetOriginId when a request matches the path pattern in PathPattern . You
	// can specify the following options:
	//
	//   - allow-all : Viewers can use HTTP or HTTPS.
	//
	//   - redirect-to-https : If a viewer submits an HTTP request, CloudFront returns
	//   an HTTP status code of 301 (Moved Permanently) to the viewer along with the
	//   HTTPS URL. The viewer then resubmits the request using the new URL.
	//
	//   - https-only : If a viewer sends an HTTP request, CloudFront returns an HTTP
	//   status code of 403 (Forbidden).
	//
	// For more information about requiring the HTTPS protocol, see [Requiring HTTPS Between Viewers and CloudFront] in the Amazon
	// CloudFront Developer Guide.
	//
	// The only way to guarantee that viewers retrieve an object that was fetched from
	// the origin using HTTPS is never to use any other protocol to fetch the object.
	// If you have recently changed from HTTP to HTTPS, we recommend that you clear
	// your objects' cache because cached objects are protocol agnostic. That means
	// that an edge location will return an object from the cache regardless of whether
	// the current request protocol matches the protocol used previously. For more
	// information, see [Managing Cache Expiration]in the Amazon CloudFront Developer Guide.
	//
	// [Requiring HTTPS Between Viewers and CloudFront]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https-viewers-to-cloudfront.html
	// [Managing Cache Expiration]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html
	//
	// This member is required.
	ViewerProtocolPolicy ViewerProtocolPolicy

	// A complex type that controls which HTTP methods CloudFront processes and
	// forwards to your Amazon S3 bucket or your custom origin. There are three
	// choices:
	//
	//   - CloudFront forwards only GET and HEAD requests.
	//
	//   - CloudFront forwards only GET , HEAD , and OPTIONS requests.
	//
	//   - CloudFront forwards GET, HEAD, OPTIONS, PUT, PATCH, POST , and DELETE
	//   requests.
	//
	// If you pick the third choice, you may need to restrict access to your Amazon S3
	// bucket or to your custom origin so users can't perform operations that you don't
	// want them to. For example, you might not want users to have permissions to
	// delete objects from your origin.
	AllowedMethods *AllowedMethods

	// The unique identifier of the cache policy that is attached to the default cache
	// behavior. For more information, see [Creating cache policies]or [Using the managed cache policies] in the Amazon CloudFront Developer
	// Guide.
	//
	// A DefaultCacheBehavior must include either a CachePolicyId or ForwardedValues .
	// We recommend that you use a CachePolicyId .
	//
	// [Creating cache policies]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy
	// [Using the managed cache policies]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html
	CachePolicyId *string

	// Whether you want CloudFront to automatically compress certain files for this
	// cache behavior. If so, specify true ; if not, specify false . For more
	// information, see [Serving Compressed Files]in the Amazon CloudFront Developer Guide.
	//
	// [Serving Compressed Files]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/ServingCompressedFiles.html
	Compress *bool

	// This field is deprecated. We recommend that you use the DefaultTTL field in a
	// cache policy instead of this field. For more information, see [Creating cache policies]or [Using the managed cache policies] in the Amazon
	// CloudFront Developer Guide.
	//
	// The default amount of time that you want objects to stay in CloudFront caches
	// before CloudFront forwards another request to your origin to determine whether
	// the object has been updated. The value that you specify applies only when your
	// origin does not add HTTP headers such as Cache-Control max-age , Cache-Control
	// s-maxage , and Expires to objects. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)] in the Amazon
	// CloudFront Developer Guide.
	//
	// [Creating cache policies]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy
	// [Using the managed cache policies]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html
	// [Managing How Long Content Stays in an Edge Cache (Expiration)]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html
	//
	// Deprecated: This member has been deprecated.
	DefaultTTL *int64

	// The value of ID for the field-level encryption configuration that you want
	// CloudFront to use for encrypting specific fields of data for the default cache
	// behavior.
	FieldLevelEncryptionId *string

	// This field is deprecated. We recommend that you use a cache policy or an origin
	// request policy instead of this field. For more information, see [Working with policies]in the Amazon
	// CloudFront Developer Guide.
	//
	// If you want to include values in the cache key, use a cache policy. For more
	// information, see [Creating cache policies]or [Using the managed cache policies] in the Amazon CloudFront Developer Guide.
	//
	// If you want to send values to the origin but not include them in the cache key,
	// use an origin request policy. For more information, see [Creating origin request policies]or [Using the managed origin request policies] in the Amazon
	// CloudFront Developer Guide.
	//
	// A DefaultCacheBehavior must include either a CachePolicyId or ForwardedValues .
	// We recommend that you use a CachePolicyId .
	//
	// A complex type that specifies how CloudFront handles query strings, cookies,
	// and HTTP headers.
	//
	// [Working with policies]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/working-with-policies.html
	// [Using the managed origin request policies]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html
	// [Creating origin request policies]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy
	// [Creating cache policies]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy
	// [Using the managed cache policies]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html
	//
	// Deprecated: This member has been deprecated.
	ForwardedValues *ForwardedValues

	// A list of CloudFront functions that are associated with this cache behavior.
	// Your functions must be published to the LIVE stage to associate them with a
	// cache behavior.
	FunctionAssociations *FunctionAssociations

	// The gRPC configuration for your cache behavior.
	GrpcConfig *GrpcConfig

	// A complex type that contains zero or more Lambda@Edge function associations for
	// a cache behavior.
	LambdaFunctionAssociations *LambdaFunctionAssociations

	// This field is deprecated. We recommend that you use the MaxTTL field in a cache
	// policy instead of this field. For more information, see [Creating cache policies]or [Using the managed cache policies] in the Amazon
	// CloudFront Developer Guide.
	//
	// The maximum amount of time that you want objects to stay in CloudFront caches
	// before CloudFront forwards another request to your origin to determine whether
	// the object has been updated. The value that you specify applies only when your
	// origin adds HTTP headers such as Cache-Control max-age , Cache-Control s-maxage
	// , and Expires to objects. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)] in the Amazon CloudFront
	// Developer Guide.
	//
	// [Creating cache policies]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy
	// [Using the managed cache policies]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html
	// [Managing How Long Content Stays in an Edge Cache (Expiration)]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html
	//
	// Deprecated: This member has been deprecated.
	MaxTTL *int64

	// This field is deprecated. We recommend that you use the MinTTL field in a cache
	// policy instead of this field. For more information, see [Creating cache policies]or [Using the managed cache policies] in the Amazon
	// CloudFront Developer Guide.
	//
	// The minimum amount of time that you want objects to stay in CloudFront caches
	// before CloudFront forwards another request to your origin to determine whether
	// the object has been updated. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)]in the Amazon CloudFront
	// Developer Guide.
	//
	// You must specify 0 for MinTTL if you configure CloudFront to forward all
	// headers to your origin (under Headers , if you specify 1 for Quantity and * for
	// Name ).
	//
	// [Creating cache policies]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy
	// [Using the managed cache policies]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html
	// [Managing How Long Content Stays in an Edge Cache (Expiration)]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html
	//
	// Deprecated: This member has been deprecated.
	MinTTL *int64

	// The unique identifier of the origin request policy that is attached to the
	// default cache behavior. For more information, see [Creating origin request policies]or [Using the managed origin request policies] in the Amazon CloudFront
	// Developer Guide.
	//
	// [Using the managed origin request policies]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html
	// [Creating origin request policies]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy
	OriginRequestPolicyId *string

	// The Amazon Resource Name (ARN) of the real-time log configuration that is
	// attached to this cache behavior. For more information, see [Real-time logs]in the Amazon
	// CloudFront Developer Guide.
	//
	// [Real-time logs]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html
	RealtimeLogConfigArn *string

	// The identifier for a response headers policy.
	ResponseHeadersPolicyId *string

	// Indicates whether you want to distribute media files in the Microsoft Smooth
	// Streaming format using the origin that is associated with this cache behavior.
	// If so, specify true ; if not, specify false . If you specify true for
	// SmoothStreaming , you can still distribute other content using this cache
	// behavior if the content matches the value of PathPattern .
	SmoothStreaming *bool

	// A list of key groups that CloudFront can use to validate signed URLs or signed
	// cookies.
	//
	// When a cache behavior contains trusted key groups, CloudFront requires signed
	// URLs or signed cookies for all requests that match the cache behavior. The URLs
	// or cookies must be signed with a private key whose corresponding public key is
	// in the key group. The signed URL or cookie contains information about which
	// public key CloudFront should use to verify the signature. For more information,
	// see [Serving private content]in the Amazon CloudFront Developer Guide.
	//
	// [Serving private content]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html
	TrustedKeyGroups *TrustedKeyGroups

	// We recommend using TrustedKeyGroups instead of TrustedSigners .
	//
	// A list of Amazon Web Services account IDs whose public keys CloudFront can use
	// to validate signed URLs or signed cookies.
	//
	// When a cache behavior contains trusted signers, CloudFront requires signed URLs
	// or signed cookies for all requests that match the cache behavior. The URLs or
	// cookies must be signed with the private key of a CloudFront key pair in a
	// trusted signer's Amazon Web Services account. The signed URL or cookie contains
	// information about which public key CloudFront should use to verify the
	// signature. For more information, see [Serving private content]in the Amazon CloudFront Developer Guide.
	//
	// [Serving private content]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html
	TrustedSigners *TrustedSigners

	noSmithyDocumentSerde
}

// A distribution tells CloudFront where you want content to be delivered from,
// and the details about how to track and manage content delivery.
type Distribution struct {

	// The distribution's Amazon Resource Name (ARN).
	//
	// This member is required.
	ARN *string

	// The distribution's configuration.
	//
	// This member is required.
	DistributionConfig *DistributionConfig

	// The distribution's CloudFront domain name. For example:
	// d111111abcdef8.cloudfront.net .
	//
	// This member is required.
	DomainName *string

	// The distribution's identifier. For example: E1U5RQF7T870K0 .
	//
	// This member is required.
	Id *string

	// The number of invalidation batches currently in progress.
	//
	// This member is required.
	InProgressInvalidationBatches *int32

	// The date and time when the distribution was last modified.
	//
	// This member is required.
	LastModifiedTime *time.Time

	// The distribution's status. When the status is Deployed , the distribution's
	// information is fully propagated to all CloudFront edge locations.
	//
	// This member is required.
	Status *string

	// This field contains a list of key groups and the public keys in each key group
	// that CloudFront can use to verify the signatures of signed URLs or signed
	// cookies.
	ActiveTrustedKeyGroups *ActiveTrustedKeyGroups

	// We recommend using TrustedKeyGroups instead of TrustedSigners .
	//
	// This field contains a list of Amazon Web Services account IDs and the active
	// CloudFront key pairs in each account that CloudFront can use to verify the
	// signatures of signed URLs or signed cookies.
	ActiveTrustedSigners *ActiveTrustedSigners

	// Amazon Web Services services in China customers must file for an Internet
	// Content Provider (ICP) recordal if they want to serve content publicly on an
	// alternate domain name, also known as a CNAME, that they've added to CloudFront.
	// AliasICPRecordal provides the ICP recordal status for CNAMEs associated with
	// distributions.
	//
	// For more information about ICP recordals, see [Signup, Accounts, and Credentials] in Getting Started with Amazon
	// Web Services services in China.
	//
	// [Signup, Accounts, and Credentials]: https://docs.amazonaws.cn/en_us/aws/latest/userguide/accounts-and-credentials.html
	AliasICPRecordals []AliasICPRecordal

	noSmithyDocumentSerde
}

// A distribution configuration.
type DistributionConfig struct {

	// A unique value (for example, a date-time stamp) that ensures that the request
	// can't be replayed.
	//
	// If the value of CallerReference is new (regardless of the content of the
	// DistributionConfig object), CloudFront creates a new distribution.
	//
	// If CallerReference is a value that you already sent in a previous request to
	// create a distribution, CloudFront returns a DistributionAlreadyExists error.
	//
	// This member is required.
	CallerReference *string

	// A comment to describe the distribution. The comment cannot be longer than 128
	// characters.
	//
	// This member is required.
	Comment *string

	// A complex type that describes the default cache behavior if you don't specify a
	// CacheBehavior element or if files don't match any of the values of PathPattern
	// in CacheBehavior elements. You must create exactly one default cache behavior.
	//
	// This member is required.
	DefaultCacheBehavior *DefaultCacheBehavior

	// From this field, you can enable or disable the selected distribution.
	//
	// This member is required.
	Enabled *bool

	// A complex type that contains information about origins for this distribution.
	//
	// This member is required.
	Origins *Origins

	// A complex type that contains information about CNAMEs (alternate domain names),
	// if any, for this distribution.
	Aliases *Aliases

	// ID of the Anycast static IP list that is associated with the distribution.
	AnycastIpListId *string

	// A complex type that contains zero or more CacheBehavior elements.
	CacheBehaviors *CacheBehaviors

	// The identifier of a continuous deployment policy. For more information, see
	// CreateContinuousDeploymentPolicy .
	ContinuousDeploymentPolicyId *string

	// A complex type that controls the following:
	//
	//   - Whether CloudFront replaces HTTP status codes in the 4xx and 5xx range with
	//   custom error messages before returning the response to the viewer.
	//
	//   - How long CloudFront caches HTTP status codes in the 4xx and 5xx range.
	//
	// For more information about custom error pages, see [Customizing Error Responses] in the Amazon CloudFront
	// Developer Guide.
	//
	// [Customizing Error Responses]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html
	CustomErrorResponses *CustomErrorResponses

	// When a viewer requests the root URL for your distribution, the default root
	// object is the object that you want CloudFront to request from your origin. For
	// example, if your root URL is https://www.example.com , you can specify
	// CloudFront to return the index.html file as the default root object. You can
	// specify a default root object so that viewers see a specific file or object,
	// instead of another object in your distribution (for example,
	// https://www.example.com/product-description.html ). A default root object avoids
	// exposing the contents of your distribution.
	//
	// You can specify the object name or a path to the object name (for example,
	// index.html or exampleFolderName/index.html ). Your string can't begin with a
	// forward slash ( / ). Only specify the object name or the path to the object.
	//
	// If you don't want to specify a default root object when you create a
	// distribution, include an empty DefaultRootObject element.
	//
	// To delete the default root object from an existing distribution, update the
	// distribution configuration and include an empty DefaultRootObject element.
	//
	// To replace the default root object, update the distribution configuration and
	// specify the new object.
	//
	// For more information about the default root object, see [Specify a default root object] in the Amazon
	// CloudFront Developer Guide.
	//
	// [Specify a default root object]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/DefaultRootObject.html
	DefaultRootObject *string

	// (Optional) Specify the HTTP version(s) that you want viewers to use to
	// communicate with CloudFront. The default value for new web distributions is
	// http2 . Viewers that don't support HTTP/2 automatically use an earlier HTTP
	// version.
	//
	// For viewers and CloudFront to use HTTP/2, viewers must support TLSv1.2 or
	// later, and must support Server Name Indication (SNI).
	//
	// For viewers and CloudFront to use HTTP/3, viewers must support TLSv1.3 and
	// Server Name Indication (SNI). CloudFront supports HTTP/3 connection migration to
	// allow the viewer to switch networks without losing connection. For more
	// information about connection migration, see [Connection Migration]at RFC 9000. For more information
	// about supported TLSv1.3 ciphers, see [Supported protocols and ciphers between viewers and CloudFront].
	//
	// [Connection Migration]: https://www.rfc-editor.org/rfc/rfc9000.html#name-connection-migration
	// [Supported protocols and ciphers between viewers and CloudFront]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/secure-connections-supported-viewer-protocols-ciphers.html
	HttpVersion HttpVersion

	// If you want CloudFront to respond to IPv6 DNS requests with an IPv6 address for
	// your distribution, specify true . If you specify false , CloudFront responds to
	// IPv6 DNS requests with the DNS response code NOERROR and with no IP addresses.
	// This allows viewers to submit a second request, for an IPv4 address for your
	// distribution.
	//
	// In general, you should enable IPv6 if you have users on IPv6 networks who want
	// to access your content. However, if you're using signed URLs or signed cookies
	// to restrict access to your content, and if you're using a custom policy that
	// includes the IpAddress parameter to restrict the IP addresses that can access
	// your content, don't enable IPv6. If you want to restrict access to some content
	// by IP address and not restrict access to other content (or restrict access but
	// not by IP address), you can create two distributions. For more information, see [Creating a Signed URL Using a Custom Policy]
	// in the Amazon CloudFront Developer Guide.
	//
	// If you're using an Route 53 Amazon Web Services Integration alias resource
	// record set to route traffic to your CloudFront distribution, you need to create
	// a second alias resource record set when both of the following are true:
	//
	//   - You enable IPv6 for the distribution
	//
	//   - You're using alternate domain names in the URLs for your objects
	//
	// For more information, see [Routing Traffic to an Amazon CloudFront Web Distribution by Using Your Domain Name] in the Route 53 Amazon Web Services Integration
	// Developer Guide.
	//
	// If you created a CNAME resource record set, either with Route 53 Amazon Web
	// Services Integration or with another DNS service, you don't need to make any
	// changes. A CNAME record will route traffic to your distribution regardless of
	// the IP address format of the viewer request.
	//
	// [Routing Traffic to an Amazon CloudFront Web Distribution by Using Your Domain Name]: https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-to-cloudfront-distribution.html
	// [Creating a Signed URL Using a Custom Policy]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-creating-signed-url-custom-policy.html
	IsIPV6Enabled *bool

	// A complex type that controls whether access logs are written for the
	// distribution.
	//
	// For more information about logging, see [Access Logs] in the Amazon CloudFront Developer
	// Guide.
	//
	// [Access Logs]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/AccessLogs.html
	Logging *LoggingConfig

	// A complex type that contains information about origin groups for this
	// distribution.
	OriginGroups *OriginGroups

	// The price class that corresponds with the maximum price that you want to pay
	// for CloudFront service. If you specify PriceClass_All , CloudFront responds to
	// requests for your objects from all CloudFront edge locations.
	//
	// If you specify a price class other than PriceClass_All , CloudFront serves your
	// objects from the CloudFront edge location that has the lowest latency among the
	// edge locations in your price class. Viewers who are in or near regions that are
	// excluded from your specified price class may encounter slower performance.
	//
	// For more information about price classes, see [Choosing the Price Class for a CloudFront Distribution] in the Amazon CloudFront
	// Developer Guide. For information about CloudFront pricing, including how price
	// classes (such as Price Class 100) map to CloudFront regions, see [Amazon CloudFront Pricing].
	//
	// [Choosing the Price Class for a CloudFront Distribution]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PriceClass.html
	// [Amazon CloudFront Pricing]: http://aws.amazon.com/cloudfront/pricing/
	PriceClass PriceClass

	// A complex type that identifies ways in which you want to restrict distribution
	// of your content.
	Restrictions *Restrictions

	// A Boolean that indicates whether this is a staging distribution. When this
	// value is true , this is a staging distribution. When this value is false , this
	// is not a staging distribution.
	Staging *bool

	// A complex type that determines the distribution's SSL/TLS configuration for
	// communicating with viewers.
	ViewerCertificate *ViewerCertificate

	// A unique identifier that specifies the WAF web ACL, if any, to associate with
	// this distribution. To specify a web ACL created using the latest version of WAF,
	// use the ACL ARN, for example
	// arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/a1b2c3d4-5678-90ab-cdef-EXAMPLE11111
	// . To specify a web ACL created using WAF Classic, use the ACL ID, for example
	// a1b2c3d4-5678-90ab-cdef-EXAMPLE11111 .
	//
	// WAF is a web application firewall that lets you monitor the HTTP and HTTPS
	// requests that are forwarded to CloudFront, and lets you control access to your
	// content. Based on conditions that you specify, such as the IP addresses that
	// requests originate from or the values of query strings, CloudFront responds to
	// requests either with the requested content or with an HTTP 403 status code
	// (Forbidden). You can also configure CloudFront to return a custom error page
	// when a request is blocked. For more information about WAF, see the [WAF Developer Guide].
	//
	// [WAF Developer Guide]: https://docs.aws.amazon.com/waf/latest/developerguide/what-is-aws-waf.html
	WebACLId *string

	noSmithyDocumentSerde
}

// A distribution Configuration and a list of tags to be associated with the
// distribution.
type DistributionConfigWithTags struct {

	// A distribution configuration.
	//
	// This member is required.
	DistributionConfig *DistributionConfig

	// A complex type that contains zero or more Tag elements.
	//
	// This member is required.
	Tags *Tags

	noSmithyDocumentSerde
}

// A list of distribution IDs.
type DistributionIdList struct {

	// A flag that indicates whether more distribution IDs remain to be listed. If
	// your results were truncated, you can make a subsequent request using the Marker
	// request field to retrieve more distribution IDs in the list.
	//
	// This member is required.
	IsTruncated *bool

	// The value provided in the Marker request field.
	//
	// This member is required.
	Marker *string

	// The maximum number of distribution IDs requested.
	//
	// This member is required.
	MaxItems *int32

	// The total number of distribution IDs returned in the response.
	//
	// This member is required.
	Quantity *int32

	// Contains the distribution IDs in the list.
	Items []string

	// Contains the value that you should use in the Marker field of a subsequent
	// request to continue listing distribution IDs where you left off.
	NextMarker *string

	noSmithyDocumentSerde
}

// A distribution list.
type DistributionList struct {

	// A flag that indicates whether more distributions remain to be listed. If your
	// results were truncated, you can make a follow-up pagination request using the
	// Marker request parameter to retrieve more distributions in the list.
	//
	// This member is required.
	IsTruncated *bool

	// The value you provided for the Marker request parameter.
	//
	// This member is required.
	Marker *string

	// The value you provided for the MaxItems request parameter.
	//
	// This member is required.
	MaxItems *int32

	// The number of distributions that were created by the current Amazon Web
	// Services account.
	//
	// This member is required.
	Quantity *int32

	// A complex type that contains one DistributionSummary element for each
	// distribution that was created by the current Amazon Web Services account.
	Items []DistributionSummary

	// If IsTruncated is true , this element is present and contains the value you can
	// use for the Marker request parameter to continue listing your distributions
	// where they left off.
	NextMarker *string

	noSmithyDocumentSerde
}

// A summary of the information about a CloudFront distribution.
type DistributionSummary struct {

	// The ARN (Amazon Resource Name) for the distribution. For example:
	// arn:aws:cloudfront::123456789012:distribution/EDFDVBD632BHDS5 , where
	// 123456789012 is your Amazon Web Services account ID.
	//
	// This member is required.
	ARN *string

	// A complex type that contains information about CNAMEs (alternate domain names),
	// if any, for this distribution.
	//
	// This member is required.
	Aliases *Aliases

	// A complex type that contains zero or more CacheBehavior elements.
	//
	// This member is required.
	CacheBehaviors *CacheBehaviors

	// The comment originally specified when this distribution was created.
	//
	// This member is required.
	Comment *string

	// A complex type that contains zero or more CustomErrorResponses elements.
	//
	// This member is required.
	CustomErrorResponses *CustomErrorResponses

	// A complex type that describes the default cache behavior if you don't specify a
	// CacheBehavior element or if files don't match any of the values of PathPattern
	// in CacheBehavior elements. You must create exactly one default cache behavior.
	//
	// This member is required.
	DefaultCacheBehavior *DefaultCacheBehavior

	// The domain name that corresponds to the distribution, for example,
	// d111111abcdef8.cloudfront.net .
	//
	// This member is required.
	DomainName *string

	// Whether the distribution is enabled to accept user requests for content.
	//
	// This member is required.
	Enabled *bool

	// Specify the maximum HTTP version that you want viewers to use to communicate
	// with CloudFront. The default value for new web distributions is http2 . Viewers
	// that don't support HTTP/2 will automatically use an earlier version.
	//
	// This member is required.
	HttpVersion HttpVersion

	// The identifier for the distribution. For example: EDFDVBD632BHDS5 .
	//
	// This member is required.
	Id *string

	// Whether CloudFront responds to IPv6 DNS requests with an IPv6 address for your
	// distribution.
	//
	// This member is required.
	IsIPV6Enabled *bool

	// The date and time the distribution was last modified.
	//
	// This member is required.
	LastModifiedTime *time.Time

	// A complex type that contains information about origins for this distribution.
	//
	// This member is required.
	Origins *Origins

	// A complex type that contains information about price class for this streaming
	// distribution.
	//
	// This member is required.
	PriceClass PriceClass

	// A complex type that identifies ways in which you want to restrict distribution
	// of your content.
	//
	// This member is required.
	Restrictions *Restrictions

	// A Boolean that indicates whether this is a staging distribution. When this
	// value is true , this is a staging distribution. When this value is false , this
	// is not a staging distribution.
	//
	// This member is required.
	Staging *bool

	// The current status of the distribution. When the status is Deployed , the
	// distribution's information is propagated to all CloudFront edge locations.
	//
	// This member is required.
	Status *string

	// A complex type that determines the distribution's SSL/TLS configuration for
	// communicating with viewers.
	//
	// This member is required.
	ViewerCertificate *ViewerCertificate

	// The Web ACL Id (if any) associated with the distribution.
	//
	// This member is required.
	WebACLId *string

	// Amazon Web Services services in China customers must file for an Internet
	// Content Provider (ICP) recordal if they want to serve content publicly on an
	// alternate domain name, also known as a CNAME, that they've added to CloudFront.
	// AliasICPRecordal provides the ICP recordal status for CNAMEs associated with
	// distributions.
	//
	// For more information about ICP recordals, see [Signup, Accounts, and Credentials] in Getting Started with Amazon
	// Web Services services in China.
	//
	// [Signup, Accounts, and Credentials]: https://docs.amazonaws.cn/en_us/aws/latest/userguide/accounts-and-credentials.html
	AliasICPRecordals []AliasICPRecordal

	// ID of the Anycast static IP list that is associated with the distribution.
	AnycastIpListId *string

	// A complex type that contains information about origin groups for this
	// distribution.
	OriginGroups *OriginGroups

	noSmithyDocumentSerde
}

// Complex data type for field-level encryption profiles that includes all of the
// encryption entities.
type EncryptionEntities struct {

	// Number of field pattern items in a field-level encryption content type-profile
	// mapping.
	//
	// This member is required.
	Quantity *int32

	// An array of field patterns in a field-level encryption content type-profile
	// mapping.
	Items []EncryptionEntity

	noSmithyDocumentSerde
}

// Complex data type for field-level encryption profiles that includes the
// encryption key and field pattern specifications.
type EncryptionEntity struct {

	// Field patterns in a field-level encryption content type profile specify the
	// fields that you want to be encrypted. You can provide the full field name, or
	// any beginning characters followed by a wildcard (*). You can't overlap field
	// patterns. For example, you can't have both ABC* and AB*. Note that field
	// patterns are case-sensitive.
	//
	// This member is required.
	FieldPatterns *FieldPatterns

	// The provider associated with the public key being used for encryption. This
	// value must also be provided with the private key for applications to be able to
	// decrypt data.
	//
	// This member is required.
	ProviderId *string

	// The public key associated with a set of field-level encryption patterns, to be
	// used when encrypting the fields that match the patterns.
	//
	// This member is required.
	PublicKeyId *string

	noSmithyDocumentSerde
}

// Contains information about the Amazon Kinesis data stream where you are sending
// real-time log data in a real-time log configuration.
type EndPoint struct {

	// The type of data stream where you are sending real-time log data. The only
	// valid value is Kinesis .
	//
	// This member is required.
	StreamType *string

	// Contains information about the Amazon Kinesis data stream where you are sending
	// real-time log data.
	KinesisStreamConfig *KinesisStreamConfig

	noSmithyDocumentSerde
}

// A complex data type that includes the profile configurations and other options
// specified for field-level encryption.
type FieldLevelEncryption struct {

	// A complex data type that includes the profile configurations specified for
	// field-level encryption.
	//
	// This member is required.
	FieldLevelEncryptionConfig *FieldLevelEncryptionConfig

	// The configuration ID for a field-level encryption configuration which includes
	// a set of profiles that specify certain selected data fields to be encrypted by
	// specific public keys.
	//
	// This member is required.
	Id *string

	// The last time the field-level encryption configuration was changed.
	//
	// This member is required.
	LastModifiedTime *time.Time

	noSmithyDocumentSerde
}

// A complex data type that includes the profile configurations specified for
// field-level encryption.
type FieldLevelEncryptionConfig struct {

	// A unique number that ensures the request can't be replayed.
	//
	// This member is required.
	CallerReference *string

	// An optional comment about the configuration. The comment cannot be longer than
	// 128 characters.
	Comment *string

	// A complex data type that specifies when to forward content if a content type
	// isn't recognized and profiles to use as by default in a request if a query
	// argument doesn't specify a profile to use.
	ContentTypeProfileConfig *ContentTypeProfileConfig

	// A complex data type that specifies when to forward content if a profile isn't
	// found and the profile that can be provided as a query argument in a request.
	QueryArgProfileConfig *QueryArgProfileConfig

	noSmithyDocumentSerde
}

// List of field-level encryption configurations.
type FieldLevelEncryptionList struct {

	// The maximum number of elements you want in the response body.
	//
	// This member is required.
	MaxItems *int32

	// The number of field-level encryption items.
	//
	// This member is required.
	Quantity *int32

	// An array of field-level encryption items.
	Items []FieldLevelEncryptionSummary

	// If there are more elements to be listed, this element is present and contains
	// the value that you can use for the Marker request parameter to continue listing
	// your configurations where you left off.
	NextMarker *string

	noSmithyDocumentSerde
}

// A complex data type for field-level encryption profiles.
type FieldLevelEncryptionProfile struct {

	// A complex data type that includes the profile name and the encryption entities
	// for the field-level encryption profile.
	//
	// This member is required.
	FieldLevelEncryptionProfileConfig *FieldLevelEncryptionProfileConfig

	// The ID for a field-level encryption profile configuration which includes a set
	// of profiles that specify certain selected data fields to be encrypted by
	// specific public keys.
	//
	// This member is required.
	Id *string

	// The last time the field-level encryption profile was updated.
	//
	// This member is required.
	LastModifiedTime *time.Time

	noSmithyDocumentSerde
}

// A complex data type of profiles for the field-level encryption.
type FieldLevelEncryptionProfileConfig struct {

	// A unique number that ensures that the request can't be replayed.
	//
	// This member is required.
	CallerReference *string

	// A complex data type of encryption entities for the field-level encryption
	// profile that include the public key ID, provider, and field patterns for
	// specifying which fields to encrypt with this key.
	//
	// This member is required.
	EncryptionEntities *EncryptionEntities

	// Profile name for the field-level encryption profile.
	//
	// This member is required.
	Name *string

	// An optional comment for the field-level encryption profile. The comment cannot
	// be longer than 128 characters.
	Comment *string

	noSmithyDocumentSerde
}

// List of field-level encryption profiles.
type FieldLevelEncryptionProfileList struct {

	// The maximum number of field-level encryption profiles you want in the response
	// body.
	//
	// This member is required.
	MaxItems *int32

	// The number of field-level encryption profiles.
	//
	// This member is required.
	Quantity *int32

	// The field-level encryption profile items.
	Items []FieldLevelEncryptionProfileSummary

	// If there are more elements to be listed, this element is present and contains
	// the value that you can use for the Marker request parameter to continue listing
	// your profiles where you left off.
	NextMarker *string

	noSmithyDocumentSerde
}

// The field-level encryption profile summary.
type FieldLevelEncryptionProfileSummary struct {

	// A complex data type of encryption entities for the field-level encryption
	// profile that include the public key ID, provider, and field patterns for
	// specifying which fields to encrypt with this key.
	//
	// This member is required.
	EncryptionEntities *EncryptionEntities

	// ID for the field-level encryption profile summary.
	//
	// This member is required.
	Id *string

	// The time when the field-level encryption profile summary was last updated.
	//
	// This member is required.
	LastModifiedTime *time.Time

	// Name for the field-level encryption profile summary.
	//
	// This member is required.
	Name *string

	// An optional comment for the field-level encryption profile summary. The comment
	// cannot be longer than 128 characters.
	Comment *string

	noSmithyDocumentSerde
}

// A summary of a field-level encryption item.
type FieldLevelEncryptionSummary struct {

	// The unique ID of a field-level encryption item.
	//
	// This member is required.
	Id *string

	// The last time that the summary of field-level encryption items was modified.
	//
	// This member is required.
	LastModifiedTime *time.Time

	// An optional comment about the field-level encryption item. The comment cannot
	// be longer than 128 characters.
	Comment *string

	// A summary of a content type-profile mapping.
	ContentTypeProfileConfig *ContentTypeProfileConfig

	// A summary of a query argument-profile mapping.
	QueryArgProfileConfig *QueryArgProfileConfig

	noSmithyDocumentSerde
}

// A complex data type that includes the field patterns to match for field-level
// encryption.
type FieldPatterns struct {

	// The number of field-level encryption field patterns.
	//
	// This member is required.
	Quantity *int32

	// An array of the field-level encryption field patterns.
	Items []string

	noSmithyDocumentSerde
}

// This field is deprecated. We recommend that you use a cache policy or an origin
// request policy instead of this field.
//
// If you want to include values in the cache key, use a cache policy. For more
// information, see [Creating cache policies]in the Amazon CloudFront Developer Guide.
//
// If you want to send values to the origin but not include them in the cache key,
// use an origin request policy. For more information, see [Creating origin request policies]in the Amazon
// CloudFront Developer Guide.
//
// A complex type that specifies how CloudFront handles query strings, cookies,
// and HTTP headers.
//
// [Creating origin request policies]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy
// [Creating cache policies]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy
type ForwardedValues struct {

	// This field is deprecated. We recommend that you use a cache policy or an origin
	// request policy instead of this field.
	//
	// If you want to include cookies in the cache key, use a cache policy. For more
	// information, see [Creating cache policies]in the Amazon CloudFront Developer Guide.
	//
	// If you want to send cookies to the origin but not include them in the cache
	// key, use an origin request policy. For more information, see [Creating origin request policies]in the Amazon
	// CloudFront Developer Guide.
	//
	// A complex type that specifies whether you want CloudFront to forward cookies to
	// the origin and, if so, which ones. For more information about forwarding cookies
	// to the origin, see [How CloudFront Forwards, Caches, and Logs Cookies]in the Amazon CloudFront Developer Guide.
	//
	// [Creating origin request policies]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy
	// [Creating cache policies]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy
	// [How CloudFront Forwards, Caches, and Logs Cookies]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Cookies.html
	//
	// This member is required.
	Cookies *CookiePreference

	// This field is deprecated. We recommend that you use a cache policy or an origin
	// request policy instead of this field.
	//
	// If you want to include query strings in the cache key, use a cache policy. For
	// more information, see [Creating cache policies]in the Amazon CloudFront Developer Guide.
	//
	// If you want to send query strings to the origin but not include them in the
	// cache key, use an origin request policy. For more information, see [Creating origin request policies]in the
	// Amazon CloudFront Developer Guide.
	//
	// Indicates whether you want CloudFront to forward query strings to the origin
	// that is associated with this cache behavior and cache based on the query string
	// parameters. CloudFront behavior depends on the value of QueryString and on the
	// values that you specify for QueryStringCacheKeys , if any:
	//
	// If you specify true for QueryString and you don't specify any values for
	// QueryStringCacheKeys , CloudFront forwards all query string parameters to the
	// origin and caches based on all query string parameters. Depending on how many
	// query string parameters and values you have, this can adversely affect
	// performance because CloudFront must forward more requests to the origin.
	//
	// If you specify true for QueryString and you specify one or more values for
	// QueryStringCacheKeys , CloudFront forwards all query string parameters to the
	// origin, but it only caches based on the query string parameters that you
	// specify.
	//
	// If you specify false for QueryString , CloudFront doesn't forward any query
	// string parameters to the origin, and doesn't cache based on query string
	// parameters.
	//
	// For more information, see [Configuring CloudFront to Cache Based on Query String Parameters] in the Amazon CloudFront Developer Guide.
	//
	// [Creating origin request policies]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy
	// [Creating cache policies]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy
	// [Configuring CloudFront to Cache Based on Query String Parameters]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/QueryStringParameters.html
	//
	// This member is required.
	QueryString *bool

	// This field is deprecated. We recommend that you use a cache policy or an origin
	// request policy instead of this field.
	//
	// If you want to include headers in the cache key, use a cache policy. For more
	// information, see [Creating cache policies]in the Amazon CloudFront Developer Guide.
	//
	// If you want to send headers to the origin but not include them in the cache
	// key, use an origin request policy. For more information, see [Creating origin request policies]in the Amazon
	// CloudFront Developer Guide.
	//
	// A complex type that specifies the Headers , if any, that you want CloudFront to
	// forward to the origin for this cache behavior (whitelisted headers). For the
	// headers that you specify, CloudFront also caches separate versions of a
	// specified object that is based on the header values in viewer requests.
	//
	// For more information, see [Caching Content Based on Request Headers] in the Amazon CloudFront Developer Guide.
	//
	// [Creating origin request policies]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy
	// [Creating cache policies]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy
	// [Caching Content Based on Request Headers]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/header-caching.html
	Headers *Headers

	// This field is deprecated. We recommend that you use a cache policy or an origin
	// request policy instead of this field.
	//
	// If you want to include query strings in the cache key, use a cache policy. For
	// more information, see [Creating cache policies]in the Amazon CloudFront Developer Guide.
	//
	// If you want to send query strings to the origin but not include them in the
	// cache key, use an origin request policy. For more information, see [Creating origin request policies]in the
	// Amazon CloudFront Developer Guide.
	//
	// A complex type that contains information about the query string parameters that
	// you want CloudFront to use for caching for this cache behavior.
	//
	// [Creating origin request policies]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy
	// [Creating cache policies]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy
	QueryStringCacheKeys *QueryStringCacheKeys

	noSmithyDocumentSerde
}

// A CloudFront function that is associated with a cache behavior in a CloudFront
// distribution.
type FunctionAssociation struct {

	// The event type of the function, either viewer-request or viewer-response . You
	// cannot use origin-facing event types ( origin-request and origin-response ) with
	// a CloudFront function.
	//
	// This member is required.
	EventType EventType

	// The Amazon Resource Name (ARN) of the function.
	//
	// This member is required.
	FunctionARN *string

	noSmithyDocumentSerde
}

// A list of CloudFront functions that are associated with a cache behavior in a
// CloudFront distribution. Your functions must be published to the LIVE stage to
// associate them with a cache behavior.
type FunctionAssociations struct {

	// The number of CloudFront functions in the list.
	//
	// This member is required.
	Quantity *int32

	// The CloudFront functions that are associated with a cache behavior in a
	// CloudFront distribution. Your functions must be published to the LIVE stage to
	// associate them with a cache behavior.
	Items []FunctionAssociation

	noSmithyDocumentSerde
}

// Contains configuration information about a CloudFront function.
type FunctionConfig struct {

	// A comment to describe the function.
	//
	// This member is required.
	Comment *string

	// The function's runtime environment version.
	//
	// This member is required.
	Runtime FunctionRuntime

	// The configuration for the key value store associations.
	KeyValueStoreAssociations *KeyValueStoreAssociations

	noSmithyDocumentSerde
}

// A list of CloudFront functions.
type FunctionList struct {

	// The maximum number of functions requested.
	//
	// This member is required.
	MaxItems *int32

	// The number of functions returned in the response.
	//
	// This member is required.
	Quantity *int32

	// Contains the functions in the list.
	Items []FunctionSummary

	// If there are more items in the list than are in this response, this element is
	// present. It contains the value that you should use in the Marker field of a
	// subsequent request to continue listing functions where you left off.
	NextMarker *string

	noSmithyDocumentSerde
}

// Contains metadata about a CloudFront function.
type FunctionMetadata struct {

	// The Amazon Resource Name (ARN) of the function. The ARN uniquely identifies the
	// function.
	//
	// This member is required.
	FunctionARN *string

	// The date and time when the function was most recently updated.
	//
	// This member is required.
	LastModifiedTime *time.Time

	// The date and time when the function was created.
	CreatedTime *time.Time

	// The stage that the function is in, either DEVELOPMENT or LIVE .
	//
	// When a function is in the DEVELOPMENT stage, you can test the function with
	// TestFunction , and update it with UpdateFunction .
	//
	// When a function is in the LIVE stage, you can attach the function to a
	// distribution's cache behavior, using the function's ARN.
	Stage FunctionStage

	noSmithyDocumentSerde
}

// Contains configuration information and metadata about a CloudFront function.
type FunctionSummary struct {

	// Contains configuration information about a CloudFront function.
	//
	// This member is required.
	FunctionConfig *FunctionConfig

	// Contains metadata about a CloudFront function.
	//
	// This member is required.
	FunctionMetadata *FunctionMetadata

	// The name of the CloudFront function.
	//
	// This member is required.
	Name *string

	// The status of the CloudFront function.
	Status *string

	noSmithyDocumentSerde
}

// A complex type that controls the countries in which your content is
// distributed. CloudFront determines the location of your users using MaxMind
// GeoIP databases.
type GeoRestriction struct {

	// When geo restriction is enabled , this is the number of countries in your
	// whitelist or blacklist . Otherwise, when it is not enabled, Quantity is 0 , and
	// you can omit Items .
	//
	// This member is required.
	Quantity *int32

	// The method that you want to use to restrict distribution of your content by
	// country:
	//
	//   - none : No geo restriction is enabled, meaning access to content is not
	//   restricted by client geo location.
	//
	//   - blacklist : The Location elements specify the countries in which you don't
	//   want CloudFront to distribute your content.
	//
	//   - whitelist : The Location elements specify the countries in which you want
	//   CloudFront to distribute your content.
	//
	// This member is required.
	RestrictionType GeoRestrictionType

	// A complex type that contains a Location element for each country in which you
	// want CloudFront either to distribute your content ( whitelist ) or not
	// distribute your content ( blacklist ).
	//
	// The Location element is a two-letter, uppercase country code for a country that
	// you want to include in your blacklist or whitelist . Include one Location
	// element for each country.
	//
	// CloudFront and MaxMind both use ISO 3166 country codes. For the current list of
	// countries and the corresponding codes, see ISO 3166-1-alpha-2 code on the
	// International Organization for Standardization website. You can also refer to
	// the country list on the CloudFront console, which includes both country names
	// and codes.
	Items []string

	noSmithyDocumentSerde
}

// Amazon CloudFront supports gRPC, an open-source remote procedure call (RPC)
// framework built on HTTP/2. gRPC offers bi-directional streaming and binary
// protocol that buffers payloads, making it suitable for applications that require
// low latency communications.
//
// To enable your distribution to handle gRPC requests, you must include HTTP/2 as
// one of the supported HTTP versions and allow HTTP methods, including POST .
//
// For more information, see [Using gRPC with CloudFront distributions] in the Amazon CloudFront Developer Guide.
//
// [Using gRPC with CloudFront distributions]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-using-grpc.html
type GrpcConfig struct {

	// Enables your CloudFront distribution to receive gRPC requests and to proxy them
	// directly to your origins.
	//
	// This member is required.
	Enabled *bool

	noSmithyDocumentSerde
}

// Contains a list of HTTP header names.
type Headers struct {

	// The number of header names in the Items list.
	//
	// This member is required.
	Quantity *int32

	// A list of HTTP header names.
	Items []string

	noSmithyDocumentSerde
}

// The import source for the key value store.
type ImportSource struct {

	// The Amazon Resource Name (ARN) of the import source for the key value store.
	//
	// This member is required.
	SourceARN *string

	// The source type of the import source for the key value store.
	//
	// This member is required.
	SourceType ImportSourceType

	noSmithyDocumentSerde
}

// An invalidation.
type Invalidation struct {

	// The date and time the invalidation request was first made.
	//
	// This member is required.
	CreateTime *time.Time

	// The identifier for the invalidation request. For example: IDFDVBD632BHDS5 .
	//
	// This member is required.
	Id *string

	// The current invalidation information for the batch request.
	//
	// This member is required.
	InvalidationBatch *InvalidationBatch

	// The status of the invalidation request. When the invalidation batch is
	// finished, the status is Completed .
	//
	// This member is required.
	Status *string

	noSmithyDocumentSerde
}

// An invalidation batch.
type InvalidationBatch struct {

	// A value that you specify to uniquely identify an invalidation request.
	// CloudFront uses the value to prevent you from accidentally resubmitting an
	// identical request. Whenever you create a new invalidation request, you must
	// specify a new value for CallerReference and change other values in the request
	// as applicable. One way to ensure that the value of CallerReference is unique is
	// to use a timestamp , for example, 20120301090000 .
	//
	// If you make a second invalidation request with the same value for
	// CallerReference , and if the rest of the request is the same, CloudFront doesn't
	// create a new invalidation request. Instead, CloudFront returns information about
	// the invalidation request that you previously created with the same
	// CallerReference .
	//
	// If CallerReference is a value you already sent in a previous invalidation batch
	// request but the content of any Path is different from the original request,
	// CloudFront returns an InvalidationBatchAlreadyExists error.
	//
	// This member is required.
	CallerReference *string

	// A complex type that contains information about the objects that you want to
	// invalidate. For more information, see [Specifying the Objects to Invalidate]in the Amazon CloudFront Developer Guide.
	//
	// [Specifying the Objects to Invalidate]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Invalidation.html#invalidation-specifying-objects
	//
	// This member is required.
	Paths *Paths

	noSmithyDocumentSerde
}

// The InvalidationList complex type describes the list of invalidation objects.
// For more information about invalidation, see [Invalidating Objects (Web Distributions Only)]in the Amazon CloudFront Developer
// Guide.
//
// [Invalidating Objects (Web Distributions Only)]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Invalidation.html
type InvalidationList struct {

	// A flag that indicates whether more invalidation batch requests remain to be
	// listed. If your results were truncated, you can make a follow-up pagination
	// request using the Marker request parameter to retrieve more invalidation
	// batches in the list.
	//
	// This member is required.
	IsTruncated *bool

	// The value that you provided for the Marker request parameter.
	//
	// This member is required.
	Marker *string

	// The value that you provided for the MaxItems request parameter.
	//
	// This member is required.
	MaxItems *int32

	// The number of invalidation batches that were created by the current Amazon Web
	// Services account.
	//
	// This member is required.
	Quantity *int32

	// A complex type that contains one InvalidationSummary element for each
	// invalidation batch created by the current Amazon Web Services account.
	Items []InvalidationSummary

	// If IsTruncated is true , this element is present and contains the value that you
	// can use for the Marker request parameter to continue listing your invalidation
	// batches where they left off.
	NextMarker *string

	noSmithyDocumentSerde
}

// A summary of an invalidation request.
type InvalidationSummary struct {

	// The time that an invalidation request was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The unique ID for an invalidation request.
	//
	// This member is required.
	Id *string

	// The status of an invalidation request.
	//
	// This member is required.
	Status *string

	noSmithyDocumentSerde
}

// A key group.
//
// A key group contains a list of public keys that you can use with [CloudFront signed URLs and signed cookies].
//
// [CloudFront signed URLs and signed cookies]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html
type KeyGroup struct {

	// The identifier for the key group.
	//
	// This member is required.
	Id *string

	// The key group configuration.
	//
	// This member is required.
	KeyGroupConfig *KeyGroupConfig

	// The date and time when the key group was last modified.
	//
	// This member is required.
	LastModifiedTime *time.Time

	noSmithyDocumentSerde
}

// A key group configuration.
//
// A key group contains a list of public keys that you can use with [CloudFront signed URLs and signed cookies].
//
// [CloudFront signed URLs and signed cookies]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html
type KeyGroupConfig struct {

	// A list of the identifiers of the public keys in the key group.
	//
	// This member is required.
	Items []string

	// A name to identify the key group.
	//
	// This member is required.
	Name *string

	// A comment to describe the key group. The comment cannot be longer than 128
	// characters.
	Comment *string

	noSmithyDocumentSerde
}

// A list of key groups.
type KeyGroupList struct {

	// The maximum number of key groups requested.
	//
	// This member is required.
	MaxItems *int32

	// The number of key groups returned in the response.
	//
	// This member is required.
	Quantity *int32

	// A list of key groups.
	Items []KeyGroupSummary

	// If there are more items in the list than are in this response, this element is
	// present. It contains the value that you should use in the Marker field of a
	// subsequent request to continue listing key groups.
	NextMarker *string

	noSmithyDocumentSerde
}

// Contains information about a key group.
type KeyGroupSummary struct {

	// A key group.
	//
	// This member is required.
	KeyGroup *KeyGroup

	noSmithyDocumentSerde
}

// A list of CloudFront key pair identifiers.
type KeyPairIds struct {

	// The number of key pair identifiers in the list.
	//
	// This member is required.
	Quantity *int32

	// A list of CloudFront key pair identifiers.
	Items []string

	noSmithyDocumentSerde
}

// The key value store. Use this to separate data from function code, allowing you
// to update data without having to publish a new version of a function. The key
// value store holds keys and their corresponding values.
type KeyValueStore struct {

	// The Amazon Resource Name (ARN) of the key value store.
	//
	// This member is required.
	ARN *string

	// A comment for the key value store.
	//
	// This member is required.
	Comment *string

	// The unique Id for the key value store.
	//
	// This member is required.
	Id *string

	// The last-modified time of the key value store.
	//
	// This member is required.
	LastModifiedTime *time.Time

	// The name of the key value store.
	//
	// This member is required.
	Name *string

	// The status of the key value store.
	Status *string

	noSmithyDocumentSerde
}

// The key value store association.
type KeyValueStoreAssociation struct {

	// The Amazon Resource Name (ARN) of the key value store association.
	//
	// This member is required.
	KeyValueStoreARN *string

	noSmithyDocumentSerde
}

// The key value store associations.
type KeyValueStoreAssociations struct {

	// The quantity of key value store associations.
	//
	// This member is required.
	Quantity *int32

	// The items of the key value store association.
	Items []KeyValueStoreAssociation

	noSmithyDocumentSerde
}

// The key value store list.
type KeyValueStoreList struct {

	// The maximum number of items in the key value store list.
	//
	// This member is required.
	MaxItems *int32

	// The quantity of the key value store list.
	//
	// This member is required.
	Quantity *int32

	// The items of the key value store list.
	Items []KeyValueStore

	// The next marker associated with the key value store list.
	NextMarker *string

	noSmithyDocumentSerde
}

// A list of identifiers for the public keys that CloudFront can use to verify the
// signatures of signed URLs and signed cookies.
type KGKeyPairIds struct {

	// The identifier of the key group that contains the public keys.
	KeyGroupId *string

	// A list of CloudFront key pair identifiers.
	KeyPairIds *KeyPairIds

	noSmithyDocumentSerde
}

// Contains information about the Amazon Kinesis data stream where you are sending
// real-time log data.
type KinesisStreamConfig struct {

	// The Amazon Resource Name (ARN) of an Identity and Access Management (IAM) role
	// that CloudFront can use to send real-time log data to your Kinesis data stream.
	//
	// For more information the IAM role, see [Real-time log configuration IAM role] in the Amazon CloudFront Developer
	// Guide.
	//
	// [Real-time log configuration IAM role]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-iam-role
	//
	// This member is required.
	RoleARN *string

	// The Amazon Resource Name (ARN) of the Kinesis data stream where you are sending
	// real-time log data.
	//
	// This member is required.
	StreamARN *string

	noSmithyDocumentSerde
}

// A complex type that contains a Lambda@Edge function association.
type LambdaFunctionAssociation struct {

	// Specifies the event type that triggers a Lambda@Edge function invocation. You
	// can specify the following values:
	//
	//   - viewer-request : The function executes when CloudFront receives a request
	//   from a viewer and before it checks to see whether the requested object is in the
	//   edge cache.
	//
	//   - origin-request : The function executes only when CloudFront sends a request
	//   to your origin. When the requested object is in the edge cache, the function
	//   doesn't execute.
	//
	//   - origin-response : The function executes after CloudFront receives a response
	//   from the origin and before it caches the object in the response. When the
	//   requested object is in the edge cache, the function doesn't execute.
	//
	//   - viewer-response : The function executes before CloudFront returns the
	//   requested object to the viewer. The function executes regardless of whether the
	//   object was already in the edge cache.
	//
	// If the origin returns an HTTP status code other than HTTP 200 (OK), the
	//   function doesn't execute.
	//
	// This member is required.
	EventType EventType

	// The ARN of the Lambda@Edge function. You must specify the ARN of a function
	// version; you can't specify an alias or $LATEST.
	//
	// This member is required.
	LambdaFunctionARN *string

	// A flag that allows a Lambda@Edge function to have read access to the body
	// content. For more information, see [Accessing the Request Body by Choosing the Include Body Option]in the Amazon CloudFront Developer Guide.
	//
	// [Accessing the Request Body by Choosing the Include Body Option]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/lambda-include-body-access.html
	IncludeBody *bool

	noSmithyDocumentSerde
}

// A complex type that specifies a list of Lambda@Edge functions associations for
// a cache behavior.
//
// If you want to invoke one or more Lambda@Edge functions triggered by requests
// that match the PathPattern of the cache behavior, specify the applicable values
// for Quantity and Items . Note that there can be up to 4
// LambdaFunctionAssociation items in this list (one for each possible value of
// EventType ) and each EventType can be associated with only one function.
//
// If you don't want to invoke any Lambda@Edge functions for the requests that
// match PathPattern , specify 0 for Quantity and omit Items .
type LambdaFunctionAssociations struct {

	// The number of Lambda@Edge function associations for this cache behavior.
	//
	// This member is required.
	Quantity *int32

	//  Optional: A complex type that contains LambdaFunctionAssociation items for
	// this cache behavior. If Quantity is 0 , you can omit Items .
	Items []LambdaFunctionAssociation

	noSmithyDocumentSerde
}

// A complex type that specifies whether access logs are written for the
// distribution.
//
// If you already enabled standard logging (legacy) and you want to enable
// standard logging (v2) to send your access logs to Amazon S3, we recommend that
// you specify a different Amazon S3 bucket or use a separate path in the same
// bucket (for example, use a log prefix or partitioning). This helps you keep
// track of which log files are associated with which logging subscription and
// prevents log files from overwriting each other. For more information, see [Standard logging (access logs)]in
// the Amazon CloudFront Developer Guide.
//
// [Standard logging (access logs)]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/AccessLogs.html
type LoggingConfig struct {

	// The Amazon S3 bucket to store the access logs in, for example,
	// amzn-s3-demo-bucket.s3.amazonaws.com .
	Bucket *string

	// Specifies whether you want CloudFront to save access logs to an Amazon S3
	// bucket. If you don't want to enable logging when you create a distribution or if
	// you want to disable logging for an existing distribution, specify false for
	// Enabled , and specify empty Bucket and Prefix elements. If you specify false
	// for Enabled but you specify values for Bucket and prefix , the values are
	// automatically deleted.
	Enabled *bool

	// Specifies whether you want CloudFront to include cookies in access logs,
	// specify true for IncludeCookies . If you choose to include cookies in logs,
	// CloudFront logs all cookies regardless of how you configure the cache behaviors
	// for this distribution. If you don't want to include cookies when you create a
	// distribution or if you want to disable include cookies for an existing
	// distribution, specify false for IncludeCookies .
	IncludeCookies *bool

	// An optional string that you want CloudFront to prefix to the access log
	// filenames for this distribution, for example, myprefix/ . If you want to enable
	// logging, but you don't want to specify a prefix, you still must include an empty
	// Prefix element in the Logging element.
	Prefix *string

	noSmithyDocumentSerde
}

// A monitoring subscription. This structure contains information about whether
// additional CloudWatch metrics are enabled for a given CloudFront distribution.
type MonitoringSubscription struct {

	// A subscription configuration for additional CloudWatch metrics.
	RealtimeMetricsSubscriptionConfig *RealtimeMetricsSubscriptionConfig

	noSmithyDocumentSerde
}

// An origin.
//
// An origin is the location where content is stored, and from which CloudFront
// gets content to serve to viewers. To specify an origin:
//
//   - Use S3OriginConfig to specify an Amazon S3 bucket that is not configured
//     with static website hosting.
//
//   - Use CustomOriginConfig to specify all other kinds of origins, including:
//
//   - An Amazon S3 bucket that is configured with static website hosting
//
//   - An Elastic Load Balancing load balancer
//
//   - An Elemental MediaPackage endpoint
//
//   - An Elemental MediaStore container
//
//   - Any other HTTP server, running on an Amazon EC2 instance or any other kind
//     of host
//
// For the current maximum number of origins that you can specify per
// distribution, see [General Quotas on Web Distributions]in the Amazon CloudFront Developer Guide (quotas were
// formerly referred to as limits).
//
// [General Quotas on Web Distributions]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html#limits-web-distributions
type Origin struct {

	// The domain name for the origin.
	//
	// For more information, see [Origin Domain Name] in the Amazon CloudFront Developer Guide.
	//
	// [Origin Domain Name]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesDomainName
	//
	// This member is required.
	DomainName *string

	// A unique identifier for the origin. This value must be unique within the
	// distribution.
	//
	// Use this value to specify the TargetOriginId in a CacheBehavior or
	// DefaultCacheBehavior .
	//
	// This member is required.
	Id *string

	// The number of times that CloudFront attempts to connect to the origin. The
	// minimum number is 1, the maximum is 3, and the default (if you don't specify
	// otherwise) is 3.
	//
	// For a custom origin (including an Amazon S3 bucket that's configured with
	// static website hosting), this value also specifies the number of times that
	// CloudFront attempts to get a response from the origin, in the case of an [Origin Response Timeout].
	//
	// For more information, see [Origin Connection Attempts] in the Amazon CloudFront Developer Guide.
	//
	// [Origin Connection Attempts]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#origin-connection-attempts
	// [Origin Response Timeout]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginResponseTimeout
	ConnectionAttempts *int32

	// The number of seconds that CloudFront waits when trying to establish a
	// connection to the origin. The minimum timeout is 1 second, the maximum is 10
	// seconds, and the default (if you don't specify otherwise) is 10 seconds.
	//
	// For more information, see [Origin Connection Timeout] in the Amazon CloudFront Developer Guide.
	//
	// [Origin Connection Timeout]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#origin-connection-timeout
	ConnectionTimeout *int32

	// A list of HTTP header names and values that CloudFront adds to the requests
	// that it sends to the origin.
	//
	// For more information, see [Adding Custom Headers to Origin Requests] in the Amazon CloudFront Developer Guide.
	//
	// [Adding Custom Headers to Origin Requests]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/add-origin-custom-headers.html
	CustomHeaders *CustomHeaders

	// Use this type to specify an origin that is not an Amazon S3 bucket, with one
	// exception. If the Amazon S3 bucket is configured with static website hosting,
	// use this type. If the Amazon S3 bucket is not configured with static website
	// hosting, use the S3OriginConfig type instead.
	CustomOriginConfig *CustomOriginConfig

	// The unique identifier of an origin access control for this origin.
	//
	// For more information, see [Restricting access to an Amazon S3 origin] in the Amazon CloudFront Developer Guide.
	//
	// [Restricting access to an Amazon S3 origin]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html
	OriginAccessControlId *string

	// An optional path that CloudFront appends to the origin domain name when
	// CloudFront requests content from the origin.
	//
	// For more information, see [Origin Path] in the Amazon CloudFront Developer Guide.
	//
	// [Origin Path]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginPath
	OriginPath *string

	// CloudFront Origin Shield. Using Origin Shield can help reduce the load on your
	// origin.
	//
	// For more information, see [Using Origin Shield] in the Amazon CloudFront Developer Guide.
	//
	// [Using Origin Shield]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html
	OriginShield *OriginShield

	// Use this type to specify an origin that is an Amazon S3 bucket that is not
	// configured with static website hosting. To specify any other type of origin,
	// including an Amazon S3 bucket that is configured with static website hosting,
	// use the CustomOriginConfig type instead.
	S3OriginConfig *S3OriginConfig

	// The VPC origin configuration.
	VpcOriginConfig *VpcOriginConfig

	noSmithyDocumentSerde
}

// A CloudFront origin access control, including its unique identifier.
type OriginAccessControl struct {

	// The unique identifier of the origin access control.
	//
	// This member is required.
	Id *string

	// The origin access control.
	OriginAccessControlConfig *OriginAccessControlConfig

	noSmithyDocumentSerde
}

// A CloudFront origin access control configuration.
type OriginAccessControlConfig struct {

	// A name to identify the origin access control. You can specify up to 64
	// characters.
	//
	// This member is required.
	Name *string

	// The type of origin that this origin access control is for.
	//
	// This member is required.
	OriginAccessControlOriginType OriginAccessControlOriginTypes

	// Specifies which requests CloudFront signs (adds authentication information to).
	// Specify always for the most common use case. For more information, see [origin access control advanced settings] in the
	// Amazon CloudFront Developer Guide.
	//
	// This field can have one of the following values:
	//
	//   - always – CloudFront signs all origin requests, overwriting the Authorization
	//   header from the viewer request if one exists.
	//
	//   - never – CloudFront doesn't sign any origin requests. This value turns off
	//   origin access control for all origins in all distributions that use this origin
	//   access control.
	//
	//   - no-override – If the viewer request doesn't contain the Authorization
	//   header, then CloudFront signs the origin request. If the viewer request contains
	//   the Authorization header, then CloudFront doesn't sign the origin request and
	//   instead passes along the Authorization header from the viewer request.
	//   WARNING: To pass along the Authorization header from the viewer request, you
	//   must add the Authorization header to a [cache policy]for all cache behaviors that use
	//   origins associated with this origin access control.
	//
	// [origin access control advanced settings]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html#oac-advanced-settings
	// [cache policy]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html
	//
	// This member is required.
	SigningBehavior OriginAccessControlSigningBehaviors

	// The signing protocol of the origin access control, which determines how
	// CloudFront signs (authenticates) requests. The only valid value is sigv4 .
	//
	// This member is required.
	SigningProtocol OriginAccessControlSigningProtocols

	// A description of the origin access control.
	Description *string

	noSmithyDocumentSerde
}

// A list of CloudFront origin access controls.
type OriginAccessControlList struct {

	// If there are more items in the list than are in this response, this value is
	// true .
	//
	// This member is required.
	IsTruncated *bool

	// The value of the Marker field that was provided in the request.
	//
	// This member is required.
	Marker *string

	// The maximum number of origin access controls requested.
	//
	// This member is required.
	MaxItems *int32

	// The number of origin access controls returned in the response.
	//
	// This member is required.
	Quantity *int32

	// Contains the origin access controls in the list.
	Items []OriginAccessControlSummary

	// If there are more items in the list than are in this response, this element is
	// present. It contains the value to use in the Marker field of another request to
	// continue listing origin access controls.
	NextMarker *string

	noSmithyDocumentSerde
}

// A CloudFront origin access control.
type OriginAccessControlSummary struct {

	// A description of the origin access control.
	//
	// This member is required.
	Description *string

	// The unique identifier of the origin access control.
	//
	// This member is required.
	Id *string

	// A unique name that identifies the origin access control.
	//
	// This member is required.
	Name *string

	// The type of origin that this origin access control is for.
	//
	// This member is required.
	OriginAccessControlOriginType OriginAccessControlOriginTypes

	// A value that specifies which requests CloudFront signs (adds authentication
	// information to). This field can have one of the following values:
	//
	//   - never – CloudFront doesn't sign any origin requests.
	//
	//   - always – CloudFront signs all origin requests, overwriting the Authorization
	//   header from the viewer request if necessary.
	//
	//   - no-override – If the viewer request doesn't contain the Authorization
	//   header, CloudFront signs the origin request. If the viewer request contains the
	//   Authorization header, CloudFront doesn't sign the origin request, but instead
	//   passes along the Authorization header that it received in the viewer request.
	//
	// This member is required.
	SigningBehavior OriginAccessControlSigningBehaviors

	// The signing protocol of the origin access control. The signing protocol
	// determines how CloudFront signs (authenticates) requests. The only valid value
	// is sigv4 .
	//
	// This member is required.
	SigningProtocol OriginAccessControlSigningProtocols

	noSmithyDocumentSerde
}

// A complex type that contains HeaderName and HeaderValue elements, if any, for
// this distribution.
type OriginCustomHeader struct {

	// The name of a header that you want CloudFront to send to your origin. For more
	// information, see [Adding Custom Headers to Origin Requests]in the Amazon CloudFront Developer Guide.
	//
	// [Adding Custom Headers to Origin Requests]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/forward-custom-headers.html
	//
	// This member is required.
	HeaderName *string

	// The value for the header that you specified in the HeaderName field.
	//
	// This member is required.
	HeaderValue *string

	noSmithyDocumentSerde
}

// An origin group includes two origins (a primary origin and a secondary origin
// to failover to) and a failover criteria that you specify. You create an origin
// group to support origin failover in CloudFront. When you create or update a
// distribution, you can specify the origin group instead of a single origin, and
// CloudFront will failover from the primary origin to the secondary origin under
// the failover conditions that you've chosen.
//
// Optionally, you can choose selection criteria for your origin group to specify
// how your origins are selected when your distribution routes viewer requests.
type OriginGroup struct {

	// A complex type that contains information about the failover criteria for an
	// origin group.
	//
	// This member is required.
	FailoverCriteria *OriginGroupFailoverCriteria

	// The origin group's ID.
	//
	// This member is required.
	Id *string

	// A complex type that contains information about the origins in an origin group.
	//
	// This member is required.
	Members *OriginGroupMembers

	// The selection criteria for the origin group. For more information, see [Create an origin group] in the
	// Amazon CloudFront Developer Guide.
	//
	// [Create an origin group]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/high_availability_origin_failover.html#concept_origin_groups.creating
	SelectionCriteria OriginGroupSelectionCriteria

	noSmithyDocumentSerde
}

// A complex data type that includes information about the failover criteria for
// an origin group, including the status codes for which CloudFront will failover
// from the primary origin to the second origin.
type OriginGroupFailoverCriteria struct {

	// The status codes that, when returned from the primary origin, will trigger
	// CloudFront to failover to the second origin.
	//
	// This member is required.
	StatusCodes *StatusCodes

	noSmithyDocumentSerde
}

// An origin in an origin group.
type OriginGroupMember struct {

	// The ID for an origin in an origin group.
	//
	// This member is required.
	OriginId *string

	noSmithyDocumentSerde
}

// A complex data type for the origins included in an origin group.
type OriginGroupMembers struct {

	// Items (origins) in an origin group.
	//
	// This member is required.
	Items []OriginGroupMember

	// The number of origins in an origin group.
	//
	// This member is required.
	Quantity *int32

	noSmithyDocumentSerde
}

// A complex data type for the origin groups specified for a distribution.
type OriginGroups struct {

	// The number of origin groups.
	//
	// This member is required.
	Quantity *int32

	// The items (origin groups) in a distribution.
	Items []OriginGroup

	noSmithyDocumentSerde
}

// An origin request policy.
//
// When it's attached to a cache behavior, the origin request policy determines
// the values that CloudFront includes in requests that it sends to the origin.
// Each request that CloudFront sends to the origin includes the following:
//
//   - The request body and the URL path (without the domain name) from the viewer
//     request.
//
//   - The headers that CloudFront automatically includes in every origin request,
//     including Host , User-Agent , and X-Amz-Cf-Id .
//
//   - All HTTP headers, cookies, and URL query strings that are specified in the
//     cache policy or the origin request policy. These can include items from the
//     viewer request and, in the case of headers, additional ones that are added by
//     CloudFront.
//
// CloudFront sends a request when it can't find an object in its cache that
// matches the request. If you want to send values to the origin and also include
// them in the cache key, use CachePolicy .
type OriginRequestPolicy struct {

	// The unique identifier for the origin request policy.
	//
	// This member is required.
	Id *string

	// The date and time when the origin request policy was last modified.
	//
	// This member is required.
	LastModifiedTime *time.Time

	// The origin request policy configuration.
	//
	// This member is required.
	OriginRequestPolicyConfig *OriginRequestPolicyConfig

	noSmithyDocumentSerde
}

// An origin request policy configuration.
//
// This configuration determines the values that CloudFront includes in requests
// that it sends to the origin. Each request that CloudFront sends to the origin
// includes the following:
//
//   - The request body and the URL path (without the domain name) from the viewer
//     request.
//
//   - The headers that CloudFront automatically includes in every origin request,
//     including Host , User-Agent , and X-Amz-Cf-Id .
//
//   - All HTTP headers, cookies, and URL query strings that are specified in the
//     cache policy or the origin request policy. These can include items from the
//     viewer request and, in the case of headers, additional ones that are added by
//     CloudFront.
//
// CloudFront sends a request when it can't find an object in its cache that
// matches the request. If you want to send values to the origin and also include
// them in the cache key, use CachePolicy .
type OriginRequestPolicyConfig struct {

	// The cookies from viewer requests to include in origin requests.
	//
	// This member is required.
	CookiesConfig *OriginRequestPolicyCookiesConfig

	// The HTTP headers to include in origin requests. These can include headers from
	// viewer requests and additional headers added by CloudFront.
	//
	// This member is required.
	HeadersConfig *OriginRequestPolicyHeadersConfig

	// A unique name to identify the origin request policy.
	//
	// This member is required.
	Name *string

	// The URL query strings from viewer requests to include in origin requests.
	//
	// This member is required.
	QueryStringsConfig *OriginRequestPolicyQueryStringsConfig

	// A comment to describe the origin request policy. The comment cannot be longer
	// than 128 characters.
	Comment *string

	noSmithyDocumentSerde
}

// An object that determines whether any cookies in viewer requests (and if so,
// which cookies) are included in requests that CloudFront sends to the origin.
type OriginRequestPolicyCookiesConfig struct {

	// Determines whether cookies in viewer requests are included in requests that
	// CloudFront sends to the origin. Valid values are:
	//
	//   - none – No cookies in viewer requests are included in requests that
	//   CloudFront sends to the origin. Even when this field is set to none , any
	//   cookies that are listed in a CachePolicy are included in origin requests.
	//
	//   - whitelist – Only the cookies in viewer requests that are listed in the
	//   CookieNames type are included in requests that CloudFront sends to the origin.
	//
	//   - all – All cookies in viewer requests are included in requests that
	//   CloudFront sends to the origin.
	//
	//   - allExcept – All cookies in viewer requests are included in requests that
	//   CloudFront sends to the origin, except for those listed in the CookieNames
	//   type, which are not included.
	//
	// This member is required.
	CookieBehavior OriginRequestPolicyCookieBehavior

	// Contains a list of cookie names.
	Cookies *CookieNames

	noSmithyDocumentSerde
}

// An object that determines whether any HTTP headers (and if so, which headers)
// are included in requests that CloudFront sends to the origin.
type OriginRequestPolicyHeadersConfig struct {

	// Determines whether any HTTP headers are included in requests that CloudFront
	// sends to the origin. Valid values are:
	//
	//   - none – No HTTP headers in viewer requests are included in requests that
	//   CloudFront sends to the origin. Even when this field is set to none , any
	//   headers that are listed in a CachePolicy are included in origin requests.
	//
	//   - whitelist – Only the HTTP headers that are listed in the Headers type are
	//   included in requests that CloudFront sends to the origin.
	//
	//   - allViewer – All HTTP headers in viewer requests are included in requests
	//   that CloudFront sends to the origin.
	//
	//   - allViewerAndWhitelistCloudFront – All HTTP headers in viewer requests and
	//   the additional CloudFront headers that are listed in the Headers type are
	//   included in requests that CloudFront sends to the origin. The additional headers
	//   are added by CloudFront.
	//
	//   - allExcept – All HTTP headers in viewer requests are included in requests
	//   that CloudFront sends to the origin, except for those listed in the Headers
	//   type, which are not included.
	//
	// This member is required.
	HeaderBehavior OriginRequestPolicyHeaderBehavior

	// Contains a list of HTTP header names.
	Headers *Headers

	noSmithyDocumentSerde
}

// A list of origin request policies.
type OriginRequestPolicyList struct {

	// The maximum number of origin request policies requested.
	//
	// This member is required.
	MaxItems *int32

	// The total number of origin request policies returned in the response.
	//
	// This member is required.
	Quantity *int32

	// Contains the origin request policies in the list.
	Items []OriginRequestPolicySummary

	// If there are more items in the list than are in this response, this element is
	// present. It contains the value that you should use in the Marker field of a
	// subsequent request to continue listing origin request policies where you left
	// off.
	NextMarker *string

	noSmithyDocumentSerde
}

// An object that determines whether any URL query strings in viewer requests (and
// if so, which query strings) are included in requests that CloudFront sends to
// the origin.
type OriginRequestPolicyQueryStringsConfig struct {

	// Determines whether any URL query strings in viewer requests are included in
	// requests that CloudFront sends to the origin. Valid values are:
	//
	//   - none – No query strings in viewer requests are included in requests that
	//   CloudFront sends to the origin. Even when this field is set to none , any
	//   query strings that are listed in a CachePolicy are included in origin requests.
	//
	//   - whitelist – Only the query strings in viewer requests that are listed in the
	//   QueryStringNames type are included in requests that CloudFront sends to the
	//   origin.
	//
	//   - all – All query strings in viewer requests are included in requests that
	//   CloudFront sends to the origin.
	//
	//   - allExcept – All query strings in viewer requests are included in requests
	//   that CloudFront sends to the origin, except for those listed in the
	//   QueryStringNames type, which are not included.
	//
	// This member is required.
	QueryStringBehavior OriginRequestPolicyQueryStringBehavior

	// Contains the specific query strings in viewer requests that either are or are
	// not included in requests that CloudFront sends to the origin. The behavior
	// depends on whether the QueryStringBehavior field in the
	// OriginRequestPolicyQueryStringsConfig type is set to whitelist (the listed
	// query strings are included) or allExcept (the listed query strings are not
	// included, but all other query strings are).
	QueryStrings *QueryStringNames

	noSmithyDocumentSerde
}

// Contains an origin request policy.
type OriginRequestPolicySummary struct {

	// The origin request policy.
	//
	// This member is required.
	OriginRequestPolicy *OriginRequestPolicy

	// The type of origin request policy, either managed (created by Amazon Web
	// Services) or custom (created in this Amazon Web Services account).
	//
	// This member is required.
	Type OriginRequestPolicyType

	noSmithyDocumentSerde
}

// Contains information about the origins for this distribution.
type Origins struct {

	// A list of origins.
	//
	// This member is required.
	Items []Origin

	// The number of origins for this distribution.
	//
	// This member is required.
	Quantity *int32

	noSmithyDocumentSerde
}

// CloudFront Origin Shield.
//
// Using Origin Shield can help reduce the load on your origin. For more
// information, see [Using Origin Shield]in the Amazon CloudFront Developer Guide.
//
// [Using Origin Shield]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html
type OriginShield struct {

	// A flag that specifies whether Origin Shield is enabled.
	//
	// When it's enabled, CloudFront routes all requests through Origin Shield, which
	// can help protect your origin. When it's disabled, CloudFront might send requests
	// directly to your origin from multiple edge locations or regional edge caches.
	//
	// This member is required.
	Enabled *bool

	// The Amazon Web Services Region for Origin Shield.
	//
	// Specify the Amazon Web Services Region that has the lowest latency to your
	// origin. To specify a region, use the region code, not the region name. For
	// example, specify the US East (Ohio) region as us-east-2 .
	//
	// When you enable CloudFront Origin Shield, you must specify the Amazon Web
	// Services Region for Origin Shield. For the list of Amazon Web Services Regions
	// that you can specify, and for help choosing the best Region for your origin, see
	// [Choosing the Amazon Web Services Region for Origin Shield]in the Amazon CloudFront Developer Guide.
	//
	// [Choosing the Amazon Web Services Region for Origin Shield]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html#choose-origin-shield-region
	OriginShieldRegion *string

	noSmithyDocumentSerde
}

// A complex type that contains information about the SSL/TLS protocols that
// CloudFront can use when establishing an HTTPS connection with your origin.
type OriginSslProtocols struct {

	// A list that contains allowed SSL/TLS protocols for this distribution.
	//
	// This member is required.
	Items []SslProtocol

	// The number of SSL/TLS protocols that you want to allow CloudFront to use when
	// establishing an HTTPS connection with this origin.
	//
	// This member is required.
	Quantity *int32

	noSmithyDocumentSerde
}

// This object determines the values that CloudFront includes in the cache key.
// These values can include HTTP headers, cookies, and URL query strings.
// CloudFront uses the cache key to find an object in its cache that it can return
// to the viewer.
//
// The headers, cookies, and query strings that are included in the cache key are
// also included in requests that CloudFront sends to the origin. CloudFront sends
// a request when it can't find an object in its cache that matches the request's
// cache key. If you want to send values to the origin but not include them in the
// cache key, use OriginRequestPolicy .
type ParametersInCacheKeyAndForwardedToOrigin struct {

	// An object that determines whether any cookies in viewer requests (and if so,
	// which cookies) are included in the cache key and in requests that CloudFront
	// sends to the origin.
	//
	// This member is required.
	CookiesConfig *CachePolicyCookiesConfig

	// A flag that can affect whether the Accept-Encoding HTTP header is included in
	// the cache key and included in requests that CloudFront sends to the origin.
	//
	// This field is related to the EnableAcceptEncodingBrotli field. If one or both
	// of these fields is true and the viewer request includes the Accept-Encoding
	// header, then CloudFront does the following:
	//
	//   - Normalizes the value of the viewer's Accept-Encoding header
	//
	//   - Includes the normalized header in the cache key
	//
	//   - Includes the normalized header in the request to the origin, if a request
	//   is necessary
	//
	// For more information, see [Compression support] in the Amazon CloudFront Developer Guide.
	//
	// If you set this value to true , and this cache behavior also has an origin
	// request policy attached, do not include the Accept-Encoding header in the
	// origin request policy. CloudFront always includes the Accept-Encoding header in
	// origin requests when the value of this field is true , so including this header
	// in an origin request policy has no effect.
	//
	// If both of these fields are false , then CloudFront treats the Accept-Encoding
	// header the same as any other HTTP header in the viewer request. By default, it's
	// not included in the cache key and it's not included in origin requests. In this
	// case, you can manually add Accept-Encoding to the headers whitelist like any
	// other HTTP header.
	//
	// [Compression support]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-policy-compressed-objects
	//
	// This member is required.
	EnableAcceptEncodingGzip *bool

	// An object that determines whether any HTTP headers (and if so, which headers)
	// are included in the cache key and in requests that CloudFront sends to the
	// origin.
	//
	// This member is required.
	HeadersConfig *CachePolicyHeadersConfig

	// An object that determines whether any URL query strings in viewer requests (and
	// if so, which query strings) are included in the cache key and in requests that
	// CloudFront sends to the origin.
	//
	// This member is required.
	QueryStringsConfig *CachePolicyQueryStringsConfig

	// A flag that can affect whether the Accept-Encoding HTTP header is included in
	// the cache key and included in requests that CloudFront sends to the origin.
	//
	// This field is related to the EnableAcceptEncodingGzip field. If one or both of
	// these fields is true and the viewer request includes the Accept-Encoding
	// header, then CloudFront does the following:
	//
	//   - Normalizes the value of the viewer's Accept-Encoding header
	//
	//   - Includes the normalized header in the cache key
	//
	//   - Includes the normalized header in the request to the origin, if a request
	//   is necessary
	//
	// For more information, see [Compression support] in the Amazon CloudFront Developer Guide.
	//
	// If you set this value to true , and this cache behavior also has an origin
	// request policy attached, do not include the Accept-Encoding header in the
	// origin request policy. CloudFront always includes the Accept-Encoding header in
	// origin requests when the value of this field is true , so including this header
	// in an origin request policy has no effect.
	//
	// If both of these fields are false , then CloudFront treats the Accept-Encoding
	// header the same as any other HTTP header in the viewer request. By default, it's
	// not included in the cache key and it's not included in origin requests. In this
	// case, you can manually add Accept-Encoding to the headers whitelist like any
	// other HTTP header.
	//
	// [Compression support]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-policy-compressed-objects
	EnableAcceptEncodingBrotli *bool

	noSmithyDocumentSerde
}

// A complex type that contains information about the objects that you want to
// invalidate. For more information, see [Specifying the Objects to Invalidate]in the Amazon CloudFront Developer Guide.
//
// [Specifying the Objects to Invalidate]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Invalidation.html#invalidation-specifying-objects
type Paths struct {

	// The number of invalidation paths specified for the objects that you want to
	// invalidate.
	//
	// This member is required.
	Quantity *int32

	// A complex type that contains a list of the paths that you want to invalidate.
	Items []string

	noSmithyDocumentSerde
}

// A public key that you can use with [signed URLs and signed cookies], or with [field-level encryption].
//
// [signed URLs and signed cookies]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html
// [field-level encryption]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html
type PublicKey struct {

	// The date and time when the public key was uploaded.
	//
	// This member is required.
	CreatedTime *time.Time

	// The identifier of the public key.
	//
	// This member is required.
	Id *string

	// Configuration information about a public key that you can use with [signed URLs and signed cookies], or with [field-level encryption].
	//
	// [signed URLs and signed cookies]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html
	// [field-level encryption]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html
	//
	// This member is required.
	PublicKeyConfig *PublicKeyConfig

	noSmithyDocumentSerde
}

// Configuration information about a public key that you can use with [signed URLs and signed cookies], or with [field-level encryption].
//
// [signed URLs and signed cookies]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html
// [field-level encryption]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html
type PublicKeyConfig struct {

	// A string included in the request to help make sure that the request can't be
	// replayed.
	//
	// This member is required.
	CallerReference *string

	// The public key that you can use with [signed URLs and signed cookies], or with [field-level encryption].
	//
	// [signed URLs and signed cookies]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html
	// [field-level encryption]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html
	//
	// This member is required.
	EncodedKey *string

	// A name to help identify the public key.
	//
	// This member is required.
	Name *string

	// A comment to describe the public key. The comment cannot be longer than 128
	// characters.
	Comment *string

	noSmithyDocumentSerde
}

// A list of public keys that you can use with [signed URLs and signed cookies], or with [field-level encryption].
//
// [signed URLs and signed cookies]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html
// [field-level encryption]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html
type PublicKeyList struct {

	// The maximum number of public keys you want in the response.
	//
	// This member is required.
	MaxItems *int32

	// The number of public keys in the list.
	//
	// This member is required.
	Quantity *int32

	// A list of public keys.
	Items []PublicKeySummary

	// If there are more elements to be listed, this element is present and contains
	// the value that you can use for the Marker request parameter to continue listing
	// your public keys where you left off.
	NextMarker *string

	noSmithyDocumentSerde
}

// Contains information about a public key.
type PublicKeySummary struct {

	// The date and time when the public key was uploaded.
	//
	// This member is required.
	CreatedTime *time.Time

	// The public key.
	//
	// This member is required.
	EncodedKey *string

	// The identifier of the public key.
	//
	// This member is required.
	Id *string

	// A name to help identify the public key.
	//
	// This member is required.
	Name *string

	// A comment to describe the public key. The comment cannot be longer than 128
	// characters.
	Comment *string

	noSmithyDocumentSerde
}

// Query argument-profile mapping for field-level encryption.
type QueryArgProfile struct {

	// ID of profile to use for field-level encryption query argument-profile mapping
	//
	// This member is required.
	ProfileId *string

	// Query argument for field-level encryption query argument-profile mapping.
	//
	// This member is required.
	QueryArg *string

	noSmithyDocumentSerde
}

// Configuration for query argument-profile mapping for field-level encryption.
type QueryArgProfileConfig struct {

	// Flag to set if you want a request to be forwarded to the origin even if the
	// profile specified by the field-level encryption query argument, fle-profile, is
	// unknown.
	//
	// This member is required.
	ForwardWhenQueryArgProfileIsUnknown *bool

	// Profiles specified for query argument-profile mapping for field-level
	// encryption.
	QueryArgProfiles *QueryArgProfiles

	noSmithyDocumentSerde
}

// Query argument-profile mapping for field-level encryption.
type QueryArgProfiles struct {

	// Number of profiles for query argument-profile mapping for field-level
	// encryption.
	//
	// This member is required.
	Quantity *int32

	// Number of items for query argument-profile mapping for field-level encryption.
	Items []QueryArgProfile

	noSmithyDocumentSerde
}

// This field is deprecated. We recommend that you use a cache policy or an origin
// request policy instead of this field.
//
// If you want to include query strings in the cache key, use QueryStringsConfig
// in a cache policy. See CachePolicy .
//
// If you want to send query strings to the origin but not include them in the
// cache key, use QueryStringsConfig in an origin request policy. See
// OriginRequestPolicy .
//
// A complex type that contains information about the query string parameters that
// you want CloudFront to use for caching for a cache behavior.
type QueryStringCacheKeys struct {

	// The number of whitelisted query string parameters for a cache behavior.
	//
	// This member is required.
	Quantity *int32

	// A list that contains the query string parameters that you want CloudFront to
	// use as a basis for caching for a cache behavior. If Quantity is 0, you can omit
	// Items .
	Items []string

	noSmithyDocumentSerde
}

// Contains a list of query string names.
type QueryStringNames struct {

	// The number of query string names in the Items list.
	//
	// This member is required.
	Quantity *int32

	// A list of query string names.
	Items []string

	noSmithyDocumentSerde
}

// A real-time log configuration.
type RealtimeLogConfig struct {

	// The Amazon Resource Name (ARN) of this real-time log configuration.
	//
	// This member is required.
	ARN *string

	// Contains information about the Amazon Kinesis data stream where you are sending
	// real-time log data for this real-time log configuration.
	//
	// This member is required.
	EndPoints []EndPoint

	// A list of fields that are included in each real-time log record. In an API
	// response, the fields are provided in the same order in which they are sent to
	// the Amazon Kinesis data stream.
	//
	// For more information about fields, see [Real-time log configuration fields] in the Amazon CloudFront Developer
	// Guide.
	//
	// [Real-time log configuration fields]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields
	//
	// This member is required.
	Fields []string

	// The unique name of this real-time log configuration.
	//
	// This member is required.
	Name *string

	// The sampling rate for this real-time log configuration. The sampling rate
	// determines the percentage of viewer requests that are represented in the
	// real-time log data. The sampling rate is an integer between 1 and 100,
	// inclusive.
	//
	// This member is required.
	SamplingRate *int64

	noSmithyDocumentSerde
}

// A list of real-time log configurations.
type RealtimeLogConfigs struct {

	// A flag that indicates whether there are more real-time log configurations than
	// are contained in this list.
	//
	// This member is required.
	IsTruncated *bool

	// This parameter indicates where this list of real-time log configurations
	// begins. This list includes real-time log configurations that occur after the
	// marker.
	//
	// This member is required.
	Marker *string

	// The maximum number of real-time log configurations requested.
	//
	// This member is required.
	MaxItems *int32

	// Contains the list of real-time log configurations.
	Items []RealtimeLogConfig

	// If there are more items in the list than are in this response, this element is
	// present. It contains the value that you should use in the Marker field of a
	// subsequent request to continue listing real-time log configurations where you
	// left off.
	NextMarker *string

	noSmithyDocumentSerde
}

// A subscription configuration for additional CloudWatch metrics.
type RealtimeMetricsSubscriptionConfig struct {

	// A flag that indicates whether additional CloudWatch metrics are enabled for a
	// given CloudFront distribution.
	//
	// This member is required.
	RealtimeMetricsSubscriptionStatus RealtimeMetricsSubscriptionStatus

	noSmithyDocumentSerde
}

// A response headers policy.
//
// A response headers policy contains information about a set of HTTP response
// headers.
//
// After you create a response headers policy, you can use its ID to attach it to
// one or more cache behaviors in a CloudFront distribution. When it's attached to
// a cache behavior, the response headers policy affects the HTTP headers that
// CloudFront includes in HTTP responses to requests that match the cache behavior.
// CloudFront adds or removes response headers according to the configuration of
// the response headers policy.
//
// For more information, see [Adding or removing HTTP headers in CloudFront responses] in the Amazon CloudFront Developer Guide.
//
// [Adding or removing HTTP headers in CloudFront responses]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/modifying-response-headers.html
type ResponseHeadersPolicy struct {

	// The identifier for the response headers policy.
	//
	// This member is required.
	Id *string

	// The date and time when the response headers policy was last modified.
	//
	// This member is required.
	LastModifiedTime *time.Time

	// A response headers policy configuration.
	//
	// This member is required.
	ResponseHeadersPolicyConfig *ResponseHeadersPolicyConfig

	noSmithyDocumentSerde
}

// A list of HTTP header names that CloudFront includes as values for the
// Access-Control-Allow-Headers HTTP response header.
//
// For more information about the Access-Control-Allow-Headers HTTP response
// header, see [Access-Control-Allow-Headers]in the MDN Web Docs.
//
// [Access-Control-Allow-Headers]: https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Headers
type ResponseHeadersPolicyAccessControlAllowHeaders struct {

	// The list of HTTP header names. You can specify * to allow all headers.
	//
	// This member is required.
	Items []string

	// The number of HTTP header names in the list.
	//
	// This member is required.
	Quantity *int32

	noSmithyDocumentSerde
}

// A list of HTTP methods that CloudFront includes as values for the
// Access-Control-Allow-Methods HTTP response header.
//
// For more information about the Access-Control-Allow-Methods HTTP response
// header, see [Access-Control-Allow-Methods]in the MDN Web Docs.
//
// [Access-Control-Allow-Methods]: https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Methods
type ResponseHeadersPolicyAccessControlAllowMethods struct {

	// The list of HTTP methods. Valid values are:
	//
	//   - GET
	//
	//   - DELETE
	//
	//   - HEAD
	//
	//   - OPTIONS
	//
	//   - PATCH
	//
	//   - POST
	//
	//   - PUT
	//
	//   - ALL
	//
	// ALL is a special value that includes all of the listed HTTP methods.
	//
	// This member is required.
	Items []ResponseHeadersPolicyAccessControlAllowMethodsValues

	// The number of HTTP methods in the list.
	//
	// This member is required.
	Quantity *int32

	noSmithyDocumentSerde
}

// A list of origins (domain names) that CloudFront can use as the value for the
// Access-Control-Allow-Origin HTTP response header.
//
// For more information about the Access-Control-Allow-Origin HTTP response
// header, see [Access-Control-Allow-Origin]in the MDN Web Docs.
//
// [Access-Control-Allow-Origin]: https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Origin
type ResponseHeadersPolicyAccessControlAllowOrigins struct {

	// The list of origins (domain names). You can specify * to allow all origins.
	//
	// This member is required.
	Items []string

	// The number of origins in the list.
	//
	// This member is required.
	Quantity *int32

	noSmithyDocumentSerde
}

// A list of HTTP headers that CloudFront includes as values for the
// Access-Control-Expose-Headers HTTP response header.
//
// For more information about the Access-Control-Expose-Headers HTTP response
// header, see [Access-Control-Expose-Headers]in the MDN Web Docs.
//
// [Access-Control-Expose-Headers]: https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Expose-Headers
type ResponseHeadersPolicyAccessControlExposeHeaders struct {

	// The number of HTTP headers in the list.
	//
	// This member is required.
	Quantity *int32

	// The list of HTTP headers. You can specify * to expose all headers.
	Items []string

	noSmithyDocumentSerde
}

// A response headers policy configuration.
//
// A response headers policy configuration contains metadata about the response
// headers policy, and configurations for sets of HTTP response headers.
type ResponseHeadersPolicyConfig struct {

	// A name to identify the response headers policy.
	//
	// The name must be unique for response headers policies in this Amazon Web
	// Services account.
	//
	// This member is required.
	Name *string

	// A comment to describe the response headers policy.
	//
	// The comment cannot be longer than 128 characters.
	Comment *string

	// A configuration for a set of HTTP response headers that are used for
	// cross-origin resource sharing (CORS).
	CorsConfig *ResponseHeadersPolicyCorsConfig

	// A configuration for a set of custom HTTP response headers.
	CustomHeadersConfig *ResponseHeadersPolicyCustomHeadersConfig

	// A configuration for a set of HTTP headers to remove from the HTTP response.
	RemoveHeadersConfig *ResponseHeadersPolicyRemoveHeadersConfig

	// A configuration for a set of security-related HTTP response headers.
	SecurityHeadersConfig *ResponseHeadersPolicySecurityHeadersConfig

	// A configuration for enabling the Server-Timing header in HTTP responses sent
	// from CloudFront.
	ServerTimingHeadersConfig *ResponseHeadersPolicyServerTimingHeadersConfig

	noSmithyDocumentSerde
}

// The policy directives and their values that CloudFront includes as values for
// the Content-Security-Policy HTTP response header.
//
// For more information about the Content-Security-Policy HTTP response header,
// see [Content-Security-Policy]in the MDN Web Docs.
//
// [Content-Security-Policy]: https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Security-Policy
type ResponseHeadersPolicyContentSecurityPolicy struct {

	// The policy directives and their values that CloudFront includes as values for
	// the Content-Security-Policy HTTP response header.
	//
	// This member is required.
	ContentSecurityPolicy *string

	// A Boolean that determines whether CloudFront overrides the
	// Content-Security-Policy HTTP response header received from the origin with the
	// one specified in this response headers policy.
	//
	// This member is required.
	Override *bool

	noSmithyDocumentSerde
}

// Determines whether CloudFront includes the X-Content-Type-Options HTTP response
// header with its value set to nosniff .
//
// For more information about the X-Content-Type-Options HTTP response header, see [X-Content-Type-Options]
// in the MDN Web Docs.
//
// [X-Content-Type-Options]: https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Content-Type-Options
type ResponseHeadersPolicyContentTypeOptions struct {

	// A Boolean that determines whether CloudFront overrides the
	// X-Content-Type-Options HTTP response header received from the origin with the
	// one specified in this response headers policy.
	//
	// This member is required.
	Override *bool

	noSmithyDocumentSerde
}

// A configuration for a set of HTTP response headers that are used for
// cross-origin resource sharing (CORS). CloudFront adds these headers to HTTP
// responses that it sends for CORS requests that match a cache behavior associated
// with this response headers policy.
//
// For more information about CORS, see [Cross-Origin Resource Sharing (CORS)] in the MDN Web Docs.
//
// [Cross-Origin Resource Sharing (CORS)]: https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS
type ResponseHeadersPolicyCorsConfig struct {

	// A Boolean that CloudFront uses as the value for the
	// Access-Control-Allow-Credentials HTTP response header.
	//
	// For more information about the Access-Control-Allow-Credentials HTTP response
	// header, see [Access-Control-Allow-Credentials]in the MDN Web Docs.
	//
	// [Access-Control-Allow-Credentials]: https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Credentials
	//
	// This member is required.
	AccessControlAllowCredentials *bool

	// A list of HTTP header names that CloudFront includes as values for the
	// Access-Control-Allow-Headers HTTP response header.
	//
	// For more information about the Access-Control-Allow-Headers HTTP response
	// header, see [Access-Control-Allow-Headers]in the MDN Web Docs.
	//
	// [Access-Control-Allow-Headers]: https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Headers
	//
	// This member is required.
	AccessControlAllowHeaders *ResponseHeadersPolicyAccessControlAllowHeaders

	// A list of HTTP methods that CloudFront includes as values for the
	// Access-Control-Allow-Methods HTTP response header.
	//
	// For more information about the Access-Control-Allow-Methods HTTP response
	// header, see [Access-Control-Allow-Methods]in the MDN Web Docs.
	//
	// [Access-Control-Allow-Methods]: https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Methods
	//
	// This member is required.
	AccessControlAllowMethods *ResponseHeadersPolicyAccessControlAllowMethods

	// A list of origins (domain names) that CloudFront can use as the value for the
	// Access-Control-Allow-Origin HTTP response header.
	//
	// For more information about the Access-Control-Allow-Origin HTTP response
	// header, see [Access-Control-Allow-Origin]in the MDN Web Docs.
	//
	// [Access-Control-Allow-Origin]: https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Origin
	//
	// This member is required.
	AccessControlAllowOrigins *ResponseHeadersPolicyAccessControlAllowOrigins

	// A Boolean that determines whether CloudFront overrides HTTP response headers
	// received from the origin with the ones specified in this response headers
	// policy.
	//
	// This member is required.
	OriginOverride *bool

	// A list of HTTP headers that CloudFront includes as values for the
	// Access-Control-Expose-Headers HTTP response header.
	//
	// For more information about the Access-Control-Expose-Headers HTTP response
	// header, see [Access-Control-Expose-Headers]in the MDN Web Docs.
	//
	// [Access-Control-Expose-Headers]: https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Expose-Headers
	AccessControlExposeHeaders *ResponseHeadersPolicyAccessControlExposeHeaders

	// A number that CloudFront uses as the value for the Access-Control-Max-Age HTTP
	// response header.
	//
	// For more information about the Access-Control-Max-Age HTTP response header, see [Access-Control-Max-Age]
	// in the MDN Web Docs.
	//
	// [Access-Control-Max-Age]: https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Max-Age
	AccessControlMaxAgeSec *int32

	noSmithyDocumentSerde
}

// An HTTP response header name and its value. CloudFront includes this header in
// HTTP responses that it sends for requests that match a cache behavior that's
// associated with this response headers policy.
type ResponseHeadersPolicyCustomHeader struct {

	// The HTTP response header name.
	//
	// This member is required.
	Header *string

	// A Boolean that determines whether CloudFront overrides a response header with
	// the same name received from the origin with the header specified here.
	//
	// This member is required.
	Override *bool

	// The value for the HTTP response header.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// A list of HTTP response header names and their values. CloudFront includes
// these headers in HTTP responses that it sends for requests that match a cache
// behavior that's associated with this response headers policy.
type ResponseHeadersPolicyCustomHeadersConfig struct {

	// The number of HTTP response headers in the list.
	//
	// This member is required.
	Quantity *int32

	// The list of HTTP response headers and their values.
	Items []ResponseHeadersPolicyCustomHeader

	noSmithyDocumentSerde
}

// Determines whether CloudFront includes the X-Frame-Options HTTP response header
// and the header's value.
//
// For more information about the X-Frame-Options HTTP response header, see [X-Frame-Options] in
// the MDN Web Docs.
//
// [X-Frame-Options]: https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Frame-Options
type ResponseHeadersPolicyFrameOptions struct {

	// The value of the X-Frame-Options HTTP response header. Valid values are DENY
	// and SAMEORIGIN .
	//
	// For more information about these values, see [X-Frame-Options] in the MDN Web Docs.
	//
	// [X-Frame-Options]: https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Frame-Options
	//
	// This member is required.
	FrameOption FrameOptionsList

	// A Boolean that determines whether CloudFront overrides the X-Frame-Options HTTP
	// response header received from the origin with the one specified in this response
	// headers policy.
	//
	// This member is required.
	Override *bool

	noSmithyDocumentSerde
}

// A list of response headers policies.
type ResponseHeadersPolicyList struct {

	// The maximum number of response headers policies requested.
	//
	// This member is required.
	MaxItems *int32

	// The number of response headers policies returned.
	//
	// This member is required.
	Quantity *int32

	// The response headers policies in the list.
	Items []ResponseHeadersPolicySummary

	// If there are more items in the list than are in this response, this element is
	// present. It contains the value that you should use in the Marker field of a
	// subsequent request to continue listing response headers policies where you left
	// off.
	NextMarker *string

	noSmithyDocumentSerde
}

// Determines whether CloudFront includes the Referrer-Policy HTTP response header
// and the header's value.
//
// For more information about the Referrer-Policy HTTP response header, see [Referrer-Policy] in
// the MDN Web Docs.
//
// [Referrer-Policy]: https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Referrer-Policy
type ResponseHeadersPolicyReferrerPolicy struct {

	// A Boolean that determines whether CloudFront overrides the Referrer-Policy HTTP
	// response header received from the origin with the one specified in this response
	// headers policy.
	//
	// This member is required.
	Override *bool

	// The value of the Referrer-Policy HTTP response header. Valid values are:
	//
	//   - no-referrer
	//
	//   - no-referrer-when-downgrade
	//
	//   - origin
	//
	//   - origin-when-cross-origin
	//
	//   - same-origin
	//
	//   - strict-origin
	//
	//   - strict-origin-when-cross-origin
	//
	//   - unsafe-url
	//
	// For more information about these values, see [Referrer-Policy] in the MDN Web Docs.
	//
	// [Referrer-Policy]: https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Referrer-Policy
	//
	// This member is required.
	ReferrerPolicy ReferrerPolicyList

	noSmithyDocumentSerde
}

// The name of an HTTP header that CloudFront removes from HTTP responses to
// requests that match the cache behavior that this response headers policy is
// attached to.
type ResponseHeadersPolicyRemoveHeader struct {

	// The HTTP header name.
	//
	// This member is required.
	Header *string

	noSmithyDocumentSerde
}

// A list of HTTP header names that CloudFront removes from HTTP responses to
// requests that match the cache behavior that this response headers policy is
// attached to.
type ResponseHeadersPolicyRemoveHeadersConfig struct {

	// The number of HTTP header names in the list.
	//
	// This member is required.
	Quantity *int32

	// The list of HTTP header names.
	Items []ResponseHeadersPolicyRemoveHeader

	noSmithyDocumentSerde
}

// A configuration for a set of security-related HTTP response headers. CloudFront
// adds these headers to HTTP responses that it sends for requests that match a
// cache behavior associated with this response headers policy.
type ResponseHeadersPolicySecurityHeadersConfig struct {

	// The policy directives and their values that CloudFront includes as values for
	// the Content-Security-Policy HTTP response header.
	//
	// For more information about the Content-Security-Policy HTTP response header,
	// see [Content-Security-Policy]in the MDN Web Docs.
	//
	// [Content-Security-Policy]: https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Security-Policy
	ContentSecurityPolicy *ResponseHeadersPolicyContentSecurityPolicy

	// Determines whether CloudFront includes the X-Content-Type-Options HTTP response
	// header with its value set to nosniff .
	//
	// For more information about the X-Content-Type-Options HTTP response header, see [X-Content-Type-Options]
	// in the MDN Web Docs.
	//
	// [X-Content-Type-Options]: https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Content-Type-Options
	ContentTypeOptions *ResponseHeadersPolicyContentTypeOptions

	// Determines whether CloudFront includes the X-Frame-Options HTTP response header
	// and the header's value.
	//
	// For more information about the X-Frame-Options HTTP response header, see [X-Frame-Options] in
	// the MDN Web Docs.
	//
	// [X-Frame-Options]: https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Frame-Options
	FrameOptions *ResponseHeadersPolicyFrameOptions

	// Determines whether CloudFront includes the Referrer-Policy HTTP response header
	// and the header's value.
	//
	// For more information about the Referrer-Policy HTTP response header, see [Referrer-Policy] in
	// the MDN Web Docs.
	//
	// [Referrer-Policy]: https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Referrer-Policy
	ReferrerPolicy *ResponseHeadersPolicyReferrerPolicy

	// Determines whether CloudFront includes the Strict-Transport-Security HTTP
	// response header and the header's value.
	//
	// For more information about the Strict-Transport-Security HTTP response header,
	// see [Security headers]in the Amazon CloudFront Developer Guide and [Strict-Transport-Security] in the MDN Web Docs.
	//
	// [Strict-Transport-Security]: https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Strict-Transport-Security
	// [Security headers]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/understanding-response-headers-policies.html#understanding-response-headers-policies-security
	StrictTransportSecurity *ResponseHeadersPolicyStrictTransportSecurity

	// Determines whether CloudFront includes the X-XSS-Protection HTTP response
	// header and the header's value.
	//
	// For more information about the X-XSS-Protection HTTP response header, see [X-XSS-Protection] in
	// the MDN Web Docs.
	//
	// [X-XSS-Protection]: https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection
	XSSProtection *ResponseHeadersPolicyXSSProtection

	noSmithyDocumentSerde
}

// A configuration for enabling the Server-Timing header in HTTP responses sent
// from CloudFront. CloudFront adds this header to HTTP responses that it sends in
// response to requests that match a cache behavior that's associated with this
// response headers policy.
//
// You can use the Server-Timing header to view metrics that can help you gain
// insights about the behavior and performance of CloudFront. For example, you can
// see which cache layer served a cache hit, or the first byte latency from the
// origin when there was a cache miss. You can use the metrics in the Server-Timing
// header to troubleshoot issues or test the efficiency of your CloudFront
// configuration. For more information, see [Server-Timing header]in the Amazon CloudFront Developer
// Guide.
//
// [Server-Timing header]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/understanding-response-headers-policies.html#server-timing-header
type ResponseHeadersPolicyServerTimingHeadersConfig struct {

	// A Boolean that determines whether CloudFront adds the Server-Timing header to
	// HTTP responses that it sends in response to requests that match a cache behavior
	// that's associated with this response headers policy.
	//
	// This member is required.
	Enabled *bool

	// A number 0–100 (inclusive) that specifies the percentage of responses that you
	// want CloudFront to add the Server-Timing header to. When you set the sampling
	// rate to 100, CloudFront adds the Server-Timing header to the HTTP response for
	// every request that matches the cache behavior that this response headers policy
	// is attached to. When you set it to 50, CloudFront adds the header to 50% of the
	// responses for requests that match the cache behavior. You can set the sampling
	// rate to any number 0–100 with up to four decimal places.
	SamplingRate *float64

	noSmithyDocumentSerde
}

// Determines whether CloudFront includes the Strict-Transport-Security HTTP
// response header and the header's value.
//
// For more information about the Strict-Transport-Security HTTP response header,
// see [Strict-Transport-Security]in the MDN Web Docs.
//
// [Strict-Transport-Security]: https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Strict-Transport-Security
type ResponseHeadersPolicyStrictTransportSecurity struct {

	// A number that CloudFront uses as the value for the max-age directive in the
	// Strict-Transport-Security HTTP response header.
	//
	// This member is required.
	AccessControlMaxAgeSec *int32

	// A Boolean that determines whether CloudFront overrides the
	// Strict-Transport-Security HTTP response header received from the origin with the
	// one specified in this response headers policy.
	//
	// This member is required.
	Override *bool

	// A Boolean that determines whether CloudFront includes the includeSubDomains
	// directive in the Strict-Transport-Security HTTP response header.
	IncludeSubdomains *bool

	// A Boolean that determines whether CloudFront includes the preload directive in
	// the Strict-Transport-Security HTTP response header.
	Preload *bool

	noSmithyDocumentSerde
}

// Contains a response headers policy.
type ResponseHeadersPolicySummary struct {

	// The response headers policy.
	//
	// This member is required.
	ResponseHeadersPolicy *ResponseHeadersPolicy

	// The type of response headers policy, either managed (created by Amazon Web
	// Services) or custom (created in this Amazon Web Services account).
	//
	// This member is required.
	Type ResponseHeadersPolicyType

	noSmithyDocumentSerde
}

// Determines whether CloudFront includes the X-XSS-Protection HTTP response
// header and the header's value.
//
// For more information about the X-XSS-Protection HTTP response header, see [X-XSS-Protection] in
// the MDN Web Docs.
//
// [X-XSS-Protection]: https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection
type ResponseHeadersPolicyXSSProtection struct {

	// A Boolean that determines whether CloudFront overrides the X-XSS-Protection
	// HTTP response header received from the origin with the one specified in this
	// response headers policy.
	//
	// This member is required.
	Override *bool

	// A Boolean that determines the value of the X-XSS-Protection HTTP response
	// header. When this setting is true , the value of the X-XSS-Protection header is
	// 1 . When this setting is false , the value of the X-XSS-Protection header is 0 .
	//
	// For more information about these settings, see [X-XSS-Protection] in the MDN Web Docs.
	//
	// [X-XSS-Protection]: https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection
	//
	// This member is required.
	Protection *bool

	// A Boolean that determines whether CloudFront includes the mode=block directive
	// in the X-XSS-Protection header.
	//
	// For more information about this directive, see [X-XSS-Protection] in the MDN Web Docs.
	//
	// [X-XSS-Protection]: https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection
	ModeBlock *bool

	// A reporting URI, which CloudFront uses as the value of the report directive in
	// the X-XSS-Protection header.
	//
	// You cannot specify a ReportUri when ModeBlock is true .
	//
	// For more information about using a reporting URL, see [X-XSS-Protection] in the MDN Web Docs.
	//
	// [X-XSS-Protection]: https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection
	ReportUri *string

	noSmithyDocumentSerde
}

// A complex type that identifies ways in which you want to restrict distribution
// of your content.
type Restrictions struct {

	// A complex type that controls the countries in which your content is
	// distributed. CloudFront determines the location of your users using MaxMind
	// GeoIP databases.
	//
	// This member is required.
	GeoRestriction *GeoRestriction

	noSmithyDocumentSerde
}

// A complex type that contains information about the Amazon S3 bucket from which
// you want CloudFront to get your media files for distribution.
type S3Origin struct {

	// The DNS name of the Amazon S3 origin.
	//
	// This member is required.
	DomainName *string

	// The CloudFront origin access identity to associate with the distribution. Use
	// an origin access identity to configure the distribution so that end users can
	// only access objects in an Amazon S3 bucket through CloudFront.
	//
	// If you want end users to be able to access objects using either the CloudFront
	// URL or the Amazon S3 URL, specify an empty OriginAccessIdentity element.
	//
	// To delete the origin access identity from an existing distribution, update the
	// distribution configuration and include an empty OriginAccessIdentity element.
	//
	// To replace the origin access identity, update the distribution configuration
	// and specify the new origin access identity.
	//
	// For more information, see [Using an Origin Access Identity to Restrict Access to Your Amazon S3 Content] in the Amazon CloudFront Developer Guide.
	//
	// [Using an Origin Access Identity to Restrict Access to Your Amazon S3 Content]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html
	//
	// This member is required.
	OriginAccessIdentity *string

	noSmithyDocumentSerde
}

// A complex type that contains information about the Amazon S3 origin. If the
// origin is a custom origin or an S3 bucket that is configured as a website
// endpoint, use the CustomOriginConfig element instead.
type S3OriginConfig struct {

	// If you're using origin access control (OAC) instead of origin access identity,
	// specify an empty OriginAccessIdentity element. For more information, see [Restricting access to an Amazon Web Services] in
	// the Amazon CloudFront Developer Guide.
	//
	// The CloudFront origin access identity to associate with the origin. Use an
	// origin access identity to configure the origin so that viewers can only access
	// objects in an Amazon S3 bucket through CloudFront. The format of the value is:
	//
	//     origin-access-identity/cloudfront/ID-of-origin-access-identity
	//
	// The  ID-of-origin-access-identity  is the value that CloudFront returned in the
	// ID element when you created the origin access identity.
	//
	// If you want viewers to be able to access objects using either the CloudFront
	// URL or the Amazon S3 URL, specify an empty OriginAccessIdentity element.
	//
	// To delete the origin access identity from an existing distribution, update the
	// distribution configuration and include an empty OriginAccessIdentity element.
	//
	// To replace the origin access identity, update the distribution configuration
	// and specify the new origin access identity.
	//
	// For more information about the origin access identity, see [Serving Private Content through CloudFront] in the Amazon
	// CloudFront Developer Guide.
	//
	// [Serving Private Content through CloudFront]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html
	// [Restricting access to an Amazon Web Services]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-origin.html
	//
	// This member is required.
	OriginAccessIdentity *string

	noSmithyDocumentSerde
}

// Session stickiness provides the ability to define multiple requests from a
// single viewer as a single session. This prevents the potentially inconsistent
// experience of sending some of a given user's requests to your staging
// distribution, while others are sent to your primary distribution. Define the
// session duration using TTL values.
type SessionStickinessConfig struct {

	// The amount of time after which you want sessions to cease if no requests are
	// received. Allowed values are 300–3600 seconds (5–60 minutes).
	//
	// The value must be less than or equal to MaximumTTL .
	//
	// This member is required.
	IdleTTL *int32

	// The maximum amount of time to consider requests from the viewer as being part
	// of the same session. Allowed values are 300–3600 seconds (5–60 minutes).
	//
	// The value must be greater than or equal to IdleTTL .
	//
	// This member is required.
	MaximumTTL *int32

	noSmithyDocumentSerde
}

// A list of Amazon Web Services accounts and the active CloudFront key pairs in
// each account that CloudFront can use to verify the signatures of signed URLs and
// signed cookies.
type Signer struct {

	// An Amazon Web Services account number that contains active CloudFront key pairs
	// that CloudFront can use to verify the signatures of signed URLs and signed
	// cookies. If the Amazon Web Services account that owns the key pairs is the same
	// account that owns the CloudFront distribution, the value of this field is self .
	AwsAccountNumber *string

	// A list of CloudFront key pair identifiers.
	KeyPairIds *KeyPairIds

	noSmithyDocumentSerde
}

// The CloudFront domain name of the staging distribution.
type StagingDistributionDnsNames struct {

	// The number of CloudFront domain names in your staging distribution.
	//
	// This member is required.
	Quantity *int32

	// The CloudFront domain name of the staging distribution.
	Items []string

	noSmithyDocumentSerde
}

// A complex data type for the status codes that you specify that, when returned
// by a primary origin, trigger CloudFront to failover to a second origin.
type StatusCodes struct {

	// The items (status codes) for an origin group.
	//
	// This member is required.
	Items []int32

	// The number of status codes.
	//
	// This member is required.
	Quantity *int32

	noSmithyDocumentSerde
}

// A streaming distribution tells CloudFront where you want RTMP content to be
// delivered from, and the details about how to track and manage content delivery.
type StreamingDistribution struct {

	// The ARN (Amazon Resource Name) for the distribution. For example:
	// arn:aws:cloudfront::123456789012:distribution/EDFDVBD632BHDS5 , where
	// 123456789012 is your Amazon Web Services account ID.
	//
	// This member is required.
	ARN *string

	// A complex type that lists the Amazon Web Services accounts, if any, that you
	// included in the TrustedSigners complex type for this distribution. These are
	// the accounts that you want to allow to create signed URLs for private content.
	//
	// The Signer complex type lists the Amazon Web Services account number of the
	// trusted signer or self if the signer is the Amazon Web Services account that
	// created the distribution. The Signer element also includes the IDs of any
	// active CloudFront key pairs that are associated with the trusted signer's Amazon
	// Web Services account. If no KeyPairId element appears for a Signer , that signer
	// can't create signed URLs.
	//
	// For more information, see [Serving Private Content through CloudFront] in the Amazon CloudFront Developer Guide.
	//
	// [Serving Private Content through CloudFront]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html
	//
	// This member is required.
	ActiveTrustedSigners *ActiveTrustedSigners

	// The domain name that corresponds to the streaming distribution, for example,
	// s5c39gqb8ow64r.cloudfront.net .
	//
	// This member is required.
	DomainName *string

	// The identifier for the RTMP distribution. For example: EGTXBD79EXAMPLE .
	//
	// This member is required.
	Id *string

	// The current status of the RTMP distribution. When the status is Deployed , the
	// distribution's information is propagated to all CloudFront edge locations.
	//
	// This member is required.
	Status *string

	// The current configuration information for the RTMP distribution.
	//
	// This member is required.
	StreamingDistributionConfig *StreamingDistributionConfig

	// The date and time that the distribution was last modified.
	LastModifiedTime *time.Time

	noSmithyDocumentSerde
}

// The RTMP distribution's configuration information.
type StreamingDistributionConfig struct {

	// A unique value (for example, a date-time stamp) that ensures that the request
	// can't be replayed.
	//
	// If the value of CallerReference is new (regardless of the content of the
	// StreamingDistributionConfig object), CloudFront creates a new distribution.
	//
	// If CallerReference is a value that you already sent in a previous request to
	// create a distribution, CloudFront returns a DistributionAlreadyExists error.
	//
	// This member is required.
	CallerReference *string

	// Any comments you want to include about the streaming distribution.
	//
	// This member is required.
	Comment *string

	// Whether the streaming distribution is enabled to accept user requests for
	// content.
	//
	// This member is required.
	Enabled *bool

	// A complex type that contains information about the Amazon S3 bucket from which
	// you want CloudFront to get your media files for distribution.
	//
	// This member is required.
	S3Origin *S3Origin

	// A complex type that specifies any Amazon Web Services accounts that you want to
	// permit to create signed URLs for private content. If you want the distribution
	// to use signed URLs, include this element; if you want the distribution to use
	// public URLs, remove this element. For more information, see [Serving Private Content through CloudFront]in the Amazon
	// CloudFront Developer Guide.
	//
	// [Serving Private Content through CloudFront]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html
	//
	// This member is required.
	TrustedSigners *TrustedSigners

	// A complex type that contains information about CNAMEs (alternate domain names),
	// if any, for this streaming distribution.
	Aliases *Aliases

	// A complex type that controls whether access logs are written for the streaming
	// distribution.
	Logging *StreamingLoggingConfig

	// A complex type that contains information about price class for this streaming
	// distribution.
	PriceClass PriceClass

	noSmithyDocumentSerde
}

// A streaming distribution Configuration and a list of tags to be associated with
// the streaming distribution.
type StreamingDistributionConfigWithTags struct {

	// A streaming distribution Configuration.
	//
	// This member is required.
	StreamingDistributionConfig *StreamingDistributionConfig

	// A complex type that contains zero or more Tag elements.
	//
	// This member is required.
	Tags *Tags

	noSmithyDocumentSerde
}

// A streaming distribution list.
type StreamingDistributionList struct {

	// A flag that indicates whether more streaming distributions remain to be listed.
	// If your results were truncated, you can make a follow-up pagination request
	// using the Marker request parameter to retrieve more distributions in the list.
	//
	// This member is required.
	IsTruncated *bool

	// The value you provided for the Marker request parameter.
	//
	// This member is required.
	Marker *string

	// The value you provided for the MaxItems request parameter.
	//
	// This member is required.
	MaxItems *int32

	// The number of streaming distributions that were created by the current Amazon
	// Web Services account.
	//
	// This member is required.
	Quantity *int32

	// A complex type that contains one StreamingDistributionSummary element for each
	// distribution that was created by the current Amazon Web Services account.
	Items []StreamingDistributionSummary

	// If IsTruncated is true , this element is present and contains the value you can
	// use for the Marker request parameter to continue listing your RTMP
	// distributions where they left off.
	NextMarker *string

	noSmithyDocumentSerde
}

// A summary of the information for a CloudFront streaming distribution.
type StreamingDistributionSummary struct {

	// The ARN (Amazon Resource Name) for the streaming distribution. For example:
	// arn:aws:cloudfront::123456789012:streaming-distribution/EDFDVBD632BHDS5 , where
	// 123456789012 is your Amazon Web Services account ID.
	//
	// This member is required.
	ARN *string

	// A complex type that contains information about CNAMEs (alternate domain names),
	// if any, for this streaming distribution.
	//
	// This member is required.
	Aliases *Aliases

	// The comment originally specified when this distribution was created.
	//
	// This member is required.
	Comment *string

	// The domain name corresponding to the distribution, for example,
	// d111111abcdef8.cloudfront.net .
	//
	// This member is required.
	DomainName *string

	// Whether the distribution is enabled to accept end user requests for content.
	//
	// This member is required.
	Enabled *bool

	// The identifier for the distribution, for example, EDFDVBD632BHDS5 .
	//
	// This member is required.
	Id *string

	// The date and time the distribution was last modified.
	//
	// This member is required.
	LastModifiedTime *time.Time

	// A complex type that contains information about price class for this streaming
	// distribution.
	//
	// This member is required.
	PriceClass PriceClass

	// A complex type that contains information about the Amazon S3 bucket from which
	// you want CloudFront to get your media files for distribution.
	//
	// This member is required.
	S3Origin *S3Origin

	// Indicates the current status of the distribution. When the status is Deployed ,
	// the distribution's information is fully propagated throughout the Amazon
	// CloudFront system.
	//
	// This member is required.
	Status *string

	// A complex type that specifies the Amazon Web Services accounts, if any, that
	// you want to allow to create signed URLs for private content. If you want to
	// require signed URLs in requests for objects in the target origin that match the
	// PathPattern for this cache behavior, specify true for Enabled , and specify the
	// applicable values for Quantity and Items .If you don't want to require signed
	// URLs in requests for objects that match PathPattern , specify false for Enabled
	// and 0 for Quantity . Omit Items . To add, change, or remove one or more trusted
	// signers, change Enabled to true (if it's currently false ), change Quantity as
	// applicable, and specify all of the trusted signers that you want to include in
	// the updated distribution.
	//
	// For more information, see [Serving Private Content through CloudFront] in the Amazon CloudFront Developer Guide.
	//
	// [Serving Private Content through CloudFront]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html
	//
	// This member is required.
	TrustedSigners *TrustedSigners

	noSmithyDocumentSerde
}

// A complex type that controls whether access logs are written for this streaming
// distribution.
type StreamingLoggingConfig struct {

	// The Amazon S3 bucket to store the access logs in, for example,
	// amzn-s3-demo-bucket.s3.amazonaws.com .
	//
	// This member is required.
	Bucket *string

	// Specifies whether you want CloudFront to save access logs to an Amazon S3
	// bucket. If you don't want to enable logging when you create a streaming
	// distribution or if you want to disable logging for an existing streaming
	// distribution, specify false for Enabled , and specify empty Bucket and Prefix
	// elements. If you specify false for Enabled but you specify values for Bucket
	// and Prefix , the values are automatically deleted.
	//
	// This member is required.
	Enabled *bool

	// An optional string that you want CloudFront to prefix to the access log
	// filenames for this streaming distribution, for example, myprefix/ . If you want
	// to enable logging, but you don't want to specify a prefix, you still must
	// include an empty Prefix element in the Logging element.
	//
	// This member is required.
	Prefix *string

	noSmithyDocumentSerde
}

// A complex type that contains Tag key and Tag value.
type Tag struct {

	// A string that contains Tag key.
	//
	// The string length should be between 1 and 128 characters. Valid characters
	// include a-z , A-Z , 0-9 , space, and the special characters _ - . : / = + @ .
	//
	// This member is required.
	Key *string

	// A string that contains an optional Tag value.
	//
	// The string length should be between 0 and 256 characters. Valid characters
	// include a-z , A-Z , 0-9 , space, and the special characters _ - . : / = + @ .
	Value *string

	noSmithyDocumentSerde
}

// A complex type that contains zero or more Tag elements.
type TagKeys struct {

	// A complex type that contains Tag key elements.
	Items []string

	noSmithyDocumentSerde
}

// A complex type that contains zero or more Tag elements.
type Tags struct {

	// A complex type that contains Tag elements.
	Items []Tag

	noSmithyDocumentSerde
}

// Contains the result of testing a CloudFront function with TestFunction .
type TestResult struct {

	// The amount of time that the function took to run as a percentage of the maximum
	// allowed time. For example, a compute utilization of 35 means that the function
	// completed in 35% of the maximum allowed time.
	ComputeUtilization *string

	// If the result of testing the function was an error, this field contains the
	// error message.
	FunctionErrorMessage *string

	// Contains the log lines that the function wrote (if any) when running the test.
	FunctionExecutionLogs []string

	// The event object returned by the function. For more information about the
	// structure of the event object, see [Event object structure]in the Amazon CloudFront Developer Guide.
	//
	// [Event object structure]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/functions-event-structure.html
	FunctionOutput *string

	// Contains configuration information and metadata about the CloudFront function
	// that was tested.
	FunctionSummary *FunctionSummary

	noSmithyDocumentSerde
}

// The traffic configuration of your continuous deployment.
type TrafficConfig struct {

	// The type of traffic configuration.
	//
	// This member is required.
	Type ContinuousDeploymentPolicyType

	// Determines which HTTP requests are sent to the staging distribution.
	SingleHeaderConfig *ContinuousDeploymentSingleHeaderConfig

	// Contains the percentage of traffic to send to the staging distribution.
	SingleWeightConfig *ContinuousDeploymentSingleWeightConfig

	noSmithyDocumentSerde
}

// A list of key groups whose public keys CloudFront can use to verify the
// signatures of signed URLs and signed cookies.
type TrustedKeyGroups struct {

	// This field is true if any of the key groups in the list have public keys that
	// CloudFront can use to verify the signatures of signed URLs and signed cookies.
	// If not, this field is false .
	//
	// This member is required.
	Enabled *bool

	// The number of key groups in the list.
	//
	// This member is required.
	Quantity *int32

	// A list of key groups identifiers.
	Items []string

	noSmithyDocumentSerde
}

// A list of Amazon Web Services accounts whose public keys CloudFront can use to
// verify the signatures of signed URLs and signed cookies.
type TrustedSigners struct {

	// This field is true if any of the Amazon Web Services accounts in the list are
	// configured as trusted signers. If not, this field is false .
	//
	// This member is required.
	Enabled *bool

	// The number of Amazon Web Services accounts in the list.
	//
	// This member is required.
	Quantity *int32

	// A list of Amazon Web Services account identifiers.
	Items []string

	noSmithyDocumentSerde
}

// A complex type that determines the distribution's SSL/TLS configuration for
// communicating with viewers.
//
// If the distribution doesn't use Aliases (also known as alternate domain names
// or CNAMEs)—that is, if the distribution uses the CloudFront domain name such as
// d111111abcdef8.cloudfront.net —set CloudFrontDefaultCertificate to true and
// leave all other fields empty.
//
// If the distribution uses Aliases (alternate domain names or CNAMEs), use the
// fields in this type to specify the following settings:
//
//   - Which viewers the distribution accepts HTTPS connections from: only viewers
//     that support [server name indication (SNI)](recommended), or all viewers including those that don't support
//     SNI.
//
//   - To accept HTTPS connections from only viewers that support SNI, set
//     SSLSupportMethod to sni-only . This is recommended. Most browsers and clients
//     support SNI.
//
//   - To accept HTTPS connections from all viewers, including those that don't
//     support SNI, set SSLSupportMethod to vip . This is not recommended, and
//     results in additional monthly charges from CloudFront.
//
//   - The minimum SSL/TLS protocol version that the distribution can use to
//     communicate with viewers. To specify a minimum version, choose a value for
//     MinimumProtocolVersion . For more information, see [Security Policy]in the Amazon CloudFront
//     Developer Guide.
//
//   - The location of the SSL/TLS certificate, [Certificate Manager (ACM)](recommended) or [Identity and Access Management (IAM)]. You specify the
//     location by setting a value in one of the following fields (not both):
//
//   - ACMCertificateArn
//
//   - IAMCertificateId
//
// All distributions support HTTPS connections from viewers. To require viewers to
// use HTTPS only, or to redirect them from HTTP to HTTPS, use ViewerProtocolPolicy
// in the CacheBehavior or DefaultCacheBehavior . To specify how CloudFront should
// use SSL/TLS to communicate with your custom origin, use CustomOriginConfig .
//
// For more information, see [Using HTTPS with CloudFront] and [Using Alternate Domain Names and HTTPS] in the Amazon CloudFront Developer Guide.
//
// [Using HTTPS with CloudFront]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https.html
// [Security Policy]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValues-security-policy
// [Certificate Manager (ACM)]: https://docs.aws.amazon.com/acm/latest/userguide/acm-overview.html
// [Using Alternate Domain Names and HTTPS]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https-alternate-domain-names.html
// [server name indication (SNI)]: https://en.wikipedia.org/wiki/Server_Name_Indication
// [Identity and Access Management (IAM)]: https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html
type ViewerCertificate struct {

	// If the distribution uses Aliases (alternate domain names or CNAMEs) and the
	// SSL/TLS certificate is stored in [Certificate Manager (ACM)], provide the Amazon Resource Name (ARN) of
	// the ACM certificate. CloudFront only supports ACM certificates in the US East
	// (N. Virginia) Region ( us-east-1 ).
	//
	// If you specify an ACM certificate ARN, you must also specify values for
	// MinimumProtocolVersion and SSLSupportMethod .
	//
	// [Certificate Manager (ACM)]: https://docs.aws.amazon.com/acm/latest/userguide/acm-overview.html
	ACMCertificateArn *string

	// This field is deprecated. Use one of the following fields instead:
	//
	//   - ACMCertificateArn
	//
	//   - IAMCertificateId
	//
	//   - CloudFrontDefaultCertificate
	//
	// Deprecated: This member has been deprecated.
	Certificate *string

	// This field is deprecated. Use one of the following fields instead:
	//
	//   - ACMCertificateArn
	//
	//   - IAMCertificateId
	//
	//   - CloudFrontDefaultCertificate
	//
	// Deprecated: This member has been deprecated.
	CertificateSource CertificateSource

	// If the distribution uses the CloudFront domain name such as
	// d111111abcdef8.cloudfront.net , set this field to true .
	//
	// If the distribution uses Aliases (alternate domain names or CNAMEs), set this
	// field to false and specify values for the following fields:
	//
	//   - ACMCertificateArn or IAMCertificateId (specify a value for one, not both)
	//
	//   - MinimumProtocolVersion
	//
	//   - SSLSupportMethod
	CloudFrontDefaultCertificate *bool

	// If the distribution uses Aliases (alternate domain names or CNAMEs) and the
	// SSL/TLS certificate is stored in [Identity and Access Management (IAM)], provide the ID of the IAM certificate.
	//
	// If you specify an IAM certificate ID, you must also specify values for
	// MinimumProtocolVersion and SSLSupportMethod .
	//
	// [Identity and Access Management (IAM)]: https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html
	IAMCertificateId *string

	// If the distribution uses Aliases (alternate domain names or CNAMEs), specify
	// the security policy that you want CloudFront to use for HTTPS connections with
	// viewers. The security policy determines two settings:
	//
	//   - The minimum SSL/TLS protocol that CloudFront can use to communicate with
	//   viewers.
	//
	//   - The ciphers that CloudFront can use to encrypt the content that it returns
	//   to viewers.
	//
	// For more information, see [Security Policy] and [Supported Protocols and Ciphers Between Viewers and CloudFront] in the Amazon CloudFront Developer Guide.
	//
	// On the CloudFront console, this setting is called Security Policy.
	//
	// When you're using SNI only (you set SSLSupportMethod to sni-only ), you must
	// specify TLSv1 or higher.
	//
	// If the distribution uses the CloudFront domain name such as
	// d111111abcdef8.cloudfront.net (you set CloudFrontDefaultCertificate to true ),
	// CloudFront automatically sets the security policy to TLSv1 regardless of the
	// value that you set here.
	//
	// [Security Policy]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValues-security-policy
	// [Supported Protocols and Ciphers Between Viewers and CloudFront]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/secure-connections-supported-viewer-protocols-ciphers.html#secure-connections-supported-ciphers
	MinimumProtocolVersion MinimumProtocolVersion

	// If the distribution uses Aliases (alternate domain names or CNAMEs), specify
	// which viewers the distribution accepts HTTPS connections from.
	//
	//   - sni-only – The distribution accepts HTTPS connections from only viewers that
	//   support [server name indication (SNI)]. This is recommended. Most browsers and clients support SNI.
	//
	//   - vip – The distribution accepts HTTPS connections from all viewers including
	//   those that don't support SNI. This is not recommended, and results in additional
	//   monthly charges from CloudFront.
	//
	//   - static-ip - Do not specify this value unless your distribution has been
	//   enabled for this feature by the CloudFront team. If you have a use case that
	//   requires static IP addresses for a distribution, contact CloudFront through the [Amazon Web Services Support Center]
	//   .
	//
	// If the distribution uses the CloudFront domain name such as
	// d111111abcdef8.cloudfront.net , don't set a value for this field.
	//
	// [server name indication (SNI)]: https://en.wikipedia.org/wiki/Server_Name_Indication
	// [Amazon Web Services Support Center]: https://console.aws.amazon.com/support/home
	SSLSupportMethod SSLSupportMethod

	noSmithyDocumentSerde
}

// An Amazon CloudFront VPC origin.
type VpcOrigin struct {

	// The VPC origin ARN.
	//
	// This member is required.
	Arn *string

	// The VPC origin created time.
	//
	// This member is required.
	CreatedTime *time.Time

	// The VPC origin ID.
	//
	// This member is required.
	Id *string

	// The VPC origin last modified time.
	//
	// This member is required.
	LastModifiedTime *time.Time

	// The VPC origin status.
	//
	// This member is required.
	Status *string

	// The VPC origin endpoint configuration.
	//
	// This member is required.
	VpcOriginEndpointConfig *VpcOriginEndpointConfig

	noSmithyDocumentSerde
}

// An Amazon CloudFront VPC origin configuration.
type VpcOriginConfig struct {

	// The VPC origin ID.
	//
	// This member is required.
	VpcOriginId *string

	// Specifies how long, in seconds, CloudFront persists its connection to the
	// origin. The minimum timeout is 1 second, the maximum is 60 seconds, and the
	// default (if you don't specify otherwise) is 5 seconds.
	//
	// For more information, see [Keep-alive timeout (custom origins only)] in the Amazon CloudFront Developer Guide.
	//
	// [Keep-alive timeout (custom origins only)]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginKeepaliveTimeout
	OriginKeepaliveTimeout *int32

	// Specifies how long, in seconds, CloudFront waits for a response from the
	// origin. This is also known as the origin response timeout. The minimum timeout
	// is 1 second, the maximum is 60 seconds, and the default (if you don't specify
	// otherwise) is 30 seconds.
	//
	// For more information, see [Response timeout (custom origins only)] in the Amazon CloudFront Developer Guide.
	//
	// [Response timeout (custom origins only)]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginResponseTimeout
	OriginReadTimeout *int32

	noSmithyDocumentSerde
}

// An Amazon CloudFront VPC origin endpoint configuration.
type VpcOriginEndpointConfig struct {

	// The ARN of the CloudFront VPC origin endpoint configuration.
	//
	// This member is required.
	Arn *string

	// The HTTP port for the CloudFront VPC origin endpoint configuration. The default
	// value is 80 .
	//
	// This member is required.
	HTTPPort *int32

	// The HTTPS port of the CloudFront VPC origin endpoint configuration. The default
	// value is 443 .
	//
	// This member is required.
	HTTPSPort *int32

	// The name of the CloudFront VPC origin endpoint configuration.
	//
	// This member is required.
	Name *string

	// The origin protocol policy for the CloudFront VPC origin endpoint configuration.
	//
	// This member is required.
	OriginProtocolPolicy OriginProtocolPolicy

	// A complex type that contains information about the SSL/TLS protocols that
	// CloudFront can use when establishing an HTTPS connection with your origin.
	OriginSslProtocols *OriginSslProtocols

	noSmithyDocumentSerde
}

// A list of CloudFront VPC origins.
type VpcOriginList struct {

	// A flag that indicates whether more VPC origins remain to be listed. If your
	// results were truncated, you can make a follow-up pagination request using the
	// Marker request parameter to retrieve more VPC origins in the list.
	//
	// This member is required.
	IsTruncated *bool

	// The marker associated with the VPC origins list.
	//
	// This member is required.
	Marker *string

	// The maximum number of items included in the list.
	//
	// This member is required.
	MaxItems *int32

	// The number of VPC origins in the list.
	//
	// This member is required.
	Quantity *int32

	// The items of the VPC origins list.
	Items []VpcOriginSummary

	// The next marker associated with the VPC origins list.
	NextMarker *string

	noSmithyDocumentSerde
}

// A summary of the CloudFront VPC origin.
type VpcOriginSummary struct {

	// The VPC origin summary ARN.
	//
	// This member is required.
	Arn *string

	// The VPC origin summary created time.
	//
	// This member is required.
	CreatedTime *time.Time

	// The VPC origin summary ID.
	//
	// This member is required.
	Id *string

	// The VPC origin summary last modified time.
	//
	// This member is required.
	LastModifiedTime *time.Time

	// The VPC origin summary name.
	//
	// This member is required.
	Name *string

	// The VPC origin summary origin endpoint ARN.
	//
	// This member is required.
	OriginEndpointArn *string

	// The VPC origin summary status.
	//
	// This member is required.
	Status *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
