/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import proguard.classfile.Clazz;
import proguard.classfile.visitor.ClassPoolVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.util.ClassNameParser;
import proguard.util.ListParser;
import proguard.util.StringMatcher;

public class ClassPool {
    private final TreeMap<String, Clazz> classes = new TreeMap();
    private final Set<Clazz> clazzSet = new HashSet<Clazz>();

    public ClassPool() {
    }

    public ClassPool(Clazz ... classes) {
        for (Clazz clazz : classes) {
            this.addClass(clazz);
        }
    }

    public ClassPool(Iterable<? extends Clazz> classes) {
        for (Clazz clazz : classes) {
            this.addClass(clazz);
        }
    }

    public ClassPool(ClassPool classPool) {
        this(classPool.classes());
    }

    public void clear() {
        this.classes.clear();
        this.clazzSet.clear();
    }

    public void addClass(Clazz clazz) {
        this.addClass(clazz.getName(), clazz);
    }

    public void addClass(String name, Clazz clazz) {
        this.classes.put(name, clazz);
        this.clazzSet.add(clazz);
    }

    public void removeClass(Clazz clazz) {
        this.removeClass(clazz.getName());
    }

    public Clazz removeClass(String className) {
        this.clazzSet.removeIf(clazz -> clazz.getName().equals(className));
        return this.classes.remove(className);
    }

    public Clazz getClass(String className) {
        return this.classes.get(className);
    }

    public boolean contains(Clazz clazz) {
        return this.clazzSet.contains(clazz);
    }

    public Iterator<String> classNames() {
        return this.classes.keySet().iterator();
    }

    public Iterable<Clazz> classes() {
        return this.classes.values();
    }

    public int size() {
        return this.classes.size();
    }

    public ClassPool refreshedCopy() {
        return new ClassPool(this);
    }

    public <T> Map<String, T> refreshedKeysCopy(Map<String, T> map) {
        HashMap<String, T> refreshedMap = new HashMap<String, T>(map.size());
        for (Map.Entry<String, T> entry : map.entrySet()) {
            String className = entry.getKey();
            Clazz clazz = this.classes.get(className);
            if (clazz == null) continue;
            refreshedMap.put(clazz.getName(), entry.getValue());
        }
        return refreshedMap;
    }

    public <T> Map<T, String> refreshedValuesCopy(Map<T, String> map) {
        HashMap<T, String> refreshedMap = new HashMap<T, String>(map.size());
        for (Map.Entry<T, String> entry : map.entrySet()) {
            String className = entry.getValue();
            Clazz clazz = this.classes.get(className);
            if (clazz == null) continue;
            refreshedMap.put(entry.getKey(), clazz.getName());
        }
        return refreshedMap;
    }

    public Map<Clazz, String> reverseMapping() {
        HashMap<Clazz, String> reversedMap = new HashMap<Clazz, String>(this.classes.size());
        for (String originalClassName : this.classes.keySet()) {
            Clazz processedClazz = this.classes.get(originalClassName);
            reversedMap.put(processedClazz, originalClassName);
        }
        return reversedMap;
    }

    public void accept(ClassPoolVisitor classPoolVisitor) {
        classPoolVisitor.visitClassPool(this);
    }

    public void classesAccept(ClassVisitor classVisitor) {
        for (Clazz clazz : this.classes.values()) {
            clazz.accept(classVisitor);
        }
    }

    public void classesAcceptAlphabetically(ClassVisitor classVisitor) {
        for (Clazz clazz : this.classes.values()) {
            clazz.accept(classVisitor);
        }
    }

    public void classesAccept(String classNameFilter, ClassVisitor classVisitor) {
        this.classesAccept(new ListParser(new ClassNameParser()).parse(classNameFilter), classVisitor);
    }

    public void classesAccept(List classNameFilter, ClassVisitor classVisitor) {
        this.classesAccept(new ListParser(new ClassNameParser()).parse(classNameFilter), classVisitor);
    }

    public void classesAccept(StringMatcher classNameFilter, ClassVisitor classVisitor) {
        String prefix = classNameFilter.prefix();
        if ("".equals(prefix)) {
            for (Map.Entry<String, Clazz> entry : this.classes.entrySet()) {
                String className = entry.getKey();
                if (!classNameFilter.matches(className)) continue;
                Clazz clazz = entry.getValue();
                clazz.accept(classVisitor);
            }
        } else {
            Map.Entry<String, Clazz> classEntry = this.classes.ceilingEntry(prefix);
            while (classEntry != null && classEntry.getKey().startsWith(prefix)) {
                if (classNameFilter.matches(classEntry.getKey())) {
                    classEntry.getValue().accept(classVisitor);
                }
                classEntry = this.classes.higherEntry(classEntry.getKey());
            }
        }
    }

    public void classAccept(String className, ClassVisitor classVisitor) {
        Clazz clazz = this.getClass(className);
        if (clazz != null) {
            clazz.accept(classVisitor);
        }
    }
}

