/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.jvm.util;

import java.util.Arrays;
import proguard.analysis.cpa.bam.ReduceOperator;
import proguard.analysis.cpa.defaults.BamCpaRun;
import proguard.analysis.cpa.defaults.LatticeAbstractState;
import proguard.analysis.cpa.defaults.NeverAbortOperator;
import proguard.analysis.cpa.defaults.ProgramLocationDependentReachedSet;
import proguard.analysis.cpa.interfaces.AbortOperator;
import proguard.analysis.cpa.interfaces.AbstractState;
import proguard.analysis.cpa.interfaces.ConfigurableProgramAnalysis;
import proguard.analysis.cpa.interfaces.ReachedSet;
import proguard.analysis.cpa.jvm.cfa.JvmCfa;
import proguard.analysis.cpa.jvm.cfa.edges.JvmCfaEdge;
import proguard.analysis.cpa.jvm.cfa.nodes.JvmCfaNode;
import proguard.analysis.cpa.jvm.domain.reference.JvmCompositeHeapReduceOperator;
import proguard.analysis.cpa.jvm.domain.reference.JvmReferenceReduceOperator;
import proguard.analysis.cpa.jvm.operators.JvmDefaultReduceOperator;
import proguard.analysis.cpa.jvm.state.heap.HeapModel;
import proguard.classfile.MethodSignature;

public abstract class JvmBamCpaRun<CpaT extends ConfigurableProgramAnalysis, AbstractStateT extends LatticeAbstractState<AbstractStateT>, OuterAbstractStateT extends AbstractState>
extends BamCpaRun<CpaT, OuterAbstractStateT, JvmCfaNode, JvmCfaEdge, MethodSignature> {
    protected JvmCfa cfa;
    public final HeapModel heapModel;

    protected JvmBamCpaRun(JvmCfa cfa, int maxCallStackDepth) {
        this(cfa, maxCallStackDepth, HeapModel.FORGETFUL, NeverAbortOperator.INSTANCE);
    }

    protected JvmBamCpaRun(JvmCfa cfa, int maxCallStackDepth, HeapModel heapModel, AbortOperator abortOperator) {
        super(abortOperator, maxCallStackDepth);
        this.cfa = cfa;
        this.heapModel = heapModel;
    }

    public JvmCfa getCfa() {
        return this.cfa;
    }

    @Override
    public ReduceOperator<JvmCfaNode, JvmCfaEdge, MethodSignature> createReduceOperator() {
        switch (this.heapModel) {
            case FORGETFUL: {
                return new JvmDefaultReduceOperator();
            }
            case TREE: {
                return new JvmCompositeHeapReduceOperator(Arrays.asList(new JvmReferenceReduceOperator(), new JvmDefaultReduceOperator()));
            }
        }
        throw new IllegalArgumentException("Heap model " + this.heapModel.name() + " is not supported by " + this.getClass().getName());
    }

    @Override
    protected ReachedSet createReachedSet() {
        return new ProgramLocationDependentReachedSet();
    }
}

