// Code generated by cmd/lexgen (see Makefile's lexgen); DO NOT EDIT.

package bsky

// schema: app.bsky.unspecced.searchActorsSkeleton

import (
	"context"

	"github.com/bluesky-social/indigo/xrpc"
)

// UnspeccedSearchActorsSkeleton_Output is the output of a app.bsky.unspecced.searchActorsSkeleton call.
type UnspeccedSearchActorsSkeleton_Output struct {
	Actors []*UnspeccedDefs_SkeletonSearchActor `json:"actors" cborgen:"actors"`
	Cursor *string                              `json:"cursor,omitempty" cborgen:"cursor,omitempty"`
	// hitsTotal: Count of search hits. Optional, may be rounded/truncated, and may not be possible to paginate through all hits.
	HitsTotal *int64 `json:"hitsTotal,omitempty" cborgen:"hitsTotal,omitempty"`
}

// UnspeccedSearchActorsSkeleton calls the XRPC method "app.bsky.unspecced.searchActorsSkeleton".
//
// cursor: Optional pagination mechanism; may not necessarily allow scrolling through entire result set.
// q: Search query string; syntax, phrase, boolean, and faceting is unspecified, but Lucene query syntax is recommended. For typeahead search, only simple term match is supported, not full syntax.
// typeahead: If true, acts as fast/simple 'typeahead' query.
// viewer: DID of the account making the request (not included for public/unauthenticated queries). Used to boost followed accounts in ranking.
func UnspeccedSearchActorsSkeleton(ctx context.Context, c *xrpc.Client, cursor string, limit int64, q string, typeahead bool, viewer string) (*UnspeccedSearchActorsSkeleton_Output, error) {
	var out UnspeccedSearchActorsSkeleton_Output

	params := map[string]interface{}{
		"cursor":    cursor,
		"limit":     limit,
		"q":         q,
		"typeahead": typeahead,
		"viewer":    viewer,
	}
	if err := c.Do(ctx, xrpc.Query, "", "app.bsky.unspecced.searchActorsSkeleton", params, nil, &out); err != nil {
		return nil, err
	}

	return &out, nil
}
