// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package chimesdkmeetings

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opBatchCreateAttendee = "BatchCreateAttendee"

// BatchCreateAttendeeRequest generates a "aws/request.Request" representing the
// client's request for the BatchCreateAttendee operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchCreateAttendee for more information on using the BatchCreateAttendee
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchCreateAttendeeRequest method.
//	req, resp := client.BatchCreateAttendeeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-meetings-2021-07-15/BatchCreateAttendee
func (c *ChimeSDKMeetings) BatchCreateAttendeeRequest(input *BatchCreateAttendeeInput) (req *request.Request, output *BatchCreateAttendeeOutput) {
	op := &request.Operation{
		Name:       opBatchCreateAttendee,
		HTTPMethod: "POST",
		HTTPPath:   "/meetings/{MeetingId}/attendees?operation=batch-create",
	}

	if input == nil {
		input = &BatchCreateAttendeeInput{}
	}

	output = &BatchCreateAttendeeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchCreateAttendee API operation for Amazon Chime SDK Meetings.
//
// Creates up to 100 attendees for an active Amazon Chime SDK meeting. For more
// information about the Amazon Chime SDK, see Using the Amazon Chime SDK (https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html)
// in the Amazon Chime Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Meetings's
// API operation BatchCreateAttendee for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - UnauthorizedException
//     The user isn't authorized to request a resource.
//
//   - UnprocessableEntityException
//     The request was well-formed but was unable to be followed due to semantic
//     errors.
//
//   - LimitExceededException
//     The request exceeds the resource limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
//   - ThrottlingException
//     The number of customer requests exceeds the request rate limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-meetings-2021-07-15/BatchCreateAttendee
func (c *ChimeSDKMeetings) BatchCreateAttendee(input *BatchCreateAttendeeInput) (*BatchCreateAttendeeOutput, error) {
	req, out := c.BatchCreateAttendeeRequest(input)
	return out, req.Send()
}

// BatchCreateAttendeeWithContext is the same as BatchCreateAttendee with the addition of
// the ability to pass a context and additional request options.
//
// See BatchCreateAttendee for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMeetings) BatchCreateAttendeeWithContext(ctx aws.Context, input *BatchCreateAttendeeInput, opts ...request.Option) (*BatchCreateAttendeeOutput, error) {
	req, out := c.BatchCreateAttendeeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchUpdateAttendeeCapabilitiesExcept = "BatchUpdateAttendeeCapabilitiesExcept"

// BatchUpdateAttendeeCapabilitiesExceptRequest generates a "aws/request.Request" representing the
// client's request for the BatchUpdateAttendeeCapabilitiesExcept operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchUpdateAttendeeCapabilitiesExcept for more information on using the BatchUpdateAttendeeCapabilitiesExcept
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchUpdateAttendeeCapabilitiesExceptRequest method.
//	req, resp := client.BatchUpdateAttendeeCapabilitiesExceptRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-meetings-2021-07-15/BatchUpdateAttendeeCapabilitiesExcept
func (c *ChimeSDKMeetings) BatchUpdateAttendeeCapabilitiesExceptRequest(input *BatchUpdateAttendeeCapabilitiesExceptInput) (req *request.Request, output *BatchUpdateAttendeeCapabilitiesExceptOutput) {
	op := &request.Operation{
		Name:       opBatchUpdateAttendeeCapabilitiesExcept,
		HTTPMethod: "PUT",
		HTTPPath:   "/meetings/{MeetingId}/attendees/capabilities?operation=batch-update-except",
	}

	if input == nil {
		input = &BatchUpdateAttendeeCapabilitiesExceptInput{}
	}

	output = &BatchUpdateAttendeeCapabilitiesExceptOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// BatchUpdateAttendeeCapabilitiesExcept API operation for Amazon Chime SDK Meetings.
//
// Updates AttendeeCapabilities except the capabilities listed in an ExcludedAttendeeIds
// table.
//
// You use the capabilities with a set of values that control what the capabilities
// can do, such as SendReceive data. For more information about those values,
// see .
//
// When using capabilities, be aware of these corner cases:
//
//   - If you specify MeetingFeatures:Video:MaxResolution:None when you create
//     a meeting, all API requests that include SendReceive, Send, or Receive
//     for AttendeeCapabilities:Video will be rejected with ValidationError 400.
//
//   - If you specify MeetingFeatures:Content:MaxResolution:None when you create
//     a meeting, all API requests that include SendReceive, Send, or Receive
//     for AttendeeCapabilities:Content will be rejected with ValidationError
//     400.
//
//   - You can't set content capabilities to SendReceive or Receive unless
//     you also set video capabilities to SendReceive or Receive. If you don't
//     set the video capability to receive, the response will contain an HTTP
//     400 Bad Request status code. However, you can set your video capability
//     to receive and you set your content capability to not receive.
//
//   - When you change an audio capability from None or Receive to Send or
//     SendReceive , and if the attendee left their microphone unmuted, audio
//     will flow from the attendee to the other meeting participants.
//
//   - When you change a video or content capability from None or Receive to
//     Send or SendReceive , and if the attendee turned on their video or content
//     streams, remote attendees can receive those streams, but only after media
//     renegotiation between the client and the Amazon Chime back-end server.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Meetings's
// API operation BatchUpdateAttendeeCapabilitiesExcept for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ConflictException
//     Multiple instances of the same request have been made simultaneously.
//
//   - UnauthorizedException
//     The user isn't authorized to request a resource.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
//   - ThrottlingException
//     The number of customer requests exceeds the request rate limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-meetings-2021-07-15/BatchUpdateAttendeeCapabilitiesExcept
func (c *ChimeSDKMeetings) BatchUpdateAttendeeCapabilitiesExcept(input *BatchUpdateAttendeeCapabilitiesExceptInput) (*BatchUpdateAttendeeCapabilitiesExceptOutput, error) {
	req, out := c.BatchUpdateAttendeeCapabilitiesExceptRequest(input)
	return out, req.Send()
}

// BatchUpdateAttendeeCapabilitiesExceptWithContext is the same as BatchUpdateAttendeeCapabilitiesExcept with the addition of
// the ability to pass a context and additional request options.
//
// See BatchUpdateAttendeeCapabilitiesExcept for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMeetings) BatchUpdateAttendeeCapabilitiesExceptWithContext(ctx aws.Context, input *BatchUpdateAttendeeCapabilitiesExceptInput, opts ...request.Option) (*BatchUpdateAttendeeCapabilitiesExceptOutput, error) {
	req, out := c.BatchUpdateAttendeeCapabilitiesExceptRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAttendee = "CreateAttendee"

// CreateAttendeeRequest generates a "aws/request.Request" representing the
// client's request for the CreateAttendee operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAttendee for more information on using the CreateAttendee
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateAttendeeRequest method.
//	req, resp := client.CreateAttendeeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-meetings-2021-07-15/CreateAttendee
func (c *ChimeSDKMeetings) CreateAttendeeRequest(input *CreateAttendeeInput) (req *request.Request, output *CreateAttendeeOutput) {
	op := &request.Operation{
		Name:       opCreateAttendee,
		HTTPMethod: "POST",
		HTTPPath:   "/meetings/{MeetingId}/attendees",
	}

	if input == nil {
		input = &CreateAttendeeInput{}
	}

	output = &CreateAttendeeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAttendee API operation for Amazon Chime SDK Meetings.
//
// Creates a new attendee for an active Amazon Chime SDK meeting. For more information
// about the Amazon Chime SDK, see Using the Amazon Chime SDK (https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html)
// in the Amazon Chime Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Meetings's
// API operation CreateAttendee for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - UnauthorizedException
//     The user isn't authorized to request a resource.
//
//   - UnprocessableEntityException
//     The request was well-formed but was unable to be followed due to semantic
//     errors.
//
//   - LimitExceededException
//     The request exceeds the resource limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
//   - ThrottlingException
//     The number of customer requests exceeds the request rate limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-meetings-2021-07-15/CreateAttendee
func (c *ChimeSDKMeetings) CreateAttendee(input *CreateAttendeeInput) (*CreateAttendeeOutput, error) {
	req, out := c.CreateAttendeeRequest(input)
	return out, req.Send()
}

// CreateAttendeeWithContext is the same as CreateAttendee with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAttendee for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMeetings) CreateAttendeeWithContext(ctx aws.Context, input *CreateAttendeeInput, opts ...request.Option) (*CreateAttendeeOutput, error) {
	req, out := c.CreateAttendeeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateMeeting = "CreateMeeting"

// CreateMeetingRequest generates a "aws/request.Request" representing the
// client's request for the CreateMeeting operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateMeeting for more information on using the CreateMeeting
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateMeetingRequest method.
//	req, resp := client.CreateMeetingRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-meetings-2021-07-15/CreateMeeting
func (c *ChimeSDKMeetings) CreateMeetingRequest(input *CreateMeetingInput) (req *request.Request, output *CreateMeetingOutput) {
	op := &request.Operation{
		Name:       opCreateMeeting,
		HTTPMethod: "POST",
		HTTPPath:   "/meetings",
	}

	if input == nil {
		input = &CreateMeetingInput{}
	}

	output = &CreateMeetingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateMeeting API operation for Amazon Chime SDK Meetings.
//
// Creates a new Amazon Chime SDK meeting in the specified media Region with
// no initial attendees. For more information about specifying media Regions,
// see Amazon Chime SDK Media Regions (https://docs.aws.amazon.com/chime/latest/dg/chime-sdk-meetings-regions.html)
// in the Amazon Chime Developer Guide. For more information about the Amazon
// Chime SDK, see Using the Amazon Chime SDK (https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html)
// in the Amazon Chime Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Meetings's
// API operation CreateMeeting for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ConflictException
//     Multiple instances of the same request have been made simultaneously.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedException
//     The user isn't authorized to request a resource.
//
//   - ThrottlingException
//     The number of customer requests exceeds the request rate limit.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - LimitExceededException
//     The request exceeds the resource limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-meetings-2021-07-15/CreateMeeting
func (c *ChimeSDKMeetings) CreateMeeting(input *CreateMeetingInput) (*CreateMeetingOutput, error) {
	req, out := c.CreateMeetingRequest(input)
	return out, req.Send()
}

// CreateMeetingWithContext is the same as CreateMeeting with the addition of
// the ability to pass a context and additional request options.
//
// See CreateMeeting for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMeetings) CreateMeetingWithContext(ctx aws.Context, input *CreateMeetingInput, opts ...request.Option) (*CreateMeetingOutput, error) {
	req, out := c.CreateMeetingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateMeetingWithAttendees = "CreateMeetingWithAttendees"

// CreateMeetingWithAttendeesRequest generates a "aws/request.Request" representing the
// client's request for the CreateMeetingWithAttendees operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateMeetingWithAttendees for more information on using the CreateMeetingWithAttendees
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateMeetingWithAttendeesRequest method.
//	req, resp := client.CreateMeetingWithAttendeesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-meetings-2021-07-15/CreateMeetingWithAttendees
func (c *ChimeSDKMeetings) CreateMeetingWithAttendeesRequest(input *CreateMeetingWithAttendeesInput) (req *request.Request, output *CreateMeetingWithAttendeesOutput) {
	op := &request.Operation{
		Name:       opCreateMeetingWithAttendees,
		HTTPMethod: "POST",
		HTTPPath:   "/meetings?operation=create-attendees",
	}

	if input == nil {
		input = &CreateMeetingWithAttendeesInput{}
	}

	output = &CreateMeetingWithAttendeesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateMeetingWithAttendees API operation for Amazon Chime SDK Meetings.
//
// Creates a new Amazon Chime SDK meeting in the specified media Region, with
// attendees. For more information about specifying media Regions, see Amazon
// Chime SDK Media Regions (https://docs.aws.amazon.com/chime/latest/dg/chime-sdk-meetings-regions.html)
// in the Amazon Chime Developer Guide. For more information about the Amazon
// Chime SDK, see Using the Amazon Chime SDK (https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html)
// in the Amazon Chime Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Meetings's
// API operation CreateMeetingWithAttendees for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ConflictException
//     Multiple instances of the same request have been made simultaneously.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedException
//     The user isn't authorized to request a resource.
//
//   - ThrottlingException
//     The number of customer requests exceeds the request rate limit.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - LimitExceededException
//     The request exceeds the resource limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-meetings-2021-07-15/CreateMeetingWithAttendees
func (c *ChimeSDKMeetings) CreateMeetingWithAttendees(input *CreateMeetingWithAttendeesInput) (*CreateMeetingWithAttendeesOutput, error) {
	req, out := c.CreateMeetingWithAttendeesRequest(input)
	return out, req.Send()
}

// CreateMeetingWithAttendeesWithContext is the same as CreateMeetingWithAttendees with the addition of
// the ability to pass a context and additional request options.
//
// See CreateMeetingWithAttendees for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMeetings) CreateMeetingWithAttendeesWithContext(ctx aws.Context, input *CreateMeetingWithAttendeesInput, opts ...request.Option) (*CreateMeetingWithAttendeesOutput, error) {
	req, out := c.CreateMeetingWithAttendeesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAttendee = "DeleteAttendee"

// DeleteAttendeeRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAttendee operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAttendee for more information on using the DeleteAttendee
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAttendeeRequest method.
//	req, resp := client.DeleteAttendeeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-meetings-2021-07-15/DeleteAttendee
func (c *ChimeSDKMeetings) DeleteAttendeeRequest(input *DeleteAttendeeInput) (req *request.Request, output *DeleteAttendeeOutput) {
	op := &request.Operation{
		Name:       opDeleteAttendee,
		HTTPMethod: "DELETE",
		HTTPPath:   "/meetings/{MeetingId}/attendees/{AttendeeId}",
	}

	if input == nil {
		input = &DeleteAttendeeInput{}
	}

	output = &DeleteAttendeeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAttendee API operation for Amazon Chime SDK Meetings.
//
// Deletes an attendee from the specified Amazon Chime SDK meeting and deletes
// their JoinToken. Attendees are automatically deleted when a Amazon Chime
// SDK meeting is deleted. For more information about the Amazon Chime SDK,
// see Using the Amazon Chime SDK (https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html)
// in the Amazon Chime Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Meetings's
// API operation DeleteAttendee for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - UnauthorizedException
//     The user isn't authorized to request a resource.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
//   - ThrottlingException
//     The number of customer requests exceeds the request rate limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-meetings-2021-07-15/DeleteAttendee
func (c *ChimeSDKMeetings) DeleteAttendee(input *DeleteAttendeeInput) (*DeleteAttendeeOutput, error) {
	req, out := c.DeleteAttendeeRequest(input)
	return out, req.Send()
}

// DeleteAttendeeWithContext is the same as DeleteAttendee with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAttendee for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMeetings) DeleteAttendeeWithContext(ctx aws.Context, input *DeleteAttendeeInput, opts ...request.Option) (*DeleteAttendeeOutput, error) {
	req, out := c.DeleteAttendeeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteMeeting = "DeleteMeeting"

// DeleteMeetingRequest generates a "aws/request.Request" representing the
// client's request for the DeleteMeeting operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteMeeting for more information on using the DeleteMeeting
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteMeetingRequest method.
//	req, resp := client.DeleteMeetingRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-meetings-2021-07-15/DeleteMeeting
func (c *ChimeSDKMeetings) DeleteMeetingRequest(input *DeleteMeetingInput) (req *request.Request, output *DeleteMeetingOutput) {
	op := &request.Operation{
		Name:       opDeleteMeeting,
		HTTPMethod: "DELETE",
		HTTPPath:   "/meetings/{MeetingId}",
	}

	if input == nil {
		input = &DeleteMeetingInput{}
	}

	output = &DeleteMeetingOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteMeeting API operation for Amazon Chime SDK Meetings.
//
// Deletes the specified Amazon Chime SDK meeting. The operation deletes all
// attendees, disconnects all clients, and prevents new clients from joining
// the meeting. For more information about the Amazon Chime SDK, see Using the
// Amazon Chime SDK (https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html)
// in the Amazon Chime Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Meetings's
// API operation DeleteMeeting for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedException
//     The user isn't authorized to request a resource.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
//   - ThrottlingException
//     The number of customer requests exceeds the request rate limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-meetings-2021-07-15/DeleteMeeting
func (c *ChimeSDKMeetings) DeleteMeeting(input *DeleteMeetingInput) (*DeleteMeetingOutput, error) {
	req, out := c.DeleteMeetingRequest(input)
	return out, req.Send()
}

// DeleteMeetingWithContext is the same as DeleteMeeting with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMeeting for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMeetings) DeleteMeetingWithContext(ctx aws.Context, input *DeleteMeetingInput, opts ...request.Option) (*DeleteMeetingOutput, error) {
	req, out := c.DeleteMeetingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAttendee = "GetAttendee"

// GetAttendeeRequest generates a "aws/request.Request" representing the
// client's request for the GetAttendee operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAttendee for more information on using the GetAttendee
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAttendeeRequest method.
//	req, resp := client.GetAttendeeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-meetings-2021-07-15/GetAttendee
func (c *ChimeSDKMeetings) GetAttendeeRequest(input *GetAttendeeInput) (req *request.Request, output *GetAttendeeOutput) {
	op := &request.Operation{
		Name:       opGetAttendee,
		HTTPMethod: "GET",
		HTTPPath:   "/meetings/{MeetingId}/attendees/{AttendeeId}",
	}

	if input == nil {
		input = &GetAttendeeInput{}
	}

	output = &GetAttendeeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAttendee API operation for Amazon Chime SDK Meetings.
//
// Gets the Amazon Chime SDK attendee details for a specified meeting ID and
// attendee ID. For more information about the Amazon Chime SDK, see Using the
// Amazon Chime SDK (https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html)
// in the Amazon Chime Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Meetings's
// API operation GetAttendee for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - UnauthorizedException
//     The user isn't authorized to request a resource.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
//   - ThrottlingException
//     The number of customer requests exceeds the request rate limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-meetings-2021-07-15/GetAttendee
func (c *ChimeSDKMeetings) GetAttendee(input *GetAttendeeInput) (*GetAttendeeOutput, error) {
	req, out := c.GetAttendeeRequest(input)
	return out, req.Send()
}

// GetAttendeeWithContext is the same as GetAttendee with the addition of
// the ability to pass a context and additional request options.
//
// See GetAttendee for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMeetings) GetAttendeeWithContext(ctx aws.Context, input *GetAttendeeInput, opts ...request.Option) (*GetAttendeeOutput, error) {
	req, out := c.GetAttendeeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMeeting = "GetMeeting"

// GetMeetingRequest generates a "aws/request.Request" representing the
// client's request for the GetMeeting operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMeeting for more information on using the GetMeeting
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetMeetingRequest method.
//	req, resp := client.GetMeetingRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-meetings-2021-07-15/GetMeeting
func (c *ChimeSDKMeetings) GetMeetingRequest(input *GetMeetingInput) (req *request.Request, output *GetMeetingOutput) {
	op := &request.Operation{
		Name:       opGetMeeting,
		HTTPMethod: "GET",
		HTTPPath:   "/meetings/{MeetingId}",
	}

	if input == nil {
		input = &GetMeetingInput{}
	}

	output = &GetMeetingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMeeting API operation for Amazon Chime SDK Meetings.
//
// Gets the Amazon Chime SDK meeting details for the specified meeting ID. For
// more information about the Amazon Chime SDK, see Using the Amazon Chime SDK
// (https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html) in the Amazon
// Chime Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Meetings's
// API operation GetMeeting for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedException
//     The user isn't authorized to request a resource.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
//   - ThrottlingException
//     The number of customer requests exceeds the request rate limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-meetings-2021-07-15/GetMeeting
func (c *ChimeSDKMeetings) GetMeeting(input *GetMeetingInput) (*GetMeetingOutput, error) {
	req, out := c.GetMeetingRequest(input)
	return out, req.Send()
}

// GetMeetingWithContext is the same as GetMeeting with the addition of
// the ability to pass a context and additional request options.
//
// See GetMeeting for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMeetings) GetMeetingWithContext(ctx aws.Context, input *GetMeetingInput, opts ...request.Option) (*GetMeetingOutput, error) {
	req, out := c.GetMeetingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAttendees = "ListAttendees"

// ListAttendeesRequest generates a "aws/request.Request" representing the
// client's request for the ListAttendees operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAttendees for more information on using the ListAttendees
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAttendeesRequest method.
//	req, resp := client.ListAttendeesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-meetings-2021-07-15/ListAttendees
func (c *ChimeSDKMeetings) ListAttendeesRequest(input *ListAttendeesInput) (req *request.Request, output *ListAttendeesOutput) {
	op := &request.Operation{
		Name:       opListAttendees,
		HTTPMethod: "GET",
		HTTPPath:   "/meetings/{MeetingId}/attendees",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAttendeesInput{}
	}

	output = &ListAttendeesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAttendees API operation for Amazon Chime SDK Meetings.
//
// Lists the attendees for the specified Amazon Chime SDK meeting. For more
// information about the Amazon Chime SDK, see Using the Amazon Chime SDK (https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html)
// in the Amazon Chime Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Meetings's
// API operation ListAttendees for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - UnauthorizedException
//     The user isn't authorized to request a resource.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
//   - ThrottlingException
//     The number of customer requests exceeds the request rate limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-meetings-2021-07-15/ListAttendees
func (c *ChimeSDKMeetings) ListAttendees(input *ListAttendeesInput) (*ListAttendeesOutput, error) {
	req, out := c.ListAttendeesRequest(input)
	return out, req.Send()
}

// ListAttendeesWithContext is the same as ListAttendees with the addition of
// the ability to pass a context and additional request options.
//
// See ListAttendees for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMeetings) ListAttendeesWithContext(ctx aws.Context, input *ListAttendeesInput, opts ...request.Option) (*ListAttendeesOutput, error) {
	req, out := c.ListAttendeesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAttendeesPages iterates over the pages of a ListAttendees operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAttendees method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAttendees operation.
//	pageNum := 0
//	err := client.ListAttendeesPages(params,
//	    func(page *chimesdkmeetings.ListAttendeesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ChimeSDKMeetings) ListAttendeesPages(input *ListAttendeesInput, fn func(*ListAttendeesOutput, bool) bool) error {
	return c.ListAttendeesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAttendeesPagesWithContext same as ListAttendeesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMeetings) ListAttendeesPagesWithContext(ctx aws.Context, input *ListAttendeesInput, fn func(*ListAttendeesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAttendeesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAttendeesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAttendeesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-meetings-2021-07-15/ListTagsForResource
func (c *ChimeSDKMeetings) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Chime SDK Meetings.
//
// Returns a list of the tags available for the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Meetings's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedException
//     The user isn't authorized to request a resource.
//
//   - LimitExceededException
//     The request exceeds the resource limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
//   - ThrottlingException
//     The number of customer requests exceeds the request rate limit.
//
//   - ResourceNotFoundException
//     The resource that you want to tag couldn't be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-meetings-2021-07-15/ListTagsForResource
func (c *ChimeSDKMeetings) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMeetings) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartMeetingTranscription = "StartMeetingTranscription"

// StartMeetingTranscriptionRequest generates a "aws/request.Request" representing the
// client's request for the StartMeetingTranscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartMeetingTranscription for more information on using the StartMeetingTranscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartMeetingTranscriptionRequest method.
//	req, resp := client.StartMeetingTranscriptionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-meetings-2021-07-15/StartMeetingTranscription
func (c *ChimeSDKMeetings) StartMeetingTranscriptionRequest(input *StartMeetingTranscriptionInput) (req *request.Request, output *StartMeetingTranscriptionOutput) {
	op := &request.Operation{
		Name:       opStartMeetingTranscription,
		HTTPMethod: "POST",
		HTTPPath:   "/meetings/{MeetingId}/transcription?operation=start",
	}

	if input == nil {
		input = &StartMeetingTranscriptionInput{}
	}

	output = &StartMeetingTranscriptionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StartMeetingTranscription API operation for Amazon Chime SDK Meetings.
//
// Starts transcription for the specified meetingId. For more information, refer
// to Using Amazon Chime SDK live transcription (https://docs.aws.amazon.com/chime-sdk/latest/dg/meeting-transcription.html)
// in the Amazon Chime SDK Developer Guide.
//
// If you specify an invalid configuration, a TranscriptFailed event will be
// sent with the contents of the BadRequestException generated by Amazon Transcribe.
// For more information on each parameter and which combinations are valid,
// refer to the StartStreamTranscription (https://docs.aws.amazon.com/transcribe/latest/APIReference/API_streaming_StartStreamTranscription.html)
// API in the Amazon Transcribe Developer Guide.
//
// By default, Amazon Transcribe may use and store audio content processed by
// the service to develop and improve Amazon Web Services AI/ML services as
// further described in section 50 of the Amazon Web Services Service Terms
// (https://aws.amazon.com/service-terms/). Using Amazon Transcribe may be subject
// to federal and state laws or regulations regarding the recording or interception
// of electronic communications. It is your and your end users’ responsibility
// to comply with all applicable laws regarding the recording, including properly
// notifying all participants in a recorded session or communication that the
// session or communication is being recorded, and obtaining all necessary consents.
// You can opt out from Amazon Web Services using audio content to develop and
// improve AWS AI/ML services by configuring an AI services opt out policy using
// Amazon Web Services Organizations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Meetings's
// API operation StartMeetingTranscription for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - UnauthorizedException
//     The user isn't authorized to request a resource.
//
//   - LimitExceededException
//     The request exceeds the resource limit.
//
//   - UnprocessableEntityException
//     The request was well-formed but was unable to be followed due to semantic
//     errors.
//
//   - ThrottlingException
//     The number of customer requests exceeds the request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-meetings-2021-07-15/StartMeetingTranscription
func (c *ChimeSDKMeetings) StartMeetingTranscription(input *StartMeetingTranscriptionInput) (*StartMeetingTranscriptionOutput, error) {
	req, out := c.StartMeetingTranscriptionRequest(input)
	return out, req.Send()
}

// StartMeetingTranscriptionWithContext is the same as StartMeetingTranscription with the addition of
// the ability to pass a context and additional request options.
//
// See StartMeetingTranscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMeetings) StartMeetingTranscriptionWithContext(ctx aws.Context, input *StartMeetingTranscriptionInput, opts ...request.Option) (*StartMeetingTranscriptionOutput, error) {
	req, out := c.StartMeetingTranscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopMeetingTranscription = "StopMeetingTranscription"

// StopMeetingTranscriptionRequest generates a "aws/request.Request" representing the
// client's request for the StopMeetingTranscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopMeetingTranscription for more information on using the StopMeetingTranscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopMeetingTranscriptionRequest method.
//	req, resp := client.StopMeetingTranscriptionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-meetings-2021-07-15/StopMeetingTranscription
func (c *ChimeSDKMeetings) StopMeetingTranscriptionRequest(input *StopMeetingTranscriptionInput) (req *request.Request, output *StopMeetingTranscriptionOutput) {
	op := &request.Operation{
		Name:       opStopMeetingTranscription,
		HTTPMethod: "POST",
		HTTPPath:   "/meetings/{MeetingId}/transcription?operation=stop",
	}

	if input == nil {
		input = &StopMeetingTranscriptionInput{}
	}

	output = &StopMeetingTranscriptionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopMeetingTranscription API operation for Amazon Chime SDK Meetings.
//
// Stops transcription for the specified meetingId. For more information, refer
// to Using Amazon Chime SDK live transcription (https://docs.aws.amazon.com/chime-sdk/latest/dg/meeting-transcription.html)
// in the Amazon Chime SDK Developer Guide.
//
// By default, Amazon Transcribe may use and store audio content processed by
// the service to develop and improve Amazon Web Services AI/ML services as
// further described in section 50 of the Amazon Web Services Service Terms
// (https://aws.amazon.com/service-terms/). Using Amazon Transcribe may be subject
// to federal and state laws or regulations regarding the recording or interception
// of electronic communications. It is your and your end users’ responsibility
// to comply with all applicable laws regarding the recording, including properly
// notifying all participants in a recorded session or communication that the
// session or communication is being recorded, and obtaining all necessary consents.
// You can opt out from Amazon Web Services using audio content to develop and
// improve Amazon Web Services AI/ML services by configuring an AI services
// opt out policy using Amazon Web Services Organizations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Meetings's
// API operation StopMeetingTranscription for usage and error information.
//
// Returned Error Types:
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - UnauthorizedException
//     The user isn't authorized to request a resource.
//
//   - UnprocessableEntityException
//     The request was well-formed but was unable to be followed due to semantic
//     errors.
//
//   - ThrottlingException
//     The number of customer requests exceeds the request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-meetings-2021-07-15/StopMeetingTranscription
func (c *ChimeSDKMeetings) StopMeetingTranscription(input *StopMeetingTranscriptionInput) (*StopMeetingTranscriptionOutput, error) {
	req, out := c.StopMeetingTranscriptionRequest(input)
	return out, req.Send()
}

// StopMeetingTranscriptionWithContext is the same as StopMeetingTranscription with the addition of
// the ability to pass a context and additional request options.
//
// See StopMeetingTranscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMeetings) StopMeetingTranscriptionWithContext(ctx aws.Context, input *StopMeetingTranscriptionInput, opts ...request.Option) (*StopMeetingTranscriptionOutput, error) {
	req, out := c.StopMeetingTranscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-meetings-2021-07-15/TagResource
func (c *ChimeSDKMeetings) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags?operation=tag-resource",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon Chime SDK Meetings.
//
// The resource that supports tags.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Meetings's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedException
//     The user isn't authorized to request a resource.
//
//   - LimitExceededException
//     The request exceeds the resource limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
//   - ThrottlingException
//     The number of customer requests exceeds the request rate limit.
//
//   - ResourceNotFoundException
//     The resource that you want to tag couldn't be found.
//
//   - TooManyTagsException
//     Too many tags were added to the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-meetings-2021-07-15/TagResource
func (c *ChimeSDKMeetings) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMeetings) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-meetings-2021-07-15/UntagResource
func (c *ChimeSDKMeetings) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags?operation=untag-resource",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon Chime SDK Meetings.
//
// Removes the specified tags from the specified resources. When you specify
// a tag key, the action removes both that key and its associated value. The
// operation succeeds even if you attempt to remove tags from a resource that
// were already removed. Note the following:
//
//   - To remove tags from a resource, you need the necessary permissions for
//     the service that the resource belongs to as well as permissions for removing
//     tags. For more information, see the documentation for the service whose
//     resource you want to untag.
//
//   - You can only tag resources that are located in the specified Amazon
//     Web Services Region for the calling Amazon Web Services account.
//
// # Minimum permissions
//
// In addition to the tag:UntagResources permission required by this operation,
// you must also have the remove tags permission defined by the service that
// created the resource. For example, to remove the tags from an Amazon EC2
// instance using the UntagResources operation, you must have both of the following
// permissions:
//
// tag:UntagResource
//
// ChimeSDKMeetings:DeleteTags
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Meetings's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedException
//     The user isn't authorized to request a resource.
//
//   - LimitExceededException
//     The request exceeds the resource limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
//   - ThrottlingException
//     The number of customer requests exceeds the request rate limit.
//
//   - ResourceNotFoundException
//     The resource that you want to tag couldn't be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-meetings-2021-07-15/UntagResource
func (c *ChimeSDKMeetings) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMeetings) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAttendeeCapabilities = "UpdateAttendeeCapabilities"

// UpdateAttendeeCapabilitiesRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAttendeeCapabilities operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAttendeeCapabilities for more information on using the UpdateAttendeeCapabilities
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateAttendeeCapabilitiesRequest method.
//	req, resp := client.UpdateAttendeeCapabilitiesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-meetings-2021-07-15/UpdateAttendeeCapabilities
func (c *ChimeSDKMeetings) UpdateAttendeeCapabilitiesRequest(input *UpdateAttendeeCapabilitiesInput) (req *request.Request, output *UpdateAttendeeCapabilitiesOutput) {
	op := &request.Operation{
		Name:       opUpdateAttendeeCapabilities,
		HTTPMethod: "PUT",
		HTTPPath:   "/meetings/{MeetingId}/attendees/{AttendeeId}/capabilities",
	}

	if input == nil {
		input = &UpdateAttendeeCapabilitiesInput{}
	}

	output = &UpdateAttendeeCapabilitiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAttendeeCapabilities API operation for Amazon Chime SDK Meetings.
//
// The capabilities that you want to update.
//
// You use the capabilities with a set of values that control what the capabilities
// can do, such as SendReceive data. For more information about those values,
// see .
//
// When using capabilities, be aware of these corner cases:
//
//   - If you specify MeetingFeatures:Video:MaxResolution:None when you create
//     a meeting, all API requests that include SendReceive, Send, or Receive
//     for AttendeeCapabilities:Video will be rejected with ValidationError 400.
//
//   - If you specify MeetingFeatures:Content:MaxResolution:None when you create
//     a meeting, all API requests that include SendReceive, Send, or Receive
//     for AttendeeCapabilities:Content will be rejected with ValidationError
//     400.
//
//   - You can't set content capabilities to SendReceive or Receive unless
//     you also set video capabilities to SendReceive or Receive. If you don't
//     set the video capability to receive, the response will contain an HTTP
//     400 Bad Request status code. However, you can set your video capability
//     to receive and you set your content capability to not receive.
//
//   - When you change an audio capability from None or Receive to Send or
//     SendReceive , and if the attendee left their microphone unmuted, audio
//     will flow from the attendee to the other meeting participants.
//
//   - When you change a video or content capability from None or Receive to
//     Send or SendReceive , and if the attendee turned on their video or content
//     streams, remote attendees can receive those streams, but only after media
//     renegotiation between the client and the Amazon Chime back-end server.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Meetings's
// API operation UpdateAttendeeCapabilities for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ConflictException
//     Multiple instances of the same request have been made simultaneously.
//
//   - UnauthorizedException
//     The user isn't authorized to request a resource.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
//   - ThrottlingException
//     The number of customer requests exceeds the request rate limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-meetings-2021-07-15/UpdateAttendeeCapabilities
func (c *ChimeSDKMeetings) UpdateAttendeeCapabilities(input *UpdateAttendeeCapabilitiesInput) (*UpdateAttendeeCapabilitiesOutput, error) {
	req, out := c.UpdateAttendeeCapabilitiesRequest(input)
	return out, req.Send()
}

// UpdateAttendeeCapabilitiesWithContext is the same as UpdateAttendeeCapabilities with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAttendeeCapabilities for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMeetings) UpdateAttendeeCapabilitiesWithContext(ctx aws.Context, input *UpdateAttendeeCapabilitiesInput, opts ...request.Option) (*UpdateAttendeeCapabilitiesOutput, error) {
	req, out := c.UpdateAttendeeCapabilitiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// An Amazon Chime SDK meeting attendee. Includes a unique AttendeeId and JoinToken.
// The JoinToken allows a client to authenticate and join as the specified attendee.
// The JoinToken expires when the meeting ends, or when DeleteAttendee is called.
// After that, the attendee is unable to join the meeting.
//
// We recommend securely transferring each JoinToken from your server application
// to the client so that no other client has access to the token except for
// the one authorized to represent the attendee.
type Attendee struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime SDK attendee ID.
	AttendeeId *string `type:"string"`

	// The capabilities assigned to an attendee: audio, video, or content.
	//
	// You use the capabilities with a set of values that control what the capabilities
	// can do, such as SendReceive data. For more information about those values,
	// see .
	//
	// When using capabilities, be aware of these corner cases:
	//
	//    * If you specify MeetingFeatures:Video:MaxResolution:None when you create
	//    a meeting, all API requests that include SendReceive, Send, or Receive
	//    for AttendeeCapabilities:Video will be rejected with ValidationError 400.
	//
	//    * If you specify MeetingFeatures:Content:MaxResolution:None when you create
	//    a meeting, all API requests that include SendReceive, Send, or Receive
	//    for AttendeeCapabilities:Content will be rejected with ValidationError
	//    400.
	//
	//    * You can't set content capabilities to SendReceive or Receive unless
	//    you also set video capabilities to SendReceive or Receive. If you don't
	//    set the video capability to receive, the response will contain an HTTP
	//    400 Bad Request status code. However, you can set your video capability
	//    to receive and you set your content capability to not receive.
	//
	//    * When you change an audio capability from None or Receive to Send or
	//    SendReceive , and if the attendee left their microphone unmuted, audio
	//    will flow from the attendee to the other meeting participants.
	//
	//    * When you change a video or content capability from None or Receive to
	//    Send or SendReceive , and if the attendee turned on their video or content
	//    streams, remote attendees can receive those streams, but only after media
	//    renegotiation between the client and the Amazon Chime back-end server.
	Capabilities *AttendeeCapabilities `type:"structure"`

	// The Amazon Chime SDK external user ID. An idempotency token. Links the attendee
	// to an identity managed by a builder application.
	//
	// Pattern: [-_&@+=,(){}\[\]\/«».:|'"#a-zA-Z0-9À-ÿ\s]*
	//
	// Values that begin with aws: are reserved. You can't configure a value that
	// uses this prefix. Case insensitive.
	//
	// ExternalUserId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Attendee's
	// String and GoString methods.
	ExternalUserId *string `min:"2" type:"string" sensitive:"true"`

	// The join token used by the Amazon Chime SDK attendee.
	//
	// JoinToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Attendee's
	// String and GoString methods.
	JoinToken *string `min:"2" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Attendee) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Attendee) GoString() string {
	return s.String()
}

// SetAttendeeId sets the AttendeeId field's value.
func (s *Attendee) SetAttendeeId(v string) *Attendee {
	s.AttendeeId = &v
	return s
}

// SetCapabilities sets the Capabilities field's value.
func (s *Attendee) SetCapabilities(v *AttendeeCapabilities) *Attendee {
	s.Capabilities = v
	return s
}

// SetExternalUserId sets the ExternalUserId field's value.
func (s *Attendee) SetExternalUserId(v string) *Attendee {
	s.ExternalUserId = &v
	return s
}

// SetJoinToken sets the JoinToken field's value.
func (s *Attendee) SetJoinToken(v string) *Attendee {
	s.JoinToken = &v
	return s
}

// The media capabilities of an attendee: audio, video, or content.
//
// You use the capabilities with a set of values that control what the capabilities
// can do, such as SendReceive data. For more information, refer to and .
//
// When using capabilities, be aware of these corner cases:
//
//   - If you specify MeetingFeatures:Video:MaxResolution:None when you create
//     a meeting, all API requests that include SendReceive, Send, or Receive
//     for AttendeeCapabilities:Video will be rejected with ValidationError 400.
//
//   - If you specify MeetingFeatures:Content:MaxResolution:None when you create
//     a meeting, all API requests that include SendReceive, Send, or Receive
//     for AttendeeCapabilities:Content will be rejected with ValidationError
//     400.
//
//   - You can't set content capabilities to SendReceive or Receive unless
//     you also set video capabilities to SendReceive or Receive. If you don't
//     set the video capability to receive, the response will contain an HTTP
//     400 Bad Request status code. However, you can set your video capability
//     to receive and you set your content capability to not receive.
//
//   - When you change an audio capability from None or Receive to Send or
//     SendReceive , and an attendee unmutes their microphone, audio flows from
//     the attendee to the other meeting participants.
//
//   - When you change a video or content capability from None or Receive to
//     Send or SendReceive , and the attendee turns on their video or content
//     streams, remote attendees can receive those streams, but only after media
//     renegotiation between the client and the Amazon Chime back-end server.
type AttendeeCapabilities struct {
	_ struct{} `type:"structure"`

	// The audio capability assigned to an attendee.
	//
	// Audio is a required field
	Audio *string `type:"string" required:"true" enum:"MediaCapabilities"`

	// The content capability assigned to an attendee.
	//
	// Content is a required field
	Content *string `type:"string" required:"true" enum:"MediaCapabilities"`

	// The video capability assigned to an attendee.
	//
	// Video is a required field
	Video *string `type:"string" required:"true" enum:"MediaCapabilities"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttendeeCapabilities) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttendeeCapabilities) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttendeeCapabilities) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttendeeCapabilities"}
	if s.Audio == nil {
		invalidParams.Add(request.NewErrParamRequired("Audio"))
	}
	if s.Content == nil {
		invalidParams.Add(request.NewErrParamRequired("Content"))
	}
	if s.Video == nil {
		invalidParams.Add(request.NewErrParamRequired("Video"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAudio sets the Audio field's value.
func (s *AttendeeCapabilities) SetAudio(v string) *AttendeeCapabilities {
	s.Audio = &v
	return s
}

// SetContent sets the Content field's value.
func (s *AttendeeCapabilities) SetContent(v string) *AttendeeCapabilities {
	s.Content = &v
	return s
}

// SetVideo sets the Video field's value.
func (s *AttendeeCapabilities) SetVideo(v string) *AttendeeCapabilities {
	s.Video = &v
	return s
}

// Lists the maximum number of attendees allowed into the meeting.
//
// If you specify FHD for MeetingFeatures:Video:MaxResolution, or if you specify
// UHD for MeetingFeatures:Content:MaxResolution, the maximum number of attendees
// changes from the default of 250 to 25.
type AttendeeFeatures struct {
	_ struct{} `type:"structure"`

	// The maximum number of attendees allowed into the meeting.
	MaxCount *int64 `min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttendeeFeatures) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttendeeFeatures) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttendeeFeatures) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttendeeFeatures"}
	if s.MaxCount != nil && *s.MaxCount < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxCount", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxCount sets the MaxCount field's value.
func (s *AttendeeFeatures) SetMaxCount(v int64) *AttendeeFeatures {
	s.MaxCount = &v
	return s
}

// A structure that contains one or more attendee IDs.
type AttendeeIdItem struct {
	_ struct{} `type:"structure"`

	// A list of one or more attendee IDs.
	//
	// AttendeeId is a required field
	AttendeeId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttendeeIdItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttendeeIdItem) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttendeeIdItem) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttendeeIdItem"}
	if s.AttendeeId == nil {
		invalidParams.Add(request.NewErrParamRequired("AttendeeId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttendeeId sets the AttendeeId field's value.
func (s *AttendeeIdItem) SetAttendeeId(v string) *AttendeeIdItem {
	s.AttendeeId = &v
	return s
}

// An optional category of meeting features that contains audio-specific configurations,
// such as operating parameters for Amazon Voice Focus.
type AudioFeatures struct {
	_ struct{} `type:"structure"`

	// Makes echo reduction available to clients who connect to the meeting.
	EchoReduction *string `type:"string" enum:"MeetingFeatureStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudioFeatures) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudioFeatures) GoString() string {
	return s.String()
}

// SetEchoReduction sets the EchoReduction field's value.
func (s *AudioFeatures) SetEchoReduction(v string) *AudioFeatures {
	s.EchoReduction = &v
	return s
}

// The input parameters don't match the service's restrictions.
type BadRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string"`

	Message_ *string `locationName:"Message" type:"string"`

	// The request id associated with the call responsible for the exception.
	RequestId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadRequestException) GoString() string {
	return s.String()
}

func newErrorBadRequestException(v protocol.ResponseMetadata) error {
	return &BadRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BadRequestException) Code() string {
	return "BadRequestException"
}

// Message returns the exception's message.
func (s *BadRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BadRequestException) OrigErr() error {
	return nil
}

func (s *BadRequestException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BadRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BadRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

type BatchCreateAttendeeInput struct {
	_ struct{} `type:"structure"`

	// The attendee information, including attendees' IDs and join tokens.
	//
	// Attendees is a required field
	Attendees []*CreateAttendeeRequestItem `min:"1" type:"list" required:"true"`

	// The Amazon Chime SDK ID of the meeting to which you're adding attendees.
	//
	// MeetingId is a required field
	MeetingId *string `location:"uri" locationName:"MeetingId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchCreateAttendeeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchCreateAttendeeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchCreateAttendeeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchCreateAttendeeInput"}
	if s.Attendees == nil {
		invalidParams.Add(request.NewErrParamRequired("Attendees"))
	}
	if s.Attendees != nil && len(s.Attendees) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Attendees", 1))
	}
	if s.MeetingId == nil {
		invalidParams.Add(request.NewErrParamRequired("MeetingId"))
	}
	if s.MeetingId != nil && len(*s.MeetingId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeetingId", 1))
	}
	if s.Attendees != nil {
		for i, v := range s.Attendees {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Attendees", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttendees sets the Attendees field's value.
func (s *BatchCreateAttendeeInput) SetAttendees(v []*CreateAttendeeRequestItem) *BatchCreateAttendeeInput {
	s.Attendees = v
	return s
}

// SetMeetingId sets the MeetingId field's value.
func (s *BatchCreateAttendeeInput) SetMeetingId(v string) *BatchCreateAttendeeInput {
	s.MeetingId = &v
	return s
}

type BatchCreateAttendeeOutput struct {
	_ struct{} `type:"structure"`

	// The attendee information, including attendees' IDs and join tokens.
	Attendees []*Attendee `type:"list"`

	// If the action fails for one or more of the attendees in the request, a list
	// of the attendees is returned, along with error codes and error messages.
	Errors []*CreateAttendeeError `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchCreateAttendeeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchCreateAttendeeOutput) GoString() string {
	return s.String()
}

// SetAttendees sets the Attendees field's value.
func (s *BatchCreateAttendeeOutput) SetAttendees(v []*Attendee) *BatchCreateAttendeeOutput {
	s.Attendees = v
	return s
}

// SetErrors sets the Errors field's value.
func (s *BatchCreateAttendeeOutput) SetErrors(v []*CreateAttendeeError) *BatchCreateAttendeeOutput {
	s.Errors = v
	return s
}

type BatchUpdateAttendeeCapabilitiesExceptInput struct {
	_ struct{} `type:"structure"`

	// The capabilities (audio, video, or content) that you want to update.
	//
	// Capabilities is a required field
	Capabilities *AttendeeCapabilities `type:"structure" required:"true"`

	// The AttendeeIDs that you want to exclude from one or more capabilities.
	//
	// ExcludedAttendeeIds is a required field
	ExcludedAttendeeIds []*AttendeeIdItem `min:"1" type:"list" required:"true"`

	// The ID of the meeting associated with the update request.
	//
	// MeetingId is a required field
	MeetingId *string `location:"uri" locationName:"MeetingId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchUpdateAttendeeCapabilitiesExceptInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchUpdateAttendeeCapabilitiesExceptInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchUpdateAttendeeCapabilitiesExceptInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchUpdateAttendeeCapabilitiesExceptInput"}
	if s.Capabilities == nil {
		invalidParams.Add(request.NewErrParamRequired("Capabilities"))
	}
	if s.ExcludedAttendeeIds == nil {
		invalidParams.Add(request.NewErrParamRequired("ExcludedAttendeeIds"))
	}
	if s.ExcludedAttendeeIds != nil && len(s.ExcludedAttendeeIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExcludedAttendeeIds", 1))
	}
	if s.MeetingId == nil {
		invalidParams.Add(request.NewErrParamRequired("MeetingId"))
	}
	if s.MeetingId != nil && len(*s.MeetingId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeetingId", 1))
	}
	if s.Capabilities != nil {
		if err := s.Capabilities.Validate(); err != nil {
			invalidParams.AddNested("Capabilities", err.(request.ErrInvalidParams))
		}
	}
	if s.ExcludedAttendeeIds != nil {
		for i, v := range s.ExcludedAttendeeIds {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ExcludedAttendeeIds", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCapabilities sets the Capabilities field's value.
func (s *BatchUpdateAttendeeCapabilitiesExceptInput) SetCapabilities(v *AttendeeCapabilities) *BatchUpdateAttendeeCapabilitiesExceptInput {
	s.Capabilities = v
	return s
}

// SetExcludedAttendeeIds sets the ExcludedAttendeeIds field's value.
func (s *BatchUpdateAttendeeCapabilitiesExceptInput) SetExcludedAttendeeIds(v []*AttendeeIdItem) *BatchUpdateAttendeeCapabilitiesExceptInput {
	s.ExcludedAttendeeIds = v
	return s
}

// SetMeetingId sets the MeetingId field's value.
func (s *BatchUpdateAttendeeCapabilitiesExceptInput) SetMeetingId(v string) *BatchUpdateAttendeeCapabilitiesExceptInput {
	s.MeetingId = &v
	return s
}

type BatchUpdateAttendeeCapabilitiesExceptOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchUpdateAttendeeCapabilitiesExceptOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchUpdateAttendeeCapabilitiesExceptOutput) GoString() string {
	return s.String()
}

// Multiple instances of the same request have been made simultaneously.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string"`

	Message_ *string `locationName:"Message" type:"string"`

	// The ID of the request involved in the conflict.
	RequestId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Lists the content (screen share) features for the meeting. Applies to all
// attendees.
//
// If you specify MeetingFeatures:Content:MaxResolution:None when you create
// a meeting, all API requests that include SendReceive, Send, or Receive for
// AttendeeCapabilities:Content will be rejected with ValidationError 400.
type ContentFeatures struct {
	_ struct{} `type:"structure"`

	// The maximum resolution for the meeting content.
	//
	// Defaults to FHD. To use UHD, you must also provide a MeetingFeatures:Attendee:MaxCount
	// value and override the default size limit of 250 attendees.
	MaxResolution *string `type:"string" enum:"ContentResolution"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContentFeatures) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContentFeatures) GoString() string {
	return s.String()
}

// SetMaxResolution sets the MaxResolution field's value.
func (s *ContentFeatures) SetMaxResolution(v string) *ContentFeatures {
	s.MaxResolution = &v
	return s
}

// The list of errors returned when errors are encountered during the BatchCreateAttendee
// and CreateAttendee actions. This includes external user IDs, error codes,
// and error messages.
type CreateAttendeeError struct {
	_ struct{} `type:"structure"`

	// The error code.
	ErrorCode *string `type:"string"`

	// The error message.
	ErrorMessage *string `type:"string"`

	// The Amazon Chime SDK external user ID. An idempotency token. Links the attendee
	// to an identity managed by a builder application.
	//
	// Pattern: [-_&@+=,(){}\[\]\/«».:|'"#a-zA-Z0-9À-ÿ\s]*
	//
	// Values that begin with aws: are reserved. You can't configure a value that
	// uses this prefix. Case insensitive.
	//
	// ExternalUserId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateAttendeeError's
	// String and GoString methods.
	ExternalUserId *string `min:"2" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAttendeeError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAttendeeError) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *CreateAttendeeError) SetErrorCode(v string) *CreateAttendeeError {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *CreateAttendeeError) SetErrorMessage(v string) *CreateAttendeeError {
	s.ErrorMessage = &v
	return s
}

// SetExternalUserId sets the ExternalUserId field's value.
func (s *CreateAttendeeError) SetExternalUserId(v string) *CreateAttendeeError {
	s.ExternalUserId = &v
	return s
}

type CreateAttendeeInput struct {
	_ struct{} `type:"structure"`

	// The capabilities (audio, video, or content) that you want to grant an attendee.
	// If you don't specify capabilities, all users have send and receive capabilities
	// on all media channels by default.
	//
	// You use the capabilities with a set of values that control what the capabilities
	// can do, such as SendReceive data. For more information about those values,
	// see .
	//
	// When using capabilities, be aware of these corner cases:
	//
	//    * If you specify MeetingFeatures:Video:MaxResolution:None when you create
	//    a meeting, all API requests that include SendReceive, Send, or Receive
	//    for AttendeeCapabilities:Video will be rejected with ValidationError 400.
	//
	//    * If you specify MeetingFeatures:Content:MaxResolution:None when you create
	//    a meeting, all API requests that include SendReceive, Send, or Receive
	//    for AttendeeCapabilities:Content will be rejected with ValidationError
	//    400.
	//
	//    * You can't set content capabilities to SendReceive or Receive unless
	//    you also set video capabilities to SendReceive or Receive. If you don't
	//    set the video capability to receive, the response will contain an HTTP
	//    400 Bad Request status code. However, you can set your video capability
	//    to receive and you set your content capability to not receive.
	//
	//    * When you change an audio capability from None or Receive to Send or
	//    SendReceive , and if the attendee left their microphone unmuted, audio
	//    will flow from the attendee to the other meeting participants.
	//
	//    * When you change a video or content capability from None or Receive to
	//    Send or SendReceive , and if the attendee turned on their video or content
	//    streams, remote attendees can receive those streams, but only after media
	//    renegotiation between the client and the Amazon Chime back-end server.
	Capabilities *AttendeeCapabilities `type:"structure"`

	// The Amazon Chime SDK external user ID. An idempotency token. Links the attendee
	// to an identity managed by a builder application.
	//
	// Pattern: [-_&@+=,(){}\[\]\/«».:|'"#a-zA-Z0-9À-ÿ\s]*
	//
	// Values that begin with aws: are reserved. You can't configure a value that
	// uses this prefix.
	//
	// ExternalUserId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateAttendeeInput's
	// String and GoString methods.
	//
	// ExternalUserId is a required field
	ExternalUserId *string `min:"2" type:"string" required:"true" sensitive:"true"`

	// The unique ID of the meeting.
	//
	// MeetingId is a required field
	MeetingId *string `location:"uri" locationName:"MeetingId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAttendeeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAttendeeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAttendeeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAttendeeInput"}
	if s.ExternalUserId == nil {
		invalidParams.Add(request.NewErrParamRequired("ExternalUserId"))
	}
	if s.ExternalUserId != nil && len(*s.ExternalUserId) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ExternalUserId", 2))
	}
	if s.MeetingId == nil {
		invalidParams.Add(request.NewErrParamRequired("MeetingId"))
	}
	if s.MeetingId != nil && len(*s.MeetingId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeetingId", 1))
	}
	if s.Capabilities != nil {
		if err := s.Capabilities.Validate(); err != nil {
			invalidParams.AddNested("Capabilities", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCapabilities sets the Capabilities field's value.
func (s *CreateAttendeeInput) SetCapabilities(v *AttendeeCapabilities) *CreateAttendeeInput {
	s.Capabilities = v
	return s
}

// SetExternalUserId sets the ExternalUserId field's value.
func (s *CreateAttendeeInput) SetExternalUserId(v string) *CreateAttendeeInput {
	s.ExternalUserId = &v
	return s
}

// SetMeetingId sets the MeetingId field's value.
func (s *CreateAttendeeInput) SetMeetingId(v string) *CreateAttendeeInput {
	s.MeetingId = &v
	return s
}

type CreateAttendeeOutput struct {
	_ struct{} `type:"structure"`

	// The attendee information, including attendee ID and join token.
	Attendee *Attendee `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAttendeeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAttendeeOutput) GoString() string {
	return s.String()
}

// SetAttendee sets the Attendee field's value.
func (s *CreateAttendeeOutput) SetAttendee(v *Attendee) *CreateAttendeeOutput {
	s.Attendee = v
	return s
}

// The Amazon Chime SDK attendee fields to create, used with the BatchCreateAttendee
// action.
type CreateAttendeeRequestItem struct {
	_ struct{} `type:"structure"`

	// A list of one or more capabilities.
	Capabilities *AttendeeCapabilities `type:"structure"`

	// The Amazon Chime SDK external user ID. An idempotency token. Links the attendee
	// to an identity managed by a builder application.
	//
	// Pattern: [-_&@+=,(){}\[\]\/«».:|'"#a-zA-Z0-9À-ÿ\s]*
	//
	// Values that begin with aws: are reserved. You can't configure a value that
	// uses this prefix. Case insensitive.
	//
	// ExternalUserId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateAttendeeRequestItem's
	// String and GoString methods.
	//
	// ExternalUserId is a required field
	ExternalUserId *string `min:"2" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAttendeeRequestItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAttendeeRequestItem) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAttendeeRequestItem) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAttendeeRequestItem"}
	if s.ExternalUserId == nil {
		invalidParams.Add(request.NewErrParamRequired("ExternalUserId"))
	}
	if s.ExternalUserId != nil && len(*s.ExternalUserId) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ExternalUserId", 2))
	}
	if s.Capabilities != nil {
		if err := s.Capabilities.Validate(); err != nil {
			invalidParams.AddNested("Capabilities", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCapabilities sets the Capabilities field's value.
func (s *CreateAttendeeRequestItem) SetCapabilities(v *AttendeeCapabilities) *CreateAttendeeRequestItem {
	s.Capabilities = v
	return s
}

// SetExternalUserId sets the ExternalUserId field's value.
func (s *CreateAttendeeRequestItem) SetExternalUserId(v string) *CreateAttendeeRequestItem {
	s.ExternalUserId = &v
	return s
}

type CreateMeetingInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the client request. Use a different token for different
	// meetings.
	//
	// ClientRequestToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateMeetingInput's
	// String and GoString methods.
	ClientRequestToken *string `min:"2" type:"string" idempotencyToken:"true" sensitive:"true"`

	// The external meeting ID.
	//
	// Pattern: [-_&@+=,(){}\[\]\/«».:|'"#a-zA-Z0-9À-ÿ\s]*
	//
	// Values that begin with aws: are reserved. You can't configure a value that
	// uses this prefix. Case insensitive.
	//
	// ExternalMeetingId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateMeetingInput's
	// String and GoString methods.
	//
	// ExternalMeetingId is a required field
	ExternalMeetingId *string `min:"2" type:"string" required:"true" sensitive:"true"`

	// The Region in which to create the meeting.
	//
	// Available values: af-south-1, ap-northeast-1, ap-northeast-2, ap-south-1,
	// ap-southeast-1, ap-southeast-2, ca-central-1, eu-central-1, eu-north-1, eu-south-1,
	// eu-west-1, eu-west-2, eu-west-3, sa-east-1, us-east-1, us-east-2, us-west-1,
	// us-west-2.
	//
	// Available values in Amazon Web Services GovCloud (US) Regions: us-gov-east-1,
	// us-gov-west-1.
	//
	// MediaRegion is a required field
	MediaRegion *string `min:"2" type:"string" required:"true"`

	// Lists the audio and video features enabled for a meeting, such as echo reduction.
	MeetingFeatures *MeetingFeaturesConfiguration `type:"structure"`

	// Reserved.
	//
	// MeetingHostId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateMeetingInput's
	// String and GoString methods.
	MeetingHostId *string `min:"2" type:"string" sensitive:"true"`

	// The configuration for resource targets to receive notifications when meeting
	// and attendee events occur.
	NotificationsConfiguration *NotificationsConfiguration `type:"structure"`

	// When specified, replicates the media from the primary meeting to the new
	// meeting.
	PrimaryMeetingId *string `min:"2" type:"string"`

	// Applies one or more tags to an Amazon Chime SDK meeting. Note the following:
	//
	//    * Not all resources have tags. For a list of services with resources that
	//    support tagging using this operation, see Services that support the Resource
	//    Groups Tagging API (https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/supported-services.html).
	//    If the resource doesn't yet support this operation, the resource's service
	//    might support tagging using its own API operations. For more information,
	//    refer to the documentation for that service.
	//
	//    * Each resource can have up to 50 tags. For other limits, see Tag Naming
	//    and Usage Conventions (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html#tag-conventions)
	//    in the AWS General Reference.
	//
	//    * You can only tag resources that are located in the specified Amazon
	//    Web Services Region for the Amazon Web Services account.
	//
	//    * To add tags to a resource, you need the necessary permissions for the
	//    service that the resource belongs to as well as permissions for adding
	//    tags. For more information, see the documentation for each service.
	//
	// Do not store personally identifiable information (PII) or other confidential
	// or sensitive information in tags. We use tags to provide you with billing
	// and administration services. Tags are not intended to be used for private
	// or sensitive data.
	//
	// Minimum permissions
	//
	// In addition to the tag:TagResources permission required by this operation,
	// you must also have the tagging permission defined by the service that created
	// the resource. For example, to tag a ChimeSDKMeetings instance using the TagResources
	// operation, you must have both of the following permissions:
	//
	// tag:TagResources
	//
	// ChimeSDKMeetings:CreateTags
	//
	// Some services might have specific requirements for tagging some resources.
	// For example, to tag an Amazon S3 bucket, you must also have the s3:GetBucketTagging
	// permission. If the expected minimum permissions don't work, check the documentation
	// for that service's tagging APIs for more information.
	Tags []*Tag `type:"list"`

	// A consistent and opaque identifier, created and maintained by the builder
	// to represent a segment of their users.
	TenantIds []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMeetingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMeetingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateMeetingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateMeetingInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 2))
	}
	if s.ExternalMeetingId == nil {
		invalidParams.Add(request.NewErrParamRequired("ExternalMeetingId"))
	}
	if s.ExternalMeetingId != nil && len(*s.ExternalMeetingId) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ExternalMeetingId", 2))
	}
	if s.MediaRegion == nil {
		invalidParams.Add(request.NewErrParamRequired("MediaRegion"))
	}
	if s.MediaRegion != nil && len(*s.MediaRegion) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("MediaRegion", 2))
	}
	if s.MeetingHostId != nil && len(*s.MeetingHostId) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("MeetingHostId", 2))
	}
	if s.PrimaryMeetingId != nil && len(*s.PrimaryMeetingId) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("PrimaryMeetingId", 2))
	}
	if s.TenantIds != nil && len(s.TenantIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TenantIds", 1))
	}
	if s.MeetingFeatures != nil {
		if err := s.MeetingFeatures.Validate(); err != nil {
			invalidParams.AddNested("MeetingFeatures", err.(request.ErrInvalidParams))
		}
	}
	if s.NotificationsConfiguration != nil {
		if err := s.NotificationsConfiguration.Validate(); err != nil {
			invalidParams.AddNested("NotificationsConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateMeetingInput) SetClientRequestToken(v string) *CreateMeetingInput {
	s.ClientRequestToken = &v
	return s
}

// SetExternalMeetingId sets the ExternalMeetingId field's value.
func (s *CreateMeetingInput) SetExternalMeetingId(v string) *CreateMeetingInput {
	s.ExternalMeetingId = &v
	return s
}

// SetMediaRegion sets the MediaRegion field's value.
func (s *CreateMeetingInput) SetMediaRegion(v string) *CreateMeetingInput {
	s.MediaRegion = &v
	return s
}

// SetMeetingFeatures sets the MeetingFeatures field's value.
func (s *CreateMeetingInput) SetMeetingFeatures(v *MeetingFeaturesConfiguration) *CreateMeetingInput {
	s.MeetingFeatures = v
	return s
}

// SetMeetingHostId sets the MeetingHostId field's value.
func (s *CreateMeetingInput) SetMeetingHostId(v string) *CreateMeetingInput {
	s.MeetingHostId = &v
	return s
}

// SetNotificationsConfiguration sets the NotificationsConfiguration field's value.
func (s *CreateMeetingInput) SetNotificationsConfiguration(v *NotificationsConfiguration) *CreateMeetingInput {
	s.NotificationsConfiguration = v
	return s
}

// SetPrimaryMeetingId sets the PrimaryMeetingId field's value.
func (s *CreateMeetingInput) SetPrimaryMeetingId(v string) *CreateMeetingInput {
	s.PrimaryMeetingId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateMeetingInput) SetTags(v []*Tag) *CreateMeetingInput {
	s.Tags = v
	return s
}

// SetTenantIds sets the TenantIds field's value.
func (s *CreateMeetingInput) SetTenantIds(v []*string) *CreateMeetingInput {
	s.TenantIds = v
	return s
}

type CreateMeetingOutput struct {
	_ struct{} `type:"structure"`

	// The meeting information, including the meeting ID and MediaPlacement.
	Meeting *Meeting `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMeetingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMeetingOutput) GoString() string {
	return s.String()
}

// SetMeeting sets the Meeting field's value.
func (s *CreateMeetingOutput) SetMeeting(v *Meeting) *CreateMeetingOutput {
	s.Meeting = v
	return s
}

type CreateMeetingWithAttendeesInput struct {
	_ struct{} `type:"structure"`

	// The attendee information, including attendees' IDs and join tokens.
	//
	// Attendees is a required field
	Attendees []*CreateAttendeeRequestItem `min:"1" type:"list" required:"true"`

	// The unique identifier for the client request. Use a different token for different
	// meetings.
	//
	// ClientRequestToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateMeetingWithAttendeesInput's
	// String and GoString methods.
	ClientRequestToken *string `min:"2" type:"string" idempotencyToken:"true" sensitive:"true"`

	// The external meeting ID.
	//
	// Pattern: [-_&@+=,(){}\[\]\/«».:|'"#a-zA-Z0-9À-ÿ\s]*
	//
	// Values that begin with aws: are reserved. You can't configure a value that
	// uses this prefix. Case insensitive.
	//
	// ExternalMeetingId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateMeetingWithAttendeesInput's
	// String and GoString methods.
	//
	// ExternalMeetingId is a required field
	ExternalMeetingId *string `min:"2" type:"string" required:"true" sensitive:"true"`

	// The Region in which to create the meeting.
	//
	// Available values: af-south-1, ap-northeast-1, ap-northeast-2, ap-south-1,
	// ap-southeast-1, ap-southeast-2, ca-central-1, eu-central-1, eu-north-1, eu-south-1,
	// eu-west-1, eu-west-2, eu-west-3, sa-east-1, us-east-1, us-east-2, us-west-1,
	// us-west-2.
	//
	// Available values in Amazon Web Services GovCloud (US) Regions: us-gov-east-1,
	// us-gov-west-1.
	//
	// MediaRegion is a required field
	MediaRegion *string `min:"2" type:"string" required:"true"`

	// Lists the audio and video features enabled for a meeting, such as echo reduction.
	MeetingFeatures *MeetingFeaturesConfiguration `type:"structure"`

	// Reserved.
	//
	// MeetingHostId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateMeetingWithAttendeesInput's
	// String and GoString methods.
	MeetingHostId *string `min:"2" type:"string" sensitive:"true"`

	// The configuration for resource targets to receive notifications when meeting
	// and attendee events occur.
	NotificationsConfiguration *NotificationsConfiguration `type:"structure"`

	// When specified, replicates the media from the primary meeting to the new
	// meeting.
	PrimaryMeetingId *string `min:"2" type:"string"`

	// The tags in the request.
	Tags []*Tag `type:"list"`

	// A consistent and opaque identifier, created and maintained by the builder
	// to represent a segment of their users.
	TenantIds []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMeetingWithAttendeesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMeetingWithAttendeesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateMeetingWithAttendeesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateMeetingWithAttendeesInput"}
	if s.Attendees == nil {
		invalidParams.Add(request.NewErrParamRequired("Attendees"))
	}
	if s.Attendees != nil && len(s.Attendees) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Attendees", 1))
	}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 2))
	}
	if s.ExternalMeetingId == nil {
		invalidParams.Add(request.NewErrParamRequired("ExternalMeetingId"))
	}
	if s.ExternalMeetingId != nil && len(*s.ExternalMeetingId) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ExternalMeetingId", 2))
	}
	if s.MediaRegion == nil {
		invalidParams.Add(request.NewErrParamRequired("MediaRegion"))
	}
	if s.MediaRegion != nil && len(*s.MediaRegion) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("MediaRegion", 2))
	}
	if s.MeetingHostId != nil && len(*s.MeetingHostId) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("MeetingHostId", 2))
	}
	if s.PrimaryMeetingId != nil && len(*s.PrimaryMeetingId) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("PrimaryMeetingId", 2))
	}
	if s.TenantIds != nil && len(s.TenantIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TenantIds", 1))
	}
	if s.Attendees != nil {
		for i, v := range s.Attendees {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Attendees", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.MeetingFeatures != nil {
		if err := s.MeetingFeatures.Validate(); err != nil {
			invalidParams.AddNested("MeetingFeatures", err.(request.ErrInvalidParams))
		}
	}
	if s.NotificationsConfiguration != nil {
		if err := s.NotificationsConfiguration.Validate(); err != nil {
			invalidParams.AddNested("NotificationsConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttendees sets the Attendees field's value.
func (s *CreateMeetingWithAttendeesInput) SetAttendees(v []*CreateAttendeeRequestItem) *CreateMeetingWithAttendeesInput {
	s.Attendees = v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateMeetingWithAttendeesInput) SetClientRequestToken(v string) *CreateMeetingWithAttendeesInput {
	s.ClientRequestToken = &v
	return s
}

// SetExternalMeetingId sets the ExternalMeetingId field's value.
func (s *CreateMeetingWithAttendeesInput) SetExternalMeetingId(v string) *CreateMeetingWithAttendeesInput {
	s.ExternalMeetingId = &v
	return s
}

// SetMediaRegion sets the MediaRegion field's value.
func (s *CreateMeetingWithAttendeesInput) SetMediaRegion(v string) *CreateMeetingWithAttendeesInput {
	s.MediaRegion = &v
	return s
}

// SetMeetingFeatures sets the MeetingFeatures field's value.
func (s *CreateMeetingWithAttendeesInput) SetMeetingFeatures(v *MeetingFeaturesConfiguration) *CreateMeetingWithAttendeesInput {
	s.MeetingFeatures = v
	return s
}

// SetMeetingHostId sets the MeetingHostId field's value.
func (s *CreateMeetingWithAttendeesInput) SetMeetingHostId(v string) *CreateMeetingWithAttendeesInput {
	s.MeetingHostId = &v
	return s
}

// SetNotificationsConfiguration sets the NotificationsConfiguration field's value.
func (s *CreateMeetingWithAttendeesInput) SetNotificationsConfiguration(v *NotificationsConfiguration) *CreateMeetingWithAttendeesInput {
	s.NotificationsConfiguration = v
	return s
}

// SetPrimaryMeetingId sets the PrimaryMeetingId field's value.
func (s *CreateMeetingWithAttendeesInput) SetPrimaryMeetingId(v string) *CreateMeetingWithAttendeesInput {
	s.PrimaryMeetingId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateMeetingWithAttendeesInput) SetTags(v []*Tag) *CreateMeetingWithAttendeesInput {
	s.Tags = v
	return s
}

// SetTenantIds sets the TenantIds field's value.
func (s *CreateMeetingWithAttendeesInput) SetTenantIds(v []*string) *CreateMeetingWithAttendeesInput {
	s.TenantIds = v
	return s
}

type CreateMeetingWithAttendeesOutput struct {
	_ struct{} `type:"structure"`

	// The attendee information, including attendees' IDs and join tokens.
	Attendees []*Attendee `type:"list"`

	// If the action fails for one or more of the attendees in the request, a list
	// of the attendees is returned, along with error codes and error messages.
	Errors []*CreateAttendeeError `type:"list"`

	// The meeting information, including the meeting ID and MediaPlacement.
	Meeting *Meeting `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMeetingWithAttendeesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMeetingWithAttendeesOutput) GoString() string {
	return s.String()
}

// SetAttendees sets the Attendees field's value.
func (s *CreateMeetingWithAttendeesOutput) SetAttendees(v []*Attendee) *CreateMeetingWithAttendeesOutput {
	s.Attendees = v
	return s
}

// SetErrors sets the Errors field's value.
func (s *CreateMeetingWithAttendeesOutput) SetErrors(v []*CreateAttendeeError) *CreateMeetingWithAttendeesOutput {
	s.Errors = v
	return s
}

// SetMeeting sets the Meeting field's value.
func (s *CreateMeetingWithAttendeesOutput) SetMeeting(v *Meeting) *CreateMeetingWithAttendeesOutput {
	s.Meeting = v
	return s
}

type DeleteAttendeeInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Chime SDK attendee ID.
	//
	// AttendeeId is a required field
	AttendeeId *string `location:"uri" locationName:"AttendeeId" type:"string" required:"true"`

	// The Amazon Chime SDK meeting ID.
	//
	// MeetingId is a required field
	MeetingId *string `location:"uri" locationName:"MeetingId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAttendeeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAttendeeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAttendeeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAttendeeInput"}
	if s.AttendeeId == nil {
		invalidParams.Add(request.NewErrParamRequired("AttendeeId"))
	}
	if s.AttendeeId != nil && len(*s.AttendeeId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AttendeeId", 1))
	}
	if s.MeetingId == nil {
		invalidParams.Add(request.NewErrParamRequired("MeetingId"))
	}
	if s.MeetingId != nil && len(*s.MeetingId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeetingId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttendeeId sets the AttendeeId field's value.
func (s *DeleteAttendeeInput) SetAttendeeId(v string) *DeleteAttendeeInput {
	s.AttendeeId = &v
	return s
}

// SetMeetingId sets the MeetingId field's value.
func (s *DeleteAttendeeInput) SetMeetingId(v string) *DeleteAttendeeInput {
	s.MeetingId = &v
	return s
}

type DeleteAttendeeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAttendeeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAttendeeOutput) GoString() string {
	return s.String()
}

type DeleteMeetingInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Chime SDK meeting ID.
	//
	// MeetingId is a required field
	MeetingId *string `location:"uri" locationName:"MeetingId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMeetingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMeetingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMeetingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteMeetingInput"}
	if s.MeetingId == nil {
		invalidParams.Add(request.NewErrParamRequired("MeetingId"))
	}
	if s.MeetingId != nil && len(*s.MeetingId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeetingId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMeetingId sets the MeetingId field's value.
func (s *DeleteMeetingInput) SetMeetingId(v string) *DeleteMeetingInput {
	s.MeetingId = &v
	return s
}

type DeleteMeetingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMeetingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMeetingOutput) GoString() string {
	return s.String()
}

// Settings specific to the Amazon Transcribe Medical engine.
type EngineTranscribeMedicalSettings struct {
	_ struct{} `type:"structure"`

	// Set this field to PHI to identify personal health information in the transcription
	// output.
	ContentIdentificationType *string `type:"string" enum:"TranscribeMedicalContentIdentificationType"`

	// The language code specified for the Amazon Transcribe Medical engine.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"TranscribeMedicalLanguageCode"`

	// The Amazon Web Services Region passed to Amazon Transcribe Medical. If you
	// don't specify a Region, Amazon Chime uses the meeting's Region.
	Region *string `type:"string" enum:"TranscribeMedicalRegion"`

	// The specialty specified for the Amazon Transcribe Medical engine.
	//
	// Specialty is a required field
	Specialty *string `type:"string" required:"true" enum:"TranscribeMedicalSpecialty"`

	// The type of transcription.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"TranscribeMedicalType"`

	// The name of the vocabulary passed to Amazon Transcribe Medical.
	VocabularyName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EngineTranscribeMedicalSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EngineTranscribeMedicalSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EngineTranscribeMedicalSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EngineTranscribeMedicalSettings"}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.Specialty == nil {
		invalidParams.Add(request.NewErrParamRequired("Specialty"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContentIdentificationType sets the ContentIdentificationType field's value.
func (s *EngineTranscribeMedicalSettings) SetContentIdentificationType(v string) *EngineTranscribeMedicalSettings {
	s.ContentIdentificationType = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *EngineTranscribeMedicalSettings) SetLanguageCode(v string) *EngineTranscribeMedicalSettings {
	s.LanguageCode = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *EngineTranscribeMedicalSettings) SetRegion(v string) *EngineTranscribeMedicalSettings {
	s.Region = &v
	return s
}

// SetSpecialty sets the Specialty field's value.
func (s *EngineTranscribeMedicalSettings) SetSpecialty(v string) *EngineTranscribeMedicalSettings {
	s.Specialty = &v
	return s
}

// SetType sets the Type field's value.
func (s *EngineTranscribeMedicalSettings) SetType(v string) *EngineTranscribeMedicalSettings {
	s.Type = &v
	return s
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *EngineTranscribeMedicalSettings) SetVocabularyName(v string) *EngineTranscribeMedicalSettings {
	s.VocabularyName = &v
	return s
}

// Settings specific for Amazon Transcribe as the live transcription engine.
//
// If you specify an invalid combination of parameters, a TranscriptFailed event
// will be sent with the contents of the BadRequestException generated by Amazon
// Transcribe. For more information on each parameter and which combinations
// are valid, refer to the StartStreamTranscription (https://docs.aws.amazon.com/transcribe/latest/APIReference/API_streaming_StartStreamTranscription.html)
// API in the Amazon Transcribe Developer Guide.
type EngineTranscribeSettings struct {
	_ struct{} `type:"structure"`

	// Labels all personally identifiable information (PII) identified in your transcript.
	// If you don't include PiiEntityTypes, all PII is identified.
	//
	// You can’t set ContentIdentificationType and ContentRedactionType.
	ContentIdentificationType *string `type:"string" enum:"TranscribeContentIdentificationType"`

	// Content redaction is performed at the segment level. If you don't include
	// PiiEntityTypes, all PII is redacted.
	//
	// You can’t set ContentRedactionType and ContentIdentificationType.
	ContentRedactionType *string `type:"string" enum:"TranscribeContentRedactionType"`

	// Enables partial result stabilization for your transcription. Partial result
	// stabilization can reduce latency in your output, but may impact accuracy.
	EnablePartialResultsStabilization *bool `type:"boolean"`

	// Enables automatic language identification for your transcription.
	//
	// If you include IdentifyLanguage, you can optionally use LanguageOptions to
	// include a list of language codes that you think may be present in your audio
	// stream. Including language options can improve transcription accuracy.
	//
	// You can also use PreferredLanguage to include a preferred language. Doing
	// so can help Amazon Transcribe identify the language faster.
	//
	// You must include either LanguageCode or IdentifyLanguage.
	//
	// Language identification can't be combined with custom language models or
	// redaction.
	IdentifyLanguage *bool `type:"boolean"`

	// Specify the language code that represents the language spoken.
	//
	// If you're unsure of the language spoken in your audio, consider using IdentifyLanguage
	// to enable automatic language identification.
	LanguageCode *string `type:"string" enum:"TranscribeLanguageCode"`

	// Specify the name of the custom language model that you want to use when processing
	// your transcription. Note that language model names are case sensitive.
	//
	// The language of the specified language model must match the language code.
	// If the languages don't match, the custom language model isn't applied. There
	// are no errors or warnings associated with a language mismatch.
	//
	// If you use Amazon Transcribe in multiple Regions, the custom language model
	// must be available in Amazon Transcribe in each Region.
	LanguageModelName *string `min:"1" type:"string"`

	// Specify two or more language codes that represent the languages you think
	// may be present in your media; including more than five is not recommended.
	// If you're unsure what languages are present, do not include this parameter.
	//
	// Including language options can improve the accuracy of language identification.
	//
	// If you include LanguageOptions, you must also include IdentifyLanguage.
	//
	// You can only include one language dialect per language. For example, you
	// cannot include en-US and en-AU.
	LanguageOptions *string `min:"1" type:"string"`

	// Specify the level of stability to use when you enable partial results stabilization
	// (EnablePartialResultsStabilization).
	//
	// Low stability provides the highest accuracy. High stability transcribes faster,
	// but with slightly lower accuracy.
	PartialResultsStability *string `type:"string" enum:"TranscribePartialResultsStability"`

	// Specify which types of personally identifiable information (PII) you want
	// to redact in your transcript. You can include as many types as you'd like,
	// or you can select ALL.
	//
	// Values must be comma-separated and can include: ADDRESS, BANK_ACCOUNT_NUMBER,
	// BANK_ROUTING, CREDIT_DEBIT_CVV, CREDIT_DEBIT_EXPIRY CREDIT_DEBIT_NUMBER,
	// EMAIL,NAME, PHONE, PIN, SSN, or ALL.
	//
	// Note that if you include PiiEntityTypes, you must also include ContentIdentificationType
	// or ContentRedactionType.
	//
	// If you include ContentRedactionType or ContentIdentificationType, but do
	// not include PiiEntityTypes, all PII is redacted or identified.
	PiiEntityTypes *string `min:"1" type:"string"`

	// Specify a preferred language from the subset of languages codes you specified
	// in LanguageOptions.
	//
	// You can only use this parameter if you include IdentifyLanguage and LanguageOptions.
	PreferredLanguage *string `type:"string" enum:"TranscribeLanguageCode"`

	// The Amazon Web Services Region in which to use Amazon Transcribe.
	//
	// If you don't specify a Region, then the MediaRegion (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_meeting-chime_CreateMeeting.html)
	// of the meeting is used. However, if Amazon Transcribe is not available in
	// the MediaRegion, then a TranscriptFailed event is sent.
	//
	// Use auto to use Amazon Transcribe in a Region near the meeting’s MediaRegion.
	// For more information, refer to Choosing a transcription Region (https://docs.aws.amazon.com/chime-sdk/latest/dg/transcription-options.html#choose-region)
	// in the Amazon Chime SDK Developer Guide.
	Region *string `type:"string" enum:"TranscribeRegion"`

	// Specify how you want your vocabulary filter applied to your transcript.
	//
	// To replace words with ***, choose mask.
	//
	// To delete words, choose remove.
	//
	// To flag words without changing them, choose tag.
	VocabularyFilterMethod *string `type:"string" enum:"TranscribeVocabularyFilterMethod"`

	// Specify the name of the custom vocabulary filter that you want to use when
	// processing your transcription. Note that vocabulary filter names are case
	// sensitive.
	//
	// If you use Amazon Transcribe in multiple Regions, the vocabulary filter must
	// be available in Amazon Transcribe in each Region.
	//
	// If you include IdentifyLanguage and want to use one or more vocabulary filters
	// with your transcription, use the VocabularyFilterNames parameter instead.
	VocabularyFilterName *string `type:"string"`

	// Specify the names of the custom vocabulary filters that you want to use when
	// processing your transcription. Note that vocabulary filter names are case
	// sensitive.
	//
	// If you use Amazon Transcribe in multiple Regions, the vocabulary filter must
	// be available in Amazon Transcribe in each Region.
	//
	// If you're not including IdentifyLanguage and want to use a custom vocabulary
	// filter with your transcription, use the VocabularyFilterName parameter instead.
	VocabularyFilterNames *string `min:"1" type:"string"`

	// Specify the name of the custom vocabulary that you want to use when processing
	// your transcription. Note that vocabulary names are case sensitive.
	//
	// If you use Amazon Transcribe multiple Regions, the vocabulary must be available
	// in Amazon Transcribe in each Region.
	//
	// If you include IdentifyLanguage and want to use one or more custom vocabularies
	// with your transcription, use the VocabularyNames parameter instead.
	VocabularyName *string `type:"string"`

	// Specify the names of the custom vocabularies that you want to use when processing
	// your transcription. Note that vocabulary names are case sensitive.
	//
	// If you use Amazon Transcribe in multiple Regions, the vocabulary must be
	// available in Amazon Transcribe in each Region.
	//
	// If you don't include IdentifyLanguage and want to use a custom vocabulary
	// with your transcription, use the VocabularyName parameter instead.
	VocabularyNames *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EngineTranscribeSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EngineTranscribeSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EngineTranscribeSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EngineTranscribeSettings"}
	if s.LanguageModelName != nil && len(*s.LanguageModelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LanguageModelName", 1))
	}
	if s.LanguageOptions != nil && len(*s.LanguageOptions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LanguageOptions", 1))
	}
	if s.PiiEntityTypes != nil && len(*s.PiiEntityTypes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PiiEntityTypes", 1))
	}
	if s.VocabularyFilterNames != nil && len(*s.VocabularyFilterNames) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyFilterNames", 1))
	}
	if s.VocabularyNames != nil && len(*s.VocabularyNames) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyNames", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContentIdentificationType sets the ContentIdentificationType field's value.
func (s *EngineTranscribeSettings) SetContentIdentificationType(v string) *EngineTranscribeSettings {
	s.ContentIdentificationType = &v
	return s
}

// SetContentRedactionType sets the ContentRedactionType field's value.
func (s *EngineTranscribeSettings) SetContentRedactionType(v string) *EngineTranscribeSettings {
	s.ContentRedactionType = &v
	return s
}

// SetEnablePartialResultsStabilization sets the EnablePartialResultsStabilization field's value.
func (s *EngineTranscribeSettings) SetEnablePartialResultsStabilization(v bool) *EngineTranscribeSettings {
	s.EnablePartialResultsStabilization = &v
	return s
}

// SetIdentifyLanguage sets the IdentifyLanguage field's value.
func (s *EngineTranscribeSettings) SetIdentifyLanguage(v bool) *EngineTranscribeSettings {
	s.IdentifyLanguage = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *EngineTranscribeSettings) SetLanguageCode(v string) *EngineTranscribeSettings {
	s.LanguageCode = &v
	return s
}

// SetLanguageModelName sets the LanguageModelName field's value.
func (s *EngineTranscribeSettings) SetLanguageModelName(v string) *EngineTranscribeSettings {
	s.LanguageModelName = &v
	return s
}

// SetLanguageOptions sets the LanguageOptions field's value.
func (s *EngineTranscribeSettings) SetLanguageOptions(v string) *EngineTranscribeSettings {
	s.LanguageOptions = &v
	return s
}

// SetPartialResultsStability sets the PartialResultsStability field's value.
func (s *EngineTranscribeSettings) SetPartialResultsStability(v string) *EngineTranscribeSettings {
	s.PartialResultsStability = &v
	return s
}

// SetPiiEntityTypes sets the PiiEntityTypes field's value.
func (s *EngineTranscribeSettings) SetPiiEntityTypes(v string) *EngineTranscribeSettings {
	s.PiiEntityTypes = &v
	return s
}

// SetPreferredLanguage sets the PreferredLanguage field's value.
func (s *EngineTranscribeSettings) SetPreferredLanguage(v string) *EngineTranscribeSettings {
	s.PreferredLanguage = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *EngineTranscribeSettings) SetRegion(v string) *EngineTranscribeSettings {
	s.Region = &v
	return s
}

// SetVocabularyFilterMethod sets the VocabularyFilterMethod field's value.
func (s *EngineTranscribeSettings) SetVocabularyFilterMethod(v string) *EngineTranscribeSettings {
	s.VocabularyFilterMethod = &v
	return s
}

// SetVocabularyFilterName sets the VocabularyFilterName field's value.
func (s *EngineTranscribeSettings) SetVocabularyFilterName(v string) *EngineTranscribeSettings {
	s.VocabularyFilterName = &v
	return s
}

// SetVocabularyFilterNames sets the VocabularyFilterNames field's value.
func (s *EngineTranscribeSettings) SetVocabularyFilterNames(v string) *EngineTranscribeSettings {
	s.VocabularyFilterNames = &v
	return s
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *EngineTranscribeSettings) SetVocabularyName(v string) *EngineTranscribeSettings {
	s.VocabularyName = &v
	return s
}

// SetVocabularyNames sets the VocabularyNames field's value.
func (s *EngineTranscribeSettings) SetVocabularyNames(v string) *EngineTranscribeSettings {
	s.VocabularyNames = &v
	return s
}

// The client is permanently forbidden from making the request.
type ForbiddenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string"`

	Message_ *string `locationName:"Message" type:"string"`

	// The request id associated with the call responsible for the exception.
	RequestId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ForbiddenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ForbiddenException) GoString() string {
	return s.String()
}

func newErrorForbiddenException(v protocol.ResponseMetadata) error {
	return &ForbiddenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ForbiddenException) Code() string {
	return "ForbiddenException"
}

// Message returns the exception's message.
func (s *ForbiddenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ForbiddenException) OrigErr() error {
	return nil
}

func (s *ForbiddenException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ForbiddenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ForbiddenException) RequestID() string {
	return s.RespMetadata.RequestID
}

type GetAttendeeInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Chime SDK attendee ID.
	//
	// AttendeeId is a required field
	AttendeeId *string `location:"uri" locationName:"AttendeeId" type:"string" required:"true"`

	// The Amazon Chime SDK meeting ID.
	//
	// MeetingId is a required field
	MeetingId *string `location:"uri" locationName:"MeetingId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAttendeeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAttendeeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAttendeeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAttendeeInput"}
	if s.AttendeeId == nil {
		invalidParams.Add(request.NewErrParamRequired("AttendeeId"))
	}
	if s.AttendeeId != nil && len(*s.AttendeeId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AttendeeId", 1))
	}
	if s.MeetingId == nil {
		invalidParams.Add(request.NewErrParamRequired("MeetingId"))
	}
	if s.MeetingId != nil && len(*s.MeetingId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeetingId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttendeeId sets the AttendeeId field's value.
func (s *GetAttendeeInput) SetAttendeeId(v string) *GetAttendeeInput {
	s.AttendeeId = &v
	return s
}

// SetMeetingId sets the MeetingId field's value.
func (s *GetAttendeeInput) SetMeetingId(v string) *GetAttendeeInput {
	s.MeetingId = &v
	return s
}

type GetAttendeeOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime SDK attendee information.
	Attendee *Attendee `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAttendeeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAttendeeOutput) GoString() string {
	return s.String()
}

// SetAttendee sets the Attendee field's value.
func (s *GetAttendeeOutput) SetAttendee(v *Attendee) *GetAttendeeOutput {
	s.Attendee = v
	return s
}

type GetMeetingInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Chime SDK meeting ID.
	//
	// MeetingId is a required field
	MeetingId *string `location:"uri" locationName:"MeetingId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMeetingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMeetingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMeetingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMeetingInput"}
	if s.MeetingId == nil {
		invalidParams.Add(request.NewErrParamRequired("MeetingId"))
	}
	if s.MeetingId != nil && len(*s.MeetingId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeetingId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMeetingId sets the MeetingId field's value.
func (s *GetMeetingInput) SetMeetingId(v string) *GetMeetingInput {
	s.MeetingId = &v
	return s
}

type GetMeetingOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime SDK meeting information.
	Meeting *Meeting `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMeetingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMeetingOutput) GoString() string {
	return s.String()
}

// SetMeeting sets the Meeting field's value.
func (s *GetMeetingOutput) SetMeeting(v *Meeting) *GetMeetingOutput {
	s.Meeting = v
	return s
}

// The request exceeds the resource limit.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string"`

	Message_ *string `locationName:"Message" type:"string"`

	// The request id associated with the call responsible for the exception.
	RequestId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListAttendeesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return in a single call.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The Amazon Chime SDK meeting ID.
	//
	// MeetingId is a required field
	MeetingId *string `location:"uri" locationName:"MeetingId" type:"string" required:"true"`

	// The token to use to retrieve the next page of results.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAttendeesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAttendeesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAttendeesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAttendeesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.MeetingId == nil {
		invalidParams.Add(request.NewErrParamRequired("MeetingId"))
	}
	if s.MeetingId != nil && len(*s.MeetingId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeetingId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAttendeesInput) SetMaxResults(v int64) *ListAttendeesInput {
	s.MaxResults = &v
	return s
}

// SetMeetingId sets the MeetingId field's value.
func (s *ListAttendeesInput) SetMeetingId(v string) *ListAttendeesInput {
	s.MeetingId = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAttendeesInput) SetNextToken(v string) *ListAttendeesInput {
	s.NextToken = &v
	return s
}

type ListAttendeesOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime SDK attendee information.
	Attendees []*Attendee `type:"list"`

	// The token to use to retrieve the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAttendeesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAttendeesOutput) GoString() string {
	return s.String()
}

// SetAttendees sets the Attendees field's value.
func (s *ListAttendeesOutput) SetAttendees(v []*Attendee) *ListAttendeesOutput {
	s.Attendees = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAttendeesOutput) SetNextToken(v string) *ListAttendeesOutput {
	s.NextToken = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the resource.
	//
	// ResourceARN is a required field
	ResourceARN *string `location:"querystring" locationName:"arn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *ListTagsForResourceInput) SetResourceARN(v string) *ListTagsForResourceInput {
	s.ResourceARN = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The tags requested for the specified resource.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// A set of endpoints used by clients to connect to the media service group
// for an Amazon Chime SDK meeting.
type MediaPlacement struct {
	_ struct{} `type:"structure"`

	// The audio fallback URL.
	AudioFallbackUrl *string `type:"string"`

	// The audio host URL.
	AudioHostUrl *string `type:"string"`

	// The event ingestion URL.
	EventIngestionUrl *string `type:"string"`

	// The screen data URL.
	//
	// This parameter is deprecated and no longer used by the Amazon Chime SDK.
	ScreenDataUrl *string `type:"string"`

	// The screen sharing URL.
	//
	// This parameter is deprecated and no longer used by the Amazon Chime SDK.
	ScreenSharingUrl *string `type:"string"`

	// The screen viewing URL.
	//
	// This parameter is deprecated and no longer used by the Amazon Chime SDK.
	ScreenViewingUrl *string `type:"string"`

	// The signaling URL.
	SignalingUrl *string `type:"string"`

	// The turn control URL.
	//
	// This parameter is deprecated and no longer used by the Amazon Chime SDK.
	TurnControlUrl *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MediaPlacement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MediaPlacement) GoString() string {
	return s.String()
}

// SetAudioFallbackUrl sets the AudioFallbackUrl field's value.
func (s *MediaPlacement) SetAudioFallbackUrl(v string) *MediaPlacement {
	s.AudioFallbackUrl = &v
	return s
}

// SetAudioHostUrl sets the AudioHostUrl field's value.
func (s *MediaPlacement) SetAudioHostUrl(v string) *MediaPlacement {
	s.AudioHostUrl = &v
	return s
}

// SetEventIngestionUrl sets the EventIngestionUrl field's value.
func (s *MediaPlacement) SetEventIngestionUrl(v string) *MediaPlacement {
	s.EventIngestionUrl = &v
	return s
}

// SetScreenDataUrl sets the ScreenDataUrl field's value.
func (s *MediaPlacement) SetScreenDataUrl(v string) *MediaPlacement {
	s.ScreenDataUrl = &v
	return s
}

// SetScreenSharingUrl sets the ScreenSharingUrl field's value.
func (s *MediaPlacement) SetScreenSharingUrl(v string) *MediaPlacement {
	s.ScreenSharingUrl = &v
	return s
}

// SetScreenViewingUrl sets the ScreenViewingUrl field's value.
func (s *MediaPlacement) SetScreenViewingUrl(v string) *MediaPlacement {
	s.ScreenViewingUrl = &v
	return s
}

// SetSignalingUrl sets the SignalingUrl field's value.
func (s *MediaPlacement) SetSignalingUrl(v string) *MediaPlacement {
	s.SignalingUrl = &v
	return s
}

// SetTurnControlUrl sets the TurnControlUrl field's value.
func (s *MediaPlacement) SetTurnControlUrl(v string) *MediaPlacement {
	s.TurnControlUrl = &v
	return s
}

// A meeting created using the Amazon Chime SDK.
type Meeting struct {
	_ struct{} `type:"structure"`

	// The external meeting ID.
	//
	// Pattern: [-_&@+=,(){}\[\]\/«».:|'"#a-zA-Z0-9À-ÿ\s]*
	//
	// Values that begin with aws: are reserved. You can't configure a value that
	// uses this prefix. Case insensitive.
	//
	// ExternalMeetingId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Meeting's
	// String and GoString methods.
	ExternalMeetingId *string `min:"2" type:"string" sensitive:"true"`

	// The media placement for the meeting.
	MediaPlacement *MediaPlacement `type:"structure"`

	// The Region in which you create the meeting. Available values: af-south-1,
	// ap-northeast-1, ap-northeast-2, ap-south-1, ap-southeast-1, ap-southeast-2,
	// ca-central-1, eu-central-1, eu-north-1, eu-south-1, eu-west-1, eu-west-2,
	// eu-west-3, sa-east-1, us-east-1, us-east-2, us-west-1, us-west-2.
	//
	// Available values in Amazon Web Services GovCloud (US) Regions: us-gov-east-1,
	// us-gov-west-1.
	MediaRegion *string `min:"2" type:"string"`

	// The ARN of the meeting.
	MeetingArn *string `min:"1" type:"string"`

	// The features available to a meeting, such as echo reduction.
	MeetingFeatures *MeetingFeaturesConfiguration `type:"structure"`

	// Reserved.
	//
	// MeetingHostId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Meeting's
	// String and GoString methods.
	MeetingHostId *string `min:"2" type:"string" sensitive:"true"`

	// The Amazon Chime SDK meeting ID.
	MeetingId *string `type:"string"`

	// When specified, replicates the media from the primary meeting to this meeting.
	PrimaryMeetingId *string `min:"2" type:"string"`

	// Array of strings.
	TenantIds []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Meeting) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Meeting) GoString() string {
	return s.String()
}

// SetExternalMeetingId sets the ExternalMeetingId field's value.
func (s *Meeting) SetExternalMeetingId(v string) *Meeting {
	s.ExternalMeetingId = &v
	return s
}

// SetMediaPlacement sets the MediaPlacement field's value.
func (s *Meeting) SetMediaPlacement(v *MediaPlacement) *Meeting {
	s.MediaPlacement = v
	return s
}

// SetMediaRegion sets the MediaRegion field's value.
func (s *Meeting) SetMediaRegion(v string) *Meeting {
	s.MediaRegion = &v
	return s
}

// SetMeetingArn sets the MeetingArn field's value.
func (s *Meeting) SetMeetingArn(v string) *Meeting {
	s.MeetingArn = &v
	return s
}

// SetMeetingFeatures sets the MeetingFeatures field's value.
func (s *Meeting) SetMeetingFeatures(v *MeetingFeaturesConfiguration) *Meeting {
	s.MeetingFeatures = v
	return s
}

// SetMeetingHostId sets the MeetingHostId field's value.
func (s *Meeting) SetMeetingHostId(v string) *Meeting {
	s.MeetingHostId = &v
	return s
}

// SetMeetingId sets the MeetingId field's value.
func (s *Meeting) SetMeetingId(v string) *Meeting {
	s.MeetingId = &v
	return s
}

// SetPrimaryMeetingId sets the PrimaryMeetingId field's value.
func (s *Meeting) SetPrimaryMeetingId(v string) *Meeting {
	s.PrimaryMeetingId = &v
	return s
}

// SetTenantIds sets the TenantIds field's value.
func (s *Meeting) SetTenantIds(v []*string) *Meeting {
	s.TenantIds = v
	return s
}

// The configuration settings of the features available to a meeting.
type MeetingFeaturesConfiguration struct {
	_ struct{} `type:"structure"`

	// The configuration settings for the attendee features available to a meeting.
	Attendee *AttendeeFeatures `type:"structure"`

	// The configuration settings for the audio features available to a meeting.
	Audio *AudioFeatures `type:"structure"`

	// The configuration settings for the content features available to a meeting.
	Content *ContentFeatures `type:"structure"`

	// The configuration settings for the video features available to a meeting.
	Video *VideoFeatures `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MeetingFeaturesConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MeetingFeaturesConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MeetingFeaturesConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MeetingFeaturesConfiguration"}
	if s.Attendee != nil {
		if err := s.Attendee.Validate(); err != nil {
			invalidParams.AddNested("Attendee", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttendee sets the Attendee field's value.
func (s *MeetingFeaturesConfiguration) SetAttendee(v *AttendeeFeatures) *MeetingFeaturesConfiguration {
	s.Attendee = v
	return s
}

// SetAudio sets the Audio field's value.
func (s *MeetingFeaturesConfiguration) SetAudio(v *AudioFeatures) *MeetingFeaturesConfiguration {
	s.Audio = v
	return s
}

// SetContent sets the Content field's value.
func (s *MeetingFeaturesConfiguration) SetContent(v *ContentFeatures) *MeetingFeaturesConfiguration {
	s.Content = v
	return s
}

// SetVideo sets the Video field's value.
func (s *MeetingFeaturesConfiguration) SetVideo(v *VideoFeatures) *MeetingFeaturesConfiguration {
	s.Video = v
	return s
}

// One or more of the resources in the request does not exist in the system.
type NotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string"`

	Message_ *string `locationName:"Message" type:"string"`

	// The request ID associated with the call responsible for the exception.
	RequestId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotFoundException) GoString() string {
	return s.String()
}

func newErrorNotFoundException(v protocol.ResponseMetadata) error {
	return &NotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NotFoundException) Code() string {
	return "NotFoundException"
}

// Message returns the exception's message.
func (s *NotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NotFoundException) OrigErr() error {
	return nil
}

func (s *NotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The configuration for resource targets to receive notifications when meeting
// and attendee events occur.
type NotificationsConfiguration struct {
	_ struct{} `type:"structure"`

	// The ARN of the Amazon Web Services Lambda function in the notifications configuration.
	//
	// LambdaFunctionArn is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by NotificationsConfiguration's
	// String and GoString methods.
	LambdaFunctionArn *string `min:"1" type:"string" sensitive:"true"`

	// The ARN of the SNS topic.
	//
	// SnsTopicArn is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by NotificationsConfiguration's
	// String and GoString methods.
	SnsTopicArn *string `min:"1" type:"string" sensitive:"true"`

	// The ARN of the SQS queue.
	//
	// SqsQueueArn is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by NotificationsConfiguration's
	// String and GoString methods.
	SqsQueueArn *string `min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotificationsConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotificationsConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NotificationsConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NotificationsConfiguration"}
	if s.LambdaFunctionArn != nil && len(*s.LambdaFunctionArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LambdaFunctionArn", 1))
	}
	if s.SnsTopicArn != nil && len(*s.SnsTopicArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SnsTopicArn", 1))
	}
	if s.SqsQueueArn != nil && len(*s.SqsQueueArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SqsQueueArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLambdaFunctionArn sets the LambdaFunctionArn field's value.
func (s *NotificationsConfiguration) SetLambdaFunctionArn(v string) *NotificationsConfiguration {
	s.LambdaFunctionArn = &v
	return s
}

// SetSnsTopicArn sets the SnsTopicArn field's value.
func (s *NotificationsConfiguration) SetSnsTopicArn(v string) *NotificationsConfiguration {
	s.SnsTopicArn = &v
	return s
}

// SetSqsQueueArn sets the SqsQueueArn field's value.
func (s *NotificationsConfiguration) SetSqsQueueArn(v string) *NotificationsConfiguration {
	s.SqsQueueArn = &v
	return s
}

// The resource that you want to tag couldn't be found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string"`

	Message_ *string `locationName:"Message" type:"string"`

	// The ID of the resource that couldn't be found.
	RequestId *string `type:"string"`

	// The name of the resource that couldn't be found.
	ResourceName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The service encountered an unexpected error.
type ServiceFailureException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string"`

	Message_ *string `locationName:"Message" type:"string"`

	// The ID of the failed request.
	RequestId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceFailureException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceFailureException) GoString() string {
	return s.String()
}

func newErrorServiceFailureException(v protocol.ResponseMetadata) error {
	return &ServiceFailureException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceFailureException) Code() string {
	return "ServiceFailureException"
}

// Message returns the exception's message.
func (s *ServiceFailureException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceFailureException) OrigErr() error {
	return nil
}

func (s *ServiceFailureException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceFailureException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceFailureException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The service is currently unavailable.
type ServiceUnavailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string"`

	Message_ *string `locationName:"Message" type:"string"`

	// The request id associated with the call responsible for the exception.
	RequestId *string `type:"string"`

	// The number of seconds the caller should wait before retrying.
	RetryAfterSeconds *string `location:"header" locationName:"Retry-After" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUnavailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUnavailableException) GoString() string {
	return s.String()
}

func newErrorServiceUnavailableException(v protocol.ResponseMetadata) error {
	return &ServiceUnavailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceUnavailableException) Code() string {
	return "ServiceUnavailableException"
}

// Message returns the exception's message.
func (s *ServiceUnavailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceUnavailableException) OrigErr() error {
	return nil
}

func (s *ServiceUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceUnavailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceUnavailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

type StartMeetingTranscriptionInput struct {
	_ struct{} `type:"structure"`

	// The unique ID of the meeting being transcribed.
	//
	// MeetingId is a required field
	MeetingId *string `location:"uri" locationName:"MeetingId" type:"string" required:"true"`

	// The configuration for the current transcription operation. Must contain EngineTranscribeSettings
	// or EngineTranscribeMedicalSettings.
	//
	// TranscriptionConfiguration is a required field
	TranscriptionConfiguration *TranscriptionConfiguration `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartMeetingTranscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartMeetingTranscriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartMeetingTranscriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartMeetingTranscriptionInput"}
	if s.MeetingId == nil {
		invalidParams.Add(request.NewErrParamRequired("MeetingId"))
	}
	if s.MeetingId != nil && len(*s.MeetingId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeetingId", 1))
	}
	if s.TranscriptionConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("TranscriptionConfiguration"))
	}
	if s.TranscriptionConfiguration != nil {
		if err := s.TranscriptionConfiguration.Validate(); err != nil {
			invalidParams.AddNested("TranscriptionConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMeetingId sets the MeetingId field's value.
func (s *StartMeetingTranscriptionInput) SetMeetingId(v string) *StartMeetingTranscriptionInput {
	s.MeetingId = &v
	return s
}

// SetTranscriptionConfiguration sets the TranscriptionConfiguration field's value.
func (s *StartMeetingTranscriptionInput) SetTranscriptionConfiguration(v *TranscriptionConfiguration) *StartMeetingTranscriptionInput {
	s.TranscriptionConfiguration = v
	return s
}

type StartMeetingTranscriptionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartMeetingTranscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartMeetingTranscriptionOutput) GoString() string {
	return s.String()
}

type StopMeetingTranscriptionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique ID of the meeting for which you stop transcription.
	//
	// MeetingId is a required field
	MeetingId *string `location:"uri" locationName:"MeetingId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopMeetingTranscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopMeetingTranscriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopMeetingTranscriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopMeetingTranscriptionInput"}
	if s.MeetingId == nil {
		invalidParams.Add(request.NewErrParamRequired("MeetingId"))
	}
	if s.MeetingId != nil && len(*s.MeetingId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeetingId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMeetingId sets the MeetingId field's value.
func (s *StopMeetingTranscriptionInput) SetMeetingId(v string) *StopMeetingTranscriptionInput {
	s.MeetingId = &v
	return s
}

type StopMeetingTranscriptionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopMeetingTranscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopMeetingTranscriptionOutput) GoString() string {
	return s.String()
}

// A key-value pair that you define.
type Tag struct {
	_ struct{} `type:"structure"`

	// The tag's key.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The tag's value.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// Lists the requested tags.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *TagResourceInput) SetResourceARN(v string) *TagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The number of customer requests exceeds the request rate limit.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string"`

	Message_ *string `locationName:"Message" type:"string"`

	// The ID of the request that exceeded the throttling limit.
	RequestId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Too many tags were added to the specified resource.
type TooManyTagsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string"`

	Message_ *string `locationName:"Message" type:"string"`

	// The ID of the request that contains too many tags.
	RequestId *string `type:"string"`

	// The name of the resource that received too many tags.
	ResourceName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyTagsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyTagsException) GoString() string {
	return s.String()
}

func newErrorTooManyTagsException(v protocol.ResponseMetadata) error {
	return &TooManyTagsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TooManyTagsException) Code() string {
	return "TooManyTagsException"
}

// Message returns the exception's message.
func (s *TooManyTagsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TooManyTagsException) OrigErr() error {
	return nil
}

func (s *TooManyTagsException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TooManyTagsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TooManyTagsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The configuration for the current transcription operation. Must contain EngineTranscribeSettings
// or EngineTranscribeMedicalSettings.
type TranscriptionConfiguration struct {
	_ struct{} `type:"structure"`

	// The transcription configuration settings passed to Amazon Transcribe Medical.
	EngineTranscribeMedicalSettings *EngineTranscribeMedicalSettings `type:"structure"`

	// The transcription configuration settings passed to Amazon Transcribe.
	EngineTranscribeSettings *EngineTranscribeSettings `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TranscriptionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TranscriptionConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TranscriptionConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TranscriptionConfiguration"}
	if s.EngineTranscribeMedicalSettings != nil {
		if err := s.EngineTranscribeMedicalSettings.Validate(); err != nil {
			invalidParams.AddNested("EngineTranscribeMedicalSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.EngineTranscribeSettings != nil {
		if err := s.EngineTranscribeSettings.Validate(); err != nil {
			invalidParams.AddNested("EngineTranscribeSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEngineTranscribeMedicalSettings sets the EngineTranscribeMedicalSettings field's value.
func (s *TranscriptionConfiguration) SetEngineTranscribeMedicalSettings(v *EngineTranscribeMedicalSettings) *TranscriptionConfiguration {
	s.EngineTranscribeMedicalSettings = v
	return s
}

// SetEngineTranscribeSettings sets the EngineTranscribeSettings field's value.
func (s *TranscriptionConfiguration) SetEngineTranscribeSettings(v *EngineTranscribeSettings) *TranscriptionConfiguration {
	s.EngineTranscribeSettings = v
	return s
}

// The user isn't authorized to request a resource.
type UnauthorizedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string"`

	Message_ *string `locationName:"Message" type:"string"`

	// The request id associated with the call responsible for the exception.
	RequestId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnauthorizedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnauthorizedException) GoString() string {
	return s.String()
}

func newErrorUnauthorizedException(v protocol.ResponseMetadata) error {
	return &UnauthorizedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnauthorizedException) Code() string {
	return "UnauthorizedException"
}

// Message returns the exception's message.
func (s *UnauthorizedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnauthorizedException) OrigErr() error {
	return nil
}

func (s *UnauthorizedException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnauthorizedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnauthorizedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request was well-formed but was unable to be followed due to semantic
// errors.
type UnprocessableEntityException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string"`

	Message_ *string `locationName:"Message" type:"string"`

	// The request id associated with the call responsible for the exception.
	RequestId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnprocessableEntityException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnprocessableEntityException) GoString() string {
	return s.String()
}

func newErrorUnprocessableEntityException(v protocol.ResponseMetadata) error {
	return &UnprocessableEntityException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnprocessableEntityException) Code() string {
	return "UnprocessableEntityException"
}

// Message returns the exception's message.
func (s *UnprocessableEntityException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnprocessableEntityException) OrigErr() error {
	return nil
}

func (s *UnprocessableEntityException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnprocessableEntityException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnprocessableEntityException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource that you're removing tags from.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// The tag keys being removed from the resources.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *UntagResourceInput) SetResourceARN(v string) *UntagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateAttendeeCapabilitiesInput struct {
	_ struct{} `type:"structure"`

	// The ID of the attendee associated with the update request.
	//
	// AttendeeId is a required field
	AttendeeId *string `location:"uri" locationName:"AttendeeId" type:"string" required:"true"`

	// The capabilities that you want to update.
	//
	// Capabilities is a required field
	Capabilities *AttendeeCapabilities `type:"structure" required:"true"`

	// The ID of the meeting associated with the update request.
	//
	// MeetingId is a required field
	MeetingId *string `location:"uri" locationName:"MeetingId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAttendeeCapabilitiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAttendeeCapabilitiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAttendeeCapabilitiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAttendeeCapabilitiesInput"}
	if s.AttendeeId == nil {
		invalidParams.Add(request.NewErrParamRequired("AttendeeId"))
	}
	if s.AttendeeId != nil && len(*s.AttendeeId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AttendeeId", 1))
	}
	if s.Capabilities == nil {
		invalidParams.Add(request.NewErrParamRequired("Capabilities"))
	}
	if s.MeetingId == nil {
		invalidParams.Add(request.NewErrParamRequired("MeetingId"))
	}
	if s.MeetingId != nil && len(*s.MeetingId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeetingId", 1))
	}
	if s.Capabilities != nil {
		if err := s.Capabilities.Validate(); err != nil {
			invalidParams.AddNested("Capabilities", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttendeeId sets the AttendeeId field's value.
func (s *UpdateAttendeeCapabilitiesInput) SetAttendeeId(v string) *UpdateAttendeeCapabilitiesInput {
	s.AttendeeId = &v
	return s
}

// SetCapabilities sets the Capabilities field's value.
func (s *UpdateAttendeeCapabilitiesInput) SetCapabilities(v *AttendeeCapabilities) *UpdateAttendeeCapabilitiesInput {
	s.Capabilities = v
	return s
}

// SetMeetingId sets the MeetingId field's value.
func (s *UpdateAttendeeCapabilitiesInput) SetMeetingId(v string) *UpdateAttendeeCapabilitiesInput {
	s.MeetingId = &v
	return s
}

type UpdateAttendeeCapabilitiesOutput struct {
	_ struct{} `type:"structure"`

	// The updated attendee data.
	Attendee *Attendee `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAttendeeCapabilitiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAttendeeCapabilitiesOutput) GoString() string {
	return s.String()
}

// SetAttendee sets the Attendee field's value.
func (s *UpdateAttendeeCapabilitiesOutput) SetAttendee(v *Attendee) *UpdateAttendeeCapabilitiesOutput {
	s.Attendee = v
	return s
}

// The video features set for the meeting. Applies to all attendees.
//
// If you specify MeetingFeatures:Video:MaxResolution:None when you create a
// meeting, all API requests that include SendReceive, Send, or Receive for
// AttendeeCapabilities:Video will be rejected with ValidationError 400.
type VideoFeatures struct {
	_ struct{} `type:"structure"`

	// The maximum video resolution for the meeting. Applies to all attendees.
	//
	// Defaults to HD. To use FHD, you must also provide a MeetingFeatures:Attendee:MaxCount
	// value and override the default size limit of 250 attendees.
	MaxResolution *string `type:"string" enum:"VideoResolution"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VideoFeatures) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VideoFeatures) GoString() string {
	return s.String()
}

// SetMaxResolution sets the MaxResolution field's value.
func (s *VideoFeatures) SetMaxResolution(v string) *VideoFeatures {
	s.MaxResolution = &v
	return s
}

const (
	// ContentResolutionNone is a ContentResolution enum value
	ContentResolutionNone = "None"

	// ContentResolutionFhd is a ContentResolution enum value
	ContentResolutionFhd = "FHD"

	// ContentResolutionUhd is a ContentResolution enum value
	ContentResolutionUhd = "UHD"
)

// ContentResolution_Values returns all elements of the ContentResolution enum
func ContentResolution_Values() []string {
	return []string{
		ContentResolutionNone,
		ContentResolutionFhd,
		ContentResolutionUhd,
	}
}

const (
	// MediaCapabilitiesSendReceive is a MediaCapabilities enum value
	MediaCapabilitiesSendReceive = "SendReceive"

	// MediaCapabilitiesSend is a MediaCapabilities enum value
	MediaCapabilitiesSend = "Send"

	// MediaCapabilitiesReceive is a MediaCapabilities enum value
	MediaCapabilitiesReceive = "Receive"

	// MediaCapabilitiesNone is a MediaCapabilities enum value
	MediaCapabilitiesNone = "None"
)

// MediaCapabilities_Values returns all elements of the MediaCapabilities enum
func MediaCapabilities_Values() []string {
	return []string{
		MediaCapabilitiesSendReceive,
		MediaCapabilitiesSend,
		MediaCapabilitiesReceive,
		MediaCapabilitiesNone,
	}
}

const (
	// MeetingFeatureStatusAvailable is a MeetingFeatureStatus enum value
	MeetingFeatureStatusAvailable = "AVAILABLE"

	// MeetingFeatureStatusUnavailable is a MeetingFeatureStatus enum value
	MeetingFeatureStatusUnavailable = "UNAVAILABLE"
)

// MeetingFeatureStatus_Values returns all elements of the MeetingFeatureStatus enum
func MeetingFeatureStatus_Values() []string {
	return []string{
		MeetingFeatureStatusAvailable,
		MeetingFeatureStatusUnavailable,
	}
}

const (
	// TranscribeContentIdentificationTypePii is a TranscribeContentIdentificationType enum value
	TranscribeContentIdentificationTypePii = "PII"
)

// TranscribeContentIdentificationType_Values returns all elements of the TranscribeContentIdentificationType enum
func TranscribeContentIdentificationType_Values() []string {
	return []string{
		TranscribeContentIdentificationTypePii,
	}
}

const (
	// TranscribeContentRedactionTypePii is a TranscribeContentRedactionType enum value
	TranscribeContentRedactionTypePii = "PII"
)

// TranscribeContentRedactionType_Values returns all elements of the TranscribeContentRedactionType enum
func TranscribeContentRedactionType_Values() []string {
	return []string{
		TranscribeContentRedactionTypePii,
	}
}

const (
	// TranscribeLanguageCodeEnUs is a TranscribeLanguageCode enum value
	TranscribeLanguageCodeEnUs = "en-US"

	// TranscribeLanguageCodeEnGb is a TranscribeLanguageCode enum value
	TranscribeLanguageCodeEnGb = "en-GB"

	// TranscribeLanguageCodeEsUs is a TranscribeLanguageCode enum value
	TranscribeLanguageCodeEsUs = "es-US"

	// TranscribeLanguageCodeFrCa is a TranscribeLanguageCode enum value
	TranscribeLanguageCodeFrCa = "fr-CA"

	// TranscribeLanguageCodeFrFr is a TranscribeLanguageCode enum value
	TranscribeLanguageCodeFrFr = "fr-FR"

	// TranscribeLanguageCodeEnAu is a TranscribeLanguageCode enum value
	TranscribeLanguageCodeEnAu = "en-AU"

	// TranscribeLanguageCodeItIt is a TranscribeLanguageCode enum value
	TranscribeLanguageCodeItIt = "it-IT"

	// TranscribeLanguageCodeDeDe is a TranscribeLanguageCode enum value
	TranscribeLanguageCodeDeDe = "de-DE"

	// TranscribeLanguageCodePtBr is a TranscribeLanguageCode enum value
	TranscribeLanguageCodePtBr = "pt-BR"

	// TranscribeLanguageCodeJaJp is a TranscribeLanguageCode enum value
	TranscribeLanguageCodeJaJp = "ja-JP"

	// TranscribeLanguageCodeKoKr is a TranscribeLanguageCode enum value
	TranscribeLanguageCodeKoKr = "ko-KR"

	// TranscribeLanguageCodeZhCn is a TranscribeLanguageCode enum value
	TranscribeLanguageCodeZhCn = "zh-CN"

	// TranscribeLanguageCodeThTh is a TranscribeLanguageCode enum value
	TranscribeLanguageCodeThTh = "th-TH"

	// TranscribeLanguageCodeHiIn is a TranscribeLanguageCode enum value
	TranscribeLanguageCodeHiIn = "hi-IN"
)

// TranscribeLanguageCode_Values returns all elements of the TranscribeLanguageCode enum
func TranscribeLanguageCode_Values() []string {
	return []string{
		TranscribeLanguageCodeEnUs,
		TranscribeLanguageCodeEnGb,
		TranscribeLanguageCodeEsUs,
		TranscribeLanguageCodeFrCa,
		TranscribeLanguageCodeFrFr,
		TranscribeLanguageCodeEnAu,
		TranscribeLanguageCodeItIt,
		TranscribeLanguageCodeDeDe,
		TranscribeLanguageCodePtBr,
		TranscribeLanguageCodeJaJp,
		TranscribeLanguageCodeKoKr,
		TranscribeLanguageCodeZhCn,
		TranscribeLanguageCodeThTh,
		TranscribeLanguageCodeHiIn,
	}
}

const (
	// TranscribeMedicalContentIdentificationTypePhi is a TranscribeMedicalContentIdentificationType enum value
	TranscribeMedicalContentIdentificationTypePhi = "PHI"
)

// TranscribeMedicalContentIdentificationType_Values returns all elements of the TranscribeMedicalContentIdentificationType enum
func TranscribeMedicalContentIdentificationType_Values() []string {
	return []string{
		TranscribeMedicalContentIdentificationTypePhi,
	}
}

const (
	// TranscribeMedicalLanguageCodeEnUs is a TranscribeMedicalLanguageCode enum value
	TranscribeMedicalLanguageCodeEnUs = "en-US"
)

// TranscribeMedicalLanguageCode_Values returns all elements of the TranscribeMedicalLanguageCode enum
func TranscribeMedicalLanguageCode_Values() []string {
	return []string{
		TranscribeMedicalLanguageCodeEnUs,
	}
}

const (
	// TranscribeMedicalRegionUsEast1 is a TranscribeMedicalRegion enum value
	TranscribeMedicalRegionUsEast1 = "us-east-1"

	// TranscribeMedicalRegionUsEast2 is a TranscribeMedicalRegion enum value
	TranscribeMedicalRegionUsEast2 = "us-east-2"

	// TranscribeMedicalRegionUsWest2 is a TranscribeMedicalRegion enum value
	TranscribeMedicalRegionUsWest2 = "us-west-2"

	// TranscribeMedicalRegionApSoutheast2 is a TranscribeMedicalRegion enum value
	TranscribeMedicalRegionApSoutheast2 = "ap-southeast-2"

	// TranscribeMedicalRegionCaCentral1 is a TranscribeMedicalRegion enum value
	TranscribeMedicalRegionCaCentral1 = "ca-central-1"

	// TranscribeMedicalRegionEuWest1 is a TranscribeMedicalRegion enum value
	TranscribeMedicalRegionEuWest1 = "eu-west-1"

	// TranscribeMedicalRegionAuto is a TranscribeMedicalRegion enum value
	TranscribeMedicalRegionAuto = "auto"
)

// TranscribeMedicalRegion_Values returns all elements of the TranscribeMedicalRegion enum
func TranscribeMedicalRegion_Values() []string {
	return []string{
		TranscribeMedicalRegionUsEast1,
		TranscribeMedicalRegionUsEast2,
		TranscribeMedicalRegionUsWest2,
		TranscribeMedicalRegionApSoutheast2,
		TranscribeMedicalRegionCaCentral1,
		TranscribeMedicalRegionEuWest1,
		TranscribeMedicalRegionAuto,
	}
}

const (
	// TranscribeMedicalSpecialtyPrimarycare is a TranscribeMedicalSpecialty enum value
	TranscribeMedicalSpecialtyPrimarycare = "PRIMARYCARE"

	// TranscribeMedicalSpecialtyCardiology is a TranscribeMedicalSpecialty enum value
	TranscribeMedicalSpecialtyCardiology = "CARDIOLOGY"

	// TranscribeMedicalSpecialtyNeurology is a TranscribeMedicalSpecialty enum value
	TranscribeMedicalSpecialtyNeurology = "NEUROLOGY"

	// TranscribeMedicalSpecialtyOncology is a TranscribeMedicalSpecialty enum value
	TranscribeMedicalSpecialtyOncology = "ONCOLOGY"

	// TranscribeMedicalSpecialtyRadiology is a TranscribeMedicalSpecialty enum value
	TranscribeMedicalSpecialtyRadiology = "RADIOLOGY"

	// TranscribeMedicalSpecialtyUrology is a TranscribeMedicalSpecialty enum value
	TranscribeMedicalSpecialtyUrology = "UROLOGY"
)

// TranscribeMedicalSpecialty_Values returns all elements of the TranscribeMedicalSpecialty enum
func TranscribeMedicalSpecialty_Values() []string {
	return []string{
		TranscribeMedicalSpecialtyPrimarycare,
		TranscribeMedicalSpecialtyCardiology,
		TranscribeMedicalSpecialtyNeurology,
		TranscribeMedicalSpecialtyOncology,
		TranscribeMedicalSpecialtyRadiology,
		TranscribeMedicalSpecialtyUrology,
	}
}

const (
	// TranscribeMedicalTypeConversation is a TranscribeMedicalType enum value
	TranscribeMedicalTypeConversation = "CONVERSATION"

	// TranscribeMedicalTypeDictation is a TranscribeMedicalType enum value
	TranscribeMedicalTypeDictation = "DICTATION"
)

// TranscribeMedicalType_Values returns all elements of the TranscribeMedicalType enum
func TranscribeMedicalType_Values() []string {
	return []string{
		TranscribeMedicalTypeConversation,
		TranscribeMedicalTypeDictation,
	}
}

const (
	// TranscribePartialResultsStabilityLow is a TranscribePartialResultsStability enum value
	TranscribePartialResultsStabilityLow = "low"

	// TranscribePartialResultsStabilityMedium is a TranscribePartialResultsStability enum value
	TranscribePartialResultsStabilityMedium = "medium"

	// TranscribePartialResultsStabilityHigh is a TranscribePartialResultsStability enum value
	TranscribePartialResultsStabilityHigh = "high"
)

// TranscribePartialResultsStability_Values returns all elements of the TranscribePartialResultsStability enum
func TranscribePartialResultsStability_Values() []string {
	return []string{
		TranscribePartialResultsStabilityLow,
		TranscribePartialResultsStabilityMedium,
		TranscribePartialResultsStabilityHigh,
	}
}

const (
	// TranscribeRegionUsEast2 is a TranscribeRegion enum value
	TranscribeRegionUsEast2 = "us-east-2"

	// TranscribeRegionUsEast1 is a TranscribeRegion enum value
	TranscribeRegionUsEast1 = "us-east-1"

	// TranscribeRegionUsWest2 is a TranscribeRegion enum value
	TranscribeRegionUsWest2 = "us-west-2"

	// TranscribeRegionApNortheast2 is a TranscribeRegion enum value
	TranscribeRegionApNortheast2 = "ap-northeast-2"

	// TranscribeRegionApSoutheast2 is a TranscribeRegion enum value
	TranscribeRegionApSoutheast2 = "ap-southeast-2"

	// TranscribeRegionApNortheast1 is a TranscribeRegion enum value
	TranscribeRegionApNortheast1 = "ap-northeast-1"

	// TranscribeRegionCaCentral1 is a TranscribeRegion enum value
	TranscribeRegionCaCentral1 = "ca-central-1"

	// TranscribeRegionEuCentral1 is a TranscribeRegion enum value
	TranscribeRegionEuCentral1 = "eu-central-1"

	// TranscribeRegionEuWest1 is a TranscribeRegion enum value
	TranscribeRegionEuWest1 = "eu-west-1"

	// TranscribeRegionEuWest2 is a TranscribeRegion enum value
	TranscribeRegionEuWest2 = "eu-west-2"

	// TranscribeRegionSaEast1 is a TranscribeRegion enum value
	TranscribeRegionSaEast1 = "sa-east-1"

	// TranscribeRegionAuto is a TranscribeRegion enum value
	TranscribeRegionAuto = "auto"

	// TranscribeRegionUsGovWest1 is a TranscribeRegion enum value
	TranscribeRegionUsGovWest1 = "us-gov-west-1"
)

// TranscribeRegion_Values returns all elements of the TranscribeRegion enum
func TranscribeRegion_Values() []string {
	return []string{
		TranscribeRegionUsEast2,
		TranscribeRegionUsEast1,
		TranscribeRegionUsWest2,
		TranscribeRegionApNortheast2,
		TranscribeRegionApSoutheast2,
		TranscribeRegionApNortheast1,
		TranscribeRegionCaCentral1,
		TranscribeRegionEuCentral1,
		TranscribeRegionEuWest1,
		TranscribeRegionEuWest2,
		TranscribeRegionSaEast1,
		TranscribeRegionAuto,
		TranscribeRegionUsGovWest1,
	}
}

const (
	// TranscribeVocabularyFilterMethodRemove is a TranscribeVocabularyFilterMethod enum value
	TranscribeVocabularyFilterMethodRemove = "remove"

	// TranscribeVocabularyFilterMethodMask is a TranscribeVocabularyFilterMethod enum value
	TranscribeVocabularyFilterMethodMask = "mask"

	// TranscribeVocabularyFilterMethodTag is a TranscribeVocabularyFilterMethod enum value
	TranscribeVocabularyFilterMethodTag = "tag"
)

// TranscribeVocabularyFilterMethod_Values returns all elements of the TranscribeVocabularyFilterMethod enum
func TranscribeVocabularyFilterMethod_Values() []string {
	return []string{
		TranscribeVocabularyFilterMethodRemove,
		TranscribeVocabularyFilterMethodMask,
		TranscribeVocabularyFilterMethodTag,
	}
}

const (
	// VideoResolutionNone is a VideoResolution enum value
	VideoResolutionNone = "None"

	// VideoResolutionHd is a VideoResolution enum value
	VideoResolutionHd = "HD"

	// VideoResolutionFhd is a VideoResolution enum value
	VideoResolutionFhd = "FHD"
)

// VideoResolution_Values returns all elements of the VideoResolution enum
func VideoResolution_Values() []string {
	return []string{
		VideoResolutionNone,
		VideoResolutionHd,
		VideoResolutionFhd,
	}
}
