/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.declarations.comparators;

import java.util.Comparator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirReceiverParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.comparators.FirMemberDeclarationComparator;
import org.jetbrains.kotlin.fir.declarations.comparators.FirTypeParameterRefComparator;
import org.jetbrains.kotlin.fir.declarations.comparators.FirValueParameterComparator;
import org.jetbrains.kotlin.fir.types.FirTypeRefComparator;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/fir/declarations/comparators/FirCallableDeclarationComparator;", "Ljava/util/Comparator;", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "Lkotlin/Comparator;", "<init>", "()V", "compare", "", "a", "b", "tree"})
public final class FirCallableDeclarationComparator
implements Comparator<FirCallableDeclaration> {
    @NotNull
    public static final FirCallableDeclarationComparator INSTANCE = new FirCallableDeclarationComparator();

    private FirCallableDeclarationComparator() {
    }

    @Override
    public int compare(@NotNull FirCallableDeclaration a2, @NotNull FirCallableDeclaration b2) {
        int typeParameterSizeDiff;
        int returnTypeDiff;
        Intrinsics.checkNotNullParameter((Object)a2, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b2, (String)"b");
        int typeAndNameDiff = FirMemberDeclarationComparator.TypeAndNameComparator.INSTANCE.compare(a2, b2);
        if (typeAndNameDiff != 0) {
            return typeAndNameDiff;
        }
        FirReceiverParameter aReceiver = a2.getReceiverParameter();
        FirReceiverParameter bReceiver = b2.getReceiverParameter();
        if (aReceiver != null || bReceiver != null) {
            boolean bl;
            int bHasReceiverType;
            int aHasReceiverType = aReceiver != null ? 1 : 0;
            int receiverTypePresenceDiff = aHasReceiverType - (bHasReceiverType = bReceiver != null ? 1 : 0);
            if (receiverTypePresenceDiff != 0) {
                return receiverTypePresenceDiff;
            }
            boolean bl2 = bl = aReceiver != null && bReceiver != null;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
        }
        if ((returnTypeDiff = FirTypeRefComparator.INSTANCE.compare(a2.getReturnTypeRef(), b2.getReturnTypeRef())) != 0) {
            return returnTypeDiff;
        }
        if (a2 instanceof FirFunction) {
            if (!(b2 instanceof FirFunction)) {
                boolean bl = false;
                String string = "TypeAndNameComparator is inconsistent: " + UtilsKt.render(a2) + " v.s. " + UtilsKt.render(b2);
                throw new IllegalArgumentException(string.toString());
            }
            int valueParameterSizeDiff = ((FirFunction)a2).getValueParameters().size() - ((FirFunction)b2).getValueParameters().size();
            if (valueParameterSizeDiff != 0) {
                return valueParameterSizeDiff;
            }
            for (Pair pair : CollectionsKt.zip((Iterable)((FirFunction)a2).getValueParameters(), (Iterable)((FirFunction)b2).getValueParameters())) {
                FirValueParameter bValueParameter;
                FirValueParameter aValueParameter = (FirValueParameter)pair.component1();
                int valueParameterDiff = FirValueParameterComparator.INSTANCE.compare(aValueParameter, bValueParameter = (FirValueParameter)pair.component2());
                if (valueParameterDiff == 0) continue;
                return valueParameterDiff;
            }
        }
        if ((typeParameterSizeDiff = a2.getTypeParameters().size() - b2.getTypeParameters().size()) != 0) {
            return typeParameterSizeDiff;
        }
        for (Pair pair : CollectionsKt.zip((Iterable)a2.getTypeParameters(), (Iterable)b2.getTypeParameters())) {
            FirTypeParameterRef bTypeParameter;
            FirTypeParameterRef aTypeParameter = (FirTypeParameterRef)pair.component1();
            int typeParameterDiff = FirTypeParameterRefComparator.INSTANCE.compare(aTypeParameter, bTypeParameter = (FirTypeParameterRef)pair.component2());
            if (typeParameterDiff == 0) continue;
            return typeParameterDiff;
        }
        return a2.getSymbol().getCallableId().getPackageName().asString().compareTo(b2.getSymbol().getCallableId().getPackageName().asString());
    }
}

