/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.message.control;

import org.jupnp.model.action.ActionException;
import org.jupnp.model.message.StreamRequestMessage;
import org.jupnp.model.message.control.ActionRequestMessage;
import org.jupnp.model.message.header.SoapActionHeader;
import org.jupnp.model.message.header.UpnpHeader;
import org.jupnp.model.meta.Action;
import org.jupnp.model.meta.LocalService;
import org.jupnp.model.types.ErrorCode;
import org.jupnp.model.types.SoapActionType;

public class IncomingActionRequestMessage
extends StreamRequestMessage
implements ActionRequestMessage {
    private final Action action;
    private final String actionNamespace;

    public IncomingActionRequestMessage(StreamRequestMessage source, LocalService service) throws ActionException {
        super(source);
        SoapActionHeader soapActionHeader = this.getHeaders().getFirstHeader(UpnpHeader.Type.SOAPACTION, SoapActionHeader.class);
        if (soapActionHeader == null) {
            throw new ActionException(ErrorCode.INVALID_ACTION, "Missing SOAP action header");
        }
        SoapActionType actionType = (SoapActionType)soapActionHeader.getValue();
        this.action = service.getAction(actionType.getActionName());
        if (this.action == null) {
            throw new ActionException(ErrorCode.INVALID_ACTION, "Service doesn't implement action: " + actionType.getActionName());
        }
        if (!"QueryStateVariable".equals(actionType.getActionName()) && !service.getServiceType().implementsVersion(actionType.getServiceType())) {
            throw new ActionException(ErrorCode.INVALID_ACTION, "Service doesn't support the requested service version");
        }
        this.actionNamespace = actionType.getTypeString();
    }

    public Action getAction() {
        return this.action;
    }

    @Override
    public String getActionNamespace() {
        return this.actionNamespace;
    }
}

