/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.testng.ITestNGMethod;
import org.testng.TL;
import org.testng.TestRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reporter {
    private static ITestNGMethod m_currentMethod = null;
    private static TL m_localResult = new TL();
    private static Map<ITestNGMethod, List<Integer>> m_methodOutputMap = new HashMap<ITestNGMethod, List<Integer>>();

    public static synchronized void setCurrentMethod(ITestNGMethod m) {
        m_currentMethod = m;
    }

    public static List<String> getOutput() {
        return Reporter.m_localResult.m_output;
    }

    private static void log(String s, ITestNGMethod m) {
        int n = Reporter.getOutput().size();
        List<Integer> lines = m_methodOutputMap.get(m);
        if (lines == null) {
            lines = new ArrayList<Integer>();
            m_methodOutputMap.put(m, lines);
        }
        lines.add(n);
        m_methodOutputMap.put(m, lines);
        Reporter.getOutput().add(s);
    }

    public static void log(String s) {
        Reporter.log(s, Reporter.getCurrentMethod());
    }

    public static void log(String s, int level, boolean logToStandardOut) {
        if (TestRunner.getVerbose() >= level) {
            Reporter.log(s, Reporter.getCurrentMethod());
            if (logToStandardOut) {
                System.out.println(s);
            }
        }
    }

    public static void log(String s, boolean logToStandardOut) {
        Reporter.log(s, Reporter.getCurrentMethod());
        if (logToStandardOut) {
            System.out.println(s);
        }
    }

    public static void log(String s, int level) {
        if (TestRunner.getVerbose() >= level) {
            Reporter.log(s, Reporter.getCurrentMethod());
        }
    }

    private static ITestNGMethod getCurrentMethod() {
        return m_currentMethod;
    }

    private static void ppp(String s) {
        System.out.println("[Reporter] " + s);
    }

    public static List<String> getOutput(ITestNGMethod method) {
        ArrayList<String> result = new ArrayList<String>();
        List<Integer> lines = m_methodOutputMap.get(method);
        if (lines != null) {
            for (Integer n : lines) {
                result.add(Reporter.getOutput().get(n));
            }
        }
        return result;
    }
}

