import _defineProperty from "@babel/runtime/helpers/defineProperty";
import { useMemo } from 'react';
/**
 * Private symbol that is intentionally not exported from this file.
 */
var privateKey = Symbol('DroppableData');

/**
 * Data that is attached to drags.
 */

/**
 * Checks if the passed data satisfies `DroppableData` using the private symbol.
 */
export function isDroppableData(data) {
  return data[privateKey] === true;
}

/**
 * Adds the private symbol to the passed data.
 *
 * The symbol allows us to quickly check if an object satisfies `DroppableData`.
 */
export function useDroppableData(_ref) {
  var contextId = _ref.contextId,
    droppableId = _ref.droppableId,
    getIsDropDisabled = _ref.getIsDropDisabled;
  return useMemo(function () {
    return _defineProperty(_defineProperty(_defineProperty(_defineProperty({}, privateKey, true), "contextId", contextId), "droppableId", droppableId), "getIsDropDisabled", getIsDropDisabled);
  }, [contextId, droppableId, getIsDropDisabled]);
}