import _extends from "@babel/runtime/helpers/extends";
import React, { forwardRef, memo, useMemo } from 'react';
import { useDragDropContext } from '../drag-drop-context/internal-context';
import { useDraggableDimensions } from '../hooks/use-captured-dimensions';
import { attributes } from '../utils/attributes';
export const Placeholder = /*#__PURE__*/memo( /*#__PURE__*/forwardRef(function Placeholder({
  style: styleProp
}, ref) {
  const dimensions = useDraggableDimensions();
  const {
    contextId
  } = useDragDropContext();
  const dataAttributes = {
    [attributes.placeholder.contextId]: contextId
  };
  const style = useMemo(() => {
    if (!dimensions) {
      return;
    }
    const {
      margin,
      rect
    } = dimensions;
    return {
      boxSizing: 'border-box',
      width: rect.width,
      height: rect.height,
      margin: margin,
      ...styleProp
    };
  }, [dimensions, styleProp]);

  // eslint-disable-next-line @atlaskit/ui-styling-standard/enforce-style-prop -- Ignored via go/DSP-18766
  return /*#__PURE__*/React.createElement("div", _extends({
    ref: ref,
    style: style
  }, dataAttributes));
}));