// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: BUSL-1.1

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.33.0
// 	protoc        (unknown)
// source: private/pbpeering/peering.proto

package pbpeering

import (
	_ "github.com/hashicorp/consul/proto-public/annotations/ratelimit"
	pbcommon "github.com/hashicorp/consul/proto/private/pbcommon"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// PeeringState enumerates all the states a peering can be in.
type PeeringState int32

const (
	// Undefined represents an unset value for PeeringState during
	// writes.
	PeeringState_UNDEFINED PeeringState = 0
	// Pending means the peering was created by generating a peering token.
	// Peerings stay in a pending state until the peer uses the token to dial
	// the local cluster.
	PeeringState_PENDING PeeringState = 1
	// Establishing means the peering is being established from a peering token.
	// This is the initial state for dialing peers.
	PeeringState_ESTABLISHING PeeringState = 2
	// Active means that the peering connection is active and healthy.
	PeeringState_ACTIVE PeeringState = 3
	// Failing means the peering connection has been interrupted but has not yet
	// been terminated.
	PeeringState_FAILING PeeringState = 4
	// Deleting means a peering was marked for deletion and is in the process
	// of being deleted.
	PeeringState_DELETING PeeringState = 5
	// Terminated means the peering relationship has been removed.
	PeeringState_TERMINATED PeeringState = 6
)

// Enum value maps for PeeringState.
var (
	PeeringState_name = map[int32]string{
		0: "UNDEFINED",
		1: "PENDING",
		2: "ESTABLISHING",
		3: "ACTIVE",
		4: "FAILING",
		5: "DELETING",
		6: "TERMINATED",
	}
	PeeringState_value = map[string]int32{
		"UNDEFINED":    0,
		"PENDING":      1,
		"ESTABLISHING": 2,
		"ACTIVE":       3,
		"FAILING":      4,
		"DELETING":     5,
		"TERMINATED":   6,
	}
)

func (x PeeringState) Enum() *PeeringState {
	p := new(PeeringState)
	*p = x
	return p
}

func (x PeeringState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PeeringState) Descriptor() protoreflect.EnumDescriptor {
	return file_private_pbpeering_peering_proto_enumTypes[0].Descriptor()
}

func (PeeringState) Type() protoreflect.EnumType {
	return &file_private_pbpeering_peering_proto_enumTypes[0]
}

func (x PeeringState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PeeringState.Descriptor instead.
func (PeeringState) EnumDescriptor() ([]byte, []int) {
	return file_private_pbpeering_peering_proto_rawDescGZIP(), []int{0}
}

// SecretsWriteRequest encodes a request to write a peering secret as the result
// of some operation. Different operations, such as generating a peering token,
// lead to modifying the known secrets associated with a peering.
type SecretsWriteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// PeerID is the local UUID of the peering this request applies to.
	PeerID string `protobuf:"bytes,1,opt,name=PeerID,proto3" json:"PeerID,omitempty"`
	// Types that are assignable to Request:
	//
	//	*SecretsWriteRequest_GenerateToken
	//	*SecretsWriteRequest_ExchangeSecret
	//	*SecretsWriteRequest_PromotePending
	//	*SecretsWriteRequest_Establish
	Request isSecretsWriteRequest_Request `protobuf_oneof:"Request"`
}

func (x *SecretsWriteRequest) Reset() {
	*x = SecretsWriteRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbpeering_peering_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SecretsWriteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SecretsWriteRequest) ProtoMessage() {}

func (x *SecretsWriteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbpeering_peering_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SecretsWriteRequest.ProtoReflect.Descriptor instead.
func (*SecretsWriteRequest) Descriptor() ([]byte, []int) {
	return file_private_pbpeering_peering_proto_rawDescGZIP(), []int{0}
}

func (x *SecretsWriteRequest) GetPeerID() string {
	if x != nil {
		return x.PeerID
	}
	return ""
}

func (m *SecretsWriteRequest) GetRequest() isSecretsWriteRequest_Request {
	if m != nil {
		return m.Request
	}
	return nil
}

func (x *SecretsWriteRequest) GetGenerateToken() *SecretsWriteRequest_GenerateTokenRequest {
	if x, ok := x.GetRequest().(*SecretsWriteRequest_GenerateToken); ok {
		return x.GenerateToken
	}
	return nil
}

func (x *SecretsWriteRequest) GetExchangeSecret() *SecretsWriteRequest_ExchangeSecretRequest {
	if x, ok := x.GetRequest().(*SecretsWriteRequest_ExchangeSecret); ok {
		return x.ExchangeSecret
	}
	return nil
}

func (x *SecretsWriteRequest) GetPromotePending() *SecretsWriteRequest_PromotePendingRequest {
	if x, ok := x.GetRequest().(*SecretsWriteRequest_PromotePending); ok {
		return x.PromotePending
	}
	return nil
}

func (x *SecretsWriteRequest) GetEstablish() *SecretsWriteRequest_EstablishRequest {
	if x, ok := x.GetRequest().(*SecretsWriteRequest_Establish); ok {
		return x.Establish
	}
	return nil
}

type isSecretsWriteRequest_Request interface {
	isSecretsWriteRequest_Request()
}

type SecretsWriteRequest_GenerateToken struct {
	GenerateToken *SecretsWriteRequest_GenerateTokenRequest `protobuf:"bytes,2,opt,name=generate_token,json=generateToken,proto3,oneof"`
}

type SecretsWriteRequest_ExchangeSecret struct {
	ExchangeSecret *SecretsWriteRequest_ExchangeSecretRequest `protobuf:"bytes,3,opt,name=exchange_secret,json=exchangeSecret,proto3,oneof"`
}

type SecretsWriteRequest_PromotePending struct {
	PromotePending *SecretsWriteRequest_PromotePendingRequest `protobuf:"bytes,4,opt,name=promote_pending,json=promotePending,proto3,oneof"`
}

type SecretsWriteRequest_Establish struct {
	Establish *SecretsWriteRequest_EstablishRequest `protobuf:"bytes,5,opt,name=establish,proto3,oneof"`
}

func (*SecretsWriteRequest_GenerateToken) isSecretsWriteRequest_Request() {}

func (*SecretsWriteRequest_ExchangeSecret) isSecretsWriteRequest_Request() {}

func (*SecretsWriteRequest_PromotePending) isSecretsWriteRequest_Request() {}

func (*SecretsWriteRequest_Establish) isSecretsWriteRequest_Request() {}

// PeeringSecrets defines a secret used for authenticating/authorizing peer clusters.
type PeeringSecrets struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// PeerID is the local UUID of the peering this secret was generated for.
	PeerID        string                        `protobuf:"bytes,1,opt,name=PeerID,proto3" json:"PeerID,omitempty"`
	Establishment *PeeringSecrets_Establishment `protobuf:"bytes,2,opt,name=establishment,proto3" json:"establishment,omitempty"`
	Stream        *PeeringSecrets_Stream        `protobuf:"bytes,3,opt,name=stream,proto3" json:"stream,omitempty"`
}

func (x *PeeringSecrets) Reset() {
	*x = PeeringSecrets{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbpeering_peering_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PeeringSecrets) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PeeringSecrets) ProtoMessage() {}

func (x *PeeringSecrets) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbpeering_peering_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PeeringSecrets.ProtoReflect.Descriptor instead.
func (*PeeringSecrets) Descriptor() ([]byte, []int) {
	return file_private_pbpeering_peering_proto_rawDescGZIP(), []int{1}
}

func (x *PeeringSecrets) GetPeerID() string {
	if x != nil {
		return x.PeerID
	}
	return ""
}

func (x *PeeringSecrets) GetEstablishment() *PeeringSecrets_Establishment {
	if x != nil {
		return x.Establishment
	}
	return nil
}

func (x *PeeringSecrets) GetStream() *PeeringSecrets_Stream {
	if x != nil {
		return x.Stream
	}
	return nil
}

// Peering defines a peering relationship between two disparate Consul clusters
//
// mog annotation:
//
// target=github.com/hashicorp/consul/api.Peering
// output=peering.gen.go
// name=API
type Peering struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID is a datacenter-scoped UUID for the peering.
	// The ID is generated when a peering is first written to the state store.
	ID string `protobuf:"bytes,1,opt,name=ID,proto3" json:"ID,omitempty"`
	// Name is the local alias for the peering relationship.
	Name string `protobuf:"bytes,2,opt,name=Name,proto3" json:"Name,omitempty"`
	// Partition is the local partition connecting to the peer.
	Partition string `protobuf:"bytes,3,opt,name=Partition,proto3" json:"Partition,omitempty"`
	// DeletedAt is the time when the Peering was marked for deletion
	// This is nullable so that we can omit if empty when encoding in JSON
	// mog: func-to=TimePtrFromProto func-from=TimePtrToProto
	DeletedAt *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=DeletedAt,proto3" json:"DeletedAt,omitempty"`
	// Meta is a mapping of some string value to any other string value
	Meta map[string]string `protobuf:"bytes,5,rep,name=Meta,proto3" json:"Meta,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// State is one of the valid PeeringState values to represent the status of
	// peering relationship.
	//
	// mog: func-to=PeeringStateToAPI func-from=PeeringStateFromAPI
	State PeeringState `protobuf:"varint,6,opt,name=State,proto3,enum=hashicorp.consul.internal.peering.PeeringState" json:"State,omitempty"`
	// PeerID is the ID that our peer assigned to this peering.
	// This ID is to be used when dialing the peer, so that it can know who dialed it.
	PeerID string `protobuf:"bytes,7,opt,name=PeerID,proto3" json:"PeerID,omitempty"`
	// PeerCAPems contains all the CA certificates for the remote peer.
	PeerCAPems []string `protobuf:"bytes,8,rep,name=PeerCAPems,proto3" json:"PeerCAPems,omitempty"`
	// PeerServerName is the name of the remote server as it relates to TLS.
	PeerServerName string `protobuf:"bytes,9,opt,name=PeerServerName,proto3" json:"PeerServerName,omitempty"`
	// PeerServerAddresses contains all the connection addresses for the remote peer.
	PeerServerAddresses []string `protobuf:"bytes,10,rep,name=PeerServerAddresses,proto3" json:"PeerServerAddresses,omitempty"`
	// StreamStatus contains information computed on read based on the state of the stream.
	//
	// mog: func-to=StreamStatusToAPI func-from=StreamStatusFromAPI
	StreamStatus *StreamStatus `protobuf:"bytes,13,opt,name=StreamStatus,proto3" json:"StreamStatus,omitempty"`
	// CreateIndex is the Raft index at which the Peering was created.
	// @gotags: bexpr:"-"
	CreateIndex uint64 `protobuf:"varint,11,opt,name=CreateIndex,proto3" json:"CreateIndex,omitempty" bexpr:"-"`
	// ModifyIndex is the latest Raft index at which the Peering. was modified.
	// @gotags: bexpr:"-"
	ModifyIndex uint64 `protobuf:"varint,12,opt,name=ModifyIndex,proto3" json:"ModifyIndex,omitempty" bexpr:"-"`
	// Remote contains metadata about the remote peer.
	Remote *RemoteInfo `protobuf:"bytes,17,opt,name=Remote,proto3" json:"Remote,omitempty"`
	// ManualServerAddresses provides a list of manually specified server addresses from the
	// user. If this is defined, then the automatic PeerServerAddresses are ignored.
	ManualServerAddresses []string `protobuf:"bytes,18,rep,name=ManualServerAddresses,proto3" json:"ManualServerAddresses,omitempty"`
}

func (x *Peering) Reset() {
	*x = Peering{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbpeering_peering_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Peering) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Peering) ProtoMessage() {}

func (x *Peering) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbpeering_peering_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Peering.ProtoReflect.Descriptor instead.
func (*Peering) Descriptor() ([]byte, []int) {
	return file_private_pbpeering_peering_proto_rawDescGZIP(), []int{2}
}

func (x *Peering) GetID() string {
	if x != nil {
		return x.ID
	}
	return ""
}

func (x *Peering) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Peering) GetPartition() string {
	if x != nil {
		return x.Partition
	}
	return ""
}

func (x *Peering) GetDeletedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.DeletedAt
	}
	return nil
}

func (x *Peering) GetMeta() map[string]string {
	if x != nil {
		return x.Meta
	}
	return nil
}

func (x *Peering) GetState() PeeringState {
	if x != nil {
		return x.State
	}
	return PeeringState_UNDEFINED
}

func (x *Peering) GetPeerID() string {
	if x != nil {
		return x.PeerID
	}
	return ""
}

func (x *Peering) GetPeerCAPems() []string {
	if x != nil {
		return x.PeerCAPems
	}
	return nil
}

func (x *Peering) GetPeerServerName() string {
	if x != nil {
		return x.PeerServerName
	}
	return ""
}

func (x *Peering) GetPeerServerAddresses() []string {
	if x != nil {
		return x.PeerServerAddresses
	}
	return nil
}

func (x *Peering) GetStreamStatus() *StreamStatus {
	if x != nil {
		return x.StreamStatus
	}
	return nil
}

func (x *Peering) GetCreateIndex() uint64 {
	if x != nil {
		return x.CreateIndex
	}
	return 0
}

func (x *Peering) GetModifyIndex() uint64 {
	if x != nil {
		return x.ModifyIndex
	}
	return 0
}

func (x *Peering) GetRemote() *RemoteInfo {
	if x != nil {
		return x.Remote
	}
	return nil
}

func (x *Peering) GetManualServerAddresses() []string {
	if x != nil {
		return x.ManualServerAddresses
	}
	return nil
}

// mog annotation:
//
// target=github.com/hashicorp/consul/api.PeeringRemoteInfo
// output=peering.gen.go
// name=API
type RemoteInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Partition is the remote peer's partition.
	Partition string `protobuf:"bytes,1,opt,name=Partition,proto3" json:"Partition,omitempty"`
	// Datacenter is the remote peer's datacenter.
	Datacenter string `protobuf:"bytes,2,opt,name=Datacenter,proto3" json:"Datacenter,omitempty"`
	// Locality identifies where the peer is running.
	// mog: func-to=LocalityToAPI func-from=LocalityFromAPI
	Locality *pbcommon.Locality `protobuf:"bytes,3,opt,name=Locality,proto3" json:"Locality,omitempty"`
}

func (x *RemoteInfo) Reset() {
	*x = RemoteInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbpeering_peering_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RemoteInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoteInfo) ProtoMessage() {}

func (x *RemoteInfo) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbpeering_peering_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoteInfo.ProtoReflect.Descriptor instead.
func (*RemoteInfo) Descriptor() ([]byte, []int) {
	return file_private_pbpeering_peering_proto_rawDescGZIP(), []int{3}
}

func (x *RemoteInfo) GetPartition() string {
	if x != nil {
		return x.Partition
	}
	return ""
}

func (x *RemoteInfo) GetDatacenter() string {
	if x != nil {
		return x.Datacenter
	}
	return ""
}

func (x *RemoteInfo) GetLocality() *pbcommon.Locality {
	if x != nil {
		return x.Locality
	}
	return nil
}

// StreamStatus represents information about an active peering stream.
type StreamStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ImportedServices is the list of services imported from this peering.
	ImportedServices []string `protobuf:"bytes,1,rep,name=ImportedServices,proto3" json:"ImportedServices,omitempty"`
	// ExportedServices is the list of services exported to this peering.
	ExportedServices []string `protobuf:"bytes,2,rep,name=ExportedServices,proto3" json:"ExportedServices,omitempty"`
	// LastHeartbeat represents when the last heartbeat message was received.
	LastHeartbeat *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=LastHeartbeat,proto3" json:"LastHeartbeat,omitempty"`
	// LastReceive represents when any message was last received, regardless of success or error.
	LastReceive *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=LastReceive,proto3" json:"LastReceive,omitempty"`
	// LastSend represents when any message was last sent, regardless of success or error.
	LastSend *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=LastSend,proto3" json:"LastSend,omitempty"`
}

func (x *StreamStatus) Reset() {
	*x = StreamStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbpeering_peering_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StreamStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamStatus) ProtoMessage() {}

func (x *StreamStatus) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbpeering_peering_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamStatus.ProtoReflect.Descriptor instead.
func (*StreamStatus) Descriptor() ([]byte, []int) {
	return file_private_pbpeering_peering_proto_rawDescGZIP(), []int{4}
}

func (x *StreamStatus) GetImportedServices() []string {
	if x != nil {
		return x.ImportedServices
	}
	return nil
}

func (x *StreamStatus) GetExportedServices() []string {
	if x != nil {
		return x.ExportedServices
	}
	return nil
}

func (x *StreamStatus) GetLastHeartbeat() *timestamppb.Timestamp {
	if x != nil {
		return x.LastHeartbeat
	}
	return nil
}

func (x *StreamStatus) GetLastReceive() *timestamppb.Timestamp {
	if x != nil {
		return x.LastReceive
	}
	return nil
}

func (x *StreamStatus) GetLastSend() *timestamppb.Timestamp {
	if x != nil {
		return x.LastSend
	}
	return nil
}

// PeeringTrustBundle holds the trust information for validating requests from a peer.
type PeeringTrustBundle struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// TrustDomain is the domain for the bundle, example.com, foo.bar.gov for example. Note that this must not have a prefix such as "spiffe://".
	TrustDomain string `protobuf:"bytes,1,opt,name=TrustDomain,proto3" json:"TrustDomain,omitempty"`
	// PeerName associates the trust bundle with a peer.
	PeerName string `protobuf:"bytes,2,opt,name=PeerName,proto3" json:"PeerName,omitempty"`
	// Partition isolates the bundle from other trust bundles in separate local partitions.
	Partition string `protobuf:"bytes,3,opt,name=Partition,proto3" json:"Partition,omitempty"`
	// RootPEMs holds ASN.1 DER encoded X.509 certificate data for the trust bundle.
	RootPEMs []string `protobuf:"bytes,4,rep,name=RootPEMs,proto3" json:"RootPEMs,omitempty"`
	// ExportedPartition references the remote partition of the peer
	// which sent this trust bundle. Used for generating SpiffeIDs.
	ExportedPartition string `protobuf:"bytes,5,opt,name=ExportedPartition,proto3" json:"ExportedPartition,omitempty"`
	// CreateIndex is the Raft index at which the trust domain was created.
	// @gotags: bexpr:"-"
	CreateIndex uint64 `protobuf:"varint,6,opt,name=CreateIndex,proto3" json:"CreateIndex,omitempty" bexpr:"-"`
	// ModifyIndex is the latest Raft index at which the trust bundle was modified.
	// @gotags: bexpr:"-"
	ModifyIndex uint64 `protobuf:"varint,7,opt,name=ModifyIndex,proto3" json:"ModifyIndex,omitempty" bexpr:"-"`
}

func (x *PeeringTrustBundle) Reset() {
	*x = PeeringTrustBundle{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbpeering_peering_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PeeringTrustBundle) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PeeringTrustBundle) ProtoMessage() {}

func (x *PeeringTrustBundle) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbpeering_peering_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PeeringTrustBundle.ProtoReflect.Descriptor instead.
func (*PeeringTrustBundle) Descriptor() ([]byte, []int) {
	return file_private_pbpeering_peering_proto_rawDescGZIP(), []int{5}
}

func (x *PeeringTrustBundle) GetTrustDomain() string {
	if x != nil {
		return x.TrustDomain
	}
	return ""
}

func (x *PeeringTrustBundle) GetPeerName() string {
	if x != nil {
		return x.PeerName
	}
	return ""
}

func (x *PeeringTrustBundle) GetPartition() string {
	if x != nil {
		return x.Partition
	}
	return ""
}

func (x *PeeringTrustBundle) GetRootPEMs() []string {
	if x != nil {
		return x.RootPEMs
	}
	return nil
}

func (x *PeeringTrustBundle) GetExportedPartition() string {
	if x != nil {
		return x.ExportedPartition
	}
	return ""
}

func (x *PeeringTrustBundle) GetCreateIndex() uint64 {
	if x != nil {
		return x.CreateIndex
	}
	return 0
}

func (x *PeeringTrustBundle) GetModifyIndex() uint64 {
	if x != nil {
		return x.ModifyIndex
	}
	return 0
}

// PeeringServerAddresses contains the latest snapshot of all known
// server addresses for a peer.
type PeeringServerAddresses struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Addresses []string `protobuf:"bytes,1,rep,name=Addresses,proto3" json:"Addresses,omitempty"`
}

func (x *PeeringServerAddresses) Reset() {
	*x = PeeringServerAddresses{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbpeering_peering_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PeeringServerAddresses) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PeeringServerAddresses) ProtoMessage() {}

func (x *PeeringServerAddresses) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbpeering_peering_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PeeringServerAddresses.ProtoReflect.Descriptor instead.
func (*PeeringServerAddresses) Descriptor() ([]byte, []int) {
	return file_private_pbpeering_peering_proto_rawDescGZIP(), []int{6}
}

func (x *PeeringServerAddresses) GetAddresses() []string {
	if x != nil {
		return x.Addresses
	}
	return nil
}

type PeeringReadRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name      string `protobuf:"bytes,1,opt,name=Name,proto3" json:"Name,omitempty"`
	Partition string `protobuf:"bytes,2,opt,name=Partition,proto3" json:"Partition,omitempty"`
}

func (x *PeeringReadRequest) Reset() {
	*x = PeeringReadRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbpeering_peering_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PeeringReadRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PeeringReadRequest) ProtoMessage() {}

func (x *PeeringReadRequest) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbpeering_peering_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PeeringReadRequest.ProtoReflect.Descriptor instead.
func (*PeeringReadRequest) Descriptor() ([]byte, []int) {
	return file_private_pbpeering_peering_proto_rawDescGZIP(), []int{7}
}

func (x *PeeringReadRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *PeeringReadRequest) GetPartition() string {
	if x != nil {
		return x.Partition
	}
	return ""
}

type PeeringReadResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Peering *Peering `protobuf:"bytes,1,opt,name=Peering,proto3" json:"Peering,omitempty"`
}

func (x *PeeringReadResponse) Reset() {
	*x = PeeringReadResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbpeering_peering_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PeeringReadResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PeeringReadResponse) ProtoMessage() {}

func (x *PeeringReadResponse) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbpeering_peering_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PeeringReadResponse.ProtoReflect.Descriptor instead.
func (*PeeringReadResponse) Descriptor() ([]byte, []int) {
	return file_private_pbpeering_peering_proto_rawDescGZIP(), []int{8}
}

func (x *PeeringReadResponse) GetPeering() *Peering {
	if x != nil {
		return x.Peering
	}
	return nil
}

type PeeringListRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Partition string `protobuf:"bytes,1,opt,name=Partition,proto3" json:"Partition,omitempty"`
}

func (x *PeeringListRequest) Reset() {
	*x = PeeringListRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbpeering_peering_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PeeringListRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PeeringListRequest) ProtoMessage() {}

func (x *PeeringListRequest) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbpeering_peering_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PeeringListRequest.ProtoReflect.Descriptor instead.
func (*PeeringListRequest) Descriptor() ([]byte, []int) {
	return file_private_pbpeering_peering_proto_rawDescGZIP(), []int{9}
}

func (x *PeeringListRequest) GetPartition() string {
	if x != nil {
		return x.Partition
	}
	return ""
}

type PeeringListResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Peerings       []*Peering `protobuf:"bytes,1,rep,name=Peerings,proto3" json:"Peerings,omitempty"`
	OBSOLETE_Index uint64     `protobuf:"varint,2,opt,name=OBSOLETE_Index,json=OBSOLETEIndex,proto3" json:"OBSOLETE_Index,omitempty"` // Deprecated in favor of gRPC metadata
}

func (x *PeeringListResponse) Reset() {
	*x = PeeringListResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbpeering_peering_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PeeringListResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PeeringListResponse) ProtoMessage() {}

func (x *PeeringListResponse) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbpeering_peering_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PeeringListResponse.ProtoReflect.Descriptor instead.
func (*PeeringListResponse) Descriptor() ([]byte, []int) {
	return file_private_pbpeering_peering_proto_rawDescGZIP(), []int{10}
}

func (x *PeeringListResponse) GetPeerings() []*Peering {
	if x != nil {
		return x.Peerings
	}
	return nil
}

func (x *PeeringListResponse) GetOBSOLETE_Index() uint64 {
	if x != nil {
		return x.OBSOLETE_Index
	}
	return 0
}

type PeeringWriteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Peering is the peering to write with the request.
	Peering *Peering `protobuf:"bytes,1,opt,name=Peering,proto3" json:"Peering,omitempty"`
	// SecretsWriteRequest contains the optional peering secrets to persist
	// with the peering. Peering secrets are not embedded in the peering
	// object to avoid leaking them.
	SecretsRequest *SecretsWriteRequest `protobuf:"bytes,2,opt,name=SecretsRequest,proto3" json:"SecretsRequest,omitempty"`
	Meta           map[string]string    `protobuf:"bytes,3,rep,name=Meta,proto3" json:"Meta,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *PeeringWriteRequest) Reset() {
	*x = PeeringWriteRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbpeering_peering_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PeeringWriteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PeeringWriteRequest) ProtoMessage() {}

func (x *PeeringWriteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbpeering_peering_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PeeringWriteRequest.ProtoReflect.Descriptor instead.
func (*PeeringWriteRequest) Descriptor() ([]byte, []int) {
	return file_private_pbpeering_peering_proto_rawDescGZIP(), []int{11}
}

func (x *PeeringWriteRequest) GetPeering() *Peering {
	if x != nil {
		return x.Peering
	}
	return nil
}

func (x *PeeringWriteRequest) GetSecretsRequest() *SecretsWriteRequest {
	if x != nil {
		return x.SecretsRequest
	}
	return nil
}

func (x *PeeringWriteRequest) GetMeta() map[string]string {
	if x != nil {
		return x.Meta
	}
	return nil
}

// TODO(peering): Consider returning Peering if we keep this endpoint around
type PeeringWriteResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *PeeringWriteResponse) Reset() {
	*x = PeeringWriteResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbpeering_peering_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PeeringWriteResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PeeringWriteResponse) ProtoMessage() {}

func (x *PeeringWriteResponse) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbpeering_peering_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PeeringWriteResponse.ProtoReflect.Descriptor instead.
func (*PeeringWriteResponse) Descriptor() ([]byte, []int) {
	return file_private_pbpeering_peering_proto_rawDescGZIP(), []int{12}
}

type PeeringDeleteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name      string `protobuf:"bytes,1,opt,name=Name,proto3" json:"Name,omitempty"`
	Partition string `protobuf:"bytes,2,opt,name=Partition,proto3" json:"Partition,omitempty"`
}

func (x *PeeringDeleteRequest) Reset() {
	*x = PeeringDeleteRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbpeering_peering_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PeeringDeleteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PeeringDeleteRequest) ProtoMessage() {}

func (x *PeeringDeleteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbpeering_peering_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PeeringDeleteRequest.ProtoReflect.Descriptor instead.
func (*PeeringDeleteRequest) Descriptor() ([]byte, []int) {
	return file_private_pbpeering_peering_proto_rawDescGZIP(), []int{13}
}

func (x *PeeringDeleteRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *PeeringDeleteRequest) GetPartition() string {
	if x != nil {
		return x.Partition
	}
	return ""
}

type PeeringDeleteResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *PeeringDeleteResponse) Reset() {
	*x = PeeringDeleteResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbpeering_peering_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PeeringDeleteResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PeeringDeleteResponse) ProtoMessage() {}

func (x *PeeringDeleteResponse) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbpeering_peering_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PeeringDeleteResponse.ProtoReflect.Descriptor instead.
func (*PeeringDeleteResponse) Descriptor() ([]byte, []int) {
	return file_private_pbpeering_peering_proto_rawDescGZIP(), []int{14}
}

type TrustBundleListByServiceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ServiceName string `protobuf:"bytes,1,opt,name=ServiceName,proto3" json:"ServiceName,omitempty"`
	Namespace   string `protobuf:"bytes,2,opt,name=Namespace,proto3" json:"Namespace,omitempty"`
	Partition   string `protobuf:"bytes,3,opt,name=Partition,proto3" json:"Partition,omitempty"`
	Kind        string `protobuf:"bytes,4,opt,name=Kind,proto3" json:"Kind,omitempty"`
}

func (x *TrustBundleListByServiceRequest) Reset() {
	*x = TrustBundleListByServiceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbpeering_peering_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TrustBundleListByServiceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrustBundleListByServiceRequest) ProtoMessage() {}

func (x *TrustBundleListByServiceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbpeering_peering_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrustBundleListByServiceRequest.ProtoReflect.Descriptor instead.
func (*TrustBundleListByServiceRequest) Descriptor() ([]byte, []int) {
	return file_private_pbpeering_peering_proto_rawDescGZIP(), []int{15}
}

func (x *TrustBundleListByServiceRequest) GetServiceName() string {
	if x != nil {
		return x.ServiceName
	}
	return ""
}

func (x *TrustBundleListByServiceRequest) GetNamespace() string {
	if x != nil {
		return x.Namespace
	}
	return ""
}

func (x *TrustBundleListByServiceRequest) GetPartition() string {
	if x != nil {
		return x.Partition
	}
	return ""
}

func (x *TrustBundleListByServiceRequest) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

type TrustBundleListByServiceResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	OBSOLETE_Index uint64                `protobuf:"varint,1,opt,name=OBSOLETE_Index,json=OBSOLETEIndex,proto3" json:"OBSOLETE_Index,omitempty"` // Deprecated in favor of gRPC metadata
	Bundles        []*PeeringTrustBundle `protobuf:"bytes,2,rep,name=Bundles,proto3" json:"Bundles,omitempty"`
}

func (x *TrustBundleListByServiceResponse) Reset() {
	*x = TrustBundleListByServiceResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbpeering_peering_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TrustBundleListByServiceResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrustBundleListByServiceResponse) ProtoMessage() {}

func (x *TrustBundleListByServiceResponse) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbpeering_peering_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrustBundleListByServiceResponse.ProtoReflect.Descriptor instead.
func (*TrustBundleListByServiceResponse) Descriptor() ([]byte, []int) {
	return file_private_pbpeering_peering_proto_rawDescGZIP(), []int{16}
}

func (x *TrustBundleListByServiceResponse) GetOBSOLETE_Index() uint64 {
	if x != nil {
		return x.OBSOLETE_Index
	}
	return 0
}

func (x *TrustBundleListByServiceResponse) GetBundles() []*PeeringTrustBundle {
	if x != nil {
		return x.Bundles
	}
	return nil
}

type TrustBundleReadRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name      string `protobuf:"bytes,1,opt,name=Name,proto3" json:"Name,omitempty"`
	Partition string `protobuf:"bytes,2,opt,name=Partition,proto3" json:"Partition,omitempty"`
}

func (x *TrustBundleReadRequest) Reset() {
	*x = TrustBundleReadRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbpeering_peering_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TrustBundleReadRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrustBundleReadRequest) ProtoMessage() {}

func (x *TrustBundleReadRequest) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbpeering_peering_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrustBundleReadRequest.ProtoReflect.Descriptor instead.
func (*TrustBundleReadRequest) Descriptor() ([]byte, []int) {
	return file_private_pbpeering_peering_proto_rawDescGZIP(), []int{17}
}

func (x *TrustBundleReadRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *TrustBundleReadRequest) GetPartition() string {
	if x != nil {
		return x.Partition
	}
	return ""
}

type TrustBundleReadResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	OBSOLETE_Index uint64              `protobuf:"varint,1,opt,name=OBSOLETE_Index,json=OBSOLETEIndex,proto3" json:"OBSOLETE_Index,omitempty"` // Deprecated in favor of gRPC metadata
	Bundle         *PeeringTrustBundle `protobuf:"bytes,2,opt,name=Bundle,proto3" json:"Bundle,omitempty"`
}

func (x *TrustBundleReadResponse) Reset() {
	*x = TrustBundleReadResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbpeering_peering_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TrustBundleReadResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrustBundleReadResponse) ProtoMessage() {}

func (x *TrustBundleReadResponse) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbpeering_peering_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrustBundleReadResponse.ProtoReflect.Descriptor instead.
func (*TrustBundleReadResponse) Descriptor() ([]byte, []int) {
	return file_private_pbpeering_peering_proto_rawDescGZIP(), []int{18}
}

func (x *TrustBundleReadResponse) GetOBSOLETE_Index() uint64 {
	if x != nil {
		return x.OBSOLETE_Index
	}
	return 0
}

func (x *TrustBundleReadResponse) GetBundle() *PeeringTrustBundle {
	if x != nil {
		return x.Bundle
	}
	return nil
}

// This is a purely internal type and does not require query metadata.
type PeeringTerminateByIDRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ID string `protobuf:"bytes,1,opt,name=ID,proto3" json:"ID,omitempty"`
}

func (x *PeeringTerminateByIDRequest) Reset() {
	*x = PeeringTerminateByIDRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbpeering_peering_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PeeringTerminateByIDRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PeeringTerminateByIDRequest) ProtoMessage() {}

func (x *PeeringTerminateByIDRequest) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbpeering_peering_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PeeringTerminateByIDRequest.ProtoReflect.Descriptor instead.
func (*PeeringTerminateByIDRequest) Descriptor() ([]byte, []int) {
	return file_private_pbpeering_peering_proto_rawDescGZIP(), []int{19}
}

func (x *PeeringTerminateByIDRequest) GetID() string {
	if x != nil {
		return x.ID
	}
	return ""
}

type PeeringTerminateByIDResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *PeeringTerminateByIDResponse) Reset() {
	*x = PeeringTerminateByIDResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbpeering_peering_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PeeringTerminateByIDResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PeeringTerminateByIDResponse) ProtoMessage() {}

func (x *PeeringTerminateByIDResponse) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbpeering_peering_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PeeringTerminateByIDResponse.ProtoReflect.Descriptor instead.
func (*PeeringTerminateByIDResponse) Descriptor() ([]byte, []int) {
	return file_private_pbpeering_peering_proto_rawDescGZIP(), []int{20}
}

type PeeringTrustBundleWriteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	PeeringTrustBundle *PeeringTrustBundle `protobuf:"bytes,1,opt,name=PeeringTrustBundle,proto3" json:"PeeringTrustBundle,omitempty"`
}

func (x *PeeringTrustBundleWriteRequest) Reset() {
	*x = PeeringTrustBundleWriteRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbpeering_peering_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PeeringTrustBundleWriteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PeeringTrustBundleWriteRequest) ProtoMessage() {}

func (x *PeeringTrustBundleWriteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbpeering_peering_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PeeringTrustBundleWriteRequest.ProtoReflect.Descriptor instead.
func (*PeeringTrustBundleWriteRequest) Descriptor() ([]byte, []int) {
	return file_private_pbpeering_peering_proto_rawDescGZIP(), []int{21}
}

func (x *PeeringTrustBundleWriteRequest) GetPeeringTrustBundle() *PeeringTrustBundle {
	if x != nil {
		return x.PeeringTrustBundle
	}
	return nil
}

type PeeringTrustBundleWriteResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *PeeringTrustBundleWriteResponse) Reset() {
	*x = PeeringTrustBundleWriteResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbpeering_peering_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PeeringTrustBundleWriteResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PeeringTrustBundleWriteResponse) ProtoMessage() {}

func (x *PeeringTrustBundleWriteResponse) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbpeering_peering_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PeeringTrustBundleWriteResponse.ProtoReflect.Descriptor instead.
func (*PeeringTrustBundleWriteResponse) Descriptor() ([]byte, []int) {
	return file_private_pbpeering_peering_proto_rawDescGZIP(), []int{22}
}

type PeeringTrustBundleDeleteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name      string `protobuf:"bytes,1,opt,name=Name,proto3" json:"Name,omitempty"`
	Partition string `protobuf:"bytes,2,opt,name=Partition,proto3" json:"Partition,omitempty"`
}

func (x *PeeringTrustBundleDeleteRequest) Reset() {
	*x = PeeringTrustBundleDeleteRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbpeering_peering_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PeeringTrustBundleDeleteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PeeringTrustBundleDeleteRequest) ProtoMessage() {}

func (x *PeeringTrustBundleDeleteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbpeering_peering_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PeeringTrustBundleDeleteRequest.ProtoReflect.Descriptor instead.
func (*PeeringTrustBundleDeleteRequest) Descriptor() ([]byte, []int) {
	return file_private_pbpeering_peering_proto_rawDescGZIP(), []int{23}
}

func (x *PeeringTrustBundleDeleteRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *PeeringTrustBundleDeleteRequest) GetPartition() string {
	if x != nil {
		return x.Partition
	}
	return ""
}

type PeeringTrustBundleDeleteResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *PeeringTrustBundleDeleteResponse) Reset() {
	*x = PeeringTrustBundleDeleteResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbpeering_peering_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PeeringTrustBundleDeleteResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PeeringTrustBundleDeleteResponse) ProtoMessage() {}

func (x *PeeringTrustBundleDeleteResponse) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbpeering_peering_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PeeringTrustBundleDeleteResponse.ProtoReflect.Descriptor instead.
func (*PeeringTrustBundleDeleteResponse) Descriptor() ([]byte, []int) {
	return file_private_pbpeering_peering_proto_rawDescGZIP(), []int{24}
}

// mog annotation:
//
// target=github.com/hashicorp/consul/api.PeeringGenerateTokenRequest
// output=peering.gen.go
// name=API
type GenerateTokenRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the remote peer.
	PeerName string `protobuf:"bytes,1,opt,name=PeerName,proto3" json:"PeerName,omitempty"`
	// Partition is the local partition being peered.
	Partition string `protobuf:"bytes,2,opt,name=Partition,proto3" json:"Partition,omitempty"`
	// Meta is a mapping of some string value to any other string value
	Meta map[string]string `protobuf:"bytes,5,rep,name=Meta,proto3" json:"Meta,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// ServerExternalAddresses is a list of addresses to put into the generated token. This could be used to specify
	// load balancer(s) or external IPs to reach the servers from the dialing side, and will override any server
	// addresses obtained from the "consul" service.
	ServerExternalAddresses []string `protobuf:"bytes,6,rep,name=ServerExternalAddresses,proto3" json:"ServerExternalAddresses,omitempty"`
}

func (x *GenerateTokenRequest) Reset() {
	*x = GenerateTokenRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbpeering_peering_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerateTokenRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateTokenRequest) ProtoMessage() {}

func (x *GenerateTokenRequest) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbpeering_peering_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateTokenRequest.ProtoReflect.Descriptor instead.
func (*GenerateTokenRequest) Descriptor() ([]byte, []int) {
	return file_private_pbpeering_peering_proto_rawDescGZIP(), []int{25}
}

func (x *GenerateTokenRequest) GetPeerName() string {
	if x != nil {
		return x.PeerName
	}
	return ""
}

func (x *GenerateTokenRequest) GetPartition() string {
	if x != nil {
		return x.Partition
	}
	return ""
}

func (x *GenerateTokenRequest) GetMeta() map[string]string {
	if x != nil {
		return x.Meta
	}
	return nil
}

func (x *GenerateTokenRequest) GetServerExternalAddresses() []string {
	if x != nil {
		return x.ServerExternalAddresses
	}
	return nil
}

// mog annotation:
//
// target=github.com/hashicorp/consul/api.PeeringGenerateTokenResponse
// output=peering.gen.go
// name=API
type GenerateTokenResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// PeeringToken is an opaque string provided to the remote peer for it to complete
	// the peering initialization handshake.
	PeeringToken string `protobuf:"bytes,1,opt,name=PeeringToken,proto3" json:"PeeringToken,omitempty"`
}

func (x *GenerateTokenResponse) Reset() {
	*x = GenerateTokenResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbpeering_peering_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerateTokenResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateTokenResponse) ProtoMessage() {}

func (x *GenerateTokenResponse) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbpeering_peering_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateTokenResponse.ProtoReflect.Descriptor instead.
func (*GenerateTokenResponse) Descriptor() ([]byte, []int) {
	return file_private_pbpeering_peering_proto_rawDescGZIP(), []int{26}
}

func (x *GenerateTokenResponse) GetPeeringToken() string {
	if x != nil {
		return x.PeeringToken
	}
	return ""
}

// mog annotation:
//
// target=github.com/hashicorp/consul/api.PeeringEstablishRequest
// output=peering.gen.go
// name=API
type EstablishRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the remote peer.
	PeerName string `protobuf:"bytes,1,opt,name=PeerName,proto3" json:"PeerName,omitempty"`
	// The peering token returned from the peer's GenerateToken endpoint.
	PeeringToken string `protobuf:"bytes,2,opt,name=PeeringToken,proto3" json:"PeeringToken,omitempty"`
	// Partition is the local partition being peered.
	Partition string `protobuf:"bytes,3,opt,name=Partition,proto3" json:"Partition,omitempty"`
	// Meta is a mapping of some string value to any other string value
	Meta map[string]string `protobuf:"bytes,4,rep,name=Meta,proto3" json:"Meta,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *EstablishRequest) Reset() {
	*x = EstablishRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbpeering_peering_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EstablishRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EstablishRequest) ProtoMessage() {}

func (x *EstablishRequest) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbpeering_peering_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EstablishRequest.ProtoReflect.Descriptor instead.
func (*EstablishRequest) Descriptor() ([]byte, []int) {
	return file_private_pbpeering_peering_proto_rawDescGZIP(), []int{27}
}

func (x *EstablishRequest) GetPeerName() string {
	if x != nil {
		return x.PeerName
	}
	return ""
}

func (x *EstablishRequest) GetPeeringToken() string {
	if x != nil {
		return x.PeeringToken
	}
	return ""
}

func (x *EstablishRequest) GetPartition() string {
	if x != nil {
		return x.Partition
	}
	return ""
}

func (x *EstablishRequest) GetMeta() map[string]string {
	if x != nil {
		return x.Meta
	}
	return nil
}

// mog annotation:
//
// target=github.com/hashicorp/consul/api.PeeringEstablishResponse
// output=peering.gen.go
// name=API
type EstablishResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *EstablishResponse) Reset() {
	*x = EstablishResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbpeering_peering_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EstablishResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EstablishResponse) ProtoMessage() {}

func (x *EstablishResponse) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbpeering_peering_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EstablishResponse.ProtoReflect.Descriptor instead.
func (*EstablishResponse) Descriptor() ([]byte, []int) {
	return file_private_pbpeering_peering_proto_rawDescGZIP(), []int{28}
}

// GenerateTokenRequest encodes a request to persist a peering establishment
// secret. It is triggered by generating a new peering token for a peer cluster.
type SecretsWriteRequest_GenerateTokenRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// establishment_secret is the proposed secret ID to store as the establishment
	// secret for this peering.
	EstablishmentSecret string `protobuf:"bytes,1,opt,name=establishment_secret,json=establishmentSecret,proto3" json:"establishment_secret,omitempty"`
}

func (x *SecretsWriteRequest_GenerateTokenRequest) Reset() {
	*x = SecretsWriteRequest_GenerateTokenRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbpeering_peering_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SecretsWriteRequest_GenerateTokenRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SecretsWriteRequest_GenerateTokenRequest) ProtoMessage() {}

func (x *SecretsWriteRequest_GenerateTokenRequest) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbpeering_peering_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SecretsWriteRequest_GenerateTokenRequest.ProtoReflect.Descriptor instead.
func (*SecretsWriteRequest_GenerateTokenRequest) Descriptor() ([]byte, []int) {
	return file_private_pbpeering_peering_proto_rawDescGZIP(), []int{0, 0}
}

func (x *SecretsWriteRequest_GenerateTokenRequest) GetEstablishmentSecret() string {
	if x != nil {
		return x.EstablishmentSecret
	}
	return ""
}

// ExchangeSecretRequest encodes a request to persist a pending stream secret
// secret. It is triggered by an acceptor peer generating a long-lived stream secret
// in exchange for an establishment secret.
type SecretsWriteRequest_ExchangeSecretRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// establishment_secret is the secret to exchange for the given pending stream secret.
	EstablishmentSecret string `protobuf:"bytes,1,opt,name=establishment_secret,json=establishmentSecret,proto3" json:"establishment_secret,omitempty"`
	// pending_stream_secret is the proposed secret ID to store as the pending stream
	// secret for this peering.
	PendingStreamSecret string `protobuf:"bytes,2,opt,name=pending_stream_secret,json=pendingStreamSecret,proto3" json:"pending_stream_secret,omitempty"`
}

func (x *SecretsWriteRequest_ExchangeSecretRequest) Reset() {
	*x = SecretsWriteRequest_ExchangeSecretRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbpeering_peering_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SecretsWriteRequest_ExchangeSecretRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SecretsWriteRequest_ExchangeSecretRequest) ProtoMessage() {}

func (x *SecretsWriteRequest_ExchangeSecretRequest) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbpeering_peering_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SecretsWriteRequest_ExchangeSecretRequest.ProtoReflect.Descriptor instead.
func (*SecretsWriteRequest_ExchangeSecretRequest) Descriptor() ([]byte, []int) {
	return file_private_pbpeering_peering_proto_rawDescGZIP(), []int{0, 1}
}

func (x *SecretsWriteRequest_ExchangeSecretRequest) GetEstablishmentSecret() string {
	if x != nil {
		return x.EstablishmentSecret
	}
	return ""
}

func (x *SecretsWriteRequest_ExchangeSecretRequest) GetPendingStreamSecret() string {
	if x != nil {
		return x.PendingStreamSecret
	}
	return ""
}

// PromotePendingRequest encodes a request to promote a pending stream secret
// to be an active stream secret. It is triggered when the accepting stream handler
// validates an Open request from a peer with a pending stream secret.
type SecretsWriteRequest_PromotePendingRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// active_stream_secret is the proposed secret ID to store as the active stream
	// secret for this peering.
	ActiveStreamSecret string `protobuf:"bytes,1,opt,name=active_stream_secret,json=activeStreamSecret,proto3" json:"active_stream_secret,omitempty"`
}

func (x *SecretsWriteRequest_PromotePendingRequest) Reset() {
	*x = SecretsWriteRequest_PromotePendingRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbpeering_peering_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SecretsWriteRequest_PromotePendingRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SecretsWriteRequest_PromotePendingRequest) ProtoMessage() {}

func (x *SecretsWriteRequest_PromotePendingRequest) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbpeering_peering_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SecretsWriteRequest_PromotePendingRequest.ProtoReflect.Descriptor instead.
func (*SecretsWriteRequest_PromotePendingRequest) Descriptor() ([]byte, []int) {
	return file_private_pbpeering_peering_proto_rawDescGZIP(), []int{0, 2}
}

func (x *SecretsWriteRequest_PromotePendingRequest) GetActiveStreamSecret() string {
	if x != nil {
		return x.ActiveStreamSecret
	}
	return ""
}

// EstablishRequest encodes a request to persist an active stream secret.
// It is triggered after a dialing peer exchanges their establishment secret
// for a long-lived active stream secret.
type SecretsWriteRequest_EstablishRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// active_stream_secret is the proposed secret ID to store as the active stream
	// secret for this peering.
	ActiveStreamSecret string `protobuf:"bytes,1,opt,name=active_stream_secret,json=activeStreamSecret,proto3" json:"active_stream_secret,omitempty"`
}

func (x *SecretsWriteRequest_EstablishRequest) Reset() {
	*x = SecretsWriteRequest_EstablishRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbpeering_peering_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SecretsWriteRequest_EstablishRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SecretsWriteRequest_EstablishRequest) ProtoMessage() {}

func (x *SecretsWriteRequest_EstablishRequest) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbpeering_peering_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SecretsWriteRequest_EstablishRequest.ProtoReflect.Descriptor instead.
func (*SecretsWriteRequest_EstablishRequest) Descriptor() ([]byte, []int) {
	return file_private_pbpeering_peering_proto_rawDescGZIP(), []int{0, 3}
}

func (x *SecretsWriteRequest_EstablishRequest) GetActiveStreamSecret() string {
	if x != nil {
		return x.ActiveStreamSecret
	}
	return ""
}

type PeeringSecrets_Establishment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// SecretID is the one-time-use peering establishment secret.
	SecretID string `protobuf:"bytes,1,opt,name=SecretID,proto3" json:"SecretID,omitempty"`
}

func (x *PeeringSecrets_Establishment) Reset() {
	*x = PeeringSecrets_Establishment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbpeering_peering_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PeeringSecrets_Establishment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PeeringSecrets_Establishment) ProtoMessage() {}

func (x *PeeringSecrets_Establishment) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbpeering_peering_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PeeringSecrets_Establishment.ProtoReflect.Descriptor instead.
func (*PeeringSecrets_Establishment) Descriptor() ([]byte, []int) {
	return file_private_pbpeering_peering_proto_rawDescGZIP(), []int{1, 0}
}

func (x *PeeringSecrets_Establishment) GetSecretID() string {
	if x != nil {
		return x.SecretID
	}
	return ""
}

type PeeringSecrets_Stream struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ActiveSecretID is the active UUID-v4 secret being used for authorization at
	// the peering stream.
	ActiveSecretID string `protobuf:"bytes,1,opt,name=ActiveSecretID,proto3" json:"ActiveSecretID,omitempty"`
	// PendingSecretID is a UUID-v4 secret introduced during secret rotation.
	// When a peering is established or re-established, both the active secret and
	// pending secret are considered valid. However, once the dialing peer uses
	// the pending secret then it transitions to active and the previously active
	// secret is discarded.
	//
	// Pending secret IDs are only valid for long-lived stream secrets.
	// Only one establishment secret can exist for a peer at a time since they
	// are designed for one-time use.
	PendingSecretID string `protobuf:"bytes,2,opt,name=PendingSecretID,proto3" json:"PendingSecretID,omitempty"`
}

func (x *PeeringSecrets_Stream) Reset() {
	*x = PeeringSecrets_Stream{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbpeering_peering_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PeeringSecrets_Stream) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PeeringSecrets_Stream) ProtoMessage() {}

func (x *PeeringSecrets_Stream) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbpeering_peering_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PeeringSecrets_Stream.ProtoReflect.Descriptor instead.
func (*PeeringSecrets_Stream) Descriptor() ([]byte, []int) {
	return file_private_pbpeering_peering_proto_rawDescGZIP(), []int{1, 1}
}

func (x *PeeringSecrets_Stream) GetActiveSecretID() string {
	if x != nil {
		return x.ActiveSecretID
	}
	return ""
}

func (x *PeeringSecrets_Stream) GetPendingSecretID() string {
	if x != nil {
		return x.PendingSecretID
	}
	return ""
}

var File_private_pbpeering_peering_proto protoreflect.FileDescriptor

var file_private_pbpeering_peering_proto_rawDesc = []byte{
	0x0a, 0x1f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x2f, 0x70, 0x62, 0x70, 0x65, 0x65, 0x72,
	0x69, 0x6e, 0x67, 0x2f, 0x70, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x21, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e,
	0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x70, 0x65, 0x65,
	0x72, 0x69, 0x6e, 0x67, 0x1a, 0x25, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x72, 0x61, 0x74, 0x65, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x2f, 0x72, 0x61, 0x74, 0x65,
	0x6c, 0x69, 0x6d, 0x69, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1d, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x74, 0x65, 0x2f, 0x70, 0x62, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2f, 0x63,
	0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xe5, 0x06, 0x0a, 0x13,
	0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x73, 0x57, 0x72, 0x69, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x50, 0x65, 0x65, 0x72, 0x49, 0x44, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x50, 0x65, 0x65, 0x72, 0x49, 0x44, 0x12, 0x74, 0x0a, 0x0e, 0x67,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x4b, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e,
	0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e,
	0x70, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x73, 0x57,
	0x72, 0x69, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x47, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x48, 0x00, 0x52, 0x0d, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x12, 0x77, 0x0a, 0x0f, 0x65, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x73, 0x65,
	0x63, 0x72, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4c, 0x2e, 0x68, 0x61, 0x73,
	0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e,
	0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x70, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x53,
	0x65, 0x63, 0x72, 0x65, 0x74, 0x73, 0x57, 0x72, 0x69, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x2e, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x53, 0x65, 0x63, 0x72, 0x65,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x00, 0x52, 0x0e, 0x65, 0x78, 0x63, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x12, 0x77, 0x0a, 0x0f, 0x70, 0x72,
	0x6f, 0x6d, 0x6f, 0x74, 0x65, 0x5f, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x4c, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e,
	0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e,
	0x70, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x73, 0x57,
	0x72, 0x69, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x50, 0x72, 0x6f, 0x6d,
	0x6f, 0x74, 0x65, 0x50, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x48, 0x00, 0x52, 0x0e, 0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x65, 0x50, 0x65, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x12, 0x67, 0x0a, 0x09, 0x65, 0x73, 0x74, 0x61, 0x62, 0x6c, 0x69, 0x73, 0x68,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f,
	0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e,
	0x61, 0x6c, 0x2e, 0x70, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x53, 0x65, 0x63, 0x72, 0x65,
	0x74, 0x73, 0x57, 0x72, 0x69, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x45,
	0x73, 0x74, 0x61, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48,
	0x00, 0x52, 0x09, 0x65, 0x73, 0x74, 0x61, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x1a, 0x49, 0x0a, 0x14,
	0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x31, 0x0a, 0x14, 0x65, 0x73, 0x74, 0x61, 0x62, 0x6c, 0x69, 0x73,
	0x68, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x13, 0x65, 0x73, 0x74, 0x61, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x6d, 0x65, 0x6e,
	0x74, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x1a, 0x7e, 0x0a, 0x15, 0x45, 0x78, 0x63, 0x68, 0x61,
	0x6e, 0x67, 0x65, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x31, 0x0a, 0x14, 0x65, 0x73, 0x74, 0x61, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x6d, 0x65, 0x6e,
	0x74, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13,
	0x65, 0x73, 0x74, 0x61, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x63,
	0x72, 0x65, 0x74, 0x12, 0x32, 0x0a, 0x15, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x73,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x13, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x1a, 0x49, 0x0a, 0x15, 0x50, 0x72, 0x6f, 0x6d, 0x6f,
	0x74, 0x65, 0x50, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x30, 0x0a, 0x14, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12,
	0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x53, 0x65, 0x63, 0x72,
	0x65, 0x74, 0x1a, 0x44, 0x0a, 0x10, 0x45, 0x73, 0x74, 0x61, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x30, 0x0a, 0x14, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65,
	0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x42, 0x09, 0x0a, 0x07, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x22, 0xea, 0x02, 0x0a, 0x0e, 0x50, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x53,
	0x65, 0x63, 0x72, 0x65, 0x74, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x50, 0x65, 0x65, 0x72, 0x49, 0x44,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x50, 0x65, 0x65, 0x72, 0x49, 0x44, 0x12, 0x65,
	0x0a, 0x0d, 0x65, 0x73, 0x74, 0x61, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72,
	0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61,
	0x6c, 0x2e, 0x70, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x50, 0x65, 0x65, 0x72, 0x69, 0x6e,
	0x67, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x73, 0x2e, 0x45, 0x73, 0x74, 0x61, 0x62, 0x6c, 0x69,
	0x73, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x0d, 0x65, 0x73, 0x74, 0x61, 0x62, 0x6c, 0x69, 0x73,
	0x68, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x50, 0x0a, 0x06, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72,
	0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61,
	0x6c, 0x2e, 0x70, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x50, 0x65, 0x65, 0x72, 0x69, 0x6e,
	0x67, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x73, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52,
	0x06, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x1a, 0x2b, 0x0a, 0x0d, 0x45, 0x73, 0x74, 0x61, 0x62,
	0x6c, 0x69, 0x73, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x53, 0x65, 0x63, 0x72,
	0x65, 0x74, 0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x53, 0x65, 0x63, 0x72,
	0x65, 0x74, 0x49, 0x44, 0x1a, 0x5a, 0x0a, 0x06, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x26,
	0x0a, 0x0e, 0x41, 0x63, 0x74, 0x69, 0x76, 0x65, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x49, 0x44,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x41, 0x63, 0x74, 0x69, 0x76, 0x65, 0x53, 0x65,
	0x63, 0x72, 0x65, 0x74, 0x49, 0x44, 0x12, 0x28, 0x0a, 0x0f, 0x50, 0x65, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x49, 0x44, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0f, 0x50, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x49, 0x44,
	0x22, 0xf7, 0x05, 0x0a, 0x07, 0x50, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x12, 0x0e, 0x0a, 0x02,
	0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x49, 0x44, 0x12, 0x12, 0x0a, 0x04,
	0x4e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x1c, 0x0a, 0x09, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x38,
	0x0a, 0x09, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x41, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x41, 0x74, 0x12, 0x48, 0x0a, 0x04, 0x4d, 0x65, 0x74, 0x61,
	0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f,
	0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e,
	0x61, 0x6c, 0x2e, 0x70, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x50, 0x65, 0x65, 0x72, 0x69,
	0x6e, 0x67, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x04, 0x4d, 0x65,
	0x74, 0x61, 0x12, 0x45, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x2f, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f,
	0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x70, 0x65,
	0x65, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x50, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x52, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x50, 0x65, 0x65,
	0x72, 0x49, 0x44, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x50, 0x65, 0x65, 0x72, 0x49,
	0x44, 0x12, 0x1e, 0x0a, 0x0a, 0x50, 0x65, 0x65, 0x72, 0x43, 0x41, 0x50, 0x65, 0x6d, 0x73, 0x18,
	0x08, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x50, 0x65, 0x65, 0x72, 0x43, 0x41, 0x50, 0x65, 0x6d,
	0x73, 0x12, 0x26, 0x0a, 0x0e, 0x50, 0x65, 0x65, 0x72, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x4e,
	0x61, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x50, 0x65, 0x65, 0x72, 0x53,
	0x65, 0x72, 0x76, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x30, 0x0a, 0x13, 0x50, 0x65, 0x65,
	0x72, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73,
	0x18, 0x0a, 0x20, 0x03, 0x28, 0x09, 0x52, 0x13, 0x50, 0x65, 0x65, 0x72, 0x53, 0x65, 0x72, 0x76,
	0x65, 0x72, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x12, 0x53, 0x0a, 0x0c, 0x53,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x0d, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2f, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f,
	0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x70, 0x65,
	0x65, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x52, 0x0c, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x12, 0x20, 0x0a, 0x0b, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x18,
	0x0b, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0b, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64,
	0x65, 0x78, 0x12, 0x20, 0x0a, 0x0b, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x79, 0x49, 0x6e, 0x64, 0x65,
	0x78, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0b, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x79, 0x49,
	0x6e, 0x64, 0x65, 0x78, 0x12, 0x45, 0x0a, 0x06, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x18, 0x11,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70,
	0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c,
	0x2e, 0x70, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x49,
	0x6e, 0x66, 0x6f, 0x52, 0x06, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x12, 0x34, 0x0a, 0x15, 0x4d,
	0x61, 0x6e, 0x75, 0x61, 0x6c, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x41, 0x64, 0x64, 0x72, 0x65,
	0x73, 0x73, 0x65, 0x73, 0x18, 0x12, 0x20, 0x03, 0x28, 0x09, 0x52, 0x15, 0x4d, 0x61, 0x6e, 0x75,
	0x61, 0x6c, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65,
	0x73, 0x1a, 0x37, 0x0a, 0x09, 0x4d, 0x65, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10,
	0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79,
	0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x92, 0x01, 0x0a, 0x0a, 0x52,
	0x65, 0x6d, 0x6f, 0x74, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x1c, 0x0a, 0x09, 0x50, 0x61, 0x72,
	0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x50, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1e, 0x0a, 0x0a, 0x44, 0x61, 0x74, 0x61, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x44, 0x61, 0x74,
	0x61, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x12, 0x46, 0x0a, 0x08, 0x4c, 0x6f, 0x63, 0x61, 0x6c,
	0x69, 0x74, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x68, 0x61, 0x73, 0x68,
	0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74,
	0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x4c, 0x6f, 0x63,
	0x61, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x08, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x22,
	0x9e, 0x02, 0x0a, 0x0c, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x12, 0x2a, 0x0a, 0x10, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x10, 0x49, 0x6d, 0x70, 0x6f,
	0x72, 0x74, 0x65, 0x64, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x12, 0x2a, 0x0a, 0x10,
	0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x10, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x12, 0x40, 0x0a, 0x0d, 0x4c, 0x61, 0x73, 0x74,
	0x48, 0x65, 0x61, 0x72, 0x74, 0x62, 0x65, 0x61, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0d, 0x4c, 0x61, 0x73,
	0x74, 0x48, 0x65, 0x61, 0x72, 0x74, 0x62, 0x65, 0x61, 0x74, 0x12, 0x3c, 0x0a, 0x0b, 0x4c, 0x61,
	0x73, 0x74, 0x52, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0b, 0x4c, 0x61, 0x73,
	0x74, 0x52, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x12, 0x36, 0x0a, 0x08, 0x4c, 0x61, 0x73, 0x74,
	0x53, 0x65, 0x6e, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x08, 0x4c, 0x61, 0x73, 0x74, 0x53, 0x65, 0x6e, 0x64,
	0x22, 0xfe, 0x01, 0x0a, 0x12, 0x50, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x54, 0x72, 0x75, 0x73,
	0x74, 0x42, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x54, 0x72, 0x75, 0x73, 0x74,
	0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x54, 0x72,
	0x75, 0x73, 0x74, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x12, 0x1a, 0x0a, 0x08, 0x50, 0x65, 0x65,
	0x72, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x50, 0x65, 0x65,
	0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x1a, 0x0a, 0x08, 0x52, 0x6f, 0x6f, 0x74, 0x50, 0x45, 0x4d, 0x73, 0x18,
	0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x08, 0x52, 0x6f, 0x6f, 0x74, 0x50, 0x45, 0x4d, 0x73, 0x12,
	0x2c, 0x0a, 0x11, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x50, 0x61, 0x72, 0x74, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x45, 0x78, 0x70, 0x6f,
	0x72, 0x74, 0x65, 0x64, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x20, 0x0a,
	0x0b, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x04, 0x52, 0x0b, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12,
	0x20, 0x0a, 0x0b, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x79, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x04, 0x52, 0x0b, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x79, 0x49, 0x6e, 0x64, 0x65,
	0x78, 0x22, 0x36, 0x0a, 0x16, 0x50, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x72, 0x76,
	0x65, 0x72, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x12, 0x1c, 0x0a, 0x09, 0x41,
	0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09,
	0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x22, 0x46, 0x0a, 0x12, 0x50, 0x65, 0x65,
	0x72, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x61, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x12, 0x0a, 0x04, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x5b, 0x0a, 0x13, 0x50, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x61, 0x64,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x44, 0x0a, 0x07, 0x50, 0x65, 0x65, 0x72,
	0x69, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x68, 0x61, 0x73, 0x68,
	0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74,
	0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x70, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x50, 0x65,
	0x65, 0x72, 0x69, 0x6e, 0x67, 0x52, 0x07, 0x50, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x22, 0x32,
	0x0a, 0x12, 0x50, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x1c, 0x0a, 0x09, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x84, 0x01, 0x0a, 0x13, 0x50, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x4c, 0x69,
	0x73, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x46, 0x0a, 0x08, 0x50, 0x65,
	0x65, 0x72, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x68,
	0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e,
	0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x70, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67,
	0x2e, 0x50, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x52, 0x08, 0x50, 0x65, 0x65, 0x72, 0x69, 0x6e,
	0x67, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x4f, 0x42, 0x53, 0x4f, 0x4c, 0x45, 0x54, 0x45, 0x5f, 0x49,
	0x6e, 0x64, 0x65, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0d, 0x4f, 0x42, 0x53, 0x4f,
	0x4c, 0x45, 0x54, 0x45, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x22, 0xca, 0x02, 0x0a, 0x13, 0x50, 0x65,
	0x65, 0x72, 0x69, 0x6e, 0x67, 0x57, 0x72, 0x69, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x44, 0x0a, 0x07, 0x50, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63,
	0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x70,
	0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x50, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x52, 0x07,
	0x50, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x12, 0x5e, 0x0a, 0x0e, 0x53, 0x65, 0x63, 0x72, 0x65,
	0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x36, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73,
	0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x70, 0x65, 0x65, 0x72,
	0x69, 0x6e, 0x67, 0x2e, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x73, 0x57, 0x72, 0x69, 0x74, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x0e, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x54, 0x0a, 0x04, 0x4d, 0x65, 0x74, 0x61, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72,
	0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61,
	0x6c, 0x2e, 0x70, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x50, 0x65, 0x65, 0x72, 0x69, 0x6e,
	0x67, 0x57, 0x72, 0x69, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x4d, 0x65,
	0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x04, 0x4d, 0x65, 0x74, 0x61, 0x1a, 0x37, 0x0a,
	0x09, 0x4d, 0x65, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x16, 0x0a, 0x14, 0x50, 0x65, 0x65, 0x72, 0x69, 0x6e,
	0x67, 0x57, 0x72, 0x69, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x48,
	0x0a, 0x14, 0x50, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x50, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x50,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x17, 0x0a, 0x15, 0x50, 0x65, 0x65, 0x72,
	0x69, 0x6e, 0x67, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x93, 0x01, 0x0a, 0x1f, 0x54, 0x72, 0x75, 0x73, 0x74, 0x42, 0x75, 0x6e, 0x64, 0x6c,
	0x65, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x79, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x20, 0x0a, 0x0b, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x4e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x4e, 0x61, 0x6d, 0x65, 0x73,
	0x70, 0x61, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x4e, 0x61, 0x6d, 0x65,
	0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x4b, 0x69, 0x6e, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x4b, 0x69, 0x6e, 0x64, 0x22, 0x9a, 0x01, 0x0a, 0x20, 0x54, 0x72, 0x75, 0x73,
	0x74, 0x42, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x79, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x25, 0x0a, 0x0e,
	0x4f, 0x42, 0x53, 0x4f, 0x4c, 0x45, 0x54, 0x45, 0x5f, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x04, 0x52, 0x0d, 0x4f, 0x42, 0x53, 0x4f, 0x4c, 0x45, 0x54, 0x45, 0x49, 0x6e,
	0x64, 0x65, 0x78, 0x12, 0x4f, 0x0a, 0x07, 0x42, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70,
	0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c,
	0x2e, 0x70, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x50, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67,
	0x54, 0x72, 0x75, 0x73, 0x74, 0x42, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x52, 0x07, 0x42, 0x75, 0x6e,
	0x64, 0x6c, 0x65, 0x73, 0x22, 0x4a, 0x0a, 0x16, 0x54, 0x72, 0x75, 0x73, 0x74, 0x42, 0x75, 0x6e,
	0x64, 0x6c, 0x65, 0x52, 0x65, 0x61, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12,
	0x0a, 0x04, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x8f, 0x01, 0x0a, 0x17, 0x54, 0x72, 0x75, 0x73, 0x74, 0x42, 0x75, 0x6e, 0x64, 0x6c, 0x65,
	0x52, 0x65, 0x61, 0x64, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x25, 0x0a, 0x0e,
	0x4f, 0x42, 0x53, 0x4f, 0x4c, 0x45, 0x54, 0x45, 0x5f, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x04, 0x52, 0x0d, 0x4f, 0x42, 0x53, 0x4f, 0x4c, 0x45, 0x54, 0x45, 0x49, 0x6e,
	0x64, 0x65, 0x78, 0x12, 0x4d, 0x0a, 0x06, 0x42, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e,
	0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e,
	0x70, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x50, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x54,
	0x72, 0x75, 0x73, 0x74, 0x42, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x52, 0x06, 0x42, 0x75, 0x6e, 0x64,
	0x6c, 0x65, 0x22, 0x2d, 0x0a, 0x1b, 0x50, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x54, 0x65, 0x72,
	0x6d, 0x69, 0x6e, 0x61, 0x74, 0x65, 0x42, 0x79, 0x49, 0x44, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x0e, 0x0a, 0x02, 0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x49,
	0x44, 0x22, 0x1e, 0x0a, 0x1c, 0x50, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x54, 0x65, 0x72, 0x6d,
	0x69, 0x6e, 0x61, 0x74, 0x65, 0x42, 0x79, 0x49, 0x44, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x87, 0x01, 0x0a, 0x1e, 0x50, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x54, 0x72, 0x75,
	0x73, 0x74, 0x42, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x57, 0x72, 0x69, 0x74, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x65, 0x0a, 0x12, 0x50, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x54,
	0x72, 0x75, 0x73, 0x74, 0x42, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x35, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e,
	0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x70, 0x65, 0x65,
	0x72, 0x69, 0x6e, 0x67, 0x2e, 0x50, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x54, 0x72, 0x75, 0x73,
	0x74, 0x42, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x52, 0x12, 0x50, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67,
	0x54, 0x72, 0x75, 0x73, 0x74, 0x42, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x22, 0x21, 0x0a, 0x1f, 0x50,
	0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x54, 0x72, 0x75, 0x73, 0x74, 0x42, 0x75, 0x6e, 0x64, 0x6c,
	0x65, 0x57, 0x72, 0x69, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x53,
	0x0a, 0x1f, 0x50, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x54, 0x72, 0x75, 0x73, 0x74, 0x42, 0x75,
	0x6e, 0x64, 0x6c, 0x65, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x12, 0x0a, 0x04, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x22, 0x0a, 0x20, 0x50, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x54, 0x72,
	0x75, 0x73, 0x74, 0x42, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x9a, 0x02, 0x0a, 0x14, 0x47, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x1a, 0x0a, 0x08, 0x50, 0x65, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x50, 0x65, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1c, 0x0a, 0x09,
	0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x55, 0x0a, 0x04, 0x4d, 0x65,
	0x74, 0x61, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69,
	0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65,
	0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x70, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x47, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x04, 0x4d, 0x65, 0x74,
	0x61, 0x12, 0x38, 0x0a, 0x17, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x45, 0x78, 0x74, 0x65, 0x72,
	0x6e, 0x61, 0x6c, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x18, 0x06, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x17, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e,
	0x61, 0x6c, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x1a, 0x37, 0x0a, 0x09, 0x4d,
	0x65, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x22, 0x3b, 0x0a, 0x15, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x22, 0x0a,
	0x0c, 0x50, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0c, 0x50, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0xfc, 0x01, 0x0a, 0x10, 0x45, 0x73, 0x74, 0x61, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x50, 0x65, 0x65, 0x72, 0x4e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x50, 0x65, 0x65, 0x72, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0c, 0x50, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x50, 0x65, 0x65, 0x72, 0x69, 0x6e,
	0x67, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1c, 0x0a, 0x09, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x50, 0x61, 0x72, 0x74, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x51, 0x0a, 0x04, 0x4d, 0x65, 0x74, 0x61, 0x18, 0x04, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63,
	0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x70,
	0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x45, 0x73, 0x74, 0x61, 0x62, 0x6c, 0x69, 0x73, 0x68,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x52, 0x04, 0x4d, 0x65, 0x74, 0x61, 0x1a, 0x37, 0x0a, 0x09, 0x4d, 0x65, 0x74, 0x61, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x22, 0x13, 0x0a, 0x11, 0x45, 0x73, 0x74, 0x61, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2a, 0x73, 0x0a, 0x0c, 0x50, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x0d, 0x0a, 0x09, 0x55, 0x4e, 0x44, 0x45, 0x46, 0x49, 0x4e,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10,
	0x01, 0x12, 0x10, 0x0a, 0x0c, 0x45, 0x53, 0x54, 0x41, 0x42, 0x4c, 0x49, 0x53, 0x48, 0x49, 0x4e,
	0x47, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x03, 0x12,
	0x0b, 0x0a, 0x07, 0x46, 0x41, 0x49, 0x4c, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x12, 0x0c, 0x0a, 0x08,
	0x44, 0x45, 0x4c, 0x45, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x05, 0x12, 0x0e, 0x0a, 0x0a, 0x54, 0x45,
	0x52, 0x4d, 0x49, 0x4e, 0x41, 0x54, 0x45, 0x44, 0x10, 0x06, 0x32, 0x94, 0x09, 0x0a, 0x0e, 0x50,
	0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x8c, 0x01,
	0x0a, 0x0d, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12,
	0x37, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73,
	0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x70, 0x65, 0x65, 0x72,
	0x69, 0x6e, 0x67, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x38, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69,
	0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65,
	0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x70, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x47, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x08, 0xe2, 0x86, 0x04, 0x04, 0x08, 0x03, 0x10, 0x05, 0x12, 0x80, 0x01, 0x0a,
	0x09, 0x45, 0x73, 0x74, 0x61, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x12, 0x33, 0x2e, 0x68, 0x61, 0x73,
	0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e,
	0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x70, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x45,
	0x73, 0x74, 0x61, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x34, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73,
	0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x70, 0x65, 0x65, 0x72,
	0x69, 0x6e, 0x67, 0x2e, 0x45, 0x73, 0x74, 0x61, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x08, 0xe2, 0x86, 0x04, 0x04, 0x08, 0x03, 0x10, 0x05, 0x12,
	0x86, 0x01, 0x0a, 0x0b, 0x50, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x61, 0x64, 0x12,
	0x35, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73,
	0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x70, 0x65, 0x65, 0x72,
	0x69, 0x6e, 0x67, 0x2e, 0x50, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x61, 0x64, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f,
	0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e,
	0x61, 0x6c, 0x2e, 0x70, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x50, 0x65, 0x65, 0x72, 0x69,
	0x6e, 0x67, 0x52, 0x65, 0x61, 0x64, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x08,
	0xe2, 0x86, 0x04, 0x04, 0x08, 0x02, 0x10, 0x05, 0x12, 0x86, 0x01, 0x0a, 0x0b, 0x50, 0x65, 0x65,
	0x72, 0x69, 0x6e, 0x67, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x35, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69,
	0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65,
	0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x70, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x50, 0x65, 0x65,
	0x72, 0x69, 0x6e, 0x67, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x36, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73,
	0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x70, 0x65, 0x65, 0x72,
	0x69, 0x6e, 0x67, 0x2e, 0x50, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x4c, 0x69, 0x73, 0x74, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x08, 0xe2, 0x86, 0x04, 0x04, 0x08, 0x02, 0x10,
	0x05, 0x12, 0x8c, 0x01, 0x0a, 0x0d, 0x50, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x12, 0x37, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e,
	0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e,
	0x70, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x50, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x38, 0x2e, 0x68,
	0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e,
	0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x70, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67,
	0x2e, 0x50, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x08, 0xe2, 0x86, 0x04, 0x04, 0x08, 0x03, 0x10, 0x05,
	0x12, 0x89, 0x01, 0x0a, 0x0c, 0x50, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x57, 0x72, 0x69, 0x74,
	0x65, 0x12, 0x36, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f,
	0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x70, 0x65,
	0x65, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x50, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x57, 0x72, 0x69,
	0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x37, 0x2e, 0x68, 0x61, 0x73, 0x68,
	0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74,
	0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x70, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x50, 0x65,
	0x65, 0x72, 0x69, 0x6e, 0x67, 0x57, 0x72, 0x69, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x08, 0xe2, 0x86, 0x04, 0x04, 0x08, 0x03, 0x10, 0x05, 0x12, 0xad, 0x01, 0x0a,
	0x18, 0x54, 0x72, 0x75, 0x73, 0x74, 0x42, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x4c, 0x69, 0x73, 0x74,
	0x42, 0x79, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x42, 0x2e, 0x68, 0x61, 0x73, 0x68,
	0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74,
	0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x70, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x54, 0x72,
	0x75, 0x73, 0x74, 0x42, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x79, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x43, 0x2e,
	0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c,
	0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x70, 0x65, 0x65, 0x72, 0x69, 0x6e,
	0x67, 0x2e, 0x54, 0x72, 0x75, 0x73, 0x74, 0x42, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x4c, 0x69, 0x73,
	0x74, 0x42, 0x79, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x08, 0xe2, 0x86, 0x04, 0x04, 0x08, 0x02, 0x10, 0x05, 0x12, 0x92, 0x01, 0x0a,
	0x0f, 0x54, 0x72, 0x75, 0x73, 0x74, 0x42, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x52, 0x65, 0x61, 0x64,
	0x12, 0x39, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e,
	0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x70, 0x65, 0x65,
	0x72, 0x69, 0x6e, 0x67, 0x2e, 0x54, 0x72, 0x75, 0x73, 0x74, 0x42, 0x75, 0x6e, 0x64, 0x6c, 0x65,
	0x52, 0x65, 0x61, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3a, 0x2e, 0x68, 0x61,
	0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69,
	0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x70, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x2e,
	0x54, 0x72, 0x75, 0x73, 0x74, 0x42, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x52, 0x65, 0x61, 0x64, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x08, 0xe2, 0x86, 0x04, 0x04, 0x08, 0x02, 0x10,
	0x05, 0x42, 0x92, 0x02, 0x0a, 0x25, 0x63, 0x6f, 0x6d, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63,
	0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72,
	0x6e, 0x61, 0x6c, 0x2e, 0x70, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x42, 0x0c, 0x50, 0x65, 0x65,
	0x72, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x33, 0x67, 0x69, 0x74,
	0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72,
	0x70, 0x2f, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x70,
	0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x2f, 0x70, 0x62, 0x70, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67,
	0xa2, 0x02, 0x04, 0x48, 0x43, 0x49, 0x50, 0xaa, 0x02, 0x21, 0x48, 0x61, 0x73, 0x68, 0x69, 0x63,
	0x6f, 0x72, 0x70, 0x2e, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72,
	0x6e, 0x61, 0x6c, 0x2e, 0x50, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0xca, 0x02, 0x21, 0x48, 0x61,
	0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x5c, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x5c, 0x49,
	0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5c, 0x50, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0xe2,
	0x02, 0x2d, 0x48, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x5c, 0x43, 0x6f, 0x6e, 0x73,
	0x75, 0x6c, 0x5c, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5c, 0x50, 0x65, 0x65, 0x72,
	0x69, 0x6e, 0x67, 0x5c, 0x47, 0x50, 0x42, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xea,
	0x02, 0x24, 0x48, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x3a, 0x3a, 0x43, 0x6f, 0x6e,
	0x73, 0x75, 0x6c, 0x3a, 0x3a, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x3a, 0x3a, 0x50,
	0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_private_pbpeering_peering_proto_rawDescOnce sync.Once
	file_private_pbpeering_peering_proto_rawDescData = file_private_pbpeering_peering_proto_rawDesc
)

func file_private_pbpeering_peering_proto_rawDescGZIP() []byte {
	file_private_pbpeering_peering_proto_rawDescOnce.Do(func() {
		file_private_pbpeering_peering_proto_rawDescData = protoimpl.X.CompressGZIP(file_private_pbpeering_peering_proto_rawDescData)
	})
	return file_private_pbpeering_peering_proto_rawDescData
}

var file_private_pbpeering_peering_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_private_pbpeering_peering_proto_msgTypes = make([]protoimpl.MessageInfo, 39)
var file_private_pbpeering_peering_proto_goTypes = []interface{}{
	(PeeringState)(0),                                 // 0: hashicorp.consul.internal.peering.PeeringState
	(*SecretsWriteRequest)(nil),                       // 1: hashicorp.consul.internal.peering.SecretsWriteRequest
	(*PeeringSecrets)(nil),                            // 2: hashicorp.consul.internal.peering.PeeringSecrets
	(*Peering)(nil),                                   // 3: hashicorp.consul.internal.peering.Peering
	(*RemoteInfo)(nil),                                // 4: hashicorp.consul.internal.peering.RemoteInfo
	(*StreamStatus)(nil),                              // 5: hashicorp.consul.internal.peering.StreamStatus
	(*PeeringTrustBundle)(nil),                        // 6: hashicorp.consul.internal.peering.PeeringTrustBundle
	(*PeeringServerAddresses)(nil),                    // 7: hashicorp.consul.internal.peering.PeeringServerAddresses
	(*PeeringReadRequest)(nil),                        // 8: hashicorp.consul.internal.peering.PeeringReadRequest
	(*PeeringReadResponse)(nil),                       // 9: hashicorp.consul.internal.peering.PeeringReadResponse
	(*PeeringListRequest)(nil),                        // 10: hashicorp.consul.internal.peering.PeeringListRequest
	(*PeeringListResponse)(nil),                       // 11: hashicorp.consul.internal.peering.PeeringListResponse
	(*PeeringWriteRequest)(nil),                       // 12: hashicorp.consul.internal.peering.PeeringWriteRequest
	(*PeeringWriteResponse)(nil),                      // 13: hashicorp.consul.internal.peering.PeeringWriteResponse
	(*PeeringDeleteRequest)(nil),                      // 14: hashicorp.consul.internal.peering.PeeringDeleteRequest
	(*PeeringDeleteResponse)(nil),                     // 15: hashicorp.consul.internal.peering.PeeringDeleteResponse
	(*TrustBundleListByServiceRequest)(nil),           // 16: hashicorp.consul.internal.peering.TrustBundleListByServiceRequest
	(*TrustBundleListByServiceResponse)(nil),          // 17: hashicorp.consul.internal.peering.TrustBundleListByServiceResponse
	(*TrustBundleReadRequest)(nil),                    // 18: hashicorp.consul.internal.peering.TrustBundleReadRequest
	(*TrustBundleReadResponse)(nil),                   // 19: hashicorp.consul.internal.peering.TrustBundleReadResponse
	(*PeeringTerminateByIDRequest)(nil),               // 20: hashicorp.consul.internal.peering.PeeringTerminateByIDRequest
	(*PeeringTerminateByIDResponse)(nil),              // 21: hashicorp.consul.internal.peering.PeeringTerminateByIDResponse
	(*PeeringTrustBundleWriteRequest)(nil),            // 22: hashicorp.consul.internal.peering.PeeringTrustBundleWriteRequest
	(*PeeringTrustBundleWriteResponse)(nil),           // 23: hashicorp.consul.internal.peering.PeeringTrustBundleWriteResponse
	(*PeeringTrustBundleDeleteRequest)(nil),           // 24: hashicorp.consul.internal.peering.PeeringTrustBundleDeleteRequest
	(*PeeringTrustBundleDeleteResponse)(nil),          // 25: hashicorp.consul.internal.peering.PeeringTrustBundleDeleteResponse
	(*GenerateTokenRequest)(nil),                      // 26: hashicorp.consul.internal.peering.GenerateTokenRequest
	(*GenerateTokenResponse)(nil),                     // 27: hashicorp.consul.internal.peering.GenerateTokenResponse
	(*EstablishRequest)(nil),                          // 28: hashicorp.consul.internal.peering.EstablishRequest
	(*EstablishResponse)(nil),                         // 29: hashicorp.consul.internal.peering.EstablishResponse
	(*SecretsWriteRequest_GenerateTokenRequest)(nil),  // 30: hashicorp.consul.internal.peering.SecretsWriteRequest.GenerateTokenRequest
	(*SecretsWriteRequest_ExchangeSecretRequest)(nil), // 31: hashicorp.consul.internal.peering.SecretsWriteRequest.ExchangeSecretRequest
	(*SecretsWriteRequest_PromotePendingRequest)(nil), // 32: hashicorp.consul.internal.peering.SecretsWriteRequest.PromotePendingRequest
	(*SecretsWriteRequest_EstablishRequest)(nil),      // 33: hashicorp.consul.internal.peering.SecretsWriteRequest.EstablishRequest
	(*PeeringSecrets_Establishment)(nil),              // 34: hashicorp.consul.internal.peering.PeeringSecrets.Establishment
	(*PeeringSecrets_Stream)(nil),                     // 35: hashicorp.consul.internal.peering.PeeringSecrets.Stream
	nil,                                               // 36: hashicorp.consul.internal.peering.Peering.MetaEntry
	nil,                                               // 37: hashicorp.consul.internal.peering.PeeringWriteRequest.MetaEntry
	nil,                                               // 38: hashicorp.consul.internal.peering.GenerateTokenRequest.MetaEntry
	nil,                                               // 39: hashicorp.consul.internal.peering.EstablishRequest.MetaEntry
	(*timestamppb.Timestamp)(nil),                     // 40: google.protobuf.Timestamp
	(*pbcommon.Locality)(nil),                         // 41: hashicorp.consul.internal.common.Locality
}
var file_private_pbpeering_peering_proto_depIdxs = []int32{
	30, // 0: hashicorp.consul.internal.peering.SecretsWriteRequest.generate_token:type_name -> hashicorp.consul.internal.peering.SecretsWriteRequest.GenerateTokenRequest
	31, // 1: hashicorp.consul.internal.peering.SecretsWriteRequest.exchange_secret:type_name -> hashicorp.consul.internal.peering.SecretsWriteRequest.ExchangeSecretRequest
	32, // 2: hashicorp.consul.internal.peering.SecretsWriteRequest.promote_pending:type_name -> hashicorp.consul.internal.peering.SecretsWriteRequest.PromotePendingRequest
	33, // 3: hashicorp.consul.internal.peering.SecretsWriteRequest.establish:type_name -> hashicorp.consul.internal.peering.SecretsWriteRequest.EstablishRequest
	34, // 4: hashicorp.consul.internal.peering.PeeringSecrets.establishment:type_name -> hashicorp.consul.internal.peering.PeeringSecrets.Establishment
	35, // 5: hashicorp.consul.internal.peering.PeeringSecrets.stream:type_name -> hashicorp.consul.internal.peering.PeeringSecrets.Stream
	40, // 6: hashicorp.consul.internal.peering.Peering.DeletedAt:type_name -> google.protobuf.Timestamp
	36, // 7: hashicorp.consul.internal.peering.Peering.Meta:type_name -> hashicorp.consul.internal.peering.Peering.MetaEntry
	0,  // 8: hashicorp.consul.internal.peering.Peering.State:type_name -> hashicorp.consul.internal.peering.PeeringState
	5,  // 9: hashicorp.consul.internal.peering.Peering.StreamStatus:type_name -> hashicorp.consul.internal.peering.StreamStatus
	4,  // 10: hashicorp.consul.internal.peering.Peering.Remote:type_name -> hashicorp.consul.internal.peering.RemoteInfo
	41, // 11: hashicorp.consul.internal.peering.RemoteInfo.Locality:type_name -> hashicorp.consul.internal.common.Locality
	40, // 12: hashicorp.consul.internal.peering.StreamStatus.LastHeartbeat:type_name -> google.protobuf.Timestamp
	40, // 13: hashicorp.consul.internal.peering.StreamStatus.LastReceive:type_name -> google.protobuf.Timestamp
	40, // 14: hashicorp.consul.internal.peering.StreamStatus.LastSend:type_name -> google.protobuf.Timestamp
	3,  // 15: hashicorp.consul.internal.peering.PeeringReadResponse.Peering:type_name -> hashicorp.consul.internal.peering.Peering
	3,  // 16: hashicorp.consul.internal.peering.PeeringListResponse.Peerings:type_name -> hashicorp.consul.internal.peering.Peering
	3,  // 17: hashicorp.consul.internal.peering.PeeringWriteRequest.Peering:type_name -> hashicorp.consul.internal.peering.Peering
	1,  // 18: hashicorp.consul.internal.peering.PeeringWriteRequest.SecretsRequest:type_name -> hashicorp.consul.internal.peering.SecretsWriteRequest
	37, // 19: hashicorp.consul.internal.peering.PeeringWriteRequest.Meta:type_name -> hashicorp.consul.internal.peering.PeeringWriteRequest.MetaEntry
	6,  // 20: hashicorp.consul.internal.peering.TrustBundleListByServiceResponse.Bundles:type_name -> hashicorp.consul.internal.peering.PeeringTrustBundle
	6,  // 21: hashicorp.consul.internal.peering.TrustBundleReadResponse.Bundle:type_name -> hashicorp.consul.internal.peering.PeeringTrustBundle
	6,  // 22: hashicorp.consul.internal.peering.PeeringTrustBundleWriteRequest.PeeringTrustBundle:type_name -> hashicorp.consul.internal.peering.PeeringTrustBundle
	38, // 23: hashicorp.consul.internal.peering.GenerateTokenRequest.Meta:type_name -> hashicorp.consul.internal.peering.GenerateTokenRequest.MetaEntry
	39, // 24: hashicorp.consul.internal.peering.EstablishRequest.Meta:type_name -> hashicorp.consul.internal.peering.EstablishRequest.MetaEntry
	26, // 25: hashicorp.consul.internal.peering.PeeringService.GenerateToken:input_type -> hashicorp.consul.internal.peering.GenerateTokenRequest
	28, // 26: hashicorp.consul.internal.peering.PeeringService.Establish:input_type -> hashicorp.consul.internal.peering.EstablishRequest
	8,  // 27: hashicorp.consul.internal.peering.PeeringService.PeeringRead:input_type -> hashicorp.consul.internal.peering.PeeringReadRequest
	10, // 28: hashicorp.consul.internal.peering.PeeringService.PeeringList:input_type -> hashicorp.consul.internal.peering.PeeringListRequest
	14, // 29: hashicorp.consul.internal.peering.PeeringService.PeeringDelete:input_type -> hashicorp.consul.internal.peering.PeeringDeleteRequest
	12, // 30: hashicorp.consul.internal.peering.PeeringService.PeeringWrite:input_type -> hashicorp.consul.internal.peering.PeeringWriteRequest
	16, // 31: hashicorp.consul.internal.peering.PeeringService.TrustBundleListByService:input_type -> hashicorp.consul.internal.peering.TrustBundleListByServiceRequest
	18, // 32: hashicorp.consul.internal.peering.PeeringService.TrustBundleRead:input_type -> hashicorp.consul.internal.peering.TrustBundleReadRequest
	27, // 33: hashicorp.consul.internal.peering.PeeringService.GenerateToken:output_type -> hashicorp.consul.internal.peering.GenerateTokenResponse
	29, // 34: hashicorp.consul.internal.peering.PeeringService.Establish:output_type -> hashicorp.consul.internal.peering.EstablishResponse
	9,  // 35: hashicorp.consul.internal.peering.PeeringService.PeeringRead:output_type -> hashicorp.consul.internal.peering.PeeringReadResponse
	11, // 36: hashicorp.consul.internal.peering.PeeringService.PeeringList:output_type -> hashicorp.consul.internal.peering.PeeringListResponse
	15, // 37: hashicorp.consul.internal.peering.PeeringService.PeeringDelete:output_type -> hashicorp.consul.internal.peering.PeeringDeleteResponse
	13, // 38: hashicorp.consul.internal.peering.PeeringService.PeeringWrite:output_type -> hashicorp.consul.internal.peering.PeeringWriteResponse
	17, // 39: hashicorp.consul.internal.peering.PeeringService.TrustBundleListByService:output_type -> hashicorp.consul.internal.peering.TrustBundleListByServiceResponse
	19, // 40: hashicorp.consul.internal.peering.PeeringService.TrustBundleRead:output_type -> hashicorp.consul.internal.peering.TrustBundleReadResponse
	33, // [33:41] is the sub-list for method output_type
	25, // [25:33] is the sub-list for method input_type
	25, // [25:25] is the sub-list for extension type_name
	25, // [25:25] is the sub-list for extension extendee
	0,  // [0:25] is the sub-list for field type_name
}

func init() { file_private_pbpeering_peering_proto_init() }
func file_private_pbpeering_peering_proto_init() {
	if File_private_pbpeering_peering_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_private_pbpeering_peering_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SecretsWriteRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbpeering_peering_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PeeringSecrets); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbpeering_peering_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Peering); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbpeering_peering_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RemoteInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbpeering_peering_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StreamStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbpeering_peering_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PeeringTrustBundle); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbpeering_peering_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PeeringServerAddresses); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbpeering_peering_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PeeringReadRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbpeering_peering_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PeeringReadResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbpeering_peering_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PeeringListRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbpeering_peering_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PeeringListResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbpeering_peering_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PeeringWriteRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbpeering_peering_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PeeringWriteResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbpeering_peering_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PeeringDeleteRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbpeering_peering_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PeeringDeleteResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbpeering_peering_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TrustBundleListByServiceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbpeering_peering_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TrustBundleListByServiceResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbpeering_peering_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TrustBundleReadRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbpeering_peering_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TrustBundleReadResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbpeering_peering_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PeeringTerminateByIDRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbpeering_peering_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PeeringTerminateByIDResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbpeering_peering_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PeeringTrustBundleWriteRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbpeering_peering_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PeeringTrustBundleWriteResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbpeering_peering_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PeeringTrustBundleDeleteRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbpeering_peering_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PeeringTrustBundleDeleteResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbpeering_peering_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenerateTokenRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbpeering_peering_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenerateTokenResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbpeering_peering_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EstablishRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbpeering_peering_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EstablishResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbpeering_peering_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SecretsWriteRequest_GenerateTokenRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbpeering_peering_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SecretsWriteRequest_ExchangeSecretRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbpeering_peering_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SecretsWriteRequest_PromotePendingRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbpeering_peering_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SecretsWriteRequest_EstablishRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbpeering_peering_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PeeringSecrets_Establishment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbpeering_peering_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PeeringSecrets_Stream); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_private_pbpeering_peering_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*SecretsWriteRequest_GenerateToken)(nil),
		(*SecretsWriteRequest_ExchangeSecret)(nil),
		(*SecretsWriteRequest_PromotePending)(nil),
		(*SecretsWriteRequest_Establish)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_private_pbpeering_peering_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   39,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_private_pbpeering_peering_proto_goTypes,
		DependencyIndexes: file_private_pbpeering_peering_proto_depIdxs,
		EnumInfos:         file_private_pbpeering_peering_proto_enumTypes,
		MessageInfos:      file_private_pbpeering_peering_proto_msgTypes,
	}.Build()
	File_private_pbpeering_peering_proto = out.File
	file_private_pbpeering_peering_proto_rawDesc = nil
	file_private_pbpeering_peering_proto_goTypes = nil
	file_private_pbpeering_peering_proto_depIdxs = nil
}
