/*
 * Copyright (C) 2000-2007 Carsten Haitzler, Geoff Harrison and various contributors
 * Copyright (C) 2004-2022 Kim Woelders
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies of the Software, its documentation and marketing & publicity
 * materials, and acknowledgment shall be given in the documentation, materials
 * and software packages that this Software was used.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#ifndef _HINTS_H_
#define _HINTS_H_

#include "etypes.h"
#include "xwin.h"

/* ewmh.c */
void            EWMH_Init(EX_Window win_wm_check);
void            EWMH_SetDesktopCount(void);
void            EWMH_SetDesktopRoots(void);
void            EWMH_SetDesktopNames(void);
void            EWMH_SetDesktopSize(void);
void            EWMH_SetCurrentDesktop(void);
void            EWMH_SetDesktopViewport(void);
void            EWMH_SetWorkArea(void);
void            EWMH_SetClientList(void);
void            EWMH_SetClientStacking(void);
void            EWMH_SetActiveWindow(EX_Window win);
void            EWMH_SetShowingDesktop(int on);
void            EWMH_SetWindowName(EX_Window win, const char *name);
void            EWMH_SetWindowDesktop(const EWin * ewin);
void            EWMH_SetWindowState(const EWin * ewin);
void            EWMH_SetWindowBorder(const EWin * ewin);
void            EWMH_SetWindowOpacity(EWin * ewin);
void            EWMH_SetWindowActions(const EWin * ewin);
void            EWMH_GetWindowHints(EWin * ewin);
void            EWMH_DelWindowHints(const EWin * ewin);
int             EWMH_ProcessPropertyChange(EWin * ewin, EX_Atom atom_change);
int             EWMH_ProcessClientClientMessage(EWin * ewin,
                                                XClientMessageEvent * event);
int             EWMH_ProcessRootClientMessage(XClientMessageEvent * event);

/* hints.c */
void            HintsInit(void);
void            HintsSetDesktopNames(void);
void            HintsSetDesktopConfig(void);
void            HintsSetViewportConfig(void);
void            HintsSetCurrentDesktop(void);
void            HintsSetDesktopViewport(void);
void            HintsSetClientList(void);
void            HintsSetClientStacking(void);
void            HintsSetActiveWindow(EX_Window win);
void            HintsSetWindowName(Win win, const char *name);
void            HintsSetWindowClass(Win win, const char *name,
                                    const char *clss);
void            HintsSetWindowDesktop(const EWin * ewin);
void            HintsSetWindowArea(const EWin * ewin);
void            HintsSetWindowState(const EWin * ewin);
void            HintsSetWindowOpacity(EWin * ewin);
void            HintsSetWindowBorder(const EWin * ewin);
void            HintsGetWindowHints(EWin * ewin);
void            HintsDelWindowHints(const EWin * ewin);
void            HintsProcessPropertyChange(EWin * ewin, XEvent * ev);
void            HintsProcessClientClientMessage(EWin * ewin,
                                                XClientMessageEvent * event);
void            HintsProcessRootClientMessage(XClientMessageEvent * event);

EX_Pixmap       HintsGetRootPixmap(Win win);
void            HintsSetRootHints(Win win);
void            HintsSetRootInfo(Win win, EX_Pixmap pmap, unsigned int color);

void            EHintsSetInfo(const EWin * ewin);
void            EHintsGetInfo(EWin * ewin);
void            EHintsGetDeskInfo(void);
void            EHintsSetInfoOnAll(void);

typedef struct _selection ESelection;
ESelection     *SelectionAcquire(const char *name, EventCallbackFunc * func,
                                 void *data);
void            SelectionRelease(ESelection * sel);

/* icccm.c */
void            ICCCM_Init(void);
int             ICCCM_ProcessClientClientMessage(EWin * ewin,
                                                 XClientMessageEvent * event);
int             ICCCM_ProcessRootClientMessage(XClientMessageEvent * event);
void            ICCCM_GetTitle(EWin * ewin);
void            ICCCM_Delete(const EWin * ewin);
void            ICCCM_Iconify(const EWin * ewin);
void            ICCCM_DeIconify(const EWin * ewin);
void            ICCCM_SizeMatch(const EWin * ewin, int wi, int hi, int *pwo,
                                int *pho);
void            ICCCM_GetIncrementalSize(EWin * ewin, unsigned int w,
                                         unsigned int h, unsigned int *wi,
                                         unsigned int *hi);
void            ICCCM_SetSizeConstraints(EWin * ewin, unsigned int wmin,
                                         unsigned int hmin,
                                         unsigned int wmax,
                                         unsigned int hmax,
                                         unsigned int wbase,
                                         unsigned int hbase,
                                         unsigned int winc,
                                         unsigned int hinc,
                                         float amin, float amax);
void            ICCCM_Configure(EWin * ewin);
void            ICCCM_AdoptStart(const EWin * ewin);
void            ICCCM_Adopt(const EWin * ewin);
void            ICCCM_Withdraw(const EWin * ewin);
void            ICCCM_Cmap(EWin * ewin);
void            ICCCM_Focus(const EWin * ewin);
void            ICCCM_GetGeoms(EWin * ewin);
void            ICCCM_GetInfo(EWin * ewin);
void            ICCCM_GetHints(EWin * ewin);
int             ICCCM_ProcessPropertyChange(EWin * ewin, EX_Atom atom_change);

/* mwm.c */
void            MWM_GetHints(EWin * ewin, EX_Atom atom_change);
void            MWM_SetInfo(void);

#endif                          /* _HINTS_H_ */
