/*
 * Copyright (C) 2000-2007 Carsten Haitzler, Geoff Harrison and various contributors
 * Copyright (C) 2004-2023 Kim Woelders
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies of the Software, its documentation and marketing & publicity
 * materials, and acknowledgment shall be given in the documentation, materials
 * and software packages that this Software was used.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#ifndef _ETYPES_H_
#define _ETYPES_H_

/*
 * Opaque types
 */
typedef struct _background Background;

typedef struct _border Border;

typedef struct _button Button;

typedef struct _desk Desk;

typedef struct _ecursor ECursor;

typedef struct _ewin EWin;
typedef struct _ewinbit EWinBit;

typedef struct _group Group;

typedef struct _action Action;
typedef struct _actionclass ActionClass;

typedef struct _imageclass ImageClass;
typedef struct _imagestate ImageState;

typedef struct _textclass TextClass;
typedef struct _textstate TextState;

typedef struct _snapshot Snapshot;

typedef struct _timer Timer;
typedef struct _idler Idler;
typedef struct _animator Animator;

typedef struct {
    int             x;
    int             y;
    int             w;
    int             h;
} Area;

#endif                          /* _ETYPES_H_ */
