/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.generate;

import com.intellij.openapi.util.Pair;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class CanonicalSorters {
    private CanonicalSorters() {
        throw new AssertionError((Object)"Not for instantiation");
    }

    public static <T> Function<List<T>, List<T>> stableSortBySerializedBytes(DataExternalizer<T> externalizer) {
        return items -> items.stream().map(item -> Pair.pair((Object)item, (Object)CanonicalSorters.toBytesRethrowUnchecked(item, externalizer))).sorted((o1, o2) -> Arrays.compare((byte[])o1.second, (byte[])o2.second)).map(pair -> pair.first).toList();
    }

    public static <T> Function<List<T>, List<T>> stableSortByHashCodeAndBytes(KeyDescriptor<T> descriptor) {
        return items -> items.stream().sorted((i1, i2) -> {
            int i2Hash;
            int i1Hash = descriptor.getHashCode(i1);
            if (i1Hash != (i2Hash = descriptor.getHashCode(i1))) {
                return Integer.compare(i1Hash, i2Hash);
            }
            byte[] i1Bytes = CanonicalSorters.toBytesRethrowUnchecked(i1, descriptor);
            byte[] i2Bytes = CanonicalSorters.toBytesRethrowUnchecked(i2, descriptor);
            return Arrays.compare(i1Bytes, i2Bytes);
        }).toList();
    }

    public static <T> Comparator<T> bySerializedBytes(DataExternalizer<T> externalizer) {
        return (o1, o2) -> Arrays.compare(CanonicalSorters.toBytesRethrowUnchecked(o1, externalizer), CanonicalSorters.toBytesRethrowUnchecked(o2, externalizer));
    }

    private static <T> byte[] toBytesRethrowUnchecked(T object, @NotNull DataExternalizer<T> externalizer) {
        if (externalizer == null) {
            CanonicalSorters.$$$reportNull$$$0(0);
        }
        try {
            return IOUtil.toBytes(object, externalizer);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Can't serialize " + object, e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalizer", "com/intellij/indexing/shared/generate/CanonicalSorters", "toBytesRethrowUnchecked"));
    }
}

