/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Query;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import org.intellij.plugins.relaxNG.RelaxngBundle;
import org.intellij.plugins.relaxNG.compact.psi.RncDefine;
import org.intellij.plugins.relaxNG.compact.psi.RncElementVisitor;
import org.intellij.plugins.relaxNG.compact.psi.RncGrammar;
import org.intellij.plugins.relaxNG.compact.psi.impl.RncDefineImpl;
import org.intellij.plugins.relaxNG.inspections.BaseInspection;
import org.intellij.plugins.relaxNG.model.resolve.RelaxIncludeIndex;
import org.intellij.plugins.relaxNG.xml.dom.RngGrammar;
import org.jetbrains.annotations.NotNull;

public class UnusedDefineInspection
extends BaseInspection {
    @Override
    @NotNull
    public RncElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            UnusedDefineInspection.$$$reportNull$$$0(0);
        }
        return new MyElementVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/intellij/plugins/relaxNG/inspections/UnusedDefineInspection", "buildVisitor"));
    }

    private static final class MyElementVisitor
    extends RncElementVisitor {
        private final ProblemsHolder myHolder;
        private final XmlElementVisitor myXmlVisitor = new XmlElementVisitor(){

            public void visitXmlTag(@NotNull XmlTag tag) {
                if (tag == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.visitXmlTag(tag);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "org/intellij/plugins/relaxNG/inspections/UnusedDefineInspection$MyElementVisitor$1", "visitXmlTag"));
            }
        };

        MyElementVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        @Override
        protected void superVisitElement(PsiElement element) {
            element.accept((PsiElementVisitor)this.myXmlVisitor);
        }

        @Override
        public void visitDefine(RncDefine pattern) {
            RncGrammar grammar = (RncGrammar)PsiTreeUtil.getParentOfType((PsiElement)pattern, RncGrammar.class);
            PsiFile file = pattern.getContainingFile();
            if (grammar != null ? MyElementVisitor.processRncUsages(pattern, new LocalSearchScope((PsiElement)grammar)) : MyElementVisitor.processRncUsages(pattern, new LocalSearchScope((PsiElement)file))) {
                return;
            }
            PsiElementProcessor.CollectElements collector = new PsiElementProcessor.CollectElements();
            RelaxIncludeIndex.processBackwardDependencies((XmlFile)file, (PsiElementProcessor<? super XmlFile>)collector);
            if (MyElementVisitor.processRncUsages(pattern, new LocalSearchScope(collector.toArray()))) {
                return;
            }
            ASTNode astNode = ((RncDefineImpl)pattern).getNameNode();
            this.myHolder.registerProblem(astNode.getPsi(), RelaxngBundle.message("relaxng.inspection.unused-define.message", new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new MyFix()});
        }

        private static boolean processRncUsages(PsiElement tag, LocalSearchScope scope) {
            Query query2 = ReferencesSearch.search((PsiElement)tag, (SearchScope)scope);
            for (PsiReference reference : query2) {
                PsiElement e = reference.getElement();
                RncDefine t = (RncDefine)PsiTreeUtil.getParentOfType((PsiElement)e, RncDefine.class, (boolean)false);
                if (t != null && PsiTreeUtil.isAncestor((PsiElement)tag, (PsiElement)t, (boolean)true)) continue;
                return true;
            }
            return false;
        }

        public void visitXmlTag(XmlTag tag) {
            PsiFile file = tag.getContainingFile();
            if (file.getFileType() != XmlFileType.INSTANCE) {
                return;
            }
            if (!tag.getLocalName().equals("define")) {
                return;
            }
            if (!tag.getNamespace().equals("http://relaxng.org/ns/structure/1.0")) {
                return;
            }
            if (tag.getAttribute("combine") != null) {
                return;
            }
            XmlAttribute attr = tag.getAttribute("name");
            if (attr == null) {
                return;
            }
            XmlAttributeValue value = attr.getValueElement();
            if (value == null) {
                return;
            }
            String s = value.getValue();
            if (s.length() == 0) {
                return;
            }
            PsiElement parent = value.getParent();
            if (!(parent instanceof XmlAttribute)) {
                return;
            }
            if (!"name".equals(((XmlAttribute)parent).getName())) {
                return;
            }
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof XmlTag)) {
                return;
            }
            DomElement element = DomManager.getDomManager((Project)tag.getProject()).getDomElement(tag);
            if (element == null) {
                return;
            }
            RngGrammar rngGrammar = (RngGrammar)element.getParentOfType(RngGrammar.class, true);
            if (rngGrammar != null ? MyElementVisitor.processUsages((PsiElement)tag, value, new LocalSearchScope((PsiElement)rngGrammar.getXmlTag())) : MyElementVisitor.processUsages((PsiElement)tag, value, new LocalSearchScope((PsiElement)file))) {
                return;
            }
            PsiElementProcessor.CollectElements collector = new PsiElementProcessor.CollectElements();
            RelaxIncludeIndex.processBackwardDependencies((XmlFile)file, (PsiElementProcessor<? super XmlFile>)collector);
            if (MyElementVisitor.processUsages((PsiElement)tag, value, new LocalSearchScope(collector.toArray()))) {
                return;
            }
            this.myHolder.registerProblem((PsiElement)value, RelaxngBundle.message("relaxng.inspection.unused-define.message", new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new MyFix()});
        }

        private static boolean processUsages(PsiElement tag, XmlAttributeValue value, LocalSearchScope scope) {
            Query query2 = ReferencesSearch.search((PsiElement)tag, (SearchScope)scope, (boolean)true);
            for (PsiReference reference : query2) {
                XmlTag t;
                PsiElement e = reference.getElement();
                if (e == value || (t = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)e, XmlTag.class)) == null || PsiTreeUtil.isAncestor((PsiElement)tag, (PsiElement)t, (boolean)true)) continue;
                return true;
            }
            return false;
        }

        private static class MyFix<T extends PsiElement>
        implements LocalQuickFix {
            private MyFix() {
            }

            @NotNull
            public String getFamilyName() {
                String string = RelaxngBundle.message("relaxng.quickfix.remove-define", new Object[0]);
                if (string == null) {
                    MyFix.$$$reportNull$$$0(0);
                }
                return string;
            }

            public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
                if (project2 == null) {
                    MyFix.$$$reportNull$$$0(1);
                }
                if (descriptor == null) {
                    MyFix.$$$reportNull$$$0(2);
                }
                PsiElement myTag = (PsiElement)ObjectUtils.doIfNotNull((Object)descriptor.getPsiElement(), PsiElement::getParent);
                try {
                    if (myTag instanceof RncDefine && myTag.isValid()) {
                        myTag.delete();
                    }
                }
                catch (IncorrectOperationException e) {
                    Logger.getInstance((String)UnusedDefineInspection.class.getName()).error((Throwable)e);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/intellij/plugins/relaxNG/inspections/UnusedDefineInspection$MyElementVisitor$MyFix";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "descriptor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/intellij/plugins/relaxNG/inspections/UnusedDefineInspection$MyElementVisitor$MyFix";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "applyFix";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1, 2 -> new IllegalArgumentException(string);
                };
            }
        }
    }
}

