/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync.git.renderers;

import com.intellij.settingsSync.SettingsSyncBundle;
import com.intellij.settingsSync.git.record.ChangeRecord;
import com.intellij.settingsSync.git.record.HistoryRecord;
import com.intellij.settingsSync.git.renderers.SettingsHistoryCellRenderer;
import com.intellij.settingsSync.git.table.SettingsHistoryTable;
import com.intellij.settingsSync.git.table.SettingsHistoryTableRow;
import com.intellij.settingsSync.git.table.TitleRow;
import com.intellij.util.ui.UIUtil;
import icons.SettingsSyncIcons;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\t\u001a\u00020\nH\u0003J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\u0010\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J \u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0005H\u0002J \u0010!\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0005H\u0002J(\u0010\"\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u0005H\u0002J\f\u0010%\u001a\u00020\u000e*\u00020\u001cH\u0002J(\u0010&\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/intellij/settingsSync/git/renderers/SettingsHistoryNodeCellRenderer;", "Lcom/intellij/settingsSync/git/renderers/SettingsHistoryCellRenderer;", "<init>", "()V", "nodeCenterX", "", "remoteIcon", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "row", "Lcom/intellij/settingsSync/git/table/SettingsHistoryTableRow;", "isGreyedOut", "", "customizeHistoryCellRenderer", "", "table", "Lcom/intellij/settingsSync/git/table/SettingsHistoryTable;", "selected", "hasFocus", "rowIndex", "", "determineToolTipText", "", "paintComponent", "g", "Ljava/awt/Graphics;", "drawNode", "g2", "Ljava/awt/Graphics2D;", "drawLocalNode", "record", "Lcom/intellij/settingsSync/git/record/HistoryRecord;", "centerY", "drawRemoteNode", "drawTopBottomLines", "topIconPoint", "bottomIconPoint", "setRenderingHints", "drawVerticalLine", "x", "y1", "y2", "intellij.settingsSync.git"})
public final class SettingsHistoryNodeCellRenderer
extends SettingsHistoryCellRenderer {
    private final double nodeCenterX;
    @NotNull
    private final Icon remoteIcon;
    @Nullable
    private SettingsHistoryTableRow row;
    private boolean isGreyedOut;

    public SettingsHistoryNodeCellRenderer() {
        this.nodeCenterX = 20.0;
        Icon icon = SettingsSyncIcons.RemoteChanges;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"RemoteChanges");
        this.remoteIcon = icon;
    }

    @Override
    public void customizeHistoryCellRenderer(@NotNull SettingsHistoryTable table, @NotNull SettingsHistoryTableRow row, boolean selected, boolean hasFocus, int rowIndex) {
        Intrinsics.checkNotNullParameter((Object)((Object)table), (String)"table");
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        this.row = row;
        this.isGreyedOut = this.isGreyedOut(table, rowIndex);
        this.setToolTipText(this.determineToolTipText(row));
    }

    @Nls
    private final String determineToolTipText(SettingsHistoryTableRow row) {
        return row instanceof TitleRow ? (Intrinsics.areEqual((Object)row.getRecord().getOrigin(), (Object)ChangeRecord.ChangeOrigin.Local.INSTANCE) ? SettingsSyncBundle.INSTANCE.message("ui.toolwindow.node.local", new Object[0]) : SettingsSyncBundle.INSTANCE.message("ui.toolwindow.node.remote", new Object[0])) : null;
    }

    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        super.paintComponent(g);
        Graphics graphics = g.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g2 = (Graphics2D)graphics;
        g2.setColor(UIUtil.getLabelDisabledForeground());
        if (this.isGreyedOut) {
            g2.setComposite(AlphaComposite.SrcOver.derive(0.6f));
        }
        if (this.row instanceof TitleRow) {
            this.drawNode(g2);
        } else {
            this.drawVerticalLine(g2, this.nodeCenterX, 0.0, this.getHeight());
        }
    }

    private final void drawNode(Graphics2D g2) {
        Object object = this.row;
        if (object == null || (object = ((SettingsHistoryTableRow)object).getRecord()) == null) {
            return;
        }
        Object record = object;
        double centerY = (double)this.getHeight() / 2.0;
        if (Intrinsics.areEqual((Object)((ChangeRecord)record).getOrigin(), (Object)ChangeRecord.ChangeOrigin.Local.INSTANCE)) {
            this.drawLocalNode(g2, (HistoryRecord)record, centerY);
        } else {
            this.drawRemoteNode(g2, (HistoryRecord)record, centerY);
        }
    }

    private final void drawLocalNode(Graphics2D g2, HistoryRecord record, double centerY) {
        double diameter = SettingsHistoryCellRenderer.isOldUI() ? 6.0 : 5.0;
        double radius = diameter / (double)2;
        this.drawTopBottomLines(g2, record, centerY - radius, centerY + radius);
        Ellipse2D.Double oval = new Ellipse2D.Double(this.nodeCenterX - radius, centerY - radius, diameter, diameter);
        this.setRenderingHints(g2);
        g2.fill(oval);
    }

    private final void drawRemoteNode(Graphics2D g2, HistoryRecord record, double centerY) {
        int iconHeight = this.remoteIcon.getIconHeight();
        this.remoteIcon.paintIcon((Component)((Object)this), g2, (int)(this.nodeCenterX - (double)(iconHeight / 2)), (int)(centerY - (double)(iconHeight / 2)));
        this.drawTopBottomLines(g2, record, centerY - (double)(iconHeight / 2), centerY + (double)(iconHeight / 2));
    }

    private final void drawTopBottomLines(Graphics2D g2, HistoryRecord record, double topIconPoint, double bottomIconPoint) {
        if (SettingsHistoryCellRenderer.isOldUI()) {
            return;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[record.getPosition().ordinal()]) {
            case 1: {
                this.drawVerticalLine(g2, this.nodeCenterX, 0.0, topIconPoint);
                this.drawVerticalLine(g2, this.nodeCenterX, bottomIconPoint, this.getHeight());
                break;
            }
            case 2: {
                this.drawVerticalLine(g2, this.nodeCenterX, bottomIconPoint, this.getHeight());
                break;
            }
            case 3: {
                this.drawVerticalLine(g2, this.nodeCenterX, 0.0, topIconPoint);
                break;
            }
            case 4: {
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final void setRenderingHints(Graphics2D $this$setRenderingHints) {
        $this$setRenderingHints.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        $this$setRenderingHints.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
    }

    private final void drawVerticalLine(Graphics2D g2, double x, double y1, double y2) {
        if (SettingsHistoryCellRenderer.isOldUI()) {
            g2.setStroke(new BasicStroke(2.0f));
        }
        Line2D.Double line = new Line2D.Double(x, y1, x, y2);
        g2.draw(line);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[HistoryRecord.RecordPosition.values().length];
            try {
                nArray[HistoryRecord.RecordPosition.MIDDLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HistoryRecord.RecordPosition.TOP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HistoryRecord.RecordPosition.BOTTOM.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HistoryRecord.RecordPosition.SINGLE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

