/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.feedback;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.lang.Language;
import com.intellij.ml.inline.completion.impl.MLCompletionNotifications;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import java.net.URL;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.completion.full.line.experiments.FullLineExperimentFetcher;
import org.jetbrains.completion.full.line.feedback.ExplicitFeedbackKt;
import org.jetbrains.completion.full.line.feedback.ExplicitFeedbackStateComponent;
import org.jetbrains.completion.full.line.language.supporters.FullLineLanguageSettings;
import org.jetbrains.completion.full.line.language.supporters.FullLineLanguageSupporter;
import org.jetbrains.completion.full.line.settings.FullLineBundle;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\b\u001a\u00020\tJ \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0006H\u0002J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0013\u001a\u00020\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\"\u0010\u0014\u001a\u00020\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\n\u0010\u001a\u001a\u0004\u0018\u00010\u0006H\u0002R\u001f\u0010\u0004\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\t\u0012\u00070\u0006\u00a2\u0006\u0002\b\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/completion/full/line/feedback/ExplicitFeedback;", "", "<init>", "()V", "contents", "", "", "Lorg/jetbrains/annotations/Nls;", "isSupported", "", "registerCompletion", "", "accepted", "language", "Lcom/intellij/lang/Language;", "project", "Lcom/intellij/openapi/project/Project;", "getMostPopularLanguage", "isLanguageSupported", "requestFeedback", "showNotification", "mostPopularLanguage", "acceptedCompletionsCount", "", "getFeedbackUrl", "Ljava/net/URL;", "getPluginVersion", "intellij.fullLine"})
@SourceDebugExtension(value={"SMAP\nExplicitFeedback.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExplicitFeedback.kt\norg/jetbrains/completion/full/line/feedback/ExplicitFeedback\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,175:1\n1#2:176\n*E\n"})
public final class ExplicitFeedback {
    @NotNull
    public static final ExplicitFeedback INSTANCE = new ExplicitFeedback();
    @NotNull
    private static final Map<String, String> contents;

    private ExplicitFeedback() {
    }

    public final boolean isSupported() {
        return ApplicationManager.getApplication().isEAP() && !ExplicitFeedbackStateComponent.Companion.getInstance().isNotificationShown();
    }

    public final void registerCompletion(boolean accepted, @NotNull Language language, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        if (!this.isSupported() || !this.isLanguageSupported(language)) {
            return;
        }
        ExplicitFeedbackStateComponent feedbackState = ExplicitFeedbackStateComponent.Companion.getInstance();
        feedbackState.fireCompletionShown(language);
        if (accepted) {
            feedbackState.fireCompletionAccepted();
        }
        if (feedbackState.getSessionsCount() >= 30 && this.getMostPopularLanguage() != null) {
            this.requestFeedback(project);
        }
    }

    private final String getMostPopularLanguage() {
        return ExplicitFeedbackStateComponent.Companion.getInstance().getMostPopularLanguage();
    }

    private final boolean isLanguageSupported(Language language) {
        Integer currentExperiment;
        Map map2 = ExplicitFeedbackKt.access$getTargetExperiments$p();
        String string = language.getID();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getID(...)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        Integer targetExperiment = (Integer)map2.get(string2);
        FullLineExperimentFetcher fullLineExperimentFetcher = FullLineExperimentFetcher.Companion.getInstance();
        Integer n = currentExperiment = fullLineExperimentFetcher != null ? fullLineExperimentFetcher.getExperimentNumber(language) : null;
        if (!Intrinsics.areEqual((Object)targetExperiment, (Object)currentExperiment)) {
            return false;
        }
        Object object = FullLineLanguageSupporter.Companion.getInstance(language);
        return object != null && (object = object.getLanguageSettings()) != null ? ((FullLineLanguageSettings)object).isExplicitFeedbackEnabled() : false;
    }

    public final void requestFeedback(@Nullable Project project) {
        ExplicitFeedbackStateComponent feedbackState = ExplicitFeedbackStateComponent.Companion.getInstance();
        String language = this.getMostPopularLanguage();
        if (language == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        this.showNotification(project, language, feedbackState.getAcceptedCompletionsCnt());
        feedbackState.fireNotificationShown();
    }

    private final void showNotification(Project project, String mostPopularLanguage, int acceptedCompletionsCount) {
        String string = mostPopularLanguage.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String string2 = contents.get(string);
        if (string2 == null) {
            string2 = "You may have noticed that the Full Line Code Completion plugin's suggestion are changed. Please share your opinion on this. We really appreciate your feedback!";
        }
        String content = string2;
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Full Line Completion Plugin");
        Intrinsics.checkNotNullExpressionValue((Object)notificationGroup, (String)"getNotificationGroup(...)");
        AnAction[] anActionArray = new AnAction[]{MLCompletionNotifications.INSTANCE.action(FullLineBundle.message("full.line.notifications.feedback.button", new Object[0]), (arg_0, arg_1) -> ExplicitFeedback.showNotification$lambda$0(mostPopularLanguage, acceptedCompletionsCount, arg_0, arg_1))};
        MLCompletionNotifications.showFullContentBalloon$default((MLCompletionNotifications)MLCompletionNotifications.INSTANCE, (NotificationGroup)notificationGroup, (Project)project, (String)FullLineBundle.message("full.line.notifications.feedback.title", new Object[0]), (String)content, (NotificationType)NotificationType.INFORMATION, (AnAction[])anActionArray, null, (int)64, null);
    }

    /*
     * WARNING - void declaration
     */
    private final URL getFeedbackUrl(String language, int acceptedCompletionsCount) {
        Pair pair2;
        Object[] objectArray;
        Map map2 = ExplicitFeedbackKt.access$getFeedbackUrls$p();
        String string = language.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String urlHost = map2.getOrDefault(string, "https://surveys.jetbrains.com/s3/ktln-full-line-completion-feedback");
        ApplicationInfoEx applicationInfo = ApplicationInfoEx.getInstanceEx();
        Object[] objectArray2 = objectArray = new Pair[5];
        int n = 0;
        String string2 = this.getPluginVersion();
        if (string2 != null) {
            void it;
            String string3 = string2;
            int n2 = n;
            Object[] objectArray3 = objectArray2;
            boolean bl = false;
            Pair pair3 = TuplesKt.to((Object)"flcc-version", (Object)it);
            objectArray2 = objectArray3;
            n = n2;
            pair2 = pair3;
        } else {
            pair2 = null;
        }
        objectArray2[n] = pair2;
        objectArray[1] = TuplesKt.to((Object)"ide-name", (Object)applicationInfo.getVersionName());
        objectArray[2] = TuplesKt.to((Object)"ide-version", (Object)applicationInfo.getApiVersionAsNumber().asStringWithoutProductCode());
        objectArray[3] = TuplesKt.to((Object)"accepted-count", (Object)String.valueOf(acceptedCompletionsCount));
        objectArray[4] = TuplesKt.to((Object)"language", (Object)language);
        String params = CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray), (CharSequence)"&", null, null, (int)0, null, ExplicitFeedback::getFeedbackUrl$lambda$2, (int)30, null);
        return new URL(urlHost + "?" + params);
    }

    private final String getPluginVersion() {
        IdeaPluginDescriptor plugin;
        IdeaPluginDescriptor ideaPluginDescriptor = plugin = PluginManagerCore.getPlugin((PluginId)PluginId.getId((String)"org.jetbrains.completion.full.line"));
        return ideaPluginDescriptor != null ? ideaPluginDescriptor.getVersion() : null;
    }

    private static final Unit showNotification$lambda$0(String $mostPopularLanguage, int $acceptedCompletionsCount, AnActionEvent anActionEvent, Notification notification) {
        Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
        URL url = INSTANCE.getFeedbackUrl($mostPopularLanguage, $acceptedCompletionsCount);
        BrowserUtil.browse((URL)url);
        notification.hideBalloon();
        return Unit.INSTANCE;
    }

    private static final CharSequence getFeedbackUrl$lambda$2(Pair pair2) {
        Intrinsics.checkNotNullParameter((Object)pair2, (String)"<destruct>");
        String p = (String)pair2.component1();
        String v = (String)pair2.component2();
        return p + "=" + v;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"python", (Object)FullLineBundle.message("full.line.notifications.explicit.feedback.multiline.content", new Object[0])), TuplesKt.to((Object)"java", (Object)FullLineBundle.message("full.line.notifications.explicit.feedback.context.fim.content", new Object[0])), TuplesKt.to((Object)"kotlin", (Object)FullLineBundle.message("full.line.notifications.explicit.feedback.context.rag.content", new Object[0]))};
        contents = MapsKt.mapOf((Pair[])pairArray);
    }
}

