/**
 * @file libadacl.h
 *
 * @brief The public API for libadacl.
 *
 */

#include <stdbool.h>  /* the "bool" type */
#include <sys/stat.h> /* the "struct stat" type */

/* Most of the libacl functions return 1 for success, 0 for failure,
 * and -1 on error. We follow suit.
*/
#define ACL_ERROR -1
#define ACL_FAILURE 0
#define ACL_SUCCESS 1

int apply_default_acl(const char* path, bool recursive);
