//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armnetwork_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/network/armnetwork/v4"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/ExpressRouteCircuitDelete.json
func ExampleExpressRouteCircuitsClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewExpressRouteCircuitsClient().BeginDelete(ctx, "rg1", "circuitName", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/ExpressRouteCircuitGet.json
func ExampleExpressRouteCircuitsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewExpressRouteCircuitsClient().Get(ctx, "rg1", "circuitName", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ExpressRouteCircuit = armnetwork.ExpressRouteCircuit{
	// 	Name: to.Ptr("circuitName"),
	// 	Type: to.Ptr("Microsoft.Network/expressRouteCircuits"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/expressRouteCircuits/circuitName"),
	// 	Location: to.Ptr("westus"),
	// 	Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
	// 	Properties: &armnetwork.ExpressRouteCircuitPropertiesFormat{
	// 		AllowClassicOperations: to.Ptr(false),
	// 		Authorizations: []*armnetwork.ExpressRouteCircuitAuthorization{
	// 		},
	// 		CircuitProvisioningState: to.Ptr("Enabled"),
	// 		Peerings: []*armnetwork.ExpressRouteCircuitPeering{
	// 		},
	// 		ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 		ServiceKey: to.Ptr("a1410692-0000-4ceb-b94a-b90b94d398d1"),
	// 		ServiceProviderProperties: &armnetwork.ExpressRouteCircuitServiceProviderProperties{
	// 			BandwidthInMbps: to.Ptr[int32](200),
	// 			PeeringLocation: to.Ptr("peeringLocation"),
	// 			ServiceProviderName: to.Ptr("providerName"),
	// 		},
	// 		ServiceProviderProvisioningState: to.Ptr(armnetwork.ServiceProviderProvisioningStateNotProvisioned),
	// 	},
	// 	SKU: &armnetwork.ExpressRouteCircuitSKU{
	// 		Name: to.Ptr("Standard_MeteredData"),
	// 		Family: to.Ptr(armnetwork.ExpressRouteCircuitSKUFamilyMeteredData),
	// 		Tier: to.Ptr(armnetwork.ExpressRouteCircuitSKUTierStandard),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/ExpressRouteCircuitCreate.json
func ExampleExpressRouteCircuitsClient_BeginCreateOrUpdate_createExpressRouteCircuit() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewExpressRouteCircuitsClient().BeginCreateOrUpdate(ctx, "rg1", "circuitName", armnetwork.ExpressRouteCircuit{
		Location: to.Ptr("Brazil South"),
		Properties: &armnetwork.ExpressRouteCircuitPropertiesFormat{
			AllowClassicOperations: to.Ptr(false),
			Authorizations:         []*armnetwork.ExpressRouteCircuitAuthorization{},
			Peerings:               []*armnetwork.ExpressRouteCircuitPeering{},
			ServiceProviderProperties: &armnetwork.ExpressRouteCircuitServiceProviderProperties{
				BandwidthInMbps:     to.Ptr[int32](200),
				PeeringLocation:     to.Ptr("Silicon Valley"),
				ServiceProviderName: to.Ptr("Equinix"),
			},
		},
		SKU: &armnetwork.ExpressRouteCircuitSKU{
			Name:   to.Ptr("Standard_MeteredData"),
			Family: to.Ptr(armnetwork.ExpressRouteCircuitSKUFamilyMeteredData),
			Tier:   to.Ptr(armnetwork.ExpressRouteCircuitSKUTierStandard),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ExpressRouteCircuit = armnetwork.ExpressRouteCircuit{
	// 	Name: to.Ptr("circuitName"),
	// 	Type: to.Ptr("Microsoft.Network/expressRouteCircuits"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/expressRouteCircuits/circuitName"),
	// 	Location: to.Ptr("Brazil South"),
	// 	Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
	// 	Properties: &armnetwork.ExpressRouteCircuitPropertiesFormat{
	// 		AllowClassicOperations: to.Ptr(false),
	// 		Authorizations: []*armnetwork.ExpressRouteCircuitAuthorization{
	// 		},
	// 		CircuitProvisioningState: to.Ptr("Enabled"),
	// 		Peerings: []*armnetwork.ExpressRouteCircuitPeering{
	// 		},
	// 		ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 		ServiceKey: to.Ptr("a1410692-0000-4ceb-b94a-b90b94d398d1"),
	// 		ServiceProviderProperties: &armnetwork.ExpressRouteCircuitServiceProviderProperties{
	// 			BandwidthInMbps: to.Ptr[int32](200),
	// 			PeeringLocation: to.Ptr("Silicon Valley"),
	// 			ServiceProviderName: to.Ptr("Equinix"),
	// 		},
	// 		ServiceProviderProvisioningState: to.Ptr(armnetwork.ServiceProviderProvisioningStateNotProvisioned),
	// 	},
	// 	SKU: &armnetwork.ExpressRouteCircuitSKU{
	// 		Name: to.Ptr("Standard_MeteredData"),
	// 		Family: to.Ptr(armnetwork.ExpressRouteCircuitSKUFamilyMeteredData),
	// 		Tier: to.Ptr(armnetwork.ExpressRouteCircuitSKUTierStandard),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/ExpressRouteCircuitCreateOnExpressRoutePort.json
func ExampleExpressRouteCircuitsClient_BeginCreateOrUpdate_createExpressRouteCircuitOnExpressRoutePort() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewExpressRouteCircuitsClient().BeginCreateOrUpdate(ctx, "rg1", "expressRouteCircuit1", armnetwork.ExpressRouteCircuit{
		Location: to.Ptr("westus"),
		Properties: &armnetwork.ExpressRouteCircuitPropertiesFormat{
			AuthorizationKey: to.Ptr("b0be57f5-1fba-463b-adec-ffe767354cdd"),
			BandwidthInGbps:  to.Ptr[float32](10),
			ExpressRoutePort: &armnetwork.SubResource{
				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/expressRoutePorts/portName"),
			},
		},
		SKU: &armnetwork.ExpressRouteCircuitSKU{
			Name:   to.Ptr("Premium_MeteredData"),
			Family: to.Ptr(armnetwork.ExpressRouteCircuitSKUFamilyMeteredData),
			Tier:   to.Ptr(armnetwork.ExpressRouteCircuitSKUTierPremium),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ExpressRouteCircuit = armnetwork.ExpressRouteCircuit{
	// 	Name: to.Ptr("expressRouteCircuit1"),
	// 	Type: to.Ptr("Microsoft.Network/expressRouteCircuits"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/expressRouteCircuits/expressRouteCircuit1"),
	// 	Location: to.Ptr("westus"),
	// 	Properties: &armnetwork.ExpressRouteCircuitPropertiesFormat{
	// 		AllowClassicOperations: to.Ptr(false),
	// 		AuthorizationKey: to.Ptr("b0be57f5-1fba-463b-adec-ffe767354cdd"),
	// 		AuthorizationStatus: to.Ptr("Enabled"),
	// 		Authorizations: []*armnetwork.ExpressRouteCircuitAuthorization{
	// 		},
	// 		BandwidthInGbps: to.Ptr[float32](10),
	// 		CircuitProvisioningState: to.Ptr("Enabled"),
	// 		ExpressRoutePort: &armnetwork.SubResource{
	// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/expressRoutePorts/portName"),
	// 		},
	// 		GatewayManagerEtag: to.Ptr("20"),
	// 		Peerings: []*armnetwork.ExpressRouteCircuitPeering{
	// 		},
	// 		ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 		ServiceKey: to.Ptr("d281f746-ee01-4d00-8b0a-edec4833772b"),
	// 		ServiceProviderProvisioningState: to.Ptr(armnetwork.ServiceProviderProvisioningStateProvisioned),
	// 	},
	// 	SKU: &armnetwork.ExpressRouteCircuitSKU{
	// 		Name: to.Ptr("Premium_MeteredData"),
	// 		Family: to.Ptr(armnetwork.ExpressRouteCircuitSKUFamilyMeteredData),
	// 		Tier: to.Ptr(armnetwork.ExpressRouteCircuitSKUTierPremium),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/ExpressRouteCircuitUpdateTags.json
func ExampleExpressRouteCircuitsClient_UpdateTags() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewExpressRouteCircuitsClient().UpdateTags(ctx, "ertest", "er1", armnetwork.TagsObject{
		Tags: map[string]*string{
			"tag1": to.Ptr("value1"),
			"tag2": to.Ptr("value2"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ExpressRouteCircuit = armnetwork.ExpressRouteCircuit{
	// 	Name: to.Ptr("er1"),
	// 	Type: to.Ptr("Microsoft.Network/expressRouteCircuits"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/ertest/providers/Microsoft.Network/expressRouteCircuits/er1"),
	// 	Location: to.Ptr("brazilsouth"),
	// 	Tags: map[string]*string{
	// 		"tag1": to.Ptr("value1"),
	// 		"tag2": to.Ptr("value2"),
	// 	},
	// 	Properties: &armnetwork.ExpressRouteCircuitPropertiesFormat{
	// 		AllowClassicOperations: to.Ptr(false),
	// 		Authorizations: []*armnetwork.ExpressRouteCircuitAuthorization{
	// 		},
	// 		CircuitProvisioningState: to.Ptr("Enabled"),
	// 		GatewayManagerEtag: to.Ptr(""),
	// 		Peerings: []*armnetwork.ExpressRouteCircuitPeering{
	// 		},
	// 		ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 		ServiceKey: to.Ptr("0b392c2e-1e9d-46d7-b5e0-9ce90ca6b60c"),
	// 		ServiceProviderProperties: &armnetwork.ExpressRouteCircuitServiceProviderProperties{
	// 			BandwidthInMbps: to.Ptr[int32](1000),
	// 			PeeringLocation: to.Ptr("Silicon Valley"),
	// 			ServiceProviderName: to.Ptr("Equinix"),
	// 		},
	// 		ServiceProviderProvisioningState: to.Ptr(armnetwork.ServiceProviderProvisioningStateNotProvisioned),
	// 	},
	// 	SKU: &armnetwork.ExpressRouteCircuitSKU{
	// 		Name: to.Ptr("Standard_MeteredData"),
	// 		Family: to.Ptr(armnetwork.ExpressRouteCircuitSKUFamilyMeteredData),
	// 		Tier: to.Ptr(armnetwork.ExpressRouteCircuitSKUTierStandard),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/ExpressRouteCircuitARPTableList.json
func ExampleExpressRouteCircuitsClient_BeginListArpTable() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewExpressRouteCircuitsClient().BeginListArpTable(ctx, "rg1", "circuitName", "peeringName", "devicePath", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ExpressRouteCircuitsArpTableListResult = armnetwork.ExpressRouteCircuitsArpTableListResult{
	// 	Value: []*armnetwork.ExpressRouteCircuitArpTable{
	// 		{
	// 			Age: to.Ptr[int32](0),
	// 			Interface: to.Ptr("Microsoft"),
	// 			IPAddress: to.Ptr("IPAddress"),
	// 			MacAddress: to.Ptr("macAddress"),
	// 	}},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/ExpressRouteCircuitRouteTableList.json
func ExampleExpressRouteCircuitsClient_BeginListRoutesTable() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewExpressRouteCircuitsClient().BeginListRoutesTable(ctx, "rg1", "circuitName", "peeringName", "devicePath", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ExpressRouteCircuitsRoutesTableListResult = armnetwork.ExpressRouteCircuitsRoutesTableListResult{
	// 	Value: []*armnetwork.ExpressRouteCircuitRoutesTable{
	// 		{
	// 			Path: to.Ptr(""),
	// 			LocPrf: to.Ptr(""),
	// 			Network: to.Ptr(""),
	// 			NextHop: to.Ptr(""),
	// 			Weight: to.Ptr[int32](0),
	// 	}},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/ExpressRouteCircuitRouteTableSummaryList.json
func ExampleExpressRouteCircuitsClient_BeginListRoutesTableSummary() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewExpressRouteCircuitsClient().BeginListRoutesTableSummary(ctx, "rg1", "circuitName", "peeringName", "devicePath", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ExpressRouteCircuitsRoutesTableSummaryListResult = armnetwork.ExpressRouteCircuitsRoutesTableSummaryListResult{
	// 	Value: []*armnetwork.ExpressRouteCircuitRoutesTableSummary{
	// 		{
	// 			As: to.Ptr[int32](9583),
	// 			Neighbor: to.Ptr("100.65.171.1"),
	// 			StatePfxRcd: to.Ptr("Idle"),
	// 			UpDown: to.Ptr("never"),
	// 			V: to.Ptr[int32](4),
	// 	}},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/ExpressRouteCircuitStats.json
func ExampleExpressRouteCircuitsClient_GetStats() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewExpressRouteCircuitsClient().GetStats(ctx, "rg1", "circuitName", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ExpressRouteCircuitStats = armnetwork.ExpressRouteCircuitStats{
	// 	PrimarybytesIn: to.Ptr[int64](537408),
	// 	PrimarybytesOut: to.Ptr[int64](44032550),
	// 	SecondarybytesIn: to.Ptr[int64](0),
	// 	SecondarybytesOut: to.Ptr[int64](39002500),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/ExpressRouteCircuitPeeringStats.json
func ExampleExpressRouteCircuitsClient_GetPeeringStats() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewExpressRouteCircuitsClient().GetPeeringStats(ctx, "rg1", "circuitName", "peeringName", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ExpressRouteCircuitStats = armnetwork.ExpressRouteCircuitStats{
	// 	PrimarybytesIn: to.Ptr[int64](537408),
	// 	PrimarybytesOut: to.Ptr[int64](44032550),
	// 	SecondarybytesIn: to.Ptr[int64](0),
	// 	SecondarybytesOut: to.Ptr[int64](39002500),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/ExpressRouteCircuitListByResourceGroup.json
func ExampleExpressRouteCircuitsClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewExpressRouteCircuitsClient().NewListPager("rg1", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ExpressRouteCircuitListResult = armnetwork.ExpressRouteCircuitListResult{
		// 	Value: []*armnetwork.ExpressRouteCircuit{
		// 		{
		// 			Name: to.Ptr("circuitName1"),
		// 			Type: to.Ptr("Microsoft.Network/expressRouteCircuits"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/expressRouteCircuits/circuitName1"),
		// 			Location: to.Ptr("westus"),
		// 			Etag: to.Ptr("W/\"832b28c3-f5fd-4d2a-a2cb-6e4a2fe452b3\""),
		// 			Properties: &armnetwork.ExpressRouteCircuitPropertiesFormat{
		// 				AllowClassicOperations: to.Ptr(false),
		// 				Authorizations: []*armnetwork.ExpressRouteCircuitAuthorization{
		// 					{
		// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/expressRouteCircuits/circuitName/authorizations/MyAuthorization1"),
		// 						Name: to.Ptr("MyAuthorization1"),
		// 						Etag: to.Ptr("W/\"832b28c3-f5fd-4d2a-a2cb-6e4a2fe452b3\""),
		// 						Properties: &armnetwork.AuthorizationPropertiesFormat{
		// 							AuthorizationKey: to.Ptr("authkey"),
		// 							AuthorizationUseStatus: to.Ptr(armnetwork.AuthorizationUseStatusAvailable),
		// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 						},
		// 				}},
		// 				CircuitProvisioningState: to.Ptr("Enabled"),
		// 				GatewayManagerEtag: to.Ptr("113"),
		// 				Peerings: []*armnetwork.ExpressRouteCircuitPeering{
		// 				},
		// 				ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 				ServiceKey: to.Ptr("a1410692-ed3b-4ceb-b94a-b90b95d398d1"),
		// 				ServiceProviderProperties: &armnetwork.ExpressRouteCircuitServiceProviderProperties{
		// 					BandwidthInMbps: to.Ptr[int32](200),
		// 					PeeringLocation: to.Ptr("peeringLocation"),
		// 					ServiceProviderName: to.Ptr("providerName"),
		// 				},
		// 				ServiceProviderProvisioningState: to.Ptr(armnetwork.ServiceProviderProvisioningStateProvisioned),
		// 			},
		// 			SKU: &armnetwork.ExpressRouteCircuitSKU{
		// 				Name: to.Ptr("Standard_MeteredData"),
		// 				Family: to.Ptr(armnetwork.ExpressRouteCircuitSKUFamilyMeteredData),
		// 				Tier: to.Ptr(armnetwork.ExpressRouteCircuitSKUTierStandard),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("circuitName2"),
		// 			Type: to.Ptr("Microsoft.Network/expressRouteCircuits"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/expressRouteCircuits/circuitName2"),
		// 			Location: to.Ptr("westus"),
		// 			Etag: to.Ptr("W/\"e33c875f-48df-4a91-b7d3-eb95b5ddbb89\""),
		// 			Properties: &armnetwork.ExpressRouteCircuitPropertiesFormat{
		// 				AllowClassicOperations: to.Ptr(false),
		// 				Authorizations: []*armnetwork.ExpressRouteCircuitAuthorization{
		// 					{
		// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/expressRouteCircuits/circuitName2/authorizations/MyAuthorization2"),
		// 						Name: to.Ptr("MyAuthorization2"),
		// 						Etag: to.Ptr("W/\"e33c875f-48df-4a91-b7d3-eb95b5ddbb89\""),
		// 						Properties: &armnetwork.AuthorizationPropertiesFormat{
		// 							AuthorizationKey: to.Ptr("authkey"),
		// 							AuthorizationUseStatus: to.Ptr(armnetwork.AuthorizationUseStatusAvailable),
		// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 						},
		// 				}},
		// 				CircuitProvisioningState: to.Ptr("Enabled"),
		// 				GatewayManagerEtag: to.Ptr(""),
		// 				Peerings: []*armnetwork.ExpressRouteCircuitPeering{
		// 				},
		// 				ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 				ServiceKey: to.Ptr("6569625a-9ba4-498b-9719-14d778eef609"),
		// 				ServiceProviderProperties: &armnetwork.ExpressRouteCircuitServiceProviderProperties{
		// 					BandwidthInMbps: to.Ptr[int32](200),
		// 					PeeringLocation: to.Ptr("peeringLocation"),
		// 					ServiceProviderName: to.Ptr("providerName"),
		// 				},
		// 				ServiceProviderProvisioningState: to.Ptr(armnetwork.ServiceProviderProvisioningStateNotProvisioned),
		// 			},
		// 			SKU: &armnetwork.ExpressRouteCircuitSKU{
		// 				Name: to.Ptr("Standard_MeteredData"),
		// 				Family: to.Ptr(armnetwork.ExpressRouteCircuitSKUFamilyMeteredData),
		// 				Tier: to.Ptr(armnetwork.ExpressRouteCircuitSKUTierStandard),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/ExpressRouteCircuitListBySubscription.json
func ExampleExpressRouteCircuitsClient_NewListAllPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewExpressRouteCircuitsClient().NewListAllPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ExpressRouteCircuitListResult = armnetwork.ExpressRouteCircuitListResult{
		// 	Value: []*armnetwork.ExpressRouteCircuit{
		// 		{
		// 			Name: to.Ptr("circuitName1"),
		// 			Type: to.Ptr("Microsoft.Network/expressRouteCircuits"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/expressRouteCircuits/circuitName1"),
		// 			Location: to.Ptr("westus"),
		// 			Etag: to.Ptr("W/\"832b28c3-f5fd-4d2a-a2cb-6e4a2fe452b3\""),
		// 			Properties: &armnetwork.ExpressRouteCircuitPropertiesFormat{
		// 				AllowClassicOperations: to.Ptr(false),
		// 				Authorizations: []*armnetwork.ExpressRouteCircuitAuthorization{
		// 					{
		// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/expressRouteCircuits/circuitName/authorizations/MyAuthorization1"),
		// 						Name: to.Ptr("MyAuthorization1"),
		// 						Etag: to.Ptr("W/\"832b28c3-f5fd-4d2a-a2cb-6e4a2fe452b3\""),
		// 						Properties: &armnetwork.AuthorizationPropertiesFormat{
		// 							AuthorizationKey: to.Ptr("authkey"),
		// 							AuthorizationUseStatus: to.Ptr(armnetwork.AuthorizationUseStatusAvailable),
		// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 						},
		// 				}},
		// 				CircuitProvisioningState: to.Ptr("Enabled"),
		// 				GatewayManagerEtag: to.Ptr("113"),
		// 				Peerings: []*armnetwork.ExpressRouteCircuitPeering{
		// 				},
		// 				ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 				ServiceKey: to.Ptr("a1410692-ed3b-4ceb-b94a-b90b95d398d1"),
		// 				ServiceProviderProperties: &armnetwork.ExpressRouteCircuitServiceProviderProperties{
		// 					BandwidthInMbps: to.Ptr[int32](200),
		// 					PeeringLocation: to.Ptr("peeringLocation"),
		// 					ServiceProviderName: to.Ptr("providerName"),
		// 				},
		// 				ServiceProviderProvisioningState: to.Ptr(armnetwork.ServiceProviderProvisioningStateProvisioned),
		// 			},
		// 			SKU: &armnetwork.ExpressRouteCircuitSKU{
		// 				Name: to.Ptr("Standard_MeteredData"),
		// 				Family: to.Ptr(armnetwork.ExpressRouteCircuitSKUFamilyMeteredData),
		// 				Tier: to.Ptr(armnetwork.ExpressRouteCircuitSKUTierStandard),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("circuitName2"),
		// 			Type: to.Ptr("Microsoft.Network/expressRouteCircuits"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/expressRouteCircuits/circuitName2"),
		// 			Location: to.Ptr("westus"),
		// 			Etag: to.Ptr("W/\"e33c875f-48df-4a91-b7d3-eb95b5ddbb89\""),
		// 			Properties: &armnetwork.ExpressRouteCircuitPropertiesFormat{
		// 				AllowClassicOperations: to.Ptr(false),
		// 				Authorizations: []*armnetwork.ExpressRouteCircuitAuthorization{
		// 					{
		// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/expressRouteCircuits/circuitName2/authorizations/MyAuthorization2"),
		// 						Name: to.Ptr("MyAuthorization2"),
		// 						Etag: to.Ptr("W/\"e33c875f-48df-4a91-b7d3-eb95b5ddbb89\""),
		// 						Properties: &armnetwork.AuthorizationPropertiesFormat{
		// 							AuthorizationKey: to.Ptr("authkey"),
		// 							AuthorizationUseStatus: to.Ptr(armnetwork.AuthorizationUseStatusAvailable),
		// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 						},
		// 				}},
		// 				CircuitProvisioningState: to.Ptr("Enabled"),
		// 				GatewayManagerEtag: to.Ptr(""),
		// 				Peerings: []*armnetwork.ExpressRouteCircuitPeering{
		// 				},
		// 				ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 				ServiceKey: to.Ptr("6569625a-9ba4-498b-9719-14d778eef609"),
		// 				ServiceProviderProperties: &armnetwork.ExpressRouteCircuitServiceProviderProperties{
		// 					BandwidthInMbps: to.Ptr[int32](200),
		// 					PeeringLocation: to.Ptr("peeringLocation"),
		// 					ServiceProviderName: to.Ptr("providerName"),
		// 				},
		// 				ServiceProviderProvisioningState: to.Ptr(armnetwork.ServiceProviderProvisioningStateNotProvisioned),
		// 			},
		// 			SKU: &armnetwork.ExpressRouteCircuitSKU{
		// 				Name: to.Ptr("Standard_MeteredData"),
		// 				Family: to.Ptr(armnetwork.ExpressRouteCircuitSKUFamilyMeteredData),
		// 				Tier: to.Ptr(armnetwork.ExpressRouteCircuitSKUTierStandard),
		// 			},
		// 	}},
		// }
	}
}
