(* Warning! This file is generated. Modify at your own risk.
        *)

(** Data definition for API Discovery Service (v1).
  
  For more information about this data model, see the
  {{:https://developers.google.com/discovery/}API Documentation}.
  *)

module JsonSchema :
sig
  module Annotations :
  sig
    type t = {
      required : string list;
      (** A list of methods for which this property is required on requests. *)
      
    }
    
    val required : (t, string list) GapiLens.t
    
    val empty : t
    
    val render : t -> GapiJson.json_data_model list
    
    val parse : t -> GapiJson.json_data_model -> t
    
  end
  
  module Variant :
  sig
    module Map :
    sig
      type t = {
        _ref : string;
        (**  *)
        type_value : string;
        (**  *)
        
      }
      
      val _ref : (t, string) GapiLens.t
      val type_value : (t, string) GapiLens.t
      
      val empty : t
      
      val render : t -> GapiJson.json_data_model list
      
      val parse : t -> GapiJson.json_data_model -> t
      
    end
    
    type t = {
      map : Map.t list;
      (** The map of discriminant value to schema to use for parsing.. *)
      discriminant : string;
      (** The name of the type discriminant property. *)
      
    }
    
    val map : (t, Map.t list) GapiLens.t
    val discriminant : (t, string) GapiLens.t
    
    val empty : t
    
    val render : t -> GapiJson.json_data_model list
    
    val parse : t -> GapiJson.json_data_model -> t
    
  end
  
  type t = {
    items : t option;
    (** If this is a schema for an array, this property is the schema for each element in the array. *)
    repeated : bool;
    (** Whether this parameter may appear multiple times. *)
    variant : Variant.t;
    (** In a variant data type, the value of one property is used to determine how to interpret the entire entity. Its value must exist in a map of descriminant values to schema names. *)
    pattern : string;
    (** The regular expression this parameter must conform to. Uses Java 6 regex format: http://docs.oracle.com/javase/6/docs/api/java/util/regex/Pattern.html *)
    maximum : string;
    (** The maximum value of this parameter. *)
    location : string;
    (** Whether this parameter goes in the query or the path for REST requests. *)
    enum : string list;
    (** Values this parameter may take (if it is an enum). *)
    _ref : string;
    (** A reference to another schema. The value of this property is the "id" of another schema. *)
    _type : string;
    (** The value type for this schema. A list of values can be found here: http://tools.ietf.org/html/draft-zyp-json-schema-03#section-5.1 *)
    annotations : Annotations.t;
    (** Additional information about this property. *)
    required : bool;
    (** Whether the parameter is required. *)
    default : string;
    (** The default value of this property (if one exists). *)
    minimum : string;
    (** The minimum value of this parameter. *)
    description : string;
    (** A description of this object. *)
    enumDescriptions : string list;
    (** The descriptions for the enums. Each position maps to the corresponding value in the "enum" array. *)
    readOnly : bool;
    (** The value is read-only, generated by the service. The value cannot be modified by the client. If the value is included in a POST, PUT, or PATCH request, it is ignored by the service. *)
    id : string;
    (** Unique identifier for this schema. *)
    format : string;
    (** An additional regular expression or key that helps constrain the value. For more details see: http://tools.ietf.org/html/draft-zyp-json-schema-03#section-5.23 *)
    additionalProperties : t option;
    (** If this is a schema for an object, this property is the schema for any additional properties with dynamic keys on this object. *)
    properties : (string * t) list;
    (** If this is a schema for an object, list the schema for each property of this object. *)
    
  }
  
  val items : (t, t option) GapiLens.t
  val repeated : (t, bool) GapiLens.t
  val variant : (t, Variant.t) GapiLens.t
  val pattern : (t, string) GapiLens.t
  val maximum : (t, string) GapiLens.t
  val location : (t, string) GapiLens.t
  val enum : (t, string list) GapiLens.t
  val _ref : (t, string) GapiLens.t
  val _type : (t, string) GapiLens.t
  val annotations : (t, Annotations.t) GapiLens.t
  val required : (t, bool) GapiLens.t
  val default : (t, string) GapiLens.t
  val minimum : (t, string) GapiLens.t
  val description : (t, string) GapiLens.t
  val enumDescriptions : (t, string list) GapiLens.t
  val readOnly : (t, bool) GapiLens.t
  val id : (t, string) GapiLens.t
  val format : (t, string) GapiLens.t
  val additionalProperties : (t, t option) GapiLens.t
  val properties : (t, (string * t) list) GapiLens.t
  
  val empty : t
  
  val render : t -> GapiJson.json_data_model list
  
  val parse : t -> GapiJson.json_data_model -> t
  
  val to_data_model : t -> GapiJson.json_data_model
  
  val of_data_model : GapiJson.json_data_model -> t
  
end

module DirectoryList :
sig
  module Items :
  sig
    module Icons :
    sig
      type t = {
        x16 : string;
        (** The URL of the 16x16 icon. *)
        x32 : string;
        (** The URL of the 32x32 icon. *)
        
      }
      
      val x16 : (t, string) GapiLens.t
      val x32 : (t, string) GapiLens.t
      
      val empty : t
      
      val render : t -> GapiJson.json_data_model list
      
      val parse : t -> GapiJson.json_data_model -> t
      
    end
    
    type t = {
      title : string;
      (** The title of this API. *)
      id : string;
      (** The id of this API. *)
      labels : string list;
      (** Labels for the status of this API, such as labs or deprecated. *)
      description : string;
      (** The description of this API. *)
      icons : Icons.t;
      (** Links to 16x16 and 32x32 icons representing the API. *)
      name : string;
      (** The name of the API. *)
      kind : string;
      (** The kind for this response. *)
      documentationLink : string;
      (** A link to human readable documentation for the API. *)
      discoveryLink : string;
      (** A link to the discovery document. *)
      preferred : bool;
      (** True if this version is the preferred version to use. *)
      version : string;
      (** The version of the API. *)
      discoveryRestUrl : string;
      (** The URL for the discovery REST document. *)
      
    }
    
    val title : (t, string) GapiLens.t
    val id : (t, string) GapiLens.t
    val labels : (t, string list) GapiLens.t
    val description : (t, string) GapiLens.t
    val icons : (t, Icons.t) GapiLens.t
    val name : (t, string) GapiLens.t
    val kind : (t, string) GapiLens.t
    val documentationLink : (t, string) GapiLens.t
    val discoveryLink : (t, string) GapiLens.t
    val preferred : (t, bool) GapiLens.t
    val version : (t, string) GapiLens.t
    val discoveryRestUrl : (t, string) GapiLens.t
    
    val empty : t
    
    val render : t -> GapiJson.json_data_model list
    
    val parse : t -> GapiJson.json_data_model -> t
    
  end
  
  type t = {
    kind : string;
    (** The kind for this response. *)
    discoveryVersion : string;
    (** Indicate the version of the Discovery API used to generate this doc. *)
    items : Items.t list;
    (** The individual directory entries. One entry per api/version pair. *)
    
  }
  
  val kind : (t, string) GapiLens.t
  val discoveryVersion : (t, string) GapiLens.t
  val items : (t, Items.t list) GapiLens.t
  
  val empty : t
  
  val render : t -> GapiJson.json_data_model list
  
  val parse : t -> GapiJson.json_data_model -> t
  
  val to_data_model : t -> GapiJson.json_data_model
  
  val of_data_model : GapiJson.json_data_model -> t
  
end

module RestMethod :
sig
  module MediaUpload :
  sig
    module Protocols :
    sig
      module Resumable :
      sig
        type t = {
          multipart : bool;
          (** True if this endpoint supports uploading multipart media. *)
          path : string;
          (** The URI path to be used for upload. Should be used in conjunction with the basePath property at the api-level. *)
          
        }
        
        val multipart : (t, bool) GapiLens.t
        val path : (t, string) GapiLens.t
        
        val empty : t
        
        val render : t -> GapiJson.json_data_model list
        
        val parse : t -> GapiJson.json_data_model -> t
        
      end
      
      module Simple :
      sig
        type t = {
          path : string;
          (** The URI path to be used for upload. Should be used in conjunction with the basePath property at the api-level. *)
          multipart : bool;
          (** True if this endpoint supports upload multipart media. *)
          
        }
        
        val path : (t, string) GapiLens.t
        val multipart : (t, bool) GapiLens.t
        
        val empty : t
        
        val render : t -> GapiJson.json_data_model list
        
        val parse : t -> GapiJson.json_data_model -> t
        
      end
      
      type t = {
        simple : Simple.t;
        (** Supports uploading as a single HTTP request. *)
        resumable : Resumable.t;
        (** Supports the Resumable Media Upload protocol. *)
        
      }
      
      val simple : (t, Simple.t) GapiLens.t
      val resumable : (t, Resumable.t) GapiLens.t
      
      val empty : t
      
      val render : t -> GapiJson.json_data_model list
      
      val parse : t -> GapiJson.json_data_model -> t
      
    end
    
    type t = {
      protocols : Protocols.t;
      (** Supported upload protocols. *)
      accept : string list;
      (** MIME Media Ranges for acceptable media uploads to this method. *)
      maxSize : string;
      (** Maximum size of a media upload, such as "1MB", "2GB" or "3TB". *)
      
    }
    
    val protocols : (t, Protocols.t) GapiLens.t
    val accept : (t, string list) GapiLens.t
    val maxSize : (t, string) GapiLens.t
    
    val empty : t
    
    val render : t -> GapiJson.json_data_model list
    
    val parse : t -> GapiJson.json_data_model -> t
    
  end
  
  module Request :
  sig
    type t = {
      parameterName : string;
      (** parameter name. *)
      _ref : string;
      (** Schema ID for the request schema. *)
      
    }
    
    val parameterName : (t, string) GapiLens.t
    val _ref : (t, string) GapiLens.t
    
    val empty : t
    
    val render : t -> GapiJson.json_data_model list
    
    val parse : t -> GapiJson.json_data_model -> t
    
  end
  
  module Response :
  sig
    type t = {
      _ref : string;
      (** Schema ID for the response schema. *)
      
    }
    
    val _ref : (t, string) GapiLens.t
    
    val empty : t
    
    val render : t -> GapiJson.json_data_model list
    
    val parse : t -> GapiJson.json_data_model -> t
    
  end
  
  type t = {
    etagRequired : bool;
    (** Whether this method requires an ETag to be specified. The ETag is sent as an HTTP If-Match or If-None-Match header. *)
    description : string;
    (** Description of this method. *)
    response : Response.t;
    (** The schema for the response. *)
    id : string;
    (** A unique ID for this method. This property can be used to match methods between different versions of Discovery. *)
    parameters : (string * JsonSchema.t) list;
    (** Details for all parameters in this method. *)
    supportsSubscription : bool;
    (** Whether this method supports subscriptions. *)
    parameterOrder : string list;
    (** Ordered list of required parameters, serves as a hint to clients on how to structure their method signatures. The array is ordered such that the "most-significant" parameter appears first. *)
    flatPath : string;
    (** The URI path of this REST method in (RFC 6570) format without level 2 features (\{+var\}). Supplementary to the path property. *)
    supportsMediaDownload : bool;
    (** Whether this method supports media downloads. *)
    httpMethod : string;
    (** HTTP method used by this method. *)
    request : Request.t;
    (** The schema for the request. *)
    path : string;
    (** The URI path of this REST method. Should be used in conjunction with the basePath property at the api-level. *)
    supportsMediaUpload : bool;
    (** Whether this method supports media uploads. *)
    scopes : string list;
    (** OAuth 2.0 scopes applicable to this method. *)
    mediaUpload : MediaUpload.t;
    (** Media upload parameters. *)
    useMediaDownloadService : bool;
    (** Indicates that downloads from this method should use the download service URL (i.e. "/download"). Only applies if the method supports media download. *)
    
  }
  
  val etagRequired : (t, bool) GapiLens.t
  val description : (t, string) GapiLens.t
  val response : (t, Response.t) GapiLens.t
  val id : (t, string) GapiLens.t
  val parameters : (t, (string * JsonSchema.t) list) GapiLens.t
  val supportsSubscription : (t, bool) GapiLens.t
  val parameterOrder : (t, string list) GapiLens.t
  val flatPath : (t, string) GapiLens.t
  val supportsMediaDownload : (t, bool) GapiLens.t
  val httpMethod : (t, string) GapiLens.t
  val request : (t, Request.t) GapiLens.t
  val path : (t, string) GapiLens.t
  val supportsMediaUpload : (t, bool) GapiLens.t
  val scopes : (t, string list) GapiLens.t
  val mediaUpload : (t, MediaUpload.t) GapiLens.t
  val useMediaDownloadService : (t, bool) GapiLens.t
  
  val empty : t
  
  val render : t -> GapiJson.json_data_model list
  
  val parse : t -> GapiJson.json_data_model -> t
  
  val to_data_model : t -> GapiJson.json_data_model
  
  val of_data_model : GapiJson.json_data_model -> t
  
end

module RestResource :
sig
  type t = {
    resources : (string * t) list;
    (** Sub-resources on this resource. *)
    methods : (string * RestMethod.t) list;
    (** Methods on this resource. *)
    
  }
  
  val resources : (t, (string * t) list) GapiLens.t
  val methods : (t, (string * RestMethod.t) list) GapiLens.t
  
  val empty : t
  
  val render : t -> GapiJson.json_data_model list
  
  val parse : t -> GapiJson.json_data_model -> t
  
  val to_data_model : t -> GapiJson.json_data_model
  
  val of_data_model : GapiJson.json_data_model -> t
  
end

module RestDescription :
sig
  module Icons :
  sig
    type t = {
      x16 : string;
      (** The URL of the 16x16 icon. *)
      x32 : string;
      (** The URL of the 32x32 icon. *)
      
    }
    
    val x16 : (t, string) GapiLens.t
    val x32 : (t, string) GapiLens.t
    
    val empty : t
    
    val render : t -> GapiJson.json_data_model list
    
    val parse : t -> GapiJson.json_data_model -> t
    
  end
  
  module Auth :
  sig
    module Oauth2 :
    sig
      module Scopes :
      sig
        type t = {
          description : string;
          (** Description of scope. *)
          
        }
        
        val description : (t, string) GapiLens.t
        
        val empty : t
        
        val render : t -> GapiJson.json_data_model list
        
        val parse : t -> GapiJson.json_data_model -> t
        
      end
      
      type t = {
        scopes : (string * Scopes.t) list;
        (** Available OAuth 2.0 scopes. *)
        
      }
      
      val scopes : (t, (string * Scopes.t) list) GapiLens.t
      
      val empty : t
      
      val render : t -> GapiJson.json_data_model list
      
      val parse : t -> GapiJson.json_data_model -> t
      
    end
    
    type t = {
      oauth2 : Oauth2.t;
      (** OAuth 2.0 authentication information. *)
      
    }
    
    val oauth2 : (t, Oauth2.t) GapiLens.t
    
    val empty : t
    
    val render : t -> GapiJson.json_data_model list
    
    val parse : t -> GapiJson.json_data_model -> t
    
  end
  
  type t = {
    ownerName : string;
    (** The name of the owner of this API. See ownerDomain. *)
    auth : Auth.t;
    (** Authentication information. *)
    revision : string;
    (** The version of this API. *)
    documentationLink : string;
    (** A link to human readable documentation for the API. *)
    methods : (string * RestMethod.t) list;
    (** API-level methods for this API. *)
    packagePath : string;
    (** The package of the owner of this API. See ownerDomain. *)
    etag : string;
    (** The ETag for this response. *)
    name : string;
    (** The name of this API. *)
    resources : (string * RestResource.t) list;
    (** The resources in this API. *)
    discoveryVersion : string;
    (** Indicate the version of the Discovery API used to generate this doc. *)
    basePath : string;
    (** \[DEPRECATED\] The base path for REST requests. *)
    icons : Icons.t;
    (** Links to 16x16 and 32x32 icons representing the API. *)
    exponentialBackoffDefault : bool;
    (** Enable exponential backoff for suitable methods in the generated clients. *)
    schemas : (string * JsonSchema.t) list;
    (** The schemas for this API. *)
    description : string;
    (** The description of this API. *)
    version_module : bool;
    (**  *)
    rootUrl : string;
    (** The root URL under which all API services live. *)
    labels : string list;
    (** Labels for the status of this API, such as labs or deprecated. *)
    version : string;
    (** The version of this API. *)
    features : string list;
    (** A list of supported features for this API. *)
    kind : string;
    (** The kind for this response. *)
    title : string;
    (** The title of this API. *)
    baseUrl : string;
    (** \[DEPRECATED\] The base URL for REST requests. *)
    parameters : (string * JsonSchema.t) list;
    (** Common parameters that apply across all apis. *)
    batchPath : string;
    (** The path for REST batch requests. *)
    id : string;
    (** The ID of this API. *)
    protocol : string;
    (** The protocol described by this document. *)
    ownerDomain : string;
    (** The domain of the owner of this API. Together with the ownerName and a packagePath values, this can be used to generate a library for this API which would have a unique fully qualified name. *)
    canonicalName : string;
    (** Indicates how the API name should be capitalized and split into various parts. Useful for generating pretty class names. *)
    servicePath : string;
    (** The base path for all REST requests. *)
    
  }
  
  val ownerName : (t, string) GapiLens.t
  val auth : (t, Auth.t) GapiLens.t
  val revision : (t, string) GapiLens.t
  val documentationLink : (t, string) GapiLens.t
  val methods : (t, (string * RestMethod.t) list) GapiLens.t
  val packagePath : (t, string) GapiLens.t
  val etag : (t, string) GapiLens.t
  val name : (t, string) GapiLens.t
  val resources : (t, (string * RestResource.t) list) GapiLens.t
  val discoveryVersion : (t, string) GapiLens.t
  val basePath : (t, string) GapiLens.t
  val icons : (t, Icons.t) GapiLens.t
  val exponentialBackoffDefault : (t, bool) GapiLens.t
  val schemas : (t, (string * JsonSchema.t) list) GapiLens.t
  val description : (t, string) GapiLens.t
  val version_module : (t, bool) GapiLens.t
  val rootUrl : (t, string) GapiLens.t
  val labels : (t, string list) GapiLens.t
  val version : (t, string) GapiLens.t
  val features : (t, string list) GapiLens.t
  val kind : (t, string) GapiLens.t
  val title : (t, string) GapiLens.t
  val baseUrl : (t, string) GapiLens.t
  val parameters : (t, (string * JsonSchema.t) list) GapiLens.t
  val batchPath : (t, string) GapiLens.t
  val id : (t, string) GapiLens.t
  val protocol : (t, string) GapiLens.t
  val ownerDomain : (t, string) GapiLens.t
  val canonicalName : (t, string) GapiLens.t
  val servicePath : (t, string) GapiLens.t
  
  val empty : t
  
  val render : t -> GapiJson.json_data_model list
  
  val parse : t -> GapiJson.json_data_model -> t
  
  val to_data_model : t -> GapiJson.json_data_model
  
  val of_data_model : GapiJson.json_data_model -> t
  
end

