
#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include "xhkeys_conf.h"

#ifdef OSD_SUPPORT
#include <X11/Xatom.h>
#ifdef XSHAPE_SUPPORT
# include <X11/extensions/shape.h>
#endif
#include <string.h>	// strlen
#include <stdlib.h>	// free
#include <ctype.h>	// toupper
#include "xhkeys.h"

#ifdef PLUGIN_SUPPORT
# include "xhkeys_plugin.h"
#endif

// xhkeys.c
extern void SetTickTime(int index, unsigned long usecs_plus);

// xhkeys.c
extern Display *dpy;
extern int screenNo; 
extern Window  root_wnd;

// resources.c
extern int osdEnabled;
extern int osdTextTop;
extern unsigned long osdColour;
extern unsigned long osdBkgrColour;
extern unsigned long osdFrameColour;
extern unsigned long osdStippleMask;
// extern Bool osdBkgrTransparent;

extern int osdFrameWidth;

extern XRectangle osdRect;	// x, y, width, height
extern XFontStruct *osdFont;
extern unsigned long osdTimeout;
extern int osdAlignment;      // 0 - left, 1 - right, 2 - centre

// local
static GC osdGC = None;
static Window osdWnd = None;
static Pixmap osdWindowPix = None;

#ifdef XSHAPE_SUPPORT
Bool   hasShapeMask;
static GC maskGC = None;
static Pixmap osdMaskPix = None;
static Pixmap osdStipplePix = None;
#endif


static Bool osdRunning;
static Bool osdVisible;


void InitOSD(int argc, char *argv[])
{
    int mask;
    char *classname;
    const char *progname;
    int w, h, depth;
    XGCValues xgcv;
    XClassHint xch;
    XTextProperty tpname;
    XSetWindowAttributes xswa;

    if (osdEnabled == False) return;

    w = osdRect.width;  h = osdRect.height;
    depth = DefaultDepth(dpy, screenNo);

    osdWnd = XCreateSimpleWindow(dpy, root_wnd, osdRect.x, osdRect.y,
             w, h, osdFrameWidth, osdFrameColour, osdBkgrColour);
    if (osdWnd== None) return;

    // Input selection
    XSelectInput(dpy, osdWnd, ExposureMask);

    // Window attributes
    // We need to avoid window decoration
    xswa.override_redirect = 1;
    XChangeWindowAttributes(dpy, osdWnd, CWOverrideRedirect, &xswa);

    
    // Window command
    progname = argv[0];
    XSetCommand(dpy, osdWnd, argv, argc);

    // Window name
    classname = strrchr(progname, '/');
    if (classname)
        progname = classname+1;
    
    if (XStringListToTextProperty((char **)&progname, 1, &tpname)) 
        XSetWMName(dpy, osdWnd, &tpname);
    
    	    
    // Class hints
    xch.res_name = (char *)progname;
    classname = strdup(progname);
    *classname = toupper(*classname);
    *(classname+1) = toupper(*(classname+1));
    xch.res_class = classname;
    XSetClassHint(dpy, osdWnd, &xch);
    free(classname);

    // Pixmap
    osdWindowPix = XCreatePixmap(dpy, root_wnd, w, h, depth);

    // Colour gc    	
    xgcv.function = GXcopy;
//    xgcv.foreground = osdColour;
    xgcv.graphics_exposures = 0;
    xgcv.font = osdFont->fid;
    
    mask = GCFunction |  GCFont | GCGraphicsExposures; // GCForeground |
    osdGC = XCreateGC(dpy, osdWindowPix, mask, &xgcv);


#ifdef XSHAPE_SUPPORT
    hasShapeMask = False;
    maskGC = None;
    osdMaskPix = None;

    if (osdFrameWidth == 0 && 
        osdStippleMask != 0xffff && osdStippleMask != 0xffffffff)
    {
        unsigned char stippleData[4]; 
	
	unsigned long msk = osdStippleMask;
	int bh = 0;

	while (bh<4 && w!=0) {
	    stippleData[bh++] = (unsigned char) msk;
	    msk >>= 8;    
	    if (msk == 0) break;
        }

	// bitmap height must be even
	if ((bh&1) == 1) stippleData[bh++] = '\0';

	osdStipplePix = XCreateBitmapFromData(dpy, root_wnd, stippleData, 8, bh);

        // Mask pixmap
	if (osdStipplePix != None &&
	   (osdMaskPix = XCreatePixmap(dpy, root_wnd, w, h, 1)) != None) {

	    // Mask GC
	    xgcv.plane_mask = 1;
//	    xgcv.foreground = 1;
//	    xgcv.background = 0;
            xgcv.tile = osdStipplePix;

	    mask |=  (GCPlaneMask | GCTile); // GCForeground | GCBackground | GCTile);    

	    maskGC = XCreateGC(dpy, osdMaskPix, mask, &xgcv);
	    if (maskGC != None) hasShapeMask = True;
	}    
    }
    
#endif	 

    osdRunning = False;
    osdVisible = False;
}



void ProcessOSDTick(const struct timeval *curTime)
{
    if (osdRunning == False)
	HideOSD();
}

/*
Pixmap  GetOSDPluginPixmap()
{
    int fromX, fromY;
    Drawable fromDrawable;
    
    if (needRestore) {
	// Copy from backup
	fromDrawable = osdBackupPix;
	fromX = fromY = 0;
    } else {
	fromDrawable = root_wnd;
	fromX = fromY = 0;
    }
    
    XCopyArea(dpy, fromDrawable, osdPluginPix, osdGC,
	     fromX, fromY, osdRect.width, osdRect.height, 0, 0);
	     
    return osdPluginPix;    	     
}
*/

void HideOSD(void)
{
    if (osdVisible) {
//	if (osdWnd != None)
	    XUnmapWindow(dpy, osdWnd);    
	    XFlush(dpy);
	osdVisible = False;
    }	
}

// Prepares OSD to plugin call
void PrepareOSD(void)
{
    int w, h;

    w = osdRect.width;
    h = osdRect.height;

#ifdef XSHAPE_SUPPORT
    if (hasShapeMask && osdStippleMask == 0) {
	// Fully transparent background - don't erase image
	// and erase full mask
        XSetFillStyle(dpy, maskGC, FillSolid);
        XSetForeground(dpy, maskGC, 0); 
        XFillRectangle(dpy, osdMaskPix, maskGC, 0, 0, w, h);
	return;
    }    
#endif

    XSetForeground(dpy, osdGC, osdBkgrColour); 
    XFillRectangle(dpy, osdWindowPix, osdGC, 0, 0, w, h);
    
#ifdef XSHAPE_SUPPORT
    if (hasShapeMask) {
        XSetForeground(dpy, maskGC, 1); 
        XSetBackground(dpy, maskGC, 0); 
        XSetFillStyle(dpy, maskGC, FillTiled);
        XFillRectangle(dpy, osdMaskPix, maskGC, 0, 0, w, h);
    }    
#endif
}


Bool ShowOSDText(const char *text)
{
    PrepareOSD();
    return ShowOSD(text, strlen(text));
}



Bool ShowOSD(const char *text, int txtLen)
{

    int x1, y1;
//    Bool oldBackedUp = backedUp;

    if (osdWnd == None || osdRunning) return False;
    
    osdRunning = True;

//    x1 = osdRect.x;
//    y1 = osdRect.y;
    x1 = 0;
    y1 = osdTextTop;


    if (txtLen > 0) {    
        if (osdAlignment > 0) {
	    int wid1 = osdRect.width - XTextWidth(osdFont, text, txtLen);
	    if (osdAlignment == 2)  wid1 = (wid1+2)/2;
	    x1 += wid1;
        }	
	y1 += osdFont->ascent;
	
//	XSetClipRectangles(dpy, osdGC, 0, 0, &osdRect, 1, Unsorted);
	XSetForeground(dpy, osdGC, osdColour); 
        XDrawString(dpy, osdWindowPix, osdGC, x1, y1, text, txtLen);  

#ifdef XSHAPE_SUPPORT
	if (hasShapeMask) {
	    XSetForeground(dpy, maskGC, 1); 
	    XSetFillStyle(dpy, maskGC, FillSolid);
	    XDrawString(dpy, osdMaskPix, maskGC, x1, y1, text, txtLen);  
	}    
#endif
//      XSetClipRectangles(dpy, osdGC, 0, 0, &fullRect, 1, Unsorted);
    }	

    if (osdVisible == False) {
        XMapRaised(dpy, osdWnd);
	osdVisible = True;
    }	
    else {
        XRaiseWindow(dpy, osdWnd);
 //       ProcessOSDExposeEvent(NULL);	
    }
   
    ProcessOSDExposeEvent(NULL);	
	
    XFlush(dpy);  

    if (osdTimeout > 0)
	SetTickTime(1, (unsigned long)osdTimeout*1000);

    osdRunning = False;
    return True;
}

void ProcessOSDExposeEvent(const XExposeEvent *evnt)
{
    if (osdWnd != None && 
        (evnt == NULL || (evnt->count == 0 && evnt->window == osdWnd))) {
#ifdef XSHAPE_SUPPORT
	if (osdMaskPix != None)
	    XShapeCombineMask(dpy, osdWnd, ShapeBounding, 0, 0, osdMaskPix, ShapeSet);
#endif
	XCopyArea(dpy, osdWindowPix, osdWnd, osdGC, 0, 0, 
	           osdRect.width, osdRect.height, 0, 0);
    }		   
}


void DeinitOSD(void)
{
    // if (timerisset(ClearOSDTime))
    
    if (dpy != NULL) {
        if (osdWnd != None) {
	    HideOSD();
            XDestroyWindow(dpy, osdWnd);
	}
	
        if (osdGC != None) 
            XFreeGC(dpy, osdGC);

	if (osdWindowPix != None) 
	    XFreePixmap(dpy, osdWindowPix);

#ifdef XSHAPE_SUPPORT
	if (osdStipplePix != None)
	    XFreePixmap(dpy, osdStipplePix);
	
        if (maskGC != None) 
            XFreeGC(dpy, maskGC);

	if (osdMaskPix != None) 
	    XFreePixmap(dpy, osdMaskPix);
#endif

        osdWnd = None;
        osdGC = None;
	osdWindowPix = None;

#ifdef XSHAPE_SUPPORT
        maskGC = None;
	osdMaskPix = None;
#endif
    }	

    
}

#ifdef PLUGIN_SUPPORT
void FillOSDPluginData(XHKEYS_PLUGIN_OSD_DATA *osdData)
{
    osdData->dpy = dpy;
    osdData->screenNo = screenNo;
    osdData->textColour = osdColour;
    osdData->bkgrColour = osdBkgrColour;
    osdData->frameColour = osdFrameColour;

    osdData->drawGC = osdGC;
    osdData->drawPixmap = osdWindowPix;
    
#ifdef XSHAPE_SUPPORT
    if (hasShapeMask) {
	osdData->maskGC = maskGC;
	osdData->maskBitmap = osdMaskPix;
    } else {
#endif    
	osdData->maskGC = None;
	osdData->maskBitmap = None;
#ifdef XSHAPE_SUPPORT
    }
#endif    

    memcpy(&(osdData->rect), &osdRect, sizeof(osdRect));
    osdData->font = osdFont;

    osdData->textTop = osdTextTop;
    osdData->bkgrMask = osdStippleMask;
    osdData->alignment = osdAlignment;
    osdData->frameWidth = (char) osdFrameWidth;
    osdData->enabled = osdEnabled ? True : False;
    
    
}
#endif	// def PLUGIN_SUPPORT

#endif  // def OSD_SUPPORT
