// Copyright (c) Tailscale Inc & AUTHORS
// SPDX-License-Identifier: BSD-3-Clause

// Code generated by tailscale/cmd/viewer; DO NOT EDIT.

package dnstype

import (
	"encoding/json"
	"errors"
	"net/netip"

	"tailscale.com/types/views"
)

//go:generate go run tailscale.com/cmd/cloner  -clonefunc=true -type=Resolver

// View returns a read-only view of Resolver.
func (p *Resolver) View() ResolverView {
	return ResolverView{ж: p}
}

// ResolverView provides a read-only view over Resolver.
//
// Its methods should only be called if `Valid()` returns true.
type ResolverView struct {
	// ж is the underlying mutable value, named with a hard-to-type
	// character that looks pointy like a pointer.
	// It is named distinctively to make you think of how dangerous it is to escape
	// to callers. You must not let callers be able to mutate it.
	ж *Resolver
}

// Valid reports whether v's underlying value is non-nil.
func (v ResolverView) Valid() bool { return v.ж != nil }

// AsStruct returns a clone of the underlying value which aliases no memory with
// the original.
func (v ResolverView) AsStruct() *Resolver {
	if v.ж == nil {
		return nil
	}
	return v.ж.Clone()
}

func (v ResolverView) MarshalJSON() ([]byte, error) { return json.Marshal(v.ж) }

func (v *ResolverView) UnmarshalJSON(b []byte) error {
	if v.ж != nil {
		return errors.New("already initialized")
	}
	if len(b) == 0 {
		return nil
	}
	var x Resolver
	if err := json.Unmarshal(b, &x); err != nil {
		return err
	}
	v.ж = &x
	return nil
}

func (v ResolverView) Addr() string { return v.ж.Addr }
func (v ResolverView) BootstrapResolution() views.Slice[netip.Addr] {
	return views.SliceOf(v.ж.BootstrapResolution)
}
func (v ResolverView) Equal(v2 ResolverView) bool { return v.ж.Equal(v2.ж) }

// A compilation failure here means this code must be regenerated, with the command at the top of this file.
var _ResolverViewNeedsRegeneration = Resolver(struct {
	Addr                string
	BootstrapResolution []netip.Addr
}{})
