# Cantera 2.4.0

Published on August 24, 2018 | [Full release on GitHub](https://github.com/Cantera/cantera/releases/tag/v2.4.0)

Cantera 2.4.0 includes  [more than 380 commits](https://github.com/Cantera/cantera/compare/v2.3.0...v2.4.0) to the code since 2.3.0, merges more than [70 pull requests](https://github.com/Cantera/cantera/pulls?utf8=%E2%9C%93&q=is%3Apr+is%3Aclosed+updated%3A%3E%3D2017-01-18+), and [closes almost 60 issues](https://github.com/Cantera/cantera/issues?page=1&q=is%3Aissue+is%3Aclosed+updated%3A%3E%3D2017-01-18&utf8=%E2%9C%93). In this release, we improved the maintainability of Cantera by removing [or deprecating](https://cantera.org/2.4/doxygen/html/da/d58/deprecated.html) old, untested code, moving the website and Mixmaster to separate repositories, and automating more of the build/testing process. We also added new features to the 1-D reactor code (among other areas), including adding an ionized gas transport class and the `IonFlow` and `BurnerIonFlame` classes, providing better accessing to callbacks during 1-D solutions, and automatically detecting certain common failure conditions of the 1-D solver. This release of Cantera was made possible by contributions from 14 developers: [@speth](https://github.com/speth), [@bryanwweber](https://github.com/bryanwweber), [@BangShiuh](https://github.com/BangShiuh), [@decaluwe](https://github.com/decaluwe), [@wandadars](https://github.com/wandadars), [@jsantner](https://github.com/jsantner), [@arghdos](https://github.com/arghdos), [@rwest](https://github.com/rwest), [@g3bk47](https://github.com/g3bk47), [@awehrfritz](https://github.com/awehrfritz), [@band-a-prend](https://github.com/band-a-prend), [@vdevgan](https://github.com/vdevgan), [@KyleLinevitchJr](https://github.com/KyleLinevitchJr), and [@MarcDuQuesne](https://github.com/MarcDuQuesne).

In addition to Conda packages, Windows installers, and Ubuntu packages, this release also features the addition of a pre-compiled Matlab toolbox for macOS users, replacing Homebrew as the prefered method of installing Cantera for Matlab on macOS.

Thanks to a small development grant from NumFOCUS (see more about NumFOCUS below), [@bryanwweber](https://github.com/bryanwweber) and [@decaluwe](https://github.com/decaluwe) reorganized and restyled the [Cantera website](https://cantera.org). The website has moved to a [separate repository](https://github.com/Cantera/cantera-website), allowing the website content to be updated without modifications to the main Cantera source code. We also tried to make it easy for all of our users to find what they're looking for quickly, from installation instructions and tutorials for beginners, to advanced examples and API documentation for experienced Cantera programmers. The new website also redirects all traffic to HTTPS, ensuring a secure experience for everyone.

Cantera is now officially part of NumFOCUS. NumFOCUS is a 501(c)3 nonprofit dedicated to supporting the open source scientific computing community. If you are interested in learning more about NumFOCUS, please visit their website at <https://numfocus.org>, or our website at <https://cantera.org/community.html#donations>.

Cantera 2.4.0 is the last release that will be compatible with Python 2.7. Support for Python 2.7 from the Python Software Foundation will [end January 1, 2020](https://www.python.org/dev/peps/pep-0373/#maintenance-releases). Given the recent release cadence of Cantera, the next major version of Cantera will probably be released very close to that date, so we have made the decision to drop Python 2.7 support for Cantera 2.5.0 and higher.

One notable change to the build requirements for Cantera 2.4.0 is that SCons 3.0.0 or higher must be used to compile the source code. This means that either Python 2 or Python 3 can be used to run SCons. In addition, there are now three options to handle building the Python interface, depending on whether the user wants to build for Python 2 or Python 3. Please check the documentation or run `scons help` for more information.

## Summary of changes in Cantera 2.4.0

### Bugs fixed

- Fix inconsistencies and bugs in several `ThermoPhase` derived classes, including `PDSS_IdealGas`, `IonsFromNeutralVPSSTP`, `PDSS_IonsFromNeutral`, `PDSS_HKFT`, `LatticePhase`, `PDSS_SSVol`, `ConstDensityThermo`, and `PureFluidPhase`
- Preserve constant property pair when multiplying `Quantity` objects
- Fix using pure fluids in reactors
- Add temperature dependence of rotational relaxation in transport calculations
- Disable linking to external SUNDIALS libraries when building the Matlab toolbox

### Changes to existing capabilities

- Allow instantiation of `ThermoPhase` derived classes without XML
- `set_equivalence_ratio` now supports sulfur oxidation
- Make all complex object types (`ThermoPhase`, `Kinetics`, `Transport`, `Reactor`, `Domain1D`, etc.) objects non-copyable
- Deprecate `FreeFlow` and `AxiStagnFlow` classes by moving the relevant functions into the `StFlow` class
- Allow `convertMech` function to be called multiple times
- Remove the requirement for users to have Boost headers installed when building against the Cantera library
- Change the options to build the Python interface, since SCons can be run by Python 3
- Update GTest, fmtlib, SUNDIALS, and Eigen submodule versions

### Additions

- Add ion gas transport model, and `IonFlow` and `BurnerIonFlame` flame classes
- Add C++ OpenMP, Non-Ideal Shock Tube, PSR/WSR, and time-dependent mass flow rate examples
- Add class `AnyMap`
- Allow negative reaction orders
- Add unity Lewis number transport model
- Add electron to the built-in elements
- Add `get_equivalence_ratio` function

## Full Changelog

### Bugs fixed

#### Thermo/Species/Elements
- Fix issues parsing composition strings with mixtures of commas, colons, and spaces ([`3f6f580b`](https://github.com/Cantera/cantera/commit/[`3f6f580b`](https://github.com/Cantera/cantera/commit/3f6f580b25602ebb442769cca1ecf8f5d6818185)))
- Fix setting mass/mole fractions of phases with only a single species ([`ed8de04e`](https://github.com/Cantera/cantera/commit/ed8de04e5b9a490b057d38fa8538c6091bfca92b))
- Fix reference state calculations ([`38d291c6`](https://github.com/Cantera/cantera/commit/38d291c683046e41c4c40b194c27c9fef68be8b8), [`7b529ac2`](https://github.com/Cantera/cantera/commit/7b529ac2d6a1332f852edeb31498c7ee5b2a88fb))
- Fix test failures due to inconsistent species addition order ([`11a0727d`](https://github.com/Cantera/cantera/commit/11a0727d5ca6172fcb3596dbc11e7f7b1cc2e806), [#433](https://github.com/Cantera/cantera/pull/433))
- Fix errors in entropy calculation in `PDSS_IdealGas` ([`dfb32f0c`](https://github.com/Cantera/cantera/commit/dfb32f0c7ec0e5f037cb1879a73fcb926c8a401a))
- Fix and test creation of `IonsFromNeutralVPSSTP` objects ([`3a119381`](https://github.com/Cantera/cantera/commit/3a119381e81778d67a9ec83e6981d0050c620300))
- Fix inconsistencies in `PDSS_IonsFromNeutral` ([`ff46dc93`](https://github.com/Cantera/cantera/commit/ff46dc93b514d646cccf359e807cfb57ad68a460))
- Fix `PDSS_HKFT` initialization when only one property is given ([`2c3512c2`](https://github.com/Cantera/cantera/commit/2c3512c22a688ab8daecea751add0410e626fa5d))
- Fix default molar volume in `LatticePhase` ([`f3ba29f0`](https://github.com/Cantera/cantera/commit/f3ba29f0bcfacc85cfd069d83626f46dcb0421c6))
- Setting the composition with an empty array raises an exception ([`8a4142d4`](https://github.com/Cantera/cantera/commit/8a4142d4bc33de089220b1e26282500c6ce2d02b))
- Fix implementation and documentation of `PDSS_SSVol` ([`ee663c9b`](https://github.com/Cantera/cantera/commit/ee663c9b3772be84f740a3b36dff44983b79f7a6), [`a19b2bd4`](https://github.com/Cantera/cantera/commit/a19b2bd4ccdc9e687c84f4769e0c3cbc64a87fa3), [`286217d1`](https://github.com/Cantera/cantera/commit/286217d1d3d0af78e5d61353ba8e8621a9636e36), [`be8e51d2`](https://github.com/Cantera/cantera/commit/be8e51d2177740741b54241defab4726e687b67c))
- Fix definition of `ConstDensityThermo::standardConcentration` ([`89fded32`](https://github.com/Cantera/cantera/commit/89fded32d46084bd7733c81c7d1b383922e433a1), [#458](https://github.com/Cantera/cantera/pull/458), [#490](https://github.com/Cantera/cantera/pull/490))
- Preserve constant property pair when multiplying `Quantity` objects ([`c9b0bce8`](https://github.com/Cantera/cantera/commit/c9b0bce8b99000099763aedb088dddb80f7047a1))
- Fix `PureFluidPhase` state data consistency ([`fb68cae1`](https://github.com/Cantera/cantera/commit/fb68cae145d28556e4d7cc58ffc1ec871e0b0be4), [`0417d31d`](https://github.com/Cantera/cantera/commit/0417d31d0ecabd77d5b4fc24900ff0c2bc0620dd))

#### Kinetics
- Validate balance of surface sites for interface reactions ([`ac533713`](https://github.com/Cantera/cantera/commit/ac5337130a8d21728026f04155c0c85ad2ea0c5e), [#412](https://github.com/Cantera/cantera/pull/412))
- Reactions which are declared as duplicate but do not have the corresponding duplicate reaction are errors ([`0fd2f7c4`](https://github.com/Cantera/cantera/commit/0fd2f7c4d0ba7de2c471ae57053421b8d8fbb029), [`2678b57d`](https://github.com/Cantera/cantera/commit/2678b57d587d39110325a07adcfa156424a0f326), [#389](https://github.com/Cantera/cantera/pull/389))
- Fix use of `'scale'` and `'OneWayFlow'` options in `ReactonPathDiagram`s ([`0d982c8f`](https://github.com/Cantera/cantera/commit/0d982c8f582e08f0e77eff49f51f870b249d333f), [`0249ce89`](https://github.com/Cantera/cantera/commit/0249ce89b86b11d524525d2b265de857b3fe8ecf), [#378](https://github.com/Cantera/cantera/pull/378), [#424](https://github.com/Cantera/cantera/pull/424))
- Fix how species contributions to reaction paths are handled ([`3093e6e6`](https://github.com/Cantera/cantera/commit/3093e6e6d4d8960838492cb3848e0881420dc7b4), [`5a0fb579`](https://github.com/Cantera/cantera/commit/5a0fb579a83c3081033421ef6363e6b31e901a0e), [`092e0074`](https://github.com/Cantera/cantera/commit/092e00744bc6afc96bd14c130ea7162bfa9aa3d9), [#377](https://github.com/Cantera/cantera/pull/377), [#424](https://github.com/Cantera/cantera/pull/424))
- Preserve pressure units in `PLOG` reactions when converting from Chemkin to CTI format ([`7b7aea20`](https://github.com/Cantera/cantera/commit/7b7aea2038ecfad88af0919bf4104ac2a87b70e7), [`a02753ae`](https://github.com/Cantera/cantera/commit/a02753ae792a71b4eda2028d4ea73d054ad5a4b4), [#435](https://github.com/Cantera/cantera/pull/435))
- Fix style arguments for reaction path diagrams ([`b41038f8`](https://github.com/Cantera/cantera/commit/b41038f84b705102900e56a7cdbdc141670be4af), [#463](https://github.com/Cantera/cantera/pull/463))
- Fix duplicate reaction checking ([`513b4320`](https://github.com/Cantera/cantera/commit/513b43200c7b222d9ef992e00b922ef210961ad6), [`4c489c17`](https://github.com/Cantera/cantera/commit/4c489c175da4d2979a974b748a97a179f475508f), [#468](https://github.com/Cantera/cantera/pull/468))
- Fix failures due to tolerances in some kinetics tests ([`67aa9eb4`](https://github.com/Cantera/cantera/commit/67aa9eb4e3663f5507e0e6ec25b54bf74f4782c3))

#### Transport
- Fixes to enable `CK_mix` and `CK_multi` mode flags ([`35aa8be6`](https://github.com/Cantera/cantera/commit/35aa8be61e8e68907c4d4cff7c625907094c22c0), [`435f2864`](https://github.com/Cantera/cantera/commit/435f28641ec81ae53aaa8851ee9fe351b5da08b3), [`1b605133`](https://github.com/Cantera/cantera/commit/1b605133d8cb1c77b0348a9984c4b8fc64f55c2a))
- Add temperature dependence of rotational relaxation ([`e79cf6f8`](https://github.com/Cantera/cantera/commit/e79cf6f8cb59c8f8c3d994c71316e12e966140a0), [#547](https://github.com/Cantera/cantera/pull/547))

#### 0-D Reactors
- Fix using pure fluids in reactors ([`2ac8a0ef`](https://github.com/Cantera/cantera/commit/2ac8a0ef088166883ee1639ba12bd13462169e6e), [`deeaaed0`](https://github.com/Cantera/cantera/commit/deeaaed03f619e936b10e908bf9835e58dc10da7), [#475](https://github.com/Cantera/cantera/pull/475), [#487](https://github.com/Cantera/cantera/pull/487))
- Check that contents are Solution objects not Mixtures ([`a22db9fa`](https://github.com/Cantera/cantera/commit/a22db9fa22572df3be9446875607455cd3361d9e))

#### 1-D Flames
- Fix handling of domain boundary conditions when the energy equation is not solved ([`52dbe8c0`](https://github.com/Cantera/cantera/commit/52dbe8c007921769287127701017599e37460598))
- Fix handling of Soret diffusion enabling/disabling with respect to mixture-averaged diffusion approximation ([`a03afbd5`](https://github.com/Cantera/cantera/commit/a03afbd56ee3b51f203a1ee9e7c2fa536c66b01d), [`4bd5e926`](https://github.com/Cantera/cantera/commit/4bd5e92694f4ecf7dee5fdc5f48db21ea3d0b598), [`fde50511`](https://github.com/Cantera/cantera/commit/fde505113166473b1d5ad3cd61f6aed5dd7b9d4f), [#511](https://github.com/Cantera/cantera/pull/511))

#### CTI/Input files
- Fix file size limit when converting CTI to CTML ([`0a1257da`](https://github.com/Cantera/cantera/commit/0a1257daed71fdd621ac25bcdeea911d84036bfd), [#416](https://github.com/Cantera/cantera/pull/416), [#430](https://github.com/Cantera/cantera/pull/430))
- Fix for reactions with pathologically named third bodies ([`55a89106`](https://github.com/Cantera/cantera/commit/55a8910686d15071f300b2c2cec38812514f8ef6), [`6d591b82`](https://github.com/Cantera/cantera/commit/6d591b82efc9b8909ffaa6fe7e70812bdd8c9135), [`44b24ca8`](https://github.com/Cantera/cantera/commit/44b24ca873b55085770563cd4f0b63a5c712412e), [#460](https://github.com/Cantera/cantera/pull/460))
- `ctml_writer` is more tolerant of non-ASCII characters ([`0c0a38d4`](https://github.com/Cantera/cantera/commit/0c0a38d4fe6465fde3f51f73ed6bf8fe47c9fd79))
- Fix incorrect entry in `nasathermo.dat` ([`3933a943`](https://github.com/Cantera/cantera/commit/3933a943dc6fa712fa8a5c920435b28d8e563353), [#491](https://github.com/Cantera/cantera/pull/491))
- Fix writing surface reactions to the CTI file when there are no gas-phase reactions ([`552ba97a`](https://github.com/Cantera/cantera/commit/552ba97a2b3e050c9564fdaaf830fe41f73430d8))
- Fix over-zealous detection of new input file sections ([`f47e98a5`](https://github.com/Cantera/cantera/commit/f47e98a594a5b43b8b41b38eaea49eca8f30406c))
- Detect badly-formatted values of the 4th Troe coefficient ([`bde6e054`](https://github.com/Cantera/cantera/commit/bde6e0545293eb8a530174af6fbba34e4f2430de))
- Suppress some output when `quiet=True` ([`70016b97`](https://github.com/Cantera/cantera/commit/70016b97b3a9a1ec042f35394752891168321030))
- Fix duplicate key check in parseCompString ([`d0916171`](https://github.com/Cantera/cantera/commit/d09161716f2da9160dc7f08f017bfe57c546de84), [#525](https://github.com/Cantera/cantera/pull/525))
- Fix spurious unexpected output warnings ([`fd57936b`](https://github.com/Cantera/cantera/commit/fd57936b18a9bcebcffbe25316b23fe9123da18f))

#### Examples
- Fix errors and empty figures in IC engine example ([`6f564e61`](https://github.com/Cantera/cantera/commit/6f564e6101541b5368b64b64e96eac4b64f366c7), [`0d01d031`](https://github.com/Cantera/cantera/commit/0d01d031a9551bf8252a7f7f2cb769c276ab3fe8))
- Remove extraneous arguments in Matlab example scripts ([`a31b7d1b`](https://github.com/Cantera/cantera/commit/a31b7d1bb5be876729e4e7728a78f417cdf1b3dd))
- Remove or fix broken Matlab examples ([`536158b4`](https://github.com/Cantera/cantera/commit/536158b402893d14930d1da579c72d545dc72943), [`987a247b`](https://github.com/Cantera/cantera/commit/987a247bd0d7b626e972c974faf78576a48b6552))

#### Other
- Add explicit dependencies on the `scons build` step for `scons test` and `scons install` ([`70e10632`](https://github.com/Cantera/cantera/commit/70e10632d4a451dec7e0f94ab2e09156b1a6848b), [#432](https://github.com/Cantera/cantera/pull/432))
- Fix reproducibility of `add_species_sequential` test ([`11a0727d`](https://github.com/Cantera/cantera/commit/11a0727d5ca6172fcb3596dbc11e7f7b1cc2e806), [#433](https://github.com/Cantera/cantera/pull/433))
- Disable linking to external SUNDIALS libraries when building the Matlab toolbox ([`c125878a`](https://github.com/Cantera/cantera/commit/c125878a40f1395149c8e9a713aba90a0cb7cc44), [#431](https://github.com/Cantera/cantera/pull/431), [#456](https://github.com/Cantera/cantera/pull/456))
- Switch SourceForge links in the docs to point to GitHub ([`d920f2eb`](https://github.com/Cantera/cantera/commit/d920f2eb2cd7296086412746fd5e1e50ca2cd8a9), [#442](https://github.com/Cantera/cantera/pull/442), [#455](https://github.com/Cantera/cantera/pull/455))
- Fix typos in documentation ([`05809bb0`](https://github.com/Cantera/cantera/commit/05809bb027a7232badae3dc3eb970695437e19b6), [`fec6c34e`](https://github.com/Cantera/cantera/commit/fec6c34ed8052f0ee4b86e6a3c37769eba917ccc), [`35ac1acf`](https://github.com/Cantera/cantera/commit/35ac1acfa87c4262931ec7acdd62de2629353550), [`af4ccaee`](https://github.com/Cantera/cantera/commit/af4ccaee099486d60c8eadab3fe823cd427b131b), [#449](https://github.com/Cantera/cantera/pull/449))
- Easier debugging of NumPy import error messages during build ([`3f69f6ac`](https://github.com/Cantera/cantera/commit/3f69f6ac8a45196e0f0b9244e01fed06c6b0c64e))
- Use Trusty Tahr and system Python 3 on TravisCI Linux builds ([`9e5da87a`](https://github.com/Cantera/cantera/commit/9e5da87a2a07455b0c1b063c9494123561ad5c87), [`45891a21`](https://github.com/Cantera/cantera/commit/45891a2118dcd8146a1485741e9b156df271f048))
- Fix parallel builds of the Matlab toolbox ([`83123963`](https://github.com/Cantera/cantera/commit/831239633daa7a86f7774c62260c27a0354ab456), [#483](https://github.com/Cantera/cantera/pull/483))
- Remove outdated MacPorts installation instructions ([`46f8ef52`](https://github.com/Cantera/cantera/commit/46f8ef52a7c6041e1cb29e68d58cd7dc97ba1d2d), [#496](https://github.com/Cantera/cantera/pull/496))
- Fix wrong environment variable `MATLAB_PATH` -> `MATLABPATH` ([`d86a7c17`](https://github.com/Cantera/cantera/commit/d86a7c176e7bf35617728a1b2771ae673f67f351), [#501](https://github.com/Cantera/cantera/pull/501))
- Fix broken links in README, clarify PR template, add Gitter, add badges ([`e052a44e`](https://github.com/Cantera/cantera/commit/e052a44e92b1492d5515f1b759f8f2fb7d6ffa13), [`8de267f2`](https://github.com/Cantera/cantera/commit/8de267f25c9cbb58527445838ebcdc72932156bb), [`de3ec3d5`](https://github.com/Cantera/cantera/commit/de3ec3d53e3645f24ae0353d3edc83a122e4ccb4), [`0120f2fc`](https://github.com/Cantera/cantera/commit/0120f2fc5e2d431171476703cb2957960445f873), [#505](https://github.com/Cantera/cantera/pull/505), [#506](https://github.com/Cantera/cantera/pull/506), [#513](https://github.com/Cantera/cantera/pull/513))
- Fix installing dependencies on Appveyor ([`39c41035`](https://github.com/Cantera/cantera/commit/39c4103504635cb620ba6e4997ce657a4ea546e9), [`0b8f0283`](https://github.com/Cantera/cantera/commit/0b8f0283aacbb12b7f9ab4f9f016be781bd087a6), [`b1a010e3`](https://github.com/Cantera/cantera/commit/b1a010e3a3f464ed0a58c33f8265c43fc73ad8b8), [#517](https://github.com/Cantera/cantera/pull/517), [#529](https://github.com/Cantera/cantera/pull/529))
- Add update of git submodules to code checkout instructions ([`66ba4b5b`](https://github.com/Cantera/cantera/commit/66ba4b5b507fd182a35f0b3310d22fe9ee72e51c))
- Remove blank documentation page ([`84acdb1a`](https://github.com/Cantera/cantera/commit/84acdb1a300d5d5d943f579b2d03f3f5067b2514), [#518](https://github.com/Cantera/cantera/pull/518))
- Fix notation for mixture-averaged diffusion coefficient ([`df6ecb10`](https://github.com/Cantera/cantera/commit/df6ecb101b4617348419eb46786215863bf65bcd))
- Fix compiler warning about `m_Faraday_dim` ([`55490de8`](https://github.com/Cantera/cantera/commit/55490de87103563fc40e0645613ac3e69cdd15a6))
- Fix catching exceptions when checking git commit during build ([`3fac5f2b`](https://github.com/Cantera/cantera/commit/3fac5f2bc6f9060b1e24ddec12632e905b113f75), [`c8305375`](https://github.com/Cantera/cantera/commit/c8305375efa93df460a9348ca7f6aaecdcadb94f))
- Fix display of information from errors in Python callbacks ([`d3f49e74`](https://github.com/Cantera/cantera/commit/d3f49e74cb5a24722aff23db5c8e0dc14becbc07))
- Clean the correct folder after building the minimal Python interface ([`ff91457b`](https://github.com/Cantera/cantera/commit/ff91457b5af7ffe2962a15b5609ca95dbf656e30))
- Fix building MSI for Python 3.7 module ([`af51a61a`](https://github.com/Cantera/cantera/commit/af51a61ab1be3aca6ac7f7bd7094357ba4ab58db))

### Changes to existing capabilities

#### Thermo/Species/Elements
- PDSS objects store their own data ([`50ed3f2e`](https://github.com/Cantera/cantera/commit/50ed3f2e7265baf3ae65629ba67edfa68e199f11))
- Remove `VPSSMgr` and merge into `VPStandardStateTP` ([`b39537bf`](https://github.com/Cantera/cantera/commit/b39537bfcbdc8f89e607fda8822c3061aa580b7b), [#428](https://github.com/Cantera/cantera/pull/428))
- Simplify aqueous phase creation in `VPStandardStateTP` ([`3ea2a6ca`](https://github.com/Cantera/cantera/commit/3ea2a6caf32d31bb06e12ccc4e137a762ec9eec2))
- Allow instantiation of `ThermoPhase` derived classes without XML ([`86dca053`](https://github.com/Cantera/cantera/commit/86dca05369189b9b0c32cbe960ac416f0eee7ab1), [`507a3a99`](https://github.com/Cantera/cantera/commit/507a3a9985f2b0237f8d13442d6ac93f37a781d1), [`19c17d14`](https://github.com/Cantera/cantera/commit/19c17d149ba92f9f68415354cb6ac32b7e2c893b), [`db1f1af0`](https://github.com/Cantera/cantera/commit/db1f1af0a0c376747591ccdb0c77cd6487727c65), [`5efea129`](https://github.com/Cantera/cantera/commit/5efea129599cfdb7a4d7f580c145db95dde15b9c), [`3c771ded`](https://github.com/Cantera/cantera/commit/3c771ded2bf184b4cffb362127fd77ba35390da4), [`b033d44d`](https://github.com/Cantera/cantera/commit/b033d44d3e00a1c4a36cd1a501ff77d34da18bbe), [`31d54c3b`](https://github.com/Cantera/cantera/commit/31d54c3b111b2d01468faa61060d8330969dd043), [`95a52b2d`](https://github.com/Cantera/cantera/commit/95a52b2d34d7bd65e58145e30436c4e88b8b777f), [`f8ef4a8b`](https://github.com/Cantera/cantera/commit/f8ef4a8b2b3efc7392b5cdfd2a378adddf7579b8), [`a6ac4460`](https://github.com/Cantera/cantera/commit/a6ac446021b8a8b3b314f4d8f8dc8bb81ee66ac2), [`bfdc2b9e`](https://github.com/Cantera/cantera/commit/bfdc2b9e1d26d1ce9fad758a453a3f8e5f39829c), [`f69ef446`](https://github.com/Cantera/cantera/commit/f69ef446007ee73ad8c5f527605196b514feca6e), [`d744bd9f`](https://github.com/Cantera/cantera/commit/d744bd9fb8c0cdbfe48b77ef4ae4d39d3cd71647), [`3676672e`](https://github.com/Cantera/cantera/commit/3676672eec57e5e66a9ef7b50a3449bcdd184a3e), [`aa02d242`](https://github.com/Cantera/cantera/commit/aa02d2423583968132a29a980df6cb3a2d818491), [`e3afaf5e`](https://github.com/Cantera/cantera/commit/e3afaf5e6151d85e1c8ff56a3a752fbc3b170955), [`3790115b`](https://github.com/Cantera/cantera/commit/3790115b99ff927212c0e498fd18931cd550c5e9), [`4c630fc5`](https://github.com/Cantera/cantera/commit/4c630fc59211b5ebe878afef99baca7637c81a3f), [`a520f782`](https://github.com/Cantera/cantera/commit/a520f782dbe10ec42db449c5a90ed44b917f004b))
- Clean up and test `RedlichKwongMFTP` implementation and remove broken "sanity checks" ([`ecbd819e`](https://github.com/Cantera/cantera/commit/ecbd819e91340ac563ec837bc3347034e69a196f), [`dd521de2`](https://github.com/Cantera/cantera/commit/dd521de25439115e4653389221e844e56c231db3), [`f9d5f16b`](https://github.com/Cantera/cantera/commit/f9d5f16b729bed36009d7ef9ddb4a042f798cfe0), [#267](https://github.com/Cantera/cantera/pull/267), [#436](https://github.com/Cantera/cantera/pull/436), [#438](https://github.com/Cantera/cantera/pull/438))
- Move common PDSS functions into the the `PDSS_Nondimensional` class ([`574462fd`](https://github.com/Cantera/cantera/commit/574462fd3c6d6db6c2d785cc2de0ea745010199c))
- Remove unused thermodynamics models from `ThermoFactory` ([`6154e1b4`](https://github.com/Cantera/cantera/commit/6154e1b4bd417e98a8c94a195794403d633fbd18))
- Deprecate several unused/untested classes. See the [deprecation list](https://cantera.org/2.4/doxygen/html/da/d58/deprecated.html) for details. ([`2b73fe24`](https://github.com/Cantera/cantera/commit/2b73fe24baa6a10c36dcbc05e4fea2958346da78), [`6d22be2a`](https://github.com/Cantera/cantera/commit/6d22be2a6b282808ad5effa5fd5bd7dca08b0b84), [#267](https://github.com/Cantera/cantera/pull/267))
- Remove unimplemented options from `DebyeHuckel` ([`afafa34c`](https://github.com/Cantera/cantera/commit/afafa34c06640037af82ea1682d6d8c74ae84b36))
- Charge transfer reactions can be set for `surface_reaction`s, not just `edge_reaction`s ([`51f419fb`](https://github.com/Cantera/cantera/commit/51f419fbadef27d318f249c447400a1618a6d151), [#439](https://github.com/Cantera/cantera/pull/439))
- Remove unused members from some thermo classes ([`4818c873`](https://github.com/Cantera/cantera/commit/4818c87344d8d5076ec9dd2808061cdd4a1b38b9), [`6bfd82e0`](https://github.com/Cantera/cantera/commit/6bfd82e0be67a41986c07877ec973a9a97fc0d29), [`90d18dd3`](https://github.com/Cantera/cantera/commit/90d18dd3375c8c87dacecea34e253d5a01d8d8a5), [`c85ba586`](https://github.com/Cantera/cantera/commit/c85ba586d236a27b6aefb8864e3312e5299b0c3a), [`cfc3b728`](https://github.com/Cantera/cantera/commit/cfc3b728f5a7f833c80948d4b6332648882604d6), [`6ca78203`](https://github.com/Cantera/cantera/commit/6ca782030dae74333263d4456e2da7803decdbf7), [`d07908f9`](https://github.com/Cantera/cantera/commit/d07908f9c99e560992098d8ebdb367c6c93dd2a4), [`4b69c7f2`](https://github.com/Cantera/cantera/commit/4b69c7f2654d939204a8b58d8084c70ce3599814), [`572af616`](https://github.com/Cantera/cantera/commit/572af616e7ed767d306fe439c0d7dfaad9e1225b))
- Store several class properties as `shared_ptr`s ([`04f10972`](https://github.com/Cantera/cantera/commit/04f10972c8daeda802d600f5104dba59cc7d2b3d), [`4856d132`](https://github.com/Cantera/cantera/commit/4856d1328b9339459725d63a1e76671e15d91052))
- Remove debug exception from `Phase::entropyElement298` ([`d4338249`](https://github.com/Cantera/cantera/commit/d4338249fb29d5de9a1154980dcb01d603354cc0), [#467](https://github.com/Cantera/cantera/pull/467))
- Explicitly assume that the solvent species is always the first species in the phase ([`e33fe690`](https://github.com/Cantera/cantera/commit/e33fe6904d573ddd141ce5a619a24fb873137746))
- Move implementation of `HMWSoln` to a single file ([`e9f08fc5`](https://github.com/Cantera/cantera/commit/e9f08fc58e53b6061df0e75991e2c9d378eafdfd))
- Try to look up standard entropy when adding undefined elements ([`0ca788bd`](https://github.com/Cantera/cantera/commit/0ca788bd69cbc7b8a3e4ae319d6668ce6a96b1a8))
- Always use `PDSS_ConstVol` for constant volume standard state and remove the implementation from `PDSS_SSVol` ([`822cdc7d`](https://github.com/Cantera/cantera/commit/822cdc7d38b3fd609269f5d7ee8b3ff9e4e1b6cf))
- Make adding undefined elements the default behavior ([`d0355575`](https://github.com/Cantera/cantera/commit/d03555753130b9e4a9bfec10d17579fcb2038290))
- `set_equivalence_ratio` now supports sulfur oxidation ([`48eaedbb`](https://github.com/Cantera/cantera/commit/48eaedbbb44b25bab9c2938d04e508eaa9e564ec), [`acbd65d1`](https://github.com/Cantera/cantera/commit/acbd65d1922a601ced413a7d43a20540cf8b2944), [`aac8eb92`](https://github.com/Cantera/cantera/commit/aac8eb92afd4191b3581258e0c6ea17348471858), [#474](https://github.com/Cantera/cantera/pull/474))
- Relax warning threshold for heat capacity discontinuities ([`a68c048b`](https://github.com/Cantera/cantera/commit/a68c048bfa4e32392bd2faaa6740eaa76d98cacd))

#### Equilibrium Solvers
- Various clean ups, refactoring, and simplifications to the VCS solver ([`ee323bba`](https://github.com/Cantera/cantera/commit/ee323bbafc12926aa0c532047a1de4b550c6d067), [`08726b09`](https://github.com/Cantera/cantera/commit/08726b0904bc40ae182f7706b0172f04d8f4cb2f), [`da801f4c`](https://github.com/Cantera/cantera/commit/da801f4cbcd7c5c070e926a5fb54fbcb81c1c7a2), [`8522095d`](https://github.com/Cantera/cantera/commit/8522095deaacc3659b3195c5a5638bbe5b6aa606), [`bba0d8ed`](https://github.com/Cantera/cantera/commit/bba0d8edf0a96a07ca26c07351eba51216b3682b), [`1eebd3ef`](https://github.com/Cantera/cantera/commit/1eebd3efdbd469556b8a4c3800fc0499424d6513), [`da3ba359`](https://github.com/Cantera/cantera/commit/da3ba35945210644b10aa2900b846a05dd54f80e), [`4e53c893`](https://github.com/Cantera/cantera/commit/4e53c893cfdfa84ddd20868962b1c4e733135891), [`7eb939dc`](https://github.com/Cantera/cantera/commit/7eb939dc5fb79c548f813c7160836d07f24abc26), [`739d4e48`](https://github.com/Cantera/cantera/commit/739d4e483011c940840134a0e84ae2796a5cf473))
- Improve control of logging in the `ChemEquil` solver ([`5b4a977d`](https://github.com/Cantera/cantera/commit/5b4a977df7fb3fc7b80363ed84a4a035018e5e27))
- Don't use saved element potentials as an initial guess and deprecate getter/setter methods ([`74167cc3`](https://github.com/Cantera/cantera/commit/74167cc3eb81dc63b306c045e2a7b1e86fb5b08b), [`3c978cdf`](https://github.com/Cantera/cantera/commit/3c978cdff6bb950c609b15215eb3d8f608abba96), [#538](https://github.com/Cantera/cantera/pull/538))

#### Transport
- Allow construction of `Transport` derived classes without XML ([`4b5af640`](https://github.com/Cantera/cantera/commit/4b5af640505c686790ba5cf749274fbbaa61cb12), [`7020fa72`](https://github.com/Cantera/cantera/commit/7020fa72bfd7821b46a1b6ae29567e362f940e4f))
- Move `simpleTransport` test to GTest suite ([`4934079d`](https://github.com/Cantera/cantera/commit/4934079d69fcbafadf3ac361a9ddf2926c9e051b))

#### 0-D Reactors
- Make all reactor-related objects non-copyable ([`d9418bb8`](https://github.com/Cantera/cantera/commit/d9418bb8fbed2b591ca025a32a8c5c1d5591333b))

#### 1-D Flames
- Make all 1-D-related objects non-copyable ([`279c5c85`](https://github.com/Cantera/cantera/commit/279c5c8556340e8112c78aa9b7d3d39b9e90236b))
- Deprecate `FreeFlow` and `AxiStagnFlow` classes by moving the relevant functions into the `StFlow` class ([`c1067aa6`](https://github.com/Cantera/cantera/commit/c1067aa6e97584d09da63cf6abdddd110522a91e), [`3ade3335`](https://github.com/Cantera/cantera/commit/3ade3335de105506d83f8550a1ca9525bdcbce01), [`a54ab2f3`](https://github.com/Cantera/cantera/commit/a54ab2f3efec19715039cd7c064902c5050eb2c1), [#546](https://github.com/Cantera/cantera/pull/546), [#548](https://github.com/Cantera/cantera/pull/548))

#### CTI/XML/Input Files
- Make searches for child nodes case insensitive ([`1bd950fe`](https://github.com/Cantera/cantera/commit/1bd950fef558101d7e8080629b7e6c1d86fd0fe9))
- Improve error messages for invalid (floating point) geometry flags ([`6bf74d17`](https://github.com/Cantera/cantera/commit/6bf74d179b04848b756791de59f830bc46fb7537), [#446](https://github.com/Cantera/cantera/pull/446), [#454](https://github.com/Cantera/cantera/pull/454))

#### Examples/Samples
- Remove verbose output from f77 demo wrapper ([`172e9ffe`](https://github.com/Cantera/cantera/commit/172e9ffeadd8653ec309321dda61e68e0c508008))

#### Documentation
- Note requirement to use `modifySpecies` and `modifyReaction` ([`4b4128ae`](https://github.com/Cantera/cantera/commit/4b4128aebd02140ac26fc84627d618b70c5e82dc), [#394](https://github.com/Cantera/cantera/pull/394), [#542](https://github.com/Cantera/cantera/pull/542))
- Clarify the values returned by `getFwdRateConstants` ([`831b92da`](https://github.com/Cantera/cantera/commit/831b92dac4fd5b39ab9762a09ea5b3050927c173))
- Move most content from the old documentation to the new website ([`7b6d04c3`](https://github.com/Cantera/cantera/commit/7b6d04c381e9ae1bcec61c53c761412ef81422ef), [`cc9c8e56`](https://github.com/Cantera/cantera/commit/cc9c8e5633da0c69077064e1092d0a87f387fb25), [`71072c43`](https://github.com/Cantera/cantera/commit/71072c43db9eecba08a017b6fb44d811fc25f6d2), [`e81cac95`](https://github.com/Cantera/cantera/commit/e81cac9582d1492eff7c1c0feeada9a5501e91c1), [`e7f346cd`](https://github.com/Cantera/cantera/commit/e7f346cddf7713837fb907cf6f898605acb3d2d0), [`7a69386b`](https://github.com/Cantera/cantera/commit/7a69386b8db61e2a9fed74855def5f156e8795ca), [`d57f1d14`](https://github.com/Cantera/cantera/commit/d57f1d147dfe8ced738ad0f489cd4917b5d2d9a4), [`b68a87d6`](https://github.com/Cantera/cantera/commit/b68a87d62466dc0e55c9c8512573da0ae7c4c25e), [`21db5d84`](https://github.com/Cantera/cantera/commit/21db5d84f3ce60a3be79392531df3a19f2d87fa3), [`30527012`](https://github.com/Cantera/cantera/commit/3052701250034ffad1bf575b790ea1e4659314f8), [`2a7aed89`](https://github.com/Cantera/cantera/commit/2a7aed89687db2048bd262d0acea27de62883c5f), [`e8d28b0e`](https://github.com/Cantera/cantera/commit/e8d28b0e89fae05e5b7e1d01f88c67a8934380f8), [`dbc3df16`](https://github.com/Cantera/cantera/commit/dbc3df168701f631b6554ecfd74565b1c9c8f1a0), [`2f3a0122`](https://github.com/Cantera/cantera/commit/2f3a0122d65ff66552dc8ed4870d0b3edfb9d764), [`9670c5da`](https://github.com/Cantera/cantera/commit/9670c5dac6aeae078fcb4414da4fbebb33ab116d), [`3fae1c1a`](https://github.com/Cantera/cantera/commit/3fae1c1a9aaa6c26945d71bcb81be7a9af808697), [`4ea9d35a`](https://github.com/Cantera/cantera/commit/4ea9d35a2b3dc8b94d1d9681ce109b5959cdd811), [`54946368`](https://github.com/Cantera/cantera/commit/549463683da253f16620493ef50788d09a61476c), [`d2252037`](https://github.com/Cantera/cantera/commit/d2252037c66ce3451c5a12ce5adac3c9f518294f), [`c28bc023`](https://github.com/Cantera/cantera/commit/c28bc0235f1b8772ce6176adb76b7c96350d248e), [`d33e67c3`](https://github.com/Cantera/cantera/commit/d33e67c36c46846f8d30fb989a1a9640c67883e5), [`7e1b6a14`](https://github.com/Cantera/cantera/commit/7e1b6a1489d4545b0dbe3d9fe92a0aa9943e8247), [`33840414`](https://github.com/Cantera/cantera/commit/33840414e5a3d21a5f9cb25278fe9e2685c590a9), [`0d559778`](https://github.com/Cantera/cantera/commit/0d559778a7a17f5e54ba99419961fee76e39ac64), [`b84d3e3f`](https://github.com/Cantera/cantera/commit/b84d3e3f79c63b9d496fcc4d413f49cec1c04111), [`053267e2`](https://github.com/Cantera/cantera/commit/053267e254dda6e7367969c4a59e936b50e2a802), [`1864e8fd`](https://github.com/Cantera/cantera/commit/1864e8fd6c845cc61ab62f403a7f574ffde9107f), [`5f556acd`](https://github.com/Cantera/cantera/commit/5f556acd34597a352665359188dd80aa87ded536), [`045f3d37`](https://github.com/Cantera/cantera/commit/045f3d37bf330dca5d2492a3a03d1eeecb7077f3), [`1ca6c5eb`](https://github.com/Cantera/cantera/commit/1ca6c5eb402db482db0958232ab2e1231f8e8cf9), [`323c7370`](https://github.com/Cantera/cantera/commit/323c7370db1e20e507d9f95038ae6186eb51fe3e), [#544](https://github.com/Cantera/cantera/pull/544))

#### Other
- Move MixMaster into a separate repository ([`886d7b7c`](https://github.com/Cantera/cantera/commit/886d7b7cdc8326fa39cd180cbc0429cae0c8f873))
- Propagation of environment variables in SCons is more sensible ([`e5edc319`](https://github.com/Cantera/cantera/commit/e5edc319de58ce7506586ec02fcd1826b900ed71), [`3c82c3a6`](https://github.com/Cantera/cantera/commit/3c82c3a6c63920f9d60604d64d07a7f5d67340a6), [`eae9250f`](https://github.com/Cantera/cantera/commit/eae9250f2efcb365a1a99b11d74accaf04e19bd3), [`66998a5a`](https://github.com/Cantera/cantera/commit/66998a5ae17222e65a6818047617413317754c13))
- Remove deprecated code ([`7673f7cb`](https://github.com/Cantera/cantera/commit/7673f7cb529070c24d54231a2c6feb0d7514bd8d), [`3accd415`](https://github.com/Cantera/cantera/commit/3accd415e81012bc1b88832e7f29f86fd4922598))
- Print error messages from and pass flags to GTest ([`fca22d94`](https://github.com/Cantera/cantera/commit/fca22d94e5ecb1e8b359e4a1ce8cd4f840c803b5), [`461b63e4`](https://github.com/Cantera/cantera/commit/461b63e462be2edc1a99dd96aee104bc60d44794))
- Remove the requirement for clients to have Boost headers installed when building against the Cantera library ([`713b9cc2`](https://github.com/Cantera/cantera/commit/713b9cc23cd4fba835fb8b90e2762c3d48e3685c), [`f8d18322`](https://github.com/Cantera/cantera/commit/f8d183220c42e084bd2b5a26fb7c613aadaed462), [`686250e5`](https://github.com/Cantera/cantera/commit/686250e51f25bd0807af80dff37e5aa89b2f7df9), [`87a7deb3`](https://github.com/Cantera/cantera/commit/87a7deb35d829393e9d7ff108d71cc95248694ea), [`83ffd844`](https://github.com/Cantera/cantera/commit/83ffd844d1a23a7dec695726468fd081629fe81a), [#480](https://github.com/Cantera/cantera/pull/480))
- Update to GTest 1.8.0 ([`60d20754`](https://github.com/Cantera/cantera/commit/60d20754923ee05cea333f70a0d81486abb09a92), [#482](https://github.com/Cantera/cantera/pull/482))
- Remove `HAS_NO_PYTHON` configuration variable ([`16fd1831`](https://github.com/Cantera/cantera/commit/16fd18315c461a854d5d718a31608b1776aa20d4), [#483](https://github.com/Cantera/cantera/pull/483))
- Change the options to build the Python interface, since SCons can be run by Python 3 ([`94ea9b58`](https://github.com/Cantera/cantera/commit/94ea9b585f087d7a325df6e0a908869d3b1cacfd), [`2bc4d09d`](https://github.com/Cantera/cantera/commit/2bc4d09da380903e68c23946e93ded10e65ebbd5), [`6ca67b48`](https://github.com/Cantera/cantera/commit/6ca67b48452bb87b12bdb5f9caaef5b3b60cca98), [`11943bbc`](https://github.com/Cantera/cantera/commit/11943bbc6f7f6c81c682a49f180d6b89ba1839e8), [`7054a7bb`](https://github.com/Cantera/cantera/commit/7054a7bb3d994303151269ef9688f38deb184ac1), [`f824b20f`](https://github.com/Cantera/cantera/commit/f824b20fe28ccdc7a0e84b3b72b37dd7d8fb695d), [`43b42e99`](https://github.com/Cantera/cantera/commit/43b42e99420083c04762a08daf96e27a8385f714), [`c233ddcd`](https://github.com/Cantera/cantera/commit/c233ddcd30eb296b59d5dcab59409d9ebd1311a3), [`9f4590bc`](https://github.com/Cantera/cantera/commit/9f4590bc6f16f69c34f17487362aa1163891593d), [`9c9ee9e9`](https://github.com/Cantera/cantera/commit/9c9ee9e9191df2b9b5ca6a4e3ce2a37efa733023), [`5d599bb6`](https://github.com/Cantera/cantera/commit/5d599bb680e03f3918244a0a13e1ae4015413d0d), [`4e6af27e`](https://github.com/Cantera/cantera/commit/4e6af27edf6cc3ebbf90311be827fdc95e5697a1), [`3e39a0bc`](https://github.com/Cantera/cantera/commit/3e39a0bc3d0141b3205466396f37cbd6dcd30b67), [#483](https://github.com/Cantera/cantera/pull/483), [#486](https://github.com/Cantera/cantera/pull/486), [#488](https://github.com/Cantera/cantera/pull/488))
- Check for 3to2 during build by importing the library, rather than running a script ([`77ee76c5`](https://github.com/Cantera/cantera/commit/77ee76c5f30b73f17c873874842336a86f1da396), [#483](https://github.com/Cantera/cantera/pull/483))
- Use `std::sort` to eliminate need for `vcs_optMax` ([`07eed363`](https://github.com/Cantera/cantera/commit/07eed363fe9f2d6287db674a44ef4353980b7256))
- Google Test suite can be disabled entirely ([`fb4a36b1`](https://github.com/Cantera/cantera/commit/fb4a36b1ca84032704d55fa2baff8f48c980d1ac), [`9bad3545`](https://github.com/Cantera/cantera/commit/9bad3545534b022dae579a1df138f005be7695da), [`333d388f`](https://github.com/Cantera/cantera/commit/333d388f90a8d318f3dadd0e70bdcf955e1ec7bb), [#535](https://github.com/Cantera/cantera/pull/535))
- Improve behavior of Matlab test suite ([`bdaabc04`](https://github.com/Cantera/cantera/commit/bdaabc0428dbb28e4a0d6bd037ff2d4971238d33), [`677efd82`](https://github.com/Cantera/cantera/commit/677efd82d57543577ba2455c59f2ab4e35cdad00), [`b5b542d1`](https://github.com/Cantera/cantera/commit/b5b542d10b837220aaa59a0013b7d3aed922d1dd))

### Additions

#### Thermo/Species/Elements
- Allow synonyms for `Factory` model names ([`c28ca48c`](https://github.com/Cantera/cantera/commit/c28ca48cf8cbc9075ad3817b700640faad1e848c))
- Add electron to the built-in elements ([`974bbc7d`](https://github.com/Cantera/cantera/commit/974bbc7da44998f4ec8f107363bbb53661fb4b0f), [#443](https://github.com/Cantera/cantera/pull/443))
- Identify unspecified electrochemical reactions ([`04be9888`](https://github.com/Cantera/cantera/commit/04be9888ed56d14c61ce7c2b9abd58e55e9ce47a), [#452](https://github.com/Cantera/cantera/pull/452))
- Make activity coefficients and activities available ([`a5b0bdf6`](https://github.com/Cantera/cantera/commit/a5b0bdf69547b638b7e03c5aa0273a34068eebe9))
- Add regression tests for some thermo classes ([`338b2169`](https://github.com/Cantera/cantera/commit/338b21694f4840a0a54a7ed3cb8b5555aab87462))
- Create a default constructor for PDSS objects and avoid unnecessary arguments in the initializers ([`04cac2b2`](https://github.com/Cantera/cantera/commit/04cac2b2771c605cf668195f04551b209838ace5))
- Show values in `setDensity`/`setTemperature` exceptions ([`ebc478f8`](https://github.com/Cantera/cantera/commit/ebc478f8ec46eae1cda179e6b65536af268bfad7))
- Add Cython function to access species viscosity ([`cc93ce62`](https://github.com/Cantera/cantera/commit/cc93ce62ca23ac9dca8074d10d3c0531387ba864), [#527](https://github.com/Cantera/cantera/pull/527))
- Add `get_equivalence_ratio` function ([`a9ad75e9`](https://github.com/Cantera/cantera/commit/a9ad75e974b7d1aed642a23f5b58ff7bd27a2d8d), [#521](https://github.com/Cantera/cantera/pull/521))
- Add `newSubstance` method to create pure fluid objects by name ([`62c67e4a`](https://github.com/Cantera/cantera/commit/62c67e4ad1f57763c25393382e7901c8fb131713))
- Allow `surface_reaction`s (not just `edge_reaction`s) to be charge transfer reactions ([`51f419fb`](https://github.com/Cantera/cantera/commit/51f419fbadef27d318f249c447400a1618a6d151), [#439](https://github.com/Cantera/cantera/pull/439))

#### Transport
- Add unity Lewis number transport model ([`d38d9da3`](https://github.com/Cantera/cantera/commit/d38d9da32c0ecbebde25b4a33f56635f20316e0b), [`29a3c193`](https://github.com/Cantera/cantera/commit/29a3c1939960beae7a651f6fad0b754856fd5de7), [`3c3ef10f`](https://github.com/Cantera/cantera/commit/3c3ef10f9321f418db3caf9394ee551635588da3), [`d4492f3e`](https://github.com/Cantera/cantera/commit/d4492f3ea39bb991f493407470b31b22e7ba8e42), [`a1c12b4a`](https://github.com/Cantera/cantera/commit/a1c12b4a3b69c91e17bb2a156116c779e477c85c), [#510](https://github.com/Cantera/cantera/pull/510))
- Add ion gas transport model ([`b7e32e46`](https://github.com/Cantera/cantera/commit/b7e32e4604a9de401ea651f5a3142fcc04de1711), [`3a0f46eb`](https://github.com/Cantera/cantera/commit/3a0f46eb56f8a99a7152db36aa1b991538048bb9), [`eeb27d84`](https://github.com/Cantera/cantera/commit/eeb27d84a9c1a374da9bf7b4409370c62580aa84), [`f7852ad8`](https://github.com/Cantera/cantera/commit/f7852ad84c078cbbc39cfc1e23ff72087a57efb5), [`fa9b9374`](https://github.com/Cantera/cantera/commit/fa9b9374cfe8c11349866a475c4ebf535f47368a), [`1245a694`](https://github.com/Cantera/cantera/commit/1245a694e522dbd9df0fdceb004b42816e0554f3), [`5c783c70`](https://github.com/Cantera/cantera/commit/5c783c708f0c08def6f6a3d8328b336d65842357), [#539](https://github.com/Cantera/cantera/pull/539))

#### 1-D Flames
- Add access to current solution residuals ([`6a52908d`](https://github.com/Cantera/cantera/commit/6a52908d8571b171bc5685944f185f0aefef4bc3))
- Allow user to pass the locations where temperature is set during flame initialization ([`2a38b0a7`](https://github.com/Cantera/cantera/commit/2a38b0a765aee9fe0baae7d42fa8763591f09352), [#447](https://github.com/Cantera/cantera/pull/447))
- Add ability to simulate ionized flames using the `IonFlow` and `BurnerIonFlame` classes ([`3b12c6d6`](https://github.com/Cantera/cantera/commit/3b12c6d6623c83a1013398aa694b9dd4d745058c), [`e2f718c6`](https://github.com/Cantera/cantera/commit/e2f718c65b75e3d3670e9b774a79d2f4f1c8606e), [`9dd0134e`](https://github.com/Cantera/cantera/commit/9dd0134e3135720c43b01c7bf9b6961cddc4359e), [`6b6d758f`](https://github.com/Cantera/cantera/commit/6b6d758f2390487b7952916c4f3a9fdec535a59b), [`1057d207`](https://github.com/Cantera/cantera/commit/1057d2073182628e790c70df0a42f812687ff340), [`1be83743`](https://github.com/Cantera/cantera/commit/1be837434240a8610f164ee14355d4f0eee27057), [`a8cbfd2c`](https://github.com/Cantera/cantera/commit/a8cbfd2c41fc324ce40b59e6e2ac8c192e97fd83), [`2472e080`](https://github.com/Cantera/cantera/commit/2472e080c377fad61162d04200f385cc3096a39b), [`a99004d8`](https://github.com/Cantera/cantera/commit/a99004d8ef2cd802ce8923f08bf8cf9486c7e9cb), [`24940aee`](https://github.com/Cantera/cantera/commit/24940aeef774e91156cbaa15e8e219b4c35287ad), [`c3ba2642`](https://github.com/Cantera/cantera/commit/c3ba26428421f2edde473d11ad4831da2c9afe6b), [`a5762ea6`](https://github.com/Cantera/cantera/commit/a5762ea6b6ee40cc74b32ce0871ae1f788417a87), [`ac8612f3`](https://github.com/Cantera/cantera/commit/ac8612f36b7e317fb01e25a33d1edf4ecbfdc604), [#441](https://github.com/Cantera/cantera/pull/441), [#471](https://github.com/Cantera/cantera/pull/471), [#546](https://github.com/Cantera/cantera/pull/546), [#548](https://github.com/Cantera/cantera/pull/548))
- Add function to get the refine criteria used in a flame ([`bce4210e`](https://github.com/Cantera/cantera/commit/bce4210e1b2bf424c2d1e7f1ded45cfcdbfa761d), [`4b44c661`](https://github.com/Cantera/cantera/commit/4b44c6618285679d00969cddcd12310586240c48), [`c88ddce0`](https://github.com/Cantera/cantera/commit/c88ddce0d69523b9dab1cc09a1196726de0d6dd9), [#469](https://github.com/Cantera/cantera/pull/469))
- Add a more general `CounterFlowDiffusionFlame` to Matlab, replacing `npflame_init` ([`43bd96b5`](https://github.com/Cantera/cantera/commit/43bd96b5ba6073bd952dd2231daac3ead40e1ff7), [`c092484f`](https://github.com/Cantera/cantera/commit/c092484f4df60caf0c967df4552eedf2c010eb53), [#450](https://github.com/Cantera/cantera/pull/450))
- Allow access to and disabling of callbacks for 1-D problems ([`4b352751`](https://github.com/Cantera/cantera/commit/4b352751f54a033f731d3d69c43c9afe6da559d0), [`7a314d31`](https://github.com/Cantera/cantera/commit/7a314d3124bb74583850e9ede8d265f1605ae7bf), [#489](https://github.com/Cantera/cantera/pull/489))
- Automatically detect when the domain width is too narrow or the flame has blown off the burner ([`dfd4b7e6`](https://github.com/Cantera/cantera/commit/dfd4b7e671c847cbe2aa6b1e1ed49b0215727990), [`7eb4eaa1`](https://github.com/Cantera/cantera/commit/7eb4eaa13aeb77a4d723d80739e4496e75276807), [`4911539b`](https://github.com/Cantera/cantera/commit/4911539b565bffd0b30ffd26e04c30f085b85768), [#489](https://github.com/Cantera/cantera/pull/489))
- Add `BurnerIonFlame` class ([`25278695`](https://github.com/Cantera/cantera/commit/2527869536bec16a9e92a593d9389b632dac1409), [`5082a212`](https://github.com/Cantera/cantera/commit/5082a212c446743e57996d403c1061037864d540), [`ee633f3e`](https://github.com/Cantera/cantera/commit/ee633f3e16314210ecdd7edbfae8b519f274aac1), [`16624986`](https://github.com/Cantera/cantera/commit/166249869b5c3c828bfc63563de4a2c826047be8), [#548](https://github.com/Cantera/cantera/pull/548))

#### CTI/Input files
- Allow negative reaction orders ([`8f02c777`](https://github.com/Cantera/cantera/commit/8f02c777a5904069e8c8b57ae695be1fb383f033), [`4771874c`](https://github.com/Cantera/cantera/commit/4771874c757942807f40baa66e8a90e8f69ef25e), [`501b5fd1`](https://github.com/Cantera/cantera/commit/501b5fd1f52360464e55a047b92473ca0a89686d), [#485](https://github.com/Cantera/cantera/pull/485))
- Add support for parsing species with specific site occupancies ([`89bca5fc`](https://github.com/Cantera/cantera/commit/89bca5fcd1d8cd964abc731d8852d5ac87914e3c), [#444](https://github.com/Cantera/cantera/pull/444))
- Improve error message reporting during failed `ck2cti` conversions ([`4b5a37a3`](https://github.com/Cantera/cantera/commit/4b5a37a3362b7c6001f021256c3241e3e592284e), [`9c3b500e`](https://github.com/Cantera/cantera/commit/9c3b500ec869080c166485f37e2ba39c987b6f7e), [`4affcd1e`](https://github.com/Cantera/cantera/commit/4affcd1efb4f99843878147e678b7e6a9e62ccb1), [`411be3e6`](https://github.com/Cantera/cantera/commit/411be3e6cf1d110143fdf893c8a050762f7dc6c7), [#497](https://github.com/Cantera/cantera/pull/497))
- Allow `convertMech` function to be called multiple times ([`277aa0b9`](https://github.com/Cantera/cantera/commit/277aa0b91328748d266db644b12edd3934cf2ac7), [#528](https://github.com/Cantera/cantera/pull/528), [#536](https://github.com/Cantera/cantera/pull/536))

#### Other
- Add methods for getting the git commit ([`8e89bbb8`](https://github.com/Cantera/cantera/commit/8e89bbb8d2dde80b59b2533563ff67c935addd41), [`7979a2b5`](https://github.com/Cantera/cantera/commit/7979a2b52a791d0e22e161a6400590514ed024fe))
- Add class `AnyMap` ([`56022e89`](https://github.com/Cantera/cantera/commit/56022e898915c32ecb768fd8a48ec6054354a94c), [`9c084d5c`](https://github.com/Cantera/cantera/commit/9c084d5c84d010ca98d870c73139783cb769a87c), [`7fab7f3c`](https://github.com/Cantera/cantera/commit/7fab7f3cd3deec74e649a522b37e10efdf238e79), [#443](https://github.com/Cantera/cantera/pull/443))
- Add compatibility with Cython >=0.26 ([`8d953a94`](https://github.com/Cantera/cantera/commit/8d953a9424700b85beff13a83fe7a6921768dd75), [#465](https://github.com/Cantera/cantera/pull/465), [#467](https://github.com/Cantera/cantera/pull/467))
- Add compatibility with fmt 4.0.0 ([`ea69a014`](https://github.com/Cantera/cantera/commit/ea69a014a54ac0fb5199c63b4b673af0b3eff23d), [#470](https://github.com/Cantera/cantera/pull/470))
- Building now supports SCons 3.0.0 and Python 3 running SCons ([`7d0bc714`](https://github.com/Cantera/cantera/commit/7d0bc71448f549f3486c5c552c569f1e1f0f5565), [`684262e9`](https://github.com/Cantera/cantera/commit/684262e945f67498fb7ab460578249ed7bd11188), [#477](https://github.com/Cantera/cantera/pull/477), [#478](https://github.com/Cantera/cantera/pull/478), [#481](https://github.com/Cantera/cantera/pull/481))
- Allow building and testing with msvc-12.0 ([`e921cb89`](https://github.com/Cantera/cantera/commit/e921cb89c8cb3c167919344277009d54ae711255), [`6844e527`](https://github.com/Cantera/cantera/commit/6844e527137bf265ca8799f408aec1053b66b48a), [#479](https://github.com/Cantera/cantera/pull/479))
- Add `setup_cantera.csh` for use with csh/tcsh ([`4a4886f6`](https://github.com/Cantera/cantera/commit/4a4886f63ef21e763092ec04876215b61962dcab), [#453](https://github.com/Cantera/cantera/pull/453))
- Add conda GCC compilers to the check for C compilers during building ([`07409dea`](https://github.com/Cantera/cantera/commit/07409dea59cffa57e4dba91087e52d1201b4eb6e), [#486](https://github.com/Cantera/cantera/pull/486))
- Many documentation updates related to Cantera joining NumFOCUS ([`e846505f`](https://github.com/Cantera/cantera/commit/e846505f5783a979b245974a61a0d94e241ccbd1), [`e6b4761c`](https://github.com/Cantera/cantera/commit/e6b4761c6bbc31484afda0af29e6f8450e41fb21), [`af4a78dd`](https://github.com/Cantera/cantera/commit/af4a78dddef088785916cf1058c28444e33b463d), [`ec5aecd3`](https://github.com/Cantera/cantera/commit/ec5aecd3d6cd422a78df5225aead2952d04a04ee), [`419a09c4`](https://github.com/Cantera/cantera/commit/419a09c4145f2a5803f1e30a4554478ffb30235f), [`581cfb7c`](https://github.com/Cantera/cantera/commit/581cfb7c042289d4dc7eda32bdec9017d5346137), [`8caf5e5a`](https://github.com/Cantera/cantera/commit/8caf5e5aca2549d7ba2075b6312de64004d346a8), [`977a1c77`](https://github.com/Cantera/cantera/commit/977a1c7736aaf177138ae297fce3ef8b77494954), [`0d20b505`](https://github.com/Cantera/cantera/commit/0d20b50543815370244b112f9e0247568158ae19), [`c78a11b3`](https://github.com/Cantera/cantera/commit/c78a11b32f6d1613dce77cf2120ecaab96880b08), [`2abc57e2`](https://github.com/Cantera/cantera/commit/2abc57e2f1324d5e30537f01d39c15b88fe4206f), [`05fa4df3`](https://github.com/Cantera/cantera/commit/05fa4df3b9ebe4a8ea644dc23101d7cc62414404), [`8195403f`](https://github.com/Cantera/cantera/commit/8195403fefc63fd1f36707ab36b7495d5fdc22e7), [`1a394a34`](https://github.com/Cantera/cantera/commit/1a394a3402d929a4acbd47be8a4e22240ece35ed), [`c29fbc80`](https://github.com/Cantera/cantera/commit/c29fbc808e1a1073ff823da1076d066607362662), [`66597b72`](https://github.com/Cantera/cantera/commit/66597b72ffcdabd199aebe53b7654962188abe29), [`a0ac2b0c`](https://github.com/Cantera/cantera/commit/a0ac2b0cc62604009f529037001fb544176b4db3), [#502](https://github.com/Cantera/cantera/pull/502))
- Add support for SUNDIALS 3.0.0 and 3.1.0 ([`50a3fecb`](https://github.com/Cantera/cantera/commit/50a3fecb23f4cf97e71d989812a48c1a4c40f754), [`9c50f752`](https://github.com/Cantera/cantera/commit/9c50f7528c71ef470d73939f580d03ea342d85dd), [`82c959d3`](https://github.com/Cantera/cantera/commit/82c959d3a39fbe0e4ecdb0ceca9dff81c9e0254b), [`322b1fc3`](https://github.com/Cantera/cantera/commit/322b1fc37572dca61067397d460cc809b9bece46), [#503](https://github.com/Cantera/cantera/pull/503))
- Upgrade Eigen submodule to 3.3.4 ([`20f891f1`](https://github.com/Cantera/cantera/commit/20f891f1a43acb5fd72963bf34ba101e10fcbf4c))
- Add links to old versions of the documentation ([`b26dc65c`](https://github.com/Cantera/cantera/commit/b26dc65c415c69af050f1ef28c5505f10f5800bb))
- Upgrade `fmtlib` submodule to 5.0.0 ([`6b3c912e`](https://github.com/Cantera/cantera/commit/6b3c912ec3147c1cb91e57a21bda30379746c88e), [`99d4972e`](https://github.com/Cantera/cantera/commit/99d4972e6b962ed91ef7dc8fb6943416fe86c846), [`3be3f7da`](https://github.com/Cantera/cantera/commit/3be3f7dad5291aa53c633e3043768d7527e54148), [`e42b952a`](https://github.com/Cantera/cantera/commit/e42b952a8ac88b46d274cfa034e5f3617e1d8c0c), [`51d0d43a`](https://github.com/Cantera/cantera/commit/51d0d43a4505cb680e073a552cbb31b0f385460d), [`309871ae`](https://github.com/Cantera/cantera/commit/309871ae8823aa182e4f7a6fb2d8bf3a456019a3), [`dab73901`](https://github.com/Cantera/cantera/commit/dab739013ed2c766583cf27cc0617ff68f77c64d), [#540](https://github.com/Cantera/cantera/pull/540))

#### Examples/Samples
- Add C++ OpenMP example ([`78d5809d`](https://github.com/Cantera/cantera/commit/78d5809d6f3e79a6afb6dad211a0417c56bd5065))
- Add NonIdealShockTube example ([`2a601c14`](https://github.com/Cantera/cantera/commit/2a601c148f9f586d72e247162946e64739477e4a), [`e78aac7b`](https://github.com/Cantera/cantera/commit/e78aac7b70265705aef4d62cde8c675003dc50e5), [`26216e9a`](https://github.com/Cantera/cantera/commit/26216e9adc9eddbd7466b0ff068860148134241a), [#473](https://github.com/Cantera/cantera/pull/473), [#483](https://github.com/Cantera/cantera/pull/483))
- Add example of PSR/WSR that replaces `combustor.py` ([`dc5ec06a`](https://github.com/Cantera/cantera/commit/dc5ec06a0c020715ccda93942e50c2d2281ee51b), [#550](https://github.com/Cantera/cantera/pull/550))
- Add example of using a time-dependent mass flow into a reactor ([`2f67c996`](https://github.com/Cantera/cantera/commit/2f67c9969d6ff2020410fa7ea5abc782c528dc6f), [#550](https://github.com/Cantera/cantera/pull/550))
