# Examples

Cantera includes examples for a number of applications. To see all examples written in a
particular programming language, select the corresponding category below. Or, to browse
all examples covering a particular topic, regardless of programming language, select
from the {ref}`list of example tags <tagoverview>`.

```{seealso}
If you're just getting started with Cantera, see our [](/userguide/python-tutorial) for
an introduction to the Cantera Python interface, or the
[C++ Tutorial](/userguide/cxx-tutorial) for some guidance on using Cantera's C++
interface.
```

## Python Examples

````{grid} 2 2 2 3
:gutter: 3

```{grid-item-card} Thermodynamics
:link: python/thermo/index
:link-type: doc
:text-align: center
```

```{grid-item-card} Kinetics
:link: python/kinetics/index
:link-type: doc
:text-align: center
```

```{grid-item-card} Transport
:link: python/transport/index
:link-type: doc
:text-align: center
```

```{grid-item-card} Reactor networks
:link: python/reactors/index
:link-type: doc
:text-align: center
```

```{grid-item-card} 1D reacting flows
:link: python/onedim/index
:link-type: doc
:text-align: center
```

````

## Examples in Other Languages

````{grid} 2 2 3 3
:gutter: 3

```{grid-item-card} C++
:link: cxx/index
:link-type: doc
:text-align: center
```

```{grid-item-card} C (experimental)
:link: clib/index
:link-type: doc
:text-align: center
```

```{grid-item-card} Matlab (experimental)
:link: matlab_experimental/index
:link-type: doc
:text-align: center
```

```{grid-item-card} Fortran
:link: fortran/index
:link-type: doc
:text-align: center
```


````

## Input File Examples

````{grid} 2 2 3 3
:gutter: 3

```{grid-item-card} YAML
:link: input/index
:link-type: doc
:text-align: center
```

````


% The following pages are generated by sphinx-gallery
```{toctree}
:maxdepth: 2
:hidden:

python/index
cxx/index
clib/index
matlab_experimental/index
fortran/index
input/index
```

% The following page is generated by sphinx-tags
```{toctree}
:maxdepth: 1
:hidden:

/_tags/tagsindex
```
